UNIT Ed_Print;


INTERFACE

USES
  Dos, ed_var, Ed_Menue, ed_unit, grafik,
  bioscrt, keycode, Monitor, mouse, Menue, rechnen, LaufBalk;



PROCEDURE PrintText;
PROCEDURE SeitenVorschau;


IMPLEMENTATION
VAR
  PrintError : Byte;
  f          : Text;
  PrintLines : Byte;
  EofFile    : Boolean;
  SideNum    : Word;
  Lines      : Byte;
  MaxPixels  : Byte;
  Breite     : Word;
  StopPrint  : Boolean;
  PrintNum   : Word;


PROCEDURE PrintChar (c : Char);
LABEL
  Nochmal;
BEGIN
  If PrintError <> 0 Then Exit;
  Nochmal:
  If PrintNum>2 Then
  BEGIN
    Write (f, c);
    PrintError:= IOResult;
    If PrintError<>0 Then
    ErrorMsg ('Drucker nicht bereit. Nochmal versuchen?', JaNein);
    If Taste=#13 Then Goto Nochmal;
  END Else
  BEGIN
    ASM
      mov  dx, PrintNum;  mov ah, 2; int 17h;  { DruckerStatus ermitteln }
      test ah, 00100000b; jz  @2; mov Byte Ptr PrintError, 2; jmp @ende; @2:
      test ah, 00010000b; jnz @1; mov Byte Ptr PrintError, 1; jmp @ende; @1:
      test ah, 00001000b; jz  @3; mov Byte Ptr PrintError, 3; jmp @ende; @3:
      xor  ah, ah; mov al, c; int 17h;  { Zeichen drucken }
      mov  Byte Ptr PrintError, 0
      @ende:
    END;
    If PrintError<>0 Then
    BEGIN
      CASE PrintError Of
        1 : ErrorMsg ('Drucker nicht eingeschaltet. Nochmal versuchen?', JaNein);
        2 : ErrorMsg ('Drucker hat kein Papier. Nochmal versuchen?', JaNein);
        3 : ErrorMsg ('Druckerfehler. Nochmal versuchen?', JaNein);
      END;
      If Taste=#13 Then Goto Nochmal;
    END;
  END;
END;



PROCEDURE PrintStr (s : String);
VAR
  x : Byte;
BEGIN
  For x:= 1 To Length(s) Do PrintChar (s[x]);
  If KeyPressed Then
  BEGIN
    ScanKeys;
    If t1=#27 Then
    BEGIN
      StopPrint:= TRUE;
      If PrintNum<=2 Then
      ASM
        mov dx, PrintNum; mov ah, 1; int 17h; {Init}
        mov ax, 12; int 17h; {Seite auswerfen}
      END;
    END;
    t1:=#0; t2:= #0;
  END;
END;


PROCEDURE PrintEmptyLines (Count : Byte);
VAR
  x : Byte;
BEGIN
  If (PrintError<>0) or (not Konfig.PFormat) Then Exit;
  For x:= 1 To Count Do PrintStr (#13#10);
END;



PROCEDURE PrintRandLinks;
VAR
  x : Byte;
BEGIN
  If (PrintError<>0)  or (not Konfig.PFormat) Then Exit;
  For x:= 1 To Konfig.PRand Do PrintChar (#32);
END;


PROCEDURE LineCounter;
VAR
  x : Byte;
BEGIN
  If (not Konfig.PFormat) or (PrintError<>0) Then Exit;
  inc (PrintLines);
  If (PrintLines=Konfig.PLines) or (EofFile) Then
  BEGIN
    inc (SideNum);
    If Konfig.PFusszeile>0 Then
    BEGIN
      If not EofFile Then PrintEmptyLines (Konfig.PFusszeile) Else
      PrintEmptyLines (Konfig.PLines-PrintLines+Konfig.PFusszeile);
      PrintRandLinks;
      PrintStr ('Seite '+ LongStr(SideNum)+'       '+FPos[FileNr].FName+#13#10);
    END;
    PrintChar (#12);
    If PrintError<>0 Then Exit;
    If (not EofFile) and ((Konfig.PMaxSides=0) or (SideNum<Konfig.PMaxSides)) Then
    PrintEmptyLines (Konfig.PRandOben);
    PrintLines:= 0;
  END;
END;



PROCEDURE PrintText;
LABEL
  Ende, Raus;
VAR
  StartLine, EndLine, x, i, LineZahl : Word;
BEGIN
  UniWin (20, 8, 60, 14, 'Druck-Fortschritt');
  For x:= 23 To 57 Do CharXY (x, 11, ' ', 0, 7);
  WriteXY (23+6, 13, 'Druck abbrechen mit Esc', MenCol.WinT, MenCol.WinB);
  CursorOff;
  RestoreScreen;

  PrintError:= 0; StopPrint:= FALSE;
  PrintNum:= ord(Konfig.Printer)-49;    { BIOS-Nummer des Druckers }
  If LineAn * LineEn=0 Then
  BEGIN StartLine:= 1;      EndLine:= LastLine; END Else
  BEGIN StartLine:= LineAn; EndLine:= LineEn;   END;
  LineZahl:= EndLine-StartLine;

  If PrintNum>2 Then
  BEGIN
    Assign (f, 'LPT4');
    FileMode:= 2;
    Rewrite (f); PrintError:= IOResult; If PrintError<>0 Then Goto Ende;
  END;
  PrintLines:= 0; SideNum:=0;

  PrintChar (#13); If PrintError <> 0 Then Goto Raus;
  PrintEmptyLines (Konfig.PRandOben); If PrintError <> 0 Then Goto Raus;
  ClearLin;
  For x:= StartLine To EndLine Do
  BEGIN
    PrintRandLinks;
    FormatAnzeige (x);
    PrintStr (TLine^[x]^+#13#10);
    EOfFile:= x>=EndLine;
    LineCounter;
    i:= Prozent (x, LineZahl, 35);
    For i:= 23 To i+22 Do CharXY (i, 11, #176, 0, 7);
    If PrintError <> 0 Then Goto Raus;
    If ((Konfig.PFormat) and (Konfig.PMaxSides>0) and (SideNum>=Konfig.PMaxSides))
    or (StopPrint) Then
    Goto Ende; 
  END;

  If not Konfig.PFormat Then
  BEGIN PrintChar (#12); If PrintError <> 0 Then Goto Raus; END;

Ende:
  If PrintError<>0 Then ErrorMsg ('Drucker nicht bereit', Okay);
Raus:
  If PrintNum>2 Then BEGIN Close (f); If IOResult<>0 Then; END;
  ViewMode:= ShowMen; MouseBottomLine;
  ShowText;
  CursorOn;
  FertigTut;
END;



{-------------------------- Seitenvorschau ----------------------------------}

PROCEDURE MakeScreen;
BEGIN
  GraphMode (VGA320x200);
  ClearScreen (0, 0, Breite, 199, 15);
  TextAttr:= magenta;
  GotoXY (26,  1); WriteStr ('Seite :');
  GotoXY (26, 25); WriteStr ('Tasten : Esc '#24#25);
  TextAttr:= cyan;
  HorLine (196,  12,  319);
  HorLine (196,  186, 319);
  VerLine (196,  12,   68);
  VerLine (196,  131, 186);
END;



PROCEDURE WritePixels (Color : Byte; FrstLine, Min, Max : Word);
VAR
  a, c    : Word;
  b, d, e : Byte;
  st      : String[128];
BEGIN
  b:= Konfig.PRand    *ord(Konfig.PFormat); If b>MaxPixels-1 Then b:= MaxPixels-1;
  d:= Konfig.PRandOben*ord(Konfig.PFormat); If d>63 Then d:= 63;
  TextAttr:= Color;

  For a:= 1 To Lines Do
  BEGIN
    inc (d);
    If a+FrstLine+Min<=Max Then
    For c:= 1 To MaxPixels Do
    BEGIN
      If (c>b) and (c-b<=Length (TLine^[a+FrstLine+Min]^)) and (TLine^[a+FrstLine+Min]^[c-b]<>#32) Then
      PutPixel (c*2+3, d*3+3);
    END;
  END;

  If (Konfig.PFormat) and (Konfig.PFusszeile<>0) Then
  BEGIN
    inc (d, Konfig.PFusszeile);
    st:= 'Seite '+sstr(FrstLine DIV Lines+1)+'       '+FPos[FileNr].FName;
    For c:= 1 To MaxPixels Do
    BEGIN
      If (c>b) and (c-b<=Length (st)) and (st[c-b]<>#32) Then
      PutPixel (c*2+3, d*3+3);
    END;
  END;
END;



PROCEDURE WriteText (Color : Byte; FrstLine, Min, Max : Word);
VAR
  a    : Word;
BEGIN
  TextAttr:= magenta;
  GotoXY (34,  1); WriteStr (sstr (FrstLine DIV Lines+1));
  TextAttr:= Color;
  For a:= 1 To 6 do
  BEGIN
    GotoXY (26,  2+a);
    If a+FrstLine+Min<=Max Then
    WriteStr (copy (TLine^[a+FrstLine+Min]^,    1, 15));
    GotoXY (26, 17+a);
    If a+FrstLine+57+Min-(63-Lines)<=Max Then
    WriteStr (copy (TLine^[a+57+FrstLine+Min-(63-Lines)]^, 1, 15));
  END;
END;



PROCEDURE DecFLine (VAR Wert : Word; Zahl : Byte);
BEGIN
  While (Wert>0) and (Zahl>0) Do BEGIN dec (Wert); dec (Zahl); END;
END;



PROCEDURE IncFLine (VAR Wert : Word; Zahl : Byte; Max : Word);
BEGIN
  While (Wert< Max-(Max MOD Lines)) and (Zahl>0) Do BEGIN inc (Wert); dec (Zahl); END;
END;



PROCEDURE SeitenVorschau;
VAR
  Screen   : Array[1..4000] Of Byte;
  ox, oy   : Byte;
  FrstLine : Word;
  StartLine, EndLine : Word;

BEGIN
  If LineAn*LineEn=0 Then
  BEGIN StartLine:= 1;      EndLine:= LastLine; END Else
  BEGIN StartLine:= LineAn; EndLine:= LineEn;   END;

  If Konfig.PPunkt=10 Then
  BEGIN MaxPixels:=93; Breite:=190; END Else BEGIN MaxPixels:=79; Breite:=162;END;

  Lines:= Konfig.PLines   *ord(Konfig.PFormat); If Lines=0  Then Lines:= 63;
  ox:= WhereX; oy:= WhereY; FrstLine:= 0;
  GetScreen25 (Screen);
  MakeScreen;

  REPEAT
    WritePixels (Black, FrstLine, StartLine-1, EndLine);
    WriteText (7, FrstLine, StartLine-1, EndLine);

    ScanKeys;

    WriteText (Black, FrstLine, StartLine-1, EndLine);
    WritePixels (15, FrstLine, StartLine-1, EndLine);
    If t1=#0 Then
    CASE t2 Of
      Pos1       : FrstLine:=0;
      Up, PgUp   : DecFLine (FrstLine, Lines);
      Down, PgDn : IncFLine (FrstLine, Lines, EndLine-StartLine);
      EndX       : If EndLine-StartLine>Lines Then
                   FrstLine:= (EndLine-StartLine) - ((EndLine-StartLine) MOD Lines)
                   Else FrstLine:=0;
    END;
  UNTIL t1=#27;

  GraphMode (LastMode);
  If ScrMode=FarbMon Then VGAColorOn;
  SetScreen25 (Screen);
  GotoXY (ox, oy);
  t1:=#0; t2:=#0;
END;




END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
