UNIT ED_Suche;

INTERFACE

USES
  Dos, Ed_Var, bioscrt, keycode, editors, Monitor, ed_unit,
  dialogs, strings, menue, mouse, ed_tab, ed_manag, ed_help, time;


CONST
  Beenden               = 0;
  NurSuchen             = 1;
  Ersetzen              = 2;
  Ignoriere_Gross_Klein = 3;
  Beachte_Gross_Klein   = 4;
  SuchInErsatz          : Boolean = FALSE;

PROCEDURE WriteCurPos;
PROCEDURE SetTextScreen;
PROCEDURE Suchen (Modus, Art : Byte);
PROCEDURE ReadLine    (VAR ss : String; Wort : Str80; HistListNr, Typ : Byte);
PROCEDURE ReadCmdLine (VAR ss : String; Wort : Str80; HistListNr, Typ : Byte);



IMPLEMENTATION


PROCEDURE WriteCurPos;
VAR
  x      : Word;
  FilPos : LongInt;
BEGIN
  NumXY (51, WinOk-1, 5, LastLine, MenCol.KeyT, MenCol.WinB);
  NumXY (63, WinOk-1, 5, ActLine,  MenCol.KeyT, MenCol.WinB);
  x:= WhereX-1+FPos[FileNr].Start;
  If TABMarkExist (x) <> 0 Then
  NumXY   (76, WinOK-1, 3, x, lightred, MenCol.WinB) Else
  NumXY   (76, WinOk-1, 3, x, MenCol.KeyT, MenCol.WinB);
  If x <= Length(TLine^[ActLine]^) Then
  NumXY   (40, WinOK-1, 3, ord(TLine^[ActLine]^[x]), MenCol.KeyT, MenCol.WinB) Else
  WriteXY (40, WinOK-1, '   ',  MenCol.KeyT, MenCol.WinB);

  FilPos:=0;
  For x:= 1 To ActLine-1 Do inc (FilPos, Length (TLine^[x]^));
  inc (FilPos, FPos[FileNr].Start+WhereX-1);
  NumXY   (21, WinOk-1, 11, FilPos, MenCol.KeyT, MenCol.WinB);
END;




PROCEDURE SetTextScreen;
BEGIN
  ViewMode:= ShowMen;
  MouseBottomLine;
  ShowText;
END;



PROCEDURE Fusszeile (Modus : Byte);
BEGIN
  InitHeadLine (25);
  If Modus= Ersetzen Then
  BEGIN
    HeadField ('Wort ersetzen ?   ',            #0, #0); EventOK:= FALSE;
    HeadField ('  ~J~a  ' ,                    'J', #0);
    HeadField ('  ~N~ein  ',                   'N', #0);
    HeadField ('  ~A~lle  ',                   'A', #0);
  END Else
    HeadField ('  ~Enter~ Weitersuchen  ',     #13, #0);
    HeadField ('  ~Esc~ hier beenden  ',       #27, #0);
    HeadField ('  ~Back~ zurck  ',           Back, #0);
END;


PROCEDURE ReadLine (VAR ss : String; Wort : Str80; HistListNr, Typ : Byte);
LABEL
  Nochmal;
VAR
  Temp : String;
BEGIN
  Temp:= ss;
  Nochmal:
  If (HistListNr=0) or (HistListNr>MaxHLists) Then NotHistoryList Else
  AssignHistoryList (HistList^[HistListNr]);
  LineEditbox (14, 5, 64, ss, 76, Wort, Typ);
  If ((t2=F2) and (Typ and WithList = WithList)) Then
  BEGIN FileManager (ss, Wort); Goto Nochmal; END;
  If ((t2=F1) and (Typ and WithHelp = WithHelp)) Then
  BEGIN Interne_Hilfe (EdHelpFile, Wort); Goto Nochmal; END;
  If t1=#27 Then String (ss):= temp;
END;



PROCEDURE Einlesen (VAR Modus : Byte);
VAR
  tmp : String; x : Byte;
BEGIN
  StrCopy (TLine^[ActLine]^, tmp);
  x:= FPos[FileNr].Start+WhereX-1;
  While (x>1) and (pos (tmp[x], ' /,;()[]+-*:')=0) Do dec (x);
  If x<>1 Then delete (tmp, 1, x);
  x:= 1;
  While (x<Length(tmp)) and (pos (tmp[x], ' /,;()[]+-*:')=0) Do inc (x);
  If x<>Length (tmp) Then delete (tmp, x, 255);
  If tmp<>'' Then StrCopy (tmp, Konfig.Suchwort);

  ReadLine (Konfig.Suchwort, 'Suchwort', 1, 1);
  If (t1=#27) or (Konfig.SuchWort='') Then BEGIN Modus:= Beenden; Exit; END;
  If Modus=2 Then
  BEGIN
    If tmp<>'' Then StrCopy (tmp, Konfig.Ersatzwort);
    ReadLine (Konfig.Ersatzwort, 'Ersatzwort', 2, 1);
    If t1=#27 Then Modus:= Beenden Else
    If (Konfig.ErsatzWort='')
    or (Konfig.ErsatzWort= Konfig.SuchWort) Then Modus:= NurSuchen;
    SuchInErsatz:= pos (Konfig.SuchWort, Konfig.ErsatzWort)<>0;
  END;
END;


PROCEDURE ChangeWord (p : Byte);
BEGIN
  delete (TLine^[ActLine]^, p, Length (Konfig.Suchwort));
  If Length (TLine^[ActLine]^) + Length (Konfig.ErsatzWort) >= MaxLen-1 Then
  BEGIN
    If ActLine>1 Then
    InsLines (ActLine, 1);
    If RAMError<>0 Then BEGIN ErrorMsg (MemError, Okay); Exit; END;
    StrCopy (Konfig.Ersatzwort, TLine^[ActLine]^);
  END Else
  insert (Konfig.ErsatzWort, TLine^[ActLine]^, p);
  FPos[FileNr].IfEdit:= TRUE;
END;




PROCEDURE Suchen (Modus, Art : Byte);
VAR
  p         : Byte;
  gef       : Byte;
  ChangeAll : Boolean;
  OldLine, OldFirstLine, OldStart, OldCurX : Word;


PROCEDURE SetScreen;
BEGIN
  With FPos[FileNr] Do
  BEGIN
    Line   := OldLine;  FirstLine:= OldFirstLine;
    Start  := OldStart; NewCurX  := OldCurX;
    If Line = 0 Then Line:=1; 
    ActLine:= Line+FirstLine;
    GotoXY (OldCurX, OldLine+(WinOk-1));
  END;
  SetTextScreen;
END;

BEGIN
  With FPos[FileNr] Do
  BEGIN
    OldLine:= Line; OldFirstLine:= FirstLine; OldStart:=Start; OldCurX:=NewCurX;

    Einlesen (Modus);
    If Modus= Beenden Then BEGIN SetScreen; t1:= #0; t2:= #0; Exit; END;

    t1:=#0; gef:= 0; ChangeAll:= FALSE;
    If ActLine=1 Then Line:=0 {nur ausnahmsweise !} Else DecLine;

    While ActLine<LastLine Do
    BEGIN
      incLine;
      REPEAT
        CASE Art Of
          Ignoriere_Gross_klein : p:= Pos (UpStr(Konfig.Suchwort), UpStr (TLine^[ActLine]^));
          Beachte_Gross_klein   : p:= Pos (Konfig.Suchwort, TLine^[ActLine]^);
        END;
        If (p<>0) Then
        BEGIN
          gef:= 1;
          If not ChangeAll Then
          BEGIN
            WriteCurPos;
            ShowText;
            If Konfig.SoundOn Then BEGIN Sound (1000); xDelay (100); NoSound; END;
            GotoXY (p+1, Line+(WinOk-1));
            ChangeBackColor (p+1, Line+(WinOk-1), Length(Konfig.SuchWort), Cyan);

            ViewMode:= ShowMen; Fusszeile (Modus);

            REPEAT
              MouseKey;
              Fusszeile (Modus);
            UNTIL (t1=#13) or (EventOK);

            CASE t1 Of
              #27  : BEGIN
                       NewCurX:= p+1; t1:=#1;
                       ViewMode:= ShowMen;
                       MouseBottomLine; Exit;
                     END;
              Back : BEGIN SetScreen; Exit; END;
              Else   If Modus = Ersetzen Then
                     CASE t1 Of
                       #13, 'J' : ChangeWord (p);
                       'A'      : BEGIN ChangeWord (p); If not SuchInErsatz Then ChangeAll:= TRUE; END;
                     END;
            END;
          END Else ChangeWord (p);
          If Modus=NurSuchen Then p:= 0;
        END;
      UNTIL (p=0) or (t1='N') or (t1=#27) and (t1=Back)
    END;
    If Gef= 0 Then ErrorMsg ('Suchwort nicht gefunden', Okay);
    SetScreen;
  END;
END;



PROCEDURE ReadCmdLine (VAR ss : String; Wort : Str80; HistListNr, Typ : Byte);
BEGIN
  ReadLine (ss, Wort, HistListNr, Typ);
  SetTextScreen; t1:=#0; t2:=#0;
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
