UNIT Ed_TAB;  {Tabulatorfunktionen}

INTERFACE

USES
  Ed_Unit, ed_Var, bioscrt;


PROCEDURE JumpTAB (TLine : Word);
FUNCTION  TABMarkExist (x : Byte) : Byte;
PROCEDURE Insert_or_Delete_TABMark (x : Byte);
FUNCTION  TABExist : Boolean;


IMPLEMENTATION



PROCEDURE JumpTAB (TLine : Word);
VAR
  x : Byte;
BEGIN
  With Konfig, FPos[FileNr] Do
  BEGIN
    While (TABMarks[TABPointer]=0) and (TABPointer< MaxTABLen) Do
    inc (TABPointer);
    If (TABMarks[TABPointer]<>0) and (TABMarks[TABPointer]<MaxLen) Then
    BEGIN
      If TABMarks [TABPointer] + 1 > Start+WinR Then
      BEGIN
        Start:= TABMarks [TABPointer] + 1;
        ShowText;
      END;
      If TABMarks[TABPointer] < Start Then
      BEGIN
        If TABMarks[TABPointer] < WinR Then Start:=0 Else
        Start:= TABMarks[TABPointer]-5;
        ShowText;
      END;
      GotoXY (TABMarks[TABPointer] + 1 - Start, TLine);
      inc (TabPointer);
      If TABPointer=0 Then TABPointer:=1;
    END Else BEGIN TABPointer:= 1; Start:=0; GotoXY (2, TLine); ShowText; END;
  END; 
END;



FUNCTION TABMarkExist (x : Byte) : Byte; Assembler;
ASM
  mov ax, ds
  mov es, ax
  lea di, Konfig.TabMarks
  mov al, x
  mov cx, MaxTabLen
  mov dx, cx
  cld
  repne scasb
  jcxz @ende
  sub dx, cx
  mov cx, dx
  @ende:
  mov ax, cx
END;
{Ist die TABMarke x in TABMarks gespeichert, dann wird die Adresse
 zurckgegeben, an der die Marke eingetragen ist, ansonsten 0}



FUNCTION TABExist : Boolean; assembler;
ASM
  mov ax, ds
  mov es, ax
  lea di, Konfig.TabMarks
  xor ax, ax
  mov cx, MaxTabLen
  cld
  repe scasb
  jcxz @ende
  mov ax, 1
  @ende:
END;



PROCEDURE Insert_or_Delete_TABMark (x : Byte);
BEGIN
  If TABMarkExist (x) <> 0 Then Konfig.TABMarks[TABMarkExist (x)]:= 0 Else
  If TABMarkExist (0) <> 0 Then Konfig.TABMarks[TABMarkExist (0)]:= x;
END;
{Existiert auf der Cursorposition eine TAB-Marke, wird sie gelscht,
 ansonsten wird eine neue TAB-Marke gespeichert}


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
