UNIT Ed_Undo;

INTERFACE

USES
  Ed_Var, bioscrt, keycode, ed_unit, monitor, strings, ed_form, dos,
  clipbord;


PROCEDURE BlockMark (Befehl : Char);
PROCEDURE CheckMarks;
PROCEDURE Copy_InTo_UndoBuffer (Modus : Byte);
PROCEDURE Copy_UndoBuffer_InTo_Text;
PROCEDURE CloseUndo (Modus : Byte);
FUNCTION  ClipLines : Word;

CONST
  Cut = 1;
  Cop = 2;
  Del = 3;


IMPLEMENTATION

VAR
  FullLine  : Boolean;



PROCEDURE CheckMarks;
VAR
  Temp : Word;
BEGIN
  If LineEn * LineAn = 0 Then Exit;

  If (LineAn>LineEn) Then
  BEGIN
    Temp:= SignAn; SignAn:=SignEn; SignEn:= Temp;
    Temp:= LineAn; LineAn:=LineEn; LineEn:= Temp;
  END Else
  If (LineAn=LineEn) and (SignAn>SignEn) Then
  BEGIN
    Temp:= SignAn; SignAn:=SignEn; SignEn:= Temp;
  END;
  If SignAn > Length (TLine^[LineAn]^) Then
  BEGIN
    If LineAn<LastLine Then
    BEGIN inc (LineAn); SignAn:= 1; END Else
    SignAn:= Length (TLine^[LineAn]^);
  END;
  If SignEn > Length (TLine^[LineEn]^) Then SignEn:= Length (TLine^[LineEn]^);
  FullLine:=
    (SignEn=  Length (TLine^[LineEn]^)) and (SignAn=1);
  ShowText;
END;



PROCEDURE BlockMark (Befehl : Char);
VAR
  tmp : Byte;
BEGIN
  With FPos[FileNr] Do
  CASE Befehl Of
    F6  : BEGIN LineAn:= 0; LineEn:= 0; SignAn:= 0;  SignEn:= 0; END;
    F7  : BEGIN LineAn:= ActLine;       SignAn:= Start+WhereX-1; END;
    F8  : BEGIN LineEn:= ActLine;       SignEn:= Start+WhereX-2; END;
    AF8 : BEGIN
            LineAn:= ActLine; LineEn:= ActLine;
            SignAn:= 1;  SignEn:= Length (TLine^[ActLine]^);
          END;
    AF9 : BEGIN
            LineAn:= ActLine; LineEn:= ActLine;
            tmp:= Start+WhereX-1;
            While (TLine^[ActLine]^[tmp]<>#32) and (tmp>0) Do dec (tmp);
            inc (tmp);
            SignAn:= tmp;
            While (TLine^[ActLine]^[tmp]<>#32) and (tmp<Length(TLine^[ActLine]^)) Do inc (tmp);
            SignEn:= tmp;
          END;
  END;
  CheckMarks;
END;


VAR
  UndoMaxLen : Byte;
  UndoLastLen : Byte;

CONST
  UndoBufFile = 'CLIPBRD.DAT';

  UndoOpen    : Boolean = FALSE;
  BufPtr      : Word    = 0;
  PushErr     : Word    = 0;
  ReadPtr     : Word    = 0;
  UndoError   : Boolean = FALSE;



FUNCTION BinEof (VAR TRec : Text) : Boolean;
VAR
  Tmp : Char;
BEGIN
  With TextRec (TRec) Do
  BEGIN
    If BufPtr^[BufPos]<>#26 Then BinEof:= Eof(TRec) Else
    BEGIN
      Tmp:= BufPtr^[BufPos];
      BufPtr^[BufPos]:= ' ';
      BinEof:= Eof(TRec);
      BufPtr^[BufPos]:= Tmp;
    END;
  END;
END;



FUNCTION ClipLines : Word;
VAR
  tmp : Word;
  s   : String;
  sr  : SearchRec;
BEGIN
  tmp:= 0; s:= ''; UndoMaxLen:= 0; UndoLastLen:= 0;
  If FPos[FileNr].Bin Then
  BEGIN                          
    FindFirst (Vollpfad (TempPath, UndoBufFile), anyfile, sr);
    If (DOSError=0) and (MaxLen>10) Then
    BEGIN
      Cliplines:= sr.size DIV (MaxLen-8) + ord(sr.size MOD (MaxLen-8) <>0);
      UndoLastLen:= MaxLen-10;
      UndoMaxlen := UndoLastLen;
    END Else ClipLines:= 0;
  END Else
  BEGIN
    Assign (UndoFile, Vollpfad (TempPath, UndoBufFile)); FileMode:= 0;
    SetTextBuf (UndoFile, DirList^, SizeOf (DirList^));
    Reset (UndoFile);
    While (IOResult=0) and (not Eof (UndoFile)) Do
    BEGIN
      ReadLn (UndoFile, s);
      If Length(s)>UndoMaxLen Then UndoMaxLen:= Length(s);
      inc (tmp);
    END; 
    UndoLastLen:= Length (s);
    ClipLines:= tmp;
    Close (UndoFile); If IOResult<>0 Then;
  END;
END;


PROCEDURE FlushBuffer;
VAR
  x : Word;
BEGIN
  If not UndoOpen Then
  BEGIN
    Assign (UndoFile, Vollpfad (TempPath, UndoBufFile)); FileMode:= 2;
    Rewrite (UndoFile); PushErr:= IOResult;
    If PushErr<>0 Then
    BEGIN
      SetFAttr (UndoFile, 32);
      Rewrite (UndoFile); PushErr:= IOResult;
      If PushErr<>0 Then Exit;
    END;
    UndoOpen:= TRUE;
  END;
  For x:= 1 To BufPtr Do If PushErr=0 Then
  BEGIN WriteLn (UndoFile, Undobuf^[x]); PushErr:= IOResult; END;
  BufPtr:= 0;
END;


PROCEDURE PushUndoLine (Line : String);
VAR
  x : Word;
BEGIN
  inc (BufPtr);
  StrCopy (Line, UndoBuf^[BufPtr]);
  If Length(Line)>UndoMaxLen Then UndoMaxLen:= Length(Line);
  If BufPtr>=MaxUndo Then
  BEGIN
    FlushBuffer;
    If PushErr<>0 Then ErrorMsg ('Fehler bei bernahme in Zwischenablage', Okay);
  END;
  UndoLastLen:= Length (Line);
END;


PROCEDURE CloseUndo (Modus : Byte);
BEGIN
  If ((Modus=2) and (BufPtr<>0)) or (UndoOpen) Then FlushBuffer;
  If UndoOpen Then BEGIN Close (UndoFile); If IOResult<>0 Then; END;
  UndoOpen:= FALSE;
END;


PROCEDURE Copy_InTo_UndoBuffer (Modus : Byte);
VAR
  x, i : Word;
  l    : LongInt;
BEGIN
  If LineAn * LineEn = 0 Then Exit;

  If Modus<>Del Then
  BEGIN
    UndoOpen:= FALSE;   { oder doch vor If ? }
    UndoMaxLen:= 0; BufPtr:= 0;
    l:= 0;
    For x:= LineAn To LineEn Do inc (l, Length (TLine^[x]^)+2);
    UndoError:= (LineEn-LineAn>=MaxUndo-1) and (l >= DiskFree (ProgDriveNum));
    If UndoError Then
    CASE Modus Of
      Cop : BEGIN ErrorMsg (CopyError, Okay); Exit; END;
      Cut : BEGIN ErrorMsg (CutError, Janein);  If Taste <> #13 Then Exit; END;
    END;
    UndoPointer:= 0;
  END Else UndoError:= FALSE;

  If not UndoError Then
  BEGIN
    For i:= LineAn To LineEn Do
    BEGIN
      If Modus<>Del Then
      BEGIN
        inc (UndoPointer);
        PushUndoLine (copy (TLine^[i]^, ActSignAn(i), ActSignEn(i)-ActSignAn(i)+1));
      END;
      If (Modus=Cut) or (Modus=Del) Then
      delete (TLine^[i]^, ActSignAn(i), ActSignEn(i)-ActSignAn(i)+1);
    END;
  END;

  If (Modus=Cut) or (Modus=del) Then
  BEGIN
    If ((LineAn=LineEn) and (Length (TLine^[LineAn]^)=0)) Then
    delLines (LineAn+1, 1) Else

    If (LineEn>LineAn) Then
    If Length (TLine^[LineAn]^) + Length (TLine^[LineEn]^) < MaxLen Then
    BEGIN
      StrAdd (TLine^[LineAn]^, TLine^[LineEn]^);
      If not FullLine Then
      delLines (LineEn+1, LineEn-LineAn) Else
      delLines (LineEn+1, LineEn-LineAn+1);
    END Else
    If LineEn-LineAn>1 Then delLines (LineEn, LineEn-LineAn-1);

    With FPos[FileNr] Do
    If ((LineAn>=FirstLine) and (LineAn<= FirstLine+23) and (SignAn<= Start+79))
    or (Konfig.Ersetzen) Then
    BEGIN
      While ActLine > LineAn Do DecLine;
      NewCurX:= SignAn+1;
      If NewCurX<2 Then NewCurX:=2;
    END;
  END;

  If (Modus=Cut) or (Modus=Del) Then FPos[FileNr].IfEdit:= TRUE;
  While ActLine > LastLine Do DecLine;

  If Modus<>del Then BlockMark (F6) Else {= Clear}
  BEGIN
    With FPos[FileNr] Do
    BEGIN
      If NewCurX>Start Then dec (NewCurX, Start);
      GotoXY (NewCurX, WhereY);
    END;
  END;
  ShowText;
  CloseUndo (0);
END;



FUNCTION PopUndoLine : String;
VAR
  x, y : Word;
  s    : String;
  c    : Char;
BEGIN
  If ReadPtr>BufPtr Then
  BEGIN
    If not UndoOpen Then
    BEGIN
      Assign (UndoFile, Vollpfad (TempPath, UndoBufFile)); FileMode:= 0;
      Reset (UndoFile); 
      PushErr:= IOResult;
      If PushErr<>0 Then Exit;
      UndoOpen:= TRUE;
    END;
    ReadPtr:= 1;
    BufPtr := 0;
    x:= 0;
    If not FPos[FileNr].Bin Then
    While (x<MaxUndo) and (not Eof(UndoFile)) and (PushErr=0) Do
    BEGIN
      inc (x);
      ReadLn (UndoFile, UndoBuf^[x]);
      PushErr:= IOResult;
      inc (BufPtr);
    END Else
    While (x<MaxUndo) and (not BinEof(UndoFile)) and (PushErr=0) Do
    BEGIN
      s:= '';
      y:= 0;
      While (y<MaxLen-8) and (not BinEof (UndoFile)) and (PushErr=0) Do
      BEGIN
        inc (y);
        Read (UndoFile, s[y]);
        PushErr:= IOResult;
      END;
      s[0]:= chr(y);
      If (Length(s)>=2) and (s[Length(s)]=#10) and (s[Length(s)-1]=#13) Then
      dec (s[0], 2);
      inc (x);
      UndoBuf^[x]:= s;
      inc (BufPtr);
    END;
    If PushErr<>0 Then Exit; 
  END;
  PopUndoLine:= UndoBuf^[ReadPtr];
  inc (ReadPtr);
END;



PROCEDURE Copy_UndoBuffer_InTo_Text;
VAR
  l : LongInt;
  InsLineNum  : Integer;
  LineLen     : Word;
  StartLen    : Word;
  EndLen      : Word;
  x           : Word;
  ActLineTemp : Word;
  UndoLine    : String;

LABEL
  Normal, Ende;

BEGIN
  ReadPtr:= 1; 

  With FPos[FileNr] Do
  BEGIN
  If (UndoError) or (UndoPointer=0) Then Exit;

  If UndoMaxLen >= MaxLen Then BEGIN ErrorMsg (LineError, Okay); Exit; END;

  InsLineNum:= UndoPointer; 

  While (Length(TLine^[ActLine]^) < Start+WhereX-1) and (Length(TLine^[ActLine]^)<MaxLen-1) Do
  CharAdd (TLine^[ActLine]^, ' ');

  If ((Start+WhereX-1 <= Length (TLine^[ActLine]^)) and (UndoPointer>1))
  or (FullLine)  Then
  BEGIN InsertLine (1); DecLine; END;

  ActLineTemp:= ActLine;

  UndoLine:= PopUndoLine; 

  StartLen:= Length (UndoLine) + Length (TLine^[ActLine]^);
  If (StartLen < MaxLen) Then dec (InsLineNum);

  If ActLine<LastLine Then
  BEGIN
    LineLen := Length (TLine^[ActLine+1]^);
    EndLen  := UndoLastLen + LineLen;
    If (EndLen < MaxLen) and (LineLen <> 0) and (not FullLine) Then
    dec (InsLineNum);
  END Else EndLen:= 260; {immer grer als MaxLen}

  If InsLineNum>0 Then
  BEGIN                       
    InsLines (ActLine, Word(InsLineNum));
    If RAMError<>0 Then
    BEGIN ErrorMsg (MemError, Okay); Goto Ende; END;
  END;

  For x := 1 To UndoPointer Do
  BEGIN
    If x = 1 Then
    BEGIN
      If StartLen<MaxLen Then
      Insert (UndoLine, TLine^[ActLine]^, Start+WhereX-1) Else
      Goto Normal;
    END Else
    BEGIN
      UndoLine:= PopUndoLine;

      If x = UndoPointer Then
      BEGIN
        If (EndLen<MaxLen) and (LineLen<>0) and (Not FullLine) Then
        BEGIN
          IncLine;
          TLine^[ActLine]^:= UndoLine + TLine^[ActLine]^;
        END Else Goto Normal;
      END Else

      BEGIN
        Normal:
        incLine;
        TLine^[ActLine]^:= UndoLine;
      END;
    END;
  END;

  SignAn:= Start+WhereX-1;
  SignEn:= UndoLastLen;
  If UndoPointer=1 Then SignEn:= SignEn+SignAn-1;
  LineEn:= ActLine;
  LineAn:= ActLineTemp;
  CheckMarks;

  If SignEn-Start<=78 Then NewCurX:= SignEn+2-Start Else NewCurX:= WhereX;
  Showtext;
ENDE:
  If UndoOpen Then BEGIN Close (UndoFile); If IOResult<>0 Then; END;
  IfEdit:= TRUE;
  END;

END;




END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
