UNIT ed_Unit; {gehrt zum Editor ED.PAS}

INTERFACE

USES
  biosCRT, Menue, editors, DOS, Monitor, ed_var, keycode, mouse,
  strings, time;


PROCEDURE CreateNewLine;
PROCEDURE DeleteNewLine;
PROCEDURE InsLines (StartLine, LineNum : Word);
PROCEDURE DelLines (StartLine, LineNum : Word);
PROCEDURE DecLine;
PROCEDURE IncLine;
PROCEDURE Go_Left  (y : Byte);
PROCEDURE Go_Right (y : Byte);
FUNCTION  ActSignAn (LineNum : Word) : Word;
FUNCTION  ActSignEn (LineNum : Word) : Word;


PROCEDURE WriteString (s : String; Lin : Byte);
PROCEDURE ShowText;
PROCEDURE ReleaseLines;
PROCEDURE ReadFile  (VAR FileName : PathStr);
PROCEDURE WriteFile (FileName : PathStr; Modus : Byte);
PROCEDURE MouseBottomLine;
PROCEDURE ClearLine (y, c : Byte);
PROCEDURE HeadLine;
PROCEDURE AlarmTut;
PROCEDURE FertigTut;
PROCEDURE JaNeinTut;
PROCEDURE ErrorMsg (ErrMsg : Str80; Modus : Byte);
PROCEDURE ClearLin;
PROCEDURE FormatAnzeige (Zeile : Word);
FUNCTION  sstr (Num : Word) : String;
FUNCTION  CutFName (s : String; Len : Byte) : String;


CONST
  can        = 1;
  must       = 2;
  exist      = 0;
  notExist   = 1;
  FileError  = 2;

  Janein     = 1;
  Okay       = 2;
  IncMode    : Boolean = FALSE;
  SideStep   : Byte    = 20;

VAR
  ReadStatus : Byte;

IMPLEMENTATION



PROCEDURE TWrite (Wert : Word);
BEGIN NumXY (1, 1, 10, Wert, 15, 1); END;




PROCEDURE CreateNewLine;
BEGIN
  inc (LastLine);
  GetMem (TLine^[LastLine], MaxLen);
END;



PROCEDURE DeleteNewLine;
BEGIN
  FreeMem (TLine^[LastLine], MaxLen);
  dec (LastLine);
END;


PROCEDURE InsLines (StartLine, LineNum : Word);
VAR
  x : Word;
BEGIN
  If  (MaxAvail >= (LongInt (MaxLen+1)) * LongInt(LineNum))
  and (LastLine + LineNum < MaxLines) and (LineNum>0) and (StartLine>0) Then
  BEGIN
    For x:= 1 To LineNum Do CreateNewLine;
    For x:= LastLine-LineNum DownTo StartLine Do
    StrCopy (TLine^[x]^, TLine^[x+LineNum]^);
    RAMError:=0;
  END Else RAMError:=1;
END;



PROCEDURE DelLines (StartLine, LineNum : Word);
VAR
  x : Word;
BEGIN
  If (StartLine-LineNum>0) and (LineNum>0) and (StartLine>0) Then
  BEGIN
    For x:= StartLine To LastLine Do
    StrCopy (TLine^[x]^, TLine^[x-LineNum]^);
    For x:= 1 To LineNum Do DeleteNewLine;
  END Else DosChar (#7);
  If LastLine=0 Then BEGIN InsLines (1, 1); TLine^[1]^:=''; END;
END;



PROCEDURE Go_Left (y : Byte);
VAR
  u : Byte;
BEGIN
  With FPos[FileNr] Do
  BEGIN
  ChangeL:=FALSE;
  If WhereX > WinL Then GotoXY (WhereX - 1, y) Else
  If Start > 0 Then
  BEGIN
    u:= SideStep; If u>Start Then u:= Start;
    dec (Start, u); GotoXY (WhereX+u-1, y); ShowText;
  END Else
  If ActLine>1 Then
  BEGIN
    DecLine; u:= Length(TLine^[ActLine]^);
    If u>WinR-2 Then
    BEGIN Start:= u-(WinR-2); GotoXY (WinR,   y-1); ShowText; END Else
    BEGIN Start:= 0;          GotoXY (WinL+u, y-1); END;
    ChangeL:=TRUE;
  END;
  END;
END;



PROCEDURE Go_Right (y : Byte);
BEGIN
  With FPos[FileNr] Do
  BEGIN
  ChangeL:=FALSE;
  If WhereX+Start-1 < MaxLen Then
  BEGIN
    If WhereX < WinR  Then GotoXY (WhereX + 1, y) Else
    BEGIN inc (Start, SideStep); GotoXY (WhereX - SideStep-1, y); ShowText; END;
  END Else
  BEGIN
    If Start>0 Then BEGIN Start:=0; ShowText; END;
    GotoXY (WinL, y); IncLine; ChangeL:= TRUE;
  END;
  END;
END;



PROCEDURE IncLine;
BEGIN
  With FPos[FileNr] Do
  BEGIN
    If ActLine < LastLine Then
    If (Line<=WinUK-WinOK) Then inc (Line) Else
    BEGIN
      If IncMode Then
      BEGIN inc (FirstLine, 10); dec (Line, 9); IncMode:= False; END Else
      inc (FirstLine);
    END;
    ActLine:= FirstLine + Line;
  END;
END;



PROCEDURE DecLine;
BEGIN
  With FPos[FileNr] Do
  BEGIN
    If Line > 1 Then dec (Line) Else
    If FirstLine > 0 Then dec (FirstLine);
    ActLine:= FirstLine + Line;
  END;
END;



FUNCTION ActSignAn (LineNum : Word) : Word;
BEGIN
  If LineNum = LineAn Then
  ActSignAn := SignAn Else ActSignAn:= 1;
END;


FUNCTION ActSignEn (LineNum : Word) : Word;
BEGIN
  If LineNum = LineEn Then
  ActSignEn := SignEn Else ActSignEn:= Length (TLine^[LineNum]^);
END;



PROCEDURE WriteString (s : String; Lin : Byte);
VAR
  i, sLine       : Word;
  c              : Char;
  Ubr, col, tcol : Byte;
BEGIN
  With FPos[FileNr] Do
  BEGIN
    sLine:= FirstLine+Lin-(WinOk-1);
    If (Konfig.Seitwechsel) and (sLine MOD LinesPerSide=1) Then
    CharXY (1, Lin, #16, lightgreen, menCol.WinB) Else
    CharXY (1, Lin, #32, 0, 7);

    If Konfig.UmBruchEin Then Ubr:=Konfig.Umbruch Else Ubr:= 255;
    col:= 7; tcol:= 0;

    For i:= WinL-1 To WinR-1 Do
    BEGIN
    If i+Start=Ubr Then BEGIN col:= MenCol.WinB; tcol:= 7; END;

    If  i+Start <= Length (s) Then
    BEGIN
      c:= s[i+Start];
      If  (Konfig.AllChars) and (c=' ') Then c:= #250;
      If  (LineEn  <> 0)      and (LineAn <> 0)
      and (sLine   >= LineAn) and (sLine  <= LineEn)
      and (i+Start >= ActSignAn(sLine)) and (i+Start<=ActSignEn(sLine))
      and (col=7) Then
      col:= cyan;
      CharXY (i+1, Lin, c, tcol, col);
    END Else
    BEGIN
      If (Konfig.AllChars) and (i+Start=Length(s)+1) and
      (FirstLine+Lin-(WinOk-1) <= LastLine) Then
      CharXY (i+1, Lin, #20, tCol, col) Else
      CharXY (i+1, Lin, #32, tCol, col);
    END;
    col:=7; tcol:= 0;
    END;
  END;
END;



PROCEDURE ShowText;
VAR
  y : Word;
BEGIN
  With FPos[FileNr] Do
  BEGIN
    For y:= WinOk To WinUK Do
    If (FirstLine+y-(WinOk-1)) <= LastLine Then
    WriteString (TLine^[FirstLine+y-(WinOK-1)]^, y) Else
    WriteString (Fill, y);
  END;
END;



PROCEDURE ReleaseLines;
BEGIN
  {If-Abfrage nur zu Testzwecken, kann auch raus}
  If (TextHeapStart<>NIL) and (TextHeapStart=THeapSave) Then
  BEGIN Release (TextHeapStart); LastLine:= 0; END Else
  ErrorMsg ('Interner Speicherfehler', Okay);
END;



PROCEDURE ReadFile (VAR FileName : PathStr);
VAR
  s         : String;
  attr, Gel : Word;
  p         : Byte;
  TabStr    : String;
  o         : Byte;

LABEL
  Nochmal, Ende, FError;
BEGIN
  TabStr:= ''; For o:= 1 To Konfig.TabLen Do CharAdd (Tabstr, #32);
  MaxLen:= Konfig.StartMaxLen; ReadStatus:= NotExist; FileMode:=0;

Nochmal:
  LastLine:=0; Mark (TextHeapStart);

  Assign (f, FileName); GetFattr (f, Attr);
  If (IOResult=0) and (Attr and Directory<>0) Then
  BEGIN ErrorMsg (w7, Okay); ReadStatus:= FileError; Goto FError; END;

  If FPos[FileNr].Bin Then
  BEGIN Assign (fBin, FileName); Reset (fBin, 1); END Else
  BEGIN
    Assign (f, FileName); SetTextBuf (f, DirList^, SizeOf (DirListe));
    Reset (f);
  END;

  If IOResult<>0 Then
  BEGIN CreateNewLine; TLine^[LastLine]^:= ''; Exit; END;
  ReadStatus:= Exist;

  If FPos[FileNr].Bin Then
  While (not EOF (fBin)) and (LastLine < MaxLines) and (MaxAvail >= MaxLen+1) Do
  BEGIN
    CreateNewLine;
    BlockRead (fbin, TLine^[LastLine]^[1], MaxLen-10, gel);
    If IOResult<>0 Then
    BEGIN ErrorMsg (w2, okay); ReadStatus:= FileError; Goto FError; END;
    TLine^[LastLine]^[0]:= chr (lo (gel));
  END Else
  While (not EOF (f)) and (LastLine < MaxLines) and (MaxAvail >= MaxLen+1) Do
  BEGIN
    ReadLn (f, s);
    If IOResult<>0 Then BEGIN ErrorMsg (w2, okay); ReadStatus:= FileError; Goto FError; END;
    p:= pos (#9, s);
    While (p<>0) and (Length (s) < AbsMaxLen-Konfig.TabLen) Do
    BEGIN Delete (s, p, 1); Insert (TabStr, s, p); p:= pos (#9, s); END;
    If Length (s) < MaxLen Then
    BEGIN CreateNewLine; StrCopy (s, TLine^[LastLine]^); END Else
    If Length(s) < AbsMaxLen Then
    BEGIN
      ReleaseLines; MaxLen:= Length (s)+1; Close (f); If IOResult<>0 Then;
      Goto Nochmal;
    END Else BEGIN ErrorMsg (w3, okay); ReadStatus:= FileError; Goto FError; END;
  END;

  If (MaxAvail < MaxLen+1) or (LastLine >= MaxLines) Then
  BEGIN
    ErrorMsg (w6, okay);
    FError:
    ReleaseLines;
    CreateNewLine; TLine^[LastLine]^:= '';
    FileName:= 'NONAME';
    ReadStatus:= NotExist; Goto Ende;
  END Else
  If LastLine=0 Then BEGIN CreateNewLine; TLine^[LastLine]^:= ''; END;
Ende:
  If FPos[FileNr].Bin Then Close (fBin) Else Close (f); If IOResult<>0 Then;
  If Konfig.Umbruch > MaxLen-2 Then Konfig.Umbruch:= MaxLen-2;
END;


FUNCTION GetCode (Code : Char) : String;
BEGIN
  CASE Code Of
    '' : GetCode:= '&pound;';
    '' : GetCode:= '&sub1;';
    '' : GetCode:= '&iquest;';
    '' : GetCode:= '&Auml;';
    '' : GetCode:= '&Ouml;';
    '' : GetCode:= '&Uuml;';
    '' : GetCode:= '&auml;';
    '' : GetCode:= '&ouml;';
    '' : GetCode:= '&uuml;';
    '' : GetCode:= '&Aring;';
    '' : GetCode:= '&aring;';
    '' : GetCode:= '&frac12;';
    '' : GetCode:= '&frac14;';
    '' : GetCode:= '&Aelig;';
    '' : GetCode:= '&aelig;';
    '' : GetCode:= '&Ccedil;';
    '' : GetCode:= '&ccedil;';
    '' : GetCode:= '&Eacute;';
    '' : GetCode:= '&eacute;';
    '' : GetCode:= '&ntilde;';
    '' : GetCode:= '&Ntilde;';
    '' : GetCode:= '&Oslash;';
    '' : GetCode:= '&szlig;';
    '' : GetCode:= '&laquo;';
    '' : GetCode:= '&raquo;';
    '' : GetCode:= '&deg;';
    '~' : GetCode:= '&cedil;';
    '' : GetCode:= '&agrave;';
    '' : GetCode:= '&aacute;';
    '' : Getcode:= '&acirc;';
    '' : GetCode:= '&egrave;';
    '' : GetCode:= '&euml;';
    '' : Getcode:= '&ecirc;';
    '' : GetCode:= '&igrave;';
    '' : GetCode:= '&iacute;';
    '' : Getcode:= '&icirc;';
    '' : GetCode:= '&iuml;';
    '' : GetCode:= '&ograve;';
    '' : GetCode:= '&oacute;';
    '' : Getcode:= '&ocirc;';
    '' : GetCode:= '&ugrave;';
    '' : GetCode:= '&uacute;';
    '' : Getcode:= '&ucirc;';
    '' : GetCode:= '&iexcl;';
    '' : GetCode:= '&oslash;';
    '' : Getcode:= '&yuml;';
    '' : GetCode:= '&divide;';
    '' : GetCode:= '&ordf;';
    '' : Getcode:= '&ordm;';
    '' : GetCode:= '&not;';
    '' : GetCode:= '&middot;';
    #21 : Getcode:= '&sect;'; (*Paragraf*)
    '''': Getcode:= '&acute;';
  (*
    '&' : GetCode:= '&amp;';
    #32 : GetCode:= '&nbsp;';
    '"' : Getcode:= '&quot;';
    '>' : GetCode:= '&gt;';
    '<' : GetCode:= '&lt;';
    *)
    Else  GetCode:= Code;
  END;
END;



FUNCTION HTMLLine (ein  : String) : String;
VAR
  x : Byte;
  s : String;
BEGIN
  s:= '';
  For x:= 1 To Length (ein) Do
  If Length (s) < 240 Then StrAdd (s, GetCode(ein[x]));
  HTMLLine:= s;
END;



PROCEDURE WriteFile (FileName : PathStr; Modus : Byte);
VAR
  bak             : File;
  x, OldAttr, ges : Word;
BEGIN
  If (not FPos[FileNr].IfEdit) and (Modus=Can) Then Exit;
  If (Konfig.BakFiles) and (pos (TempEnd, FileName)=0) and (not HTML) Then
  BEGIN
    Assign (bak, ChangeFileExt (FileName, BakEnd));
    SetFAttr (Bak, 32);
    Erase  (bak); If IOResult<>0 Then;
    Assign (bak, FileName);
    SetFAttr (bak, 0);
    Rename (bak, ChangeFileExt (FileName, BakEnd)); If IOResult<>0 Then;
  END;

  Assign (f, FileName);
  GetFAttr (f, OldAttr);
  If DOSError=0 Then SetFAttr (f, 32) Else OldAttr:= 32;
  If IOResult<>0 Then;

  If FPos[FileNr].Bin Then
  BEGIN
    Assign (fbin, FileName);
    ReWrite (fbin, 1);
    For x:= 1 To LastLine Do
    BEGIN
      BlockWrite (fbin, TLine^[x]^[1], Length (TLine^[x]^), ges);
      If IOResult<>0 Then ErrorMsg (w5, okay);
    END;
    Close (fbin);
    SetFAttr (fbin, OldAttr or Archive);
  END Else
  BEGIN
    If HTML Then
    Assign (f, ChangeFileExt (FileName, 'HTM')) Else
    Assign (f, FileName);
    SetTextBuf (f, DirList^, SizeOf (DirListe));
    ReWrite (f); 
    For x:= 1 To LastLine Do
    BEGIN
      If HTML Then 
      WriteLn (f, HTMLLine(TLine^[x]^)) Else
      WriteLn (f, TLine^[x]^);
      If IOResult<>0 Then ErrorMsg (w5, okay);
    END;
    Close (f);
    SetFAttr (f, OldAttr or Archive);
  END;

  If Modus = must Then FPos[FileNr].IfEdit:= FALSE;
  If IOResult<>0 Then ErrorMsg (w5, okay);
END;



PROCEDURE MouseBottomLine;
BEGIN
  If ViewMode=GetEv Then
  BEGIN
    If ym=WinOk-1 Then BEGIN If xm>WinR-2 Then t2:= Up; Exit; END;
    If ym<>25 Then Exit;
  END;
  InitHeadLine (25);
  HeadField ('  ~F1~Hilfe',  #0, F1);
  HeadField ('~F2~Save',     #0, F2);
  HeadField ('~F3~Cut',      #0, F3);
  HeadField ('~F4~Paste',    #0, F4);
  HeadField ('~F5~Copy',     #0, F5);
  HeadField ('~F6~ClrBl',    #0, F6);
  HeadField ('~F7~BlockAn',  #0, F7);
  HeadField ('~F8~BlockEn',  #0, F8);
  HeadField ('~Esc~Ende',    #27,#0);
  If ViewMode= ShowMen Then
  BEGIN
    CharXY  (1,  25, #27, MenCol.KeyT, MenCol.WinB);
    WriteXY (77, 25, #26'  '#25, MenCol.KeyT, MenCol.WinB);
  END
  Else
  BEGIN
    If xm>78 Then BEGIN t1:=#0; t2:= Down;  END Else
    If xm>75 Then BEGIN t1:=#0; t2:= Right; END Else
    If xm<=2 Then BEGIN t1:=#0; t2:= Left;  END Else;
  END;
END;



PROCEDURE ClearLine (y, c : Byte);
VAR
  x : Byte;
BEGIN
  For x:= 1 To 80 Do CharXY (x, y, #32, 0, c);
END;



PROCEDURE HeadLine;
VAR
  i : Byte;
BEGIN
  ClearLine (WinOK-1, MenCol.WinB);
  With FPos[FileNr] Do
  BEGIN
    i:= Length (FName);
    While (FName[i]<>'\') and (i>1) Do dec (i); If FName[i]='\' Then inc (i);
    WriteXY ( 2, WinOK-1, copy (FName, i, 13), yellow, MenCol.WinB);
    WriteXY (17, WinOK-1, 'Pos              ASCII      Lnge       Zeile       Spalte', 7, MenCol.WinB);
  END;
  CharXY  (80, WinOk-1, #24, MenCol.KeyT, MenCol.WinB);
END;



PROCEDURE ErrorButtons (Modus : Byte);
BEGIN
  CASE Modus Of
    1 : BEGIN
          Button (22, 14, '  ~Enter~ Ja    ',       #13, #0);
          Button (45, 14, '  ~Esc~   Nein  ',       #27, #0);
        END;
    2 : Button (32, 14, '  ~Enter~ Okay  ',         #13, #0);
  END;
END;



PROCEDURE AlarmTut;
VAR
  x : Byte;
BEGIN
  If not Konfig.SoundOn Then Exit;
  For x:= 1 To 3 Do
  BEGIN Sound (440); xDelay (100); Sound (880); xDelay (100); END;
  NoSound;
END;


PROCEDURE FertigTut;
VAR
  x : Byte;
BEGIN
  If not Konfig.SoundOn Then Exit;
  For x:= 2 To 4 Do
  BEGIN Sound (220*x); xDelay (150); END;
  NoSound;
END;


PROCEDURE JaNeinTut;
VAR
  x : Byte;
BEGIN
  If not Konfig.SoundOn Then Exit;
  For x:= 4 DownTo 2 Do
  BEGIN Sound (220*x); xDelay (150); END;
  NoSound;
END;


PROCEDURE ErrorMsg (ErrMsg : Str80; Modus : Byte);
VAR
  screen : Array[1..1700] Of Byte;

BEGIN
  Move (Mem[VideoAddr:1100], screen, SizeOf(Screen));
  CursorOff;
  ViewMode:= ShowMen;
  UniWin  (10,  8, 71, 16, 'Warnung');
  ErrorButtons (Modus);

  TextAttr:=MenCol.WinB shl 4 + MenCol.WinT;
  GotoXY (CenterTextX (ErrMsg)-Lo(WindMin)+1, 3);
  WriteStr (ErrMsg);
  GotoXY (CenterTextX (ErrMsg)-Lo(WindMin), 3);
  ViewMode:= GetEv;
  CASE Modus Of
    Okay   : AlarmTut;
    JaNein : JaNeinTut;
  END;

  REPEAT
    MouseKey;
    ErrorButtons (Modus);
  UNTIL (t1=#13) or (t1=#27);

  Taste:= t1;
  Move (screen, Mem[VideoAddr:1100], SizeOf(Screen));
  RestoreScreen;
  t1:=#0; t2:=#0;
  CursorOn;
END;




PROCEDURE ClearLin;
BEGIN
  ClearLine (25, MenCol.WinB);
  WriteXY (2, 25, 'Bitte warten. Bearbeite Zeile : ', MenCol.KeyT, MenCol.WinB);
END;


PROCEDURE FormatAnzeige (Zeile : Word);
BEGIN
  NumXY (34, 25, 5, Zeile, MenCol.KeyT, MenCol.WinB);
END;



FUNCTION CutFName (s : String; Len : Byte) : String;
VAR
  tmp : String[3];
BEGIN
  If Length(s)<=Len Then CutFName:= s Else
  BEGIN
    tmp:= s;
    delete (s, 1, 3);
    While Length(s)>Len Do delete (s, 1, 1);
    If pos ('\', s) <> 0 Then While s[1]<>'\' Do delete (s, 1, 1);
    CutFName:= tmp+'...'+s;
  END;
END;


FUNCTION sstr (Num : Word) : String;
VAR
  tmp : String[12];
BEGIN
  Str (Num, tmp);
  sstr:= tmp+'    ';
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
