UNIT ED_VAR;

INTERFACE

USES
  DOS, BiosCrt, menue, Dialogs, Monitor, disk, strings (*, ed_maxe*);


CONST
  CutError    = ' Block zu gro zum Entlschen. Trotzdem lschen?';
  CopyError   = ' Block zu gro zum Kopieren';
  LineError   = ' Zielzeile zu lang';
  MemError    = ' Nicht genug Speicherplatz zum Einfgen';

  EdHelpFile  = 'ED.HLP';
  RunHelpFile = 'RUN.HLP';
  EigHelpFile = 'EIGHELP.HLP';
  KonfigFile  = 'ED.INI';
  TempEnd     = '.TMP';
  BakEnd      = 'BAK';
  TimeDiff    = 15 * 60 * 91 DIV 5;   {15 Minuten}

  w1 = 'Nicht gengend Speicher';
  w2 = 'Datei kann nicht gelesen werden';
  w3 = 'Zeile mit berlnge gefunden';
  w4 = 'Datei kann nicht geffnet werden';
  w5 = 'Datei kann nicht geschrieben werden';
  w6 = 'Datei zu gro zum Laden';
  w7=  'Die Datei ist ein Verzeichnis';
  w8=  'Gleichnamiges Verzeichnis gefunden';
  w9=  'Datei existiert bereits. berschreiben?';

  MaxLines    = 14000;
  AbsMaxLen   = 253;
  MaxUndo     = 100;
  MaxTabLen   = 255;
  MaxFiles    =   9; {Nicht erhhen !!!}
  MaxDirList  = 200; {Achtung! Siehe DirList, auch als Puffer fr HelpLines!}
  MaxHLists   =  10; {Mindestens...}

  WinOK : Byte = 3;
  WinUK = 24;
  WinL  = 2;
  WinR  = 80;

  Save        = 1;
  NotSave     = 2;

  ins         : Boolean   = TRUE;
  BinOpen     : Boolean   = FALSE;
  RAMError    : Word      = 0;
  UndoPointer : Word      = 0;
  Fill        : String[1] = '';
  FileNum     : Word      = 0;
  FileNr      : Word      = 1;
  OpenMode    : Byte      = 0;
  DoMenue     : Boolean   = FALSE;
  GetTextMem  : Boolean   = FALSE;
  Listwahl    : Boolean   = FALSE;
  HTMmode     : Boolean   = FALSE;
  html        : Boolean   = FALSE;
  pair1       : String    = '';
  pair2       : String    = '';
  sMaxLen     : Byte      = 0;
  sMaxTemp    : Byte      = 0;

TYPE
  Str5    = String [5];
  LineStr = String;
  Str80   = String [80];

  KonfigRec = RECORD
                StartMaxLen : Byte;
                EndWarning  : Boolean; {Piepton bei Warnung?}
                TABLen      : Byte;    {Zahl der TABsprnge}
                TABPointer  : Byte;
                TABMarks    : array [1..MaxTabLen] Of Byte;
                Umbruch     : Byte;
                UmbruchEin  : Boolean;
                SeitWechsel : Boolean;
                BakFiles    : Boolean;
                AutoSave    : Boolean;
                DateiFilter : Byte;
                Printer     : Char;
                PFormat     : Boolean;
                PRandOben   : Byte;
                PLines      : Byte;
                PRand       : Byte;
                PFusszeile  : Byte;
                PMaxSides   : Byte;
                PPunkt      : Byte;
                Wait        : Boolean;
                CmdLine     : PathStr;
                PrimeFile   : PathStr;
                Compiler    : PathStr;
                ProgStart   : PathStr;
                SuchWort    : PathStr;
                Ersatzwort  : PathStr;
                Ersetzen    : Boolean;
                MacWin      : Boolean;
                AllChars    : Boolean;
                Blind       : Boolean;
                SoundOn     : Boolean;
                ReserveStr1 : PathStr;
                ReserveStr2 : PathStr;
                ReserveArr  : array[1..95] Of Byte;
              END;


TYPE
  DirListe   = array [1..MaxDirList] Of String[12];  {fr FileMan UND SetTextBuf !!!}
  TextLin    = Array [1..MaxLines] Of ^LineStr;
  UndoBuffer = Array [1..MaxUndo] Of String;
  HstLst     = Array [1..MaxHLists] Of HistoryList;

VAR
  ProgPath    : PathStr;
  Konfig      : KonfigRec;
  fbin        : File;
  f           : Text;
  MaxLen      : Word;
  Taste       : Char;
  TLine       : ^TextLin;
  UndoBuf     : ^Undobuffer;
  UndoFile    : Text;
  DirList     : ^DirListe;
  HelpLines   : ^ShortHelpList;
  HistList    : ^HstLst;
  ChangeL     : Boolean;
  TempFName   : Array[1..MaxFiles] of PathStr;
  DOSHelpLine : String;
  OpenName    : PathStr;

  FPos        : Array[1..MaxFiles] Of
                RECORD
                  Start, FirstLine, Line, NewCurX : Word; IfEdit : Boolean;
                  FName : PathStr;
                  Bin   : Boolean;
                END;

  Dateiwahl     : Byte;
  TextHeapStart : Pointer;
  THeapSave     : Pointer;
  LinesPerSide  : Byte;
  ProgDriveNum  : Byte;

  LastLine, ActLine,
  LineAn, LineEn, SignAn, SignEn, 
  OldFLin       : Word;
  DriveList     : TDriveList;


PROCEDURE GetAllMem;
PROCEDURE FreeAllMem;


IMPLEMENTATION
VAR
  HeapPointer : Pointer;  
  i           : Word;


PROCEDURE InitKonfig;
BEGIN
  Fillchar (Konfig, SizeOf(Konfig), 0);
  With Konfig Do
  BEGIN
    StartMaxLen :=  90;
    EndWarning  :=  TRUE;
    TABLen      :=  2;
    TABPointer  :=  1;
    Umbruch     :=  80;
    UmbruchEin  :=  TRUE;
    BakFiles    :=  TRUE;
    DateiFilter :=  1;
    Printer     := '1';
    PRandOben   := 3;
    PLines      := 55;
    PRand       := 8;
    PFusszeile  := 4;
    PPunkt      := 10;
  END;
  Fillchar (HistList^, SizeOf(HstLst), #0);
  If ParamCount=0 Then
  FileNr:= 1; FPos[1].FName:= 'NONAME';
  If ParamCount=0 Then FileNum:=1 Else FileNum:=0;
END;



PROCEDURE ReadKonfig;
VAR
  f : File;
  gel1, gel2, gel3, gel4, gel5 : Word;
LABEL
  Init;
BEGIN
  Assign (f, ProgPath+KonfigFile); FileMode:=0;
  Reset  (f, 1);
  If IOResult<>0 Then BEGIN InitKonfig; Exit; END;
  BlockRead (f, Konfig, SizeOf (Konfig), gel1);
  BlockRead (f, HistList^, SizeOf (HstLst), gel2);
  If (ParamCount=0) Then
  BEGIN
    BlockRead (f, FPos, SizeOf (FPos), gel3);
    BlockRead (f, FileNum, SizeOf (FileNum), gel4);
    BlockRead (f, FileNr,  SizeOf (FileNr),  gel5);
    If (IOResult<>0) or (gel3<> SizeOf (FPos)) or (gel4<>SizeOf (FileNum)) or (gel5<>SizeOf (FileNr))
    Then Goto Init;
  END;
  If (IOResult<>0) or (gel1<> SizeOf (Konfig)) or (gel2<>SizeOf (HstLst)) Then
  BEGIN Init: InitKonfig; END;
  Close (f); gel1:= IOResult;
END;



PROCEDURE WriteKonfig;
VAR
  f   : File;
  ges : Word;
BEGIN
  If sMaxLen<>0 Then Konfig.StartMaxLen:= sMaxTemp;
  Assign (f, ProgPath+KonfigFile); FileMode:=2;
  Rewrite  (f, 1);
  If IOResult<>0 Then
  BEGIN SetFAttr (f, 32); Rewrite (f, 1); If IOResult<>0 Then Exit; END;
  BlockWrite (f, Konfig, SizeOf (Konfig), ges);
  BlockWrite (f, HistList^, SizeOf (HstLst), ges);
  BlockWrite (f, FPos, SizeOf (FPos), ges);
  BlockWrite (f, FileNum, SizeOf (FileNum), ges);
  BlockWrite (f, FileNr,  SizeOf (FileNr),  ges);
  ges:= IOResult;
  Close (f);
  ges:= IOResult;
END;


PROCEDURE GetAllMem;
BEGIN
  If GetTextMem Then Exit;
  If MaxAvail > SizeOf (TextLin) + SizeOf(UndoBuffer) + SizeOf (DirListe) + SizeOf (HstLst) + 1000 Then
  BEGIN
    Mark (HeapPointer);                     {Fr Release}
    GetMem (TLine,    SizeOf (TextLin));
    GetMem (UndoBuf,  SizeOf (UndoBuffer));
    GetMem (DirList,  SizeOf (DirListe));   {fr FileMan UND SetTextBuf !!!}
    GetMem (HistList, SizeOf (HstLst));     {Puffer fr HistListen}
    Mark (THeapSave);
    GetTextMem:= TRUE;
  END Else
  BEGIN DosStr ('Nicht gengend Speicher! Weiter mit Taste.'); WaitKey; Halt; END;
  ReadKonfig;
END;


PROCEDURE FreeAllMem;
BEGIN
  If not GetTextMem Then Exit;
  WriteKonfig;
  Release (HeapPointer);
  GetTextMem:= FALSE;
END;



{----------------------------- Initialisierung -----------------------------}

BEGIN

  If (ScrMode=MonoMon) (*or (ParamStr(1)='/SW')*) Then With MenCol Do
  BEGIN
    ButtB := 0;
    Balken:= 7;
    WinB  := 0;
    HelpB := 0;
    HelpT := 7;
    KeyT  := 15;
    WinT  := 7;
  END;

  ProgPath:= ParamStr(0);
  While (ProgPath[Length(ProgPath)]<>'\') and (Length(ProgPath)>0) Do dec (ProgPath[0]);
  ProgDriveNum:= ord (Upcase (ProgPath[1])) - 64;

  (*ReadIniFile (VollPfad (ProgPath, 'ED.COL'));*)

  Fillchar (FPos, SizeOf(FPos), #0);
  For i:= 1 To MaxFiles Do With FPos[i] Do BEGIN Line:=1; NewCurX:= 2; END;
  FileNr:= 1; FPos[1].FName:= 'NONAME'; If ParamCount=0 Then FileNum:=1;

  GetTextMem:= FALSE;
  GetAllMem;

  If Konfig.PFormat Then LinesPerSide:= Konfig.PLines Else LinesPerSide:= 63;

  Blinds:= Konfig.Blind;

  GetLWList (DriveList);
  For i:= 1 To SizeOf (TDriveList) Do
  If DriveList[i]=PhantomDrive Then DriveList[i]:= NoDrive;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
