PROGRAM EditLine;
{$M 10000, 0, 0}
USES
  BiosCrt, Masken, strings, Dos, keycode;


VAR
  x       : Byte;
  Param   : String;
  f       : Text;

CONST
  Environ : String  = '';
  Batch   : String  = '';
  ins     : Boolean = TRUE;
  UpCas   : Boolean = FALSE;
  add     : Boolean = FALSE;
  view    : Boolean = FALSE;


PROCEDURE Hilfe;
BEGIN
DosLnLF
 (#13#10+
  'EDITLINE   '+CopyRight+#13#10+
  'stellt in BATCH-Dateien eine Benutzer-Eingabezeile zur Verfgung'#13#10#13#10+
  'EDITLINE [BATCH-Datei] [Variable] [/g /a /z /h]'#13#10#13#10+
  'BATCH-Datei: Name der Datei, in die EDITLINE den SET-Befehl schreiben soll');
DosLnLF
 ('Variable   : Name der Umgebungsvariablen, die die Benutzereingabe aufnehmen soll'#13#10+
  '/g   Benutzereingabe wird in Grobuchstaben verwandelt'#13#10+
  '/a   Benutzereingabe wird an den Inhalt der Variablen angehngt');
DosLnLF
 ('/z   Inhalt der Variablen wird zum Editieren angezeigt'#13#10+
  '/h   zeigt Bedienhinweise fr den Anwender');
  BlindStop;
  Halt;
END;



PROCEDURE Help;
BEGIN
DosLnLF
  ('Enter : Eingabe besttigen                 Esc   : Eingabe abbrechen'#13#10+
   '> < : Cursor bewegen                     Pos1  : Cursor an Zeilenanfang'#13#10+
   'Rck  : Zeichen vor Cursor lschen         Ende  : Cursor an Zeilenende');
DosLnLF
  ('Entf  : Zeichen ber Cursor lschen        Einfg : Einfgemodus Ein/Aus'#13#10+
   'F9    : alle Zeichen lschen               F10   : Zeile wiederherstellen');
  BlindStop;
  Halt;
END;       



PROCEDURE ErrorMsg (s : String; Error : Word);
BEGIN
  DosLnLF (s);
  BlindStop;
  Halt (Error);
END;



PROCEDURE EditStr (VAR s : String);
VAR
  StrTemp : String;
  ActSign : Byte;
  y       : Byte;

PROCEDURE IncSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign<=Length(s)) Do BEGIN inc (ActSign); dec (Zahl); END;
  GotoXY (ActSign, y);
END;


PROCEDURE DecSign (Zahl : Byte);
BEGIN
  While (Zahl>0) and (ActSign>1) Do BEGIN dec (ActSign); dec (Zahl); END;
  GotoXY (ActSign, y);
END;


BEGIN
  y:= WhereY;
  ActSign:= Length (s)+1;
  StrTemp:= s;

  REPEAT
    GotoXY (1, y); OutStr (s); ClrEol; GotoXY (ActSign, y);

    ScanBKeys;
    If t1=#27 Then
    BEGIN
      Close (f); InOutRes:= 0;
      ErrorMsg (#13#10'Eingabe vom Anwender abgebrochen', 3);
    END;
    If (t1<>#0) and (t1<>#13) Then
    BEGIN
      If t1=Back Then
      BEGIN If ActSign > 1 Then BEGIN DecSign (1); delete (s, ActSign, 1); END; END
      Else
      BEGIN
        If not ins         Then delete (s, ActSign, 1);
        If Length (s) < 79 Then insert (t1, s, ActSign);
        IncSign (1);
      END
    END
    Else
    CASE t2 Of
      Left  : DecSign (1);
      Right : IncSign (1);
      Entf  : delete  (s, ActSign, 1);
      Pos1  : DecSign (80);
      Endx  : IncSign (80);
      Einfg : Ins:= not Ins;
      F9    : BEGIN s[0]:= #0;   DecSign (80); END;
      F10   : BEGIN s:= StrTemp; IncSign (80); END;
    END;
  UNTIL (t1=#13);
END;


BEGIN
  StretchParam (Param);
  If ParamCount = 0 Then Hilfe;
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1] = '/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'H' : Help;
      'G' : UpCas := TRUE;
      'A' : Add   := TRUE;
      'Z' : View  := TRUE;
    END Else
    BEGIN
      If Batch  ='' Then Batch  := Param Else
      If Environ='' Then Environ:= Param;
    END;
  END;

  If Batch  ='' Then ErrorMsg ('Name der Batch-Datei fehlt', 1);
  If Environ='' Then ErrorMsg ('Name der Umgebungsvariablen fehlt', 2);

  Assign (f, Batch); 
  FileMode:= 2;
  Rewrite (f);

  Batch:= GetEnv (Environ);
  If view Then Param:= Batch Else Param:= '';

  EditStr (Param);
  If Upcas Then Param:= UpStr (Param);
  If add   Then Param:= Batch+Param;

  WriteLn (f, '@ECHO OFF'#13#10'SET '+Environ+'='+Param);
  Close (f);
  If IOResult<>0 Then ErrorMsg ('Fehler beim Schreiben in Batch-Datei', 4);
  Halt (0);
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
