
; stellt das Euro-Zeichen auf Bildschirm und Drucker dar

jmp BEGIN 

DB            1     ; VersionsNummer des Treibers 
DB            11    ; Treiber-Nummer zur berprfung d. UnLoader
DB            1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB            17h   ; Nummer eines der umgeleiteten Interrupts 
DB            0     ; Zahl der erwarteten Start-Parameter
 
Flag      DB  0
EuroChar  DB  213   ; Nummer des Ascii-Zeichens, das den Euro darstellen soll
Char1     DB  'C'   ; erstes zu druckendes Euro-Zeichen
Char2     DB  ''   ; zweites zu druckendes Euro-Zeichen
Char3     DB  0     ; wird zu 'R', wenn 'EUR' gedruckt werden soll

VideoAddr DW $B000 

Euro8x16  DB 00000000b      ; Bitmap fr Euro-Symbol
>            00000000b
>            00011110b
>            00110000b 
>            01100000b 
>            11111110b 
>            01100000b 
>            11111110b 
>            01100000b 
>            01100000b 
>            00110000b 
>            00011110b 
>            00000000b 
>            00000000b 
>            00000000b 
>            00000000b 
 
; ------------------------- neuer Int 10h-Handler ------------------------
 
PROC Change: 
  mov  ax, 1110h
  mov  bx, 1000h
  mov  cx, 1              ; Zahl der zu verndernden Zeichen
  cs:
  mov  dl, EuroChar       ; ASCII-Code des zu ersten zu ndernden Zeichens
  xor  dh, dh
  push cs
  pop  es
  lea  bp, Euro8x16       ; Adresse der Bitmaske
  ret
ENDP


OldInt10h:
  pushf
  DB 9Ah                  ; CALL Far Ptr = alte Int-10h-Routine
  OBJECT Old10A:
    Ofs DW '20'           ; hier setzt der Loader die alte Adresse
    Seg DW '00'           ; der alten Int-10h-Routine ein.
  OBJECT END
RET


EuroChange:
  cmp ax, 3               ; wenn in den normalen Textmodus umgeschaltet wird
  je  @change

@OldInt10:
  DB 0EAh                 ; JMP Far Ptr = alte Int-10h-Routine
  OBJECT Old10:
    Ofs DW '20'           ; hier setzt der Loader die alte Adresse
    Seg DW '00'           ; der alten Int-10h-Routine ein.
  OBJECT END

@Change:
  cs:
  cmp Byte Flag, 2
  je  @OldInt10

  #OldInt10h
  push ax, bx, cx, dx, es, bp
  #Change
  #OldInt10h
  pop  bp, es, dx, cx, bx, ax
IRET

;---------------------------- Alte Druck-Routine ----------------------------
 
OldPrinter:
  pushf                                     
  DB 9Ah                   ; Call Far Ptr = alte Print-Routine 
  OBJECT Old17:
    Ofs DW '7.'            ; hier setzt der Loader die alte Adresse
    Seg DW '00'            ; der alten Print-Routine ein.
  OBJECT END
RET

;--------------------------- Neue INT-17h-Prozedur --------------------------

PROC PRINT:
  cs:
  cmp  Byte Flag, 1        ; Flag wird vom Unloader auf 1 gesetzt, 
  je   @Unload             ; wenn EURO aus dem Speicher entfernt
                           ; werden soll. Sonst Flag = 0
  cs:
  cmp  Byte Flag, 2
  je   @OldOnly

  or   ah, ah                  ; Soll Zeichen gedruckt werden ?
  jnz  @OldOnly

  cs:
  cmp  al, EuroChar            ; Soll Euro-Zeichen gedruckt werden ?
  jne  @OldOnly

  cs:
  cmp  Byte Char1, 'x'         ; Ist Euro-Zeichen gnzlich deaktiviert ?
  je   @OldOnly

  push ax, dx
  cs:           
  mov  al, Char1 / xor ah, ah
  #OldPrinter
  pop  dx / push dx

  cs:
  mov  al, Char3 / or al, al / jnz @PrintEUR
  mov  ax, 8
  #OldPrinter
  pop  dx / push dx

  @PrintEUR:            
  cs:           
  mov  al, Char2 / xor ah, ah
  #OldPrinter

  cs:
  mov  al, Char3 / or al, al / jz @notPrintEUR
  pop  dx / push dx
  xor  ah, ah
  #OldPrinter

  @notPrintEUR:
  pop  dx, ax
IRET

@OldOnly:
  #OldPrinter
IRET                               

@Unload:
  push ds, dx, es, ax

  cs:
  cmp  Word VideoAddr, $B000
  je   @SWMoni
    cs:
    lds  dx, Old10          ; Alte Adressen laden
    mov  ax, 2510h          ; SetIntVec 10h
    int  21h                ; Alte INT 10h-Routine wieder einsetzen
  @SWMoni:

  cs:
  lds  dx, Old17          ; Alte Adressen laden 
  mov  ax, 2517h          ; SetIntVec 17h
  int  21h                ; Alte Drucker-Routine wieder einsetzen

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von EURO.COM wieder freigeben
  int  21h                ; ES=CS=Segment des freizugebenden Blocks 
  pop  ax, es, dx, ds
IRET
ENDP

 
; ------------------------------ Loader --------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt  
  lea  dx, &ProgName
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden1                ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
  
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xe / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xe: / cmp al, 'E' / je  @SetEuro 
                                              lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3517h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl

  push dx, bx
  mov  ah, 2                          ; Statusabfrage
  xor  dx, dx
  int  17h                            ; Unload anschubsen
  cmp  Word VideoAddr, $B000
  je   @SWMon
    mov  ax, 3                        ; Video-Mode umschalten (Dummy)
    int  10h
  @SWMon:
  pop  bx, dx

  cmp  bl, 1
  jne  @out

  lea  dx, &Unload

@out:
  #OutPut
 .HALT

@laden1:
  jmp short @laden

@SetEuro:                  ; Euro-Zeichen bestimmen
  mov  si, di
  inc  si
  lodsb / sub al, 48 / xor ah, ah / mov bh, 100 / mul bh / mov cl, al
  lodsb / sub al, 48 / xor ah, ah / mov bh, 10  / mul bh / add cl, al
  lodsb / sub al, 48 /                                     add cl, al

  mov EuroChar, cl
  lodsb / cmp al, '+' / jne @Laden
  lodsw / mov Char1, ax    ; gleich beide Zeichen laden
  cmp ax, 'EU' / jne @Laden
  lodsb / cmp al, 'R' / jne @Laden
  mov Char3, al

@Laden:
  -GetVideoAddr
  -EnvironMemFree

  lea  dx, &Load
  #OutPut

  cmp  Word VideoAddr, $B000
  je   @SWMoni
    mov  ax, 3510h       ; GetIntVec 10h
    int  21h                                
    mov  Old10.Ofs, bx   ; Schreibe alten Vektor in den Jmp-Befehl
    mov  Old10.Seg, es 
    mov  Old10A.Ofs, bx  ; Schreibe alten Vektor in den Call-Befehl
    mov  Old10A.Seg, es 
    mov  ax, 2510h       ; SetIntVec 10h
    lea  dx, Eurochange  ; = mov dx, Offset EuroChange, DS bereits Segment-Addr.
    int  21h

    #change
    int  10h
  @SWMoni:
 
  mov  ax, 3517h       ; GetIntVec 17h
  int  21h                                
  mov  Old17.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old17.Seg, es 
  mov  ax, 2517h       ; SetIntVec 10h
  lea  dx, Print       ; = mov dx, Offset Print, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen


PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
 
  &ProgName  DB  'EURO  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'Treiber fr Ausgabe des Euro-Symbols auf Monitor und Drucker',13,10,13,10  
  >              'Laden  : EURO [/e]',13,10
  >              'Steuern: EURO [/x|/s|/r]',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren',13,10
  >              '/e  legt fest, welches ASCII-Zeichen als Euro-Symbol ausgegeben werden soll,',13,10
  >              '    z.B. /e238 verwendet das ASCII-Zeichen 238 als Euro. Fehlt /e, verwendet',13,10
  >              '    EURO das Zeichen 213. Die Zahl mu ggf. mit fhrenden Nullen angegeben',13,10
  >              '    werden, z.B. /e031. Auf Monochrom-Monitoren erfolgt keine Euro-Ausgabe.',13,10,13,10
  >              '    /e213+C=   Euro-Symbol wird durch bereinanderdrucken von C und = erzeugt.',13,10
  >              '               (Standard-Einstellung: C und  (ASCII 196)).',13,10
  >              '    /e213+EUR  statt eines Euro-Symbols wird die Zeichenkette EUR ausgedruckt.$'



; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
