PROGRAM FComp; {FileCompare}
{$M 10000, 0, 0}

USES
  BiosCrt, Compare, Dos, Strings, keycode, hexbin, masken,
  monitor, Filecopy;

CONST
  BSize      = 30000;
  ProgName   = 'FC';

TYPE
  LineNum    = Array[1..2] Of LongInt;

VAR
  l          : Array [1..2]           of String;
  f          : Array [1..2]           of File;
  g          : Array [1..2]           of Word;
  FName      : Array [1..2]           of PathStr;
  Blocks     : Array [1..2, 1..BSize] of Char;
  x          : Word;
  min, max   : Word;
  tmp        : String;
  SyncLine   : Word;
  PStat      : Byte;

CONST
  FEnd       : Array [1..2] Of Boolean = (FALSE, FALSE);
  TPos       : Array [1..2] of LongInt = (0,0);
  BPos       : Array [1..2] of Word    = (BSize+1, BSize+1);
  LineNr     : LineNum = (0,0);
  Sign       : Word    = 0;
  FPos       : LongInt = 0;
  Ident      : Boolean = TRUE;
  TextFile   : Boolean = TRUE;
  MustText   : Boolean = FALSE;
  GrossKlein : Boolean = FALSE;
  IgnorSpace : Boolean = FALSE;
  HexView    : Boolean = FALSE;
  Wait       : Boolean = FALSE;
  ScreenLine : Byte    = 0;


PROCEDURE CloseFiles;
BEGIN
  If FileRec(f[1]).Mode<>fmClosed Then XClose(f[1]);
  If FileRec(f[2]).Mode<>fmClosed Then XClose(f[2]);
END;

PROCEDURE Break;
BEGIN
  DosStr (#13#10); CloseFiles; Halt;
END;

PROCEDURE CheckScreenLine;
BEGIN
  If not Wait Then ScreenLine:= 1; { Um berlufe zu unterdrcken }
  If ScreenLine>=22 Then
  BEGIN
    ScreenLine:= 2;
    OutStr (#13#10'Weiter mit Taste - Abbruch mit Escape');
    ScanBKeys;
    If t1=#27 Then Break;
    ClrScr;
    DosStr (#13#10);
  END;
END;


PROCEDURE OutString (s : String);
VAR
  x : Byte;
BEGIN
  StrAdd (s, #13#10);
  If not Wait Then DosStr (s) Else
  For x:= 1 To Length (s) Do
  BEGIN
    CheckScreenLine;
    DosChar (s[x]);
    If s[x]=#10 Then inc (ScreenLine);
  END;
END;


PROCEDURE w2 (s : String); BEGIN OutLnLF (s); OutLnLF (''); END;


PROCEDURE Hilfe;
CONST
s1='vergleicht den Inhalt von zwei Dateien'#13#10#13#10+
   'FC [Datei_1] [Datei_2] [/b /t /c /w /h /p]'#13#10#13#10+
   '/b   binres Vergleichen (automatisch bei EXE, COM, SYS, OBJ, LIB, BIN)'#13#10+
   '/t   erzwingt zeilenweises Vergleichen auch bei EXE, COM usw.';
s2='/c   ignoriert Gro- und Kleinschreibung'#13#10+
   '/w   ignoriert doppelte Tabulator- und Leerzeichen'#13#10+
   '/h   Hexadezimalanzeige der Unterschiede'#13#10+
   '/p   stoppt nach jeder Bildschirmseite';
BEGIN
  Standardkopf (ProgName, CopyRight);
  DosLnLF (s1); DosLnLF (s2); BlindStop;
  Halt;
END;



PROCEDURE Line; assembler;
ASM
  call checkscreenline
  mov  cx, 80
  @start:
    mov  dl, 196
    mov  ah, 02h
    int  21h
  loop @Start
  inc byte ptr ScreenLine
END;



PROCEDURE ErrorMsg (x, y : Byte);
BEGIN
  If x<3 Then OutLnLF (FName[x]);
  CASE y Of
    1 : W2 ('Datei konnte nicht geffnet werden.');
    2 : W2 ('Lesefehler in Datei.');
  END;
  CloseFiles; BlindStop;
  Halt;
END;


PROCEDURE OpenFile (Nr : Byte);
BEGIN
  Assign (f[Nr], FName[Nr]);
  FileMode:= 0;
  Reset  (f[Nr], 1);
  If IOResult<>0 Then ErrorMsg (Nr, 1);
  If (not MustText) and (
     (pos ('.EXE', FName[Nr]) <> 0)
  or (pos ('.COM', FName[Nr]) <> 0)
  or (pos ('.SYS', FName[Nr]) <> 0)
  or (pos ('.OBJ', FName[Nr]) <> 0)
  or (pos ('.LIB', FName[Nr]) <> 0)
  or (pos ('.BIN', FName[Nr]) <> 0)) Then TextFile:= FALSE;
END;


PROCEDURE OutChr (c : Char); assembler;
ASM
  mov ah, 3; xor bh, bh; int 10h       { Cursor-Position lesen }
  mov ax, 0E20h; int 10h;              { Cursor bewegen }
  cmp dx, 6223
  jb  @weiter; dec dh; @weiter:
  mov di, dx; and di, 255              { obere 8 Bits lschen }
  mov ax, dx; mov al, ah; xor ah, ah
  mov bh, 80
  mul bh
  add di, ax
  add di, di
  mov es, VideoAddr
  mov al, c
  mov ah, 7
  stosw
END;


PROCEDURE OutBlock (Nr : Byte);
VAR
  Stern : Boolean;
BEGIN
  Stern:= FALSE;
  For x:= Min To Max Do
  If HexView Then
  BEGIN
    If WhereX<>1 Then
    If (x>=Sign) and (Stern=FALSE) Then
    BEGIN DosChar ('*'); Stern:= TRUE; END Else
    DosChar (#32);
    DosStr (ByteHex(ord(Blocks[Nr, x])));
  END Else
  OutChr (Blocks[Nr, x]);
  OutLnLF (''); Line;
END;


PROCEDURE FillBlock (VAR Block); Assembler;
ASM
  mov cx, BSize shr 1
  mov al, 32
  mov ah, al
  les di, Block
  rep stosw
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8;

BEGIN
  t2:= #0;
  a1:
  EditStr (1, FName[1], 'Name der ersten Datei, die am Vergleich teilnehmen soll:');
  FName[1]:= UpStr (FName[1]);

  a2:
  EditStr (6, FName[2], 'Name der zweiten Datei, die am Vergleich teilnehmen soll:');
  If t2=Up Then Goto a1;
  FName[2]:= UpStr (FName[2]);

  a3:
  ParamField (12, TextFile,   'Dateien zeilenweise vergleichen (auer COM, EXE, SYS usw.)');
  If t2=Up Then Goto a2;

  a4:
  ParamField (13, MustText,   'erzwingt zeilenweises Vergleichen auch bei COM-, EXE-Dateien usw.');
  If t2=Up Then Goto a3;

  a5:
  ParamField (14, GrossKlein, 'ignoriert Gro- und Kleinschreibung');
  If t2=Up Then Goto a4;

  a6:
  ParamField (15, IgnorSpace, 'ignoriert doppelte Tabulator- und Leerzeichen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (16, HexView,    'Hexadezimal-Anzeige');
  If t2=Up Then Goto a6;

  a8:
  ParamField (17, wait,       'Wartet nach jeder Bildschirmseite');
  If t2=Up Then Goto a7;

  If (ee=0) and (FName[1]='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else SimpleHalt ('Abbruch durch Anwender');
  END;
  If (ee=0) and (FName[2]='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a2 END Else SimpleHalt ('Abbruch durch Anwender');
  END;
END;


FUNCTION Equal (str1, str2 : String) : Boolean;
BEGIN
  If not GrossKlein Then
  Equal:= str1 = str2 Else
  Equal:= UpStr (str1) = UpStr (str2);
END;


PROCEDURE FSeek (FNum : Byte; Posi : LongInt);
BEGIN
  Seek (f[FNum], Posi); BPos[FNum]:= BSize+1;
  TPos[FNum]:= Posi;
  FEnd[FNum]:= False;
END;


FUNCTION FiPos (FNum : Byte) : LongInt;
BEGIN
  If BPos[FNum]>= BSize+1 Then
  FiPos:= FilePos(f[FNum]) Else FiPos:= TPos[FNum]+BPos[FNum]-1;
END;


PROCEDURE ReadLine (FNr : Byte; VAR Line : String);
VAR
  c         : Char;
  EndOfLine : Byte;
BEGIN
  If FEnd[FNr] Then Exit;
  Line:= '';
  EndOfLine:= 0;
  FEnd[FNr]:= FALSE;

  REPEAT
    If BPos[FNr] > BSize Then
    BEGIN
      TPos[FNr]:= FilePos (f[FNr]);
      BlockRead (f[FNr], Blocks[FNr], BSize, g[FNr]); If IOResult<>0 Then ErrorMsg (FNr, 2);
      BPos[FNr]:= 1;
    END;
    If (BPos[FNr]>g[FNr]) and (Eof(f[FNr])) Then FEnd[FNr]:= TRUE Else
    BEGIN
      c:= Blocks[FNr, BPos[FNr]];
      If (c=#13) or (c=#10) Then inc (EndOfLine);
      If (Length (Line)<255) and (EndOfLine=0) Then CharAdd (Line, c);
      inc (BPos[FNr]);
    END;
  UNTIL (EndOfLine>=2) or (FEnd[FNr]);

  If (IgnorSpace) and (Length(Line)>0) Then
  BEGIN
    While Pos (Tab,  Line) <> 0 Do Line[pos (Tab, Line)]:= #32;
    While Pos ('  ', Line) <> 0 Do delete (Line, pos ('  ',    Line), 1);
    Line:= Trim (Line);
  END;
  inc (LineNr[FNr]);
END;


PROCEDURE SynchronizeFiles;
VAR
  OldLineNr        : LineNum;
  LastLineNr       : Array[1..3] Of LineNum;
  OldPos           : LineNum;
  sEnd             : Array[1..3] Of LineNum;
  Lin1, Lin2, Lin3 : LongInt;
  l1, l2           : String;
  x                : Byte;
  First            : LongInt;
  Shortest         : Byte;

PROCEDURE SetOld (TestNum : Byte);
VAR
  x : Byte;
BEGIN
  For x:= 1 To 2 Do sEnd[TestNum, x]:= FiPos(x);
  LastLineNr[TestNum]:= LineNr;
  LineNr:= OldLineNr;
END;


BEGIN
  For x:= 1 To 2 Do OldPos[x]:= FiPos(x);
  OldLineNr:= LineNr;
  Lin1:= 0;
  REPEAT
    ReadLine (1, l1);
    ReadLine (2, l2);
    inc (Lin1);
  UNTIL (FEnd[1]) or (FEnd[2]) or (Equal (l1, l2));
  SetOld (1);

  For x:= 1 To 2 Do FSeek (x, OldPos[x]);

  Lin2:= 0;
  l1:= l[1];
  REPEAT
    ReadLine (2, l2);
    inc (Lin2);
  UNTIL (FEnd[2]) or (Equal (l1, l2));
  SetOld (2);

  For x:= 1 To 2 Do FSeek (x, OldPos[x]);

  Lin3:= 0;
  l2:= l[2];
  REPEAT
    ReadLine (1, l1);
    inc (Lin3);
  UNTIL (FEnd[1]) or (Equal (l1, l2));
  SetOld (3);

  Shortest:= 1;
  If Lin2<Lin1 Then Shortest:= 2;
  If Lin3<Lin1 Then Shortest:= 3;

  For x:= 1 To 2 Do FSeek (x, sEnd[Shortest, x]);
  LineNr:= LastLineNr[Shortest];
END;



BEGIN
  StretchParam  (tmp);
  FName[1]:= ''; FName[2]:= '';
  If ParamCount=0 Then
  BEGIN
    FName[1]:= FExpand (''); FName[2]:= FName[1];
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
    StandardKopf (ProgName, '');
  END Else
  For x:= 1 To ParamCount Do
  BEGIN
    tmp:= UpStr (ParamStr(x));
    If tmp[1]='/' Then
    CASE tmp[2] Of
      '?' : Hilfe;
      'B' : TextFile  := FALSE;
      'C' : GrossKlein:= TRUE;
      'W' : IgnorSpace:= TRUE;
      'H' : HexView   := TRUE;
      'P' : Wait      := TRUE;
      'T' : MustText  := TRUE;
    END Else
    If FName[1]='' Then FName[1]:= tmp Else
    If FName[2]='' Then FName[2]:= tmp;
  END;

  If (FName[1] = '') or (FName[2] = '') Then
  SimpleHalt ('Dateiangaben unvollstndig');
  For x:= 1 To 2 Do
  BEGIN
    FName[x]:= FileExpand (FName[x]);
    If DOSError=0 Then PStat:= PathStatus (FName[x], CheckQuelle) Else PStat:= DOSError;
    If PStat<>0 Then SimpleHalt (PathStatusStr (PStat));
  END;

  If HexView  Then TextFile:= FALSE;
  If MustText Then TextFile:= TRUE;

  OpenFile (1);
  OpenFile (2);
  Sign:= 0;

  DosLnLF (#13#10);
  OutString ('Vergleiche Dateien:'#13#10);
  OutString ('1. '+FName[1]);
  OutString ('2. '+FName[2]+#13#10);

  If FileSize (f[1]) <> FileSize(f[2]) Then
  OutString ('Dateien sind unterschiedlich gro'#13#10);

  If TextFile Then
  While (not FEnd[1]) and (not FEnd[2]) Do
  BEGIN
    ReadLine (1, l[1]);
    ReadLine (2, l[2]);

    If not Equal (l[1], l[2]) Then
    BEGIN
      OutString ('Unterschied ab Zeile '+StrVal (LineNr[1])+'/'+StrVal (LineNr[2]));
      Line;
      OutString ('1. '+l[1]);
      OutString ('2. '+l[2]);
      Line;
      Ident:= FALSE;
      If (not FEnd[1]) and (not FEnd[2]) Then SynchronizeFiles;
      If (keyPressed) and (ReadBKey=#27) Then Break;
    END;
  END Else

  While (not EOF (f[1])) and (not EOF (f[2])) and (Sign=0) Do
  BEGIN
    FillBlock (Blocks[1]);
    FillBlock (Blocks[2]);
    BlockRead (f[1], Blocks[1], BSize, g[1]); If IOResult<>0 Then ErrorMsg (1, 2);
    BlockRead (f[2], Blocks[2], BSize, g[2]); If IOResult<>0 Then ErrorMsg (2, 2);
    
    If g[1]<g[2] Then g[1]:= g[2];

    Sign:= CompareBuffers (Blocks[1], Blocks[2], g[1]);

    If Sign<>0 Then
    BEGIN
      DosStr ('Unterschied ab Byte-Position ');
      OutLnLF (StrVal (FPos+Sign));
      Line;
      If Sign>78 Then Min:= Sign-78 Else Min:= 1;
      If Min+78<BSize Then Max:= Min+78 Else Max:= BSize;
      OutBlock (1);
      OutBlock (2);
      Ident:= FALSE;
    END;
    inc (FPos, g[1]);
  END;

  CloseFiles;

  If Ident Then
  SimpleHalt ('Dateien sind identisch.') Else
  If TextFile Then SimpleHalt ('Dateien sind unterschiedlich.');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
