PROGRAM FileFind;
{$M 65520, 0, 66000}

{DEFINE filefind -------------- mu beim Kompilieren nochmal in Options 
 angegeben werden, da sonst aus der Unit Konvert unnntzes Zeugs
 mitkompiliert wird ! }

USES
  Bioscrt, Monitor, dos, keycode, Strings, Masken, ReadText,
  Konvert, spc, filecopy, WildCard, SeekBuf;

CONST                
  PMax     = 65024;
  ProgName = 'FILEFIND';
  LogFile  : PathStr = 'FILEFIND.LOG';

TYPE
  EStr  = String[3];
  Str_2 = String[2];
  Block = array[1..PMax] Of Char;

CONST
  SearchMode  : Boolean = FALSE;
  Searchexe   : Boolean = FALSE;
  WinKonvert  : Boolean = FALSE;
  SubDirs     : Boolean = FALSE;
  Abbruch     : Boolean = FALSE;
  HTMLKonvert : Boolean = FALSE;
  BrowserMode : Boolean = FALSE;
  BMode       : Boolean = FALSE;

VAR
  Result, gefunden, ONr, gelesen  : Word;
  Suchpfad, ProgDir : PathStr;
  Datenmenge     : LongInt;
  Beispiel       : String;
  Param          : String;
  Suchworte      : TSuchworte;
  Suchwort       : String;
  xf             : Text;
  pd             : Byte absolute ProgDir;
  p              : ^block;
  b              : Word;
  i, PStat, n    : Byte;
  Strich         : String[85];

CONST
  SearchDir      : String = '';
  SuchMask       : String = '';
  Umlaute        : array[1..7] of Char = 'ᄔ';
  BinExt         = ' EXE COM DLL OVL ';


PROCEDURE Hilfe;
CONST
s1='durchsucht Datentrger nach Dateien bzw. Dateien nach Textstellen'#13#10#13#10+
   'FILEFIND [Suchverzeichnis] [gesuchte Datei(en)] [Suchwort(e)] [/s /i /e /w /h]'#13#10#13#10+
   '/s  durchsucht auch Unterverzeichnisse'#13#10+
   '/i  ignoriert Gro- und Kleinschreibung'#13#10;
s2='/e  durchsucht auch Programmdateien (EXE, COM usw.)'#13#10+
   '/h  erkennt auch HTML-Zeichensatz (Umlaute usw.)'#13#10+
   '/w  erkennt auch Windows-Zeichensatz (Umlaute usw.)'#13#10#13#10;
s3='Wenn [Suchwort] fehlt, sucht FILEFIND ohne Inhaltsprfung nach den Dateien.'#13#10+
   'SPACE-Dateien werden bei der Inhaltsprfung entkomprimiert.'#13#10;
BEGIN
  Standardkopf (ProgName, Copyright);
  DosStr (s1); DosStr (s2); DosStr (s3); Blindstop;
  Halt;
END;


PROCEDURE HTMLKon;
VAR
  tmp     : String[20];
  x, y, z : Word;
BEGIN
  y:= 0;
  For x:= 1 To gelesen Do
  BEGIN
    If p^[x]='&' Then
    BEGIN
      tmp:= '&';
      While (Length(tmp)<20) and (p^[x]<>';') and (p^[x]<>' ') and (x+1<gelesen) Do
      BEGIN inc (x); CharAdd (tmp, p^[x]); END;
      tmp:= html2text (tmp);
      For z:= 1 To Length (tmp) Do BEGIN inc (y); p^[y]:=tmp[z]; END;
    END Else
    BEGIN inc (y); p^[y]:= p^[x]; END;
  END;
  gelesen:= y;
END;


PROCEDURE WriteQuelle (Quelle : PathStr; Attr : Byte);
BEGIN
  If (BrowserMode) and (Attr and (directory or VolumeID or SysFile) = 0) Then
  WriteLn (xf, '<A HREF="'+Quelle+'">'+Quelle+'</A>'#13#10) Else
  WriteLn (xf, Quelle, #13#10);
END;


PROCEDURE SearchFile (FileName : PathStr; Attr : Byte);
VAR                                
  f       : File;
  IsSpace : Boolean;
  ToRead  : Word;
  RPos    : Word;
  SeekPos : LongInt;
  c, lc   : Char;
  Ort     : Word;

BEGIN
  FileMode:=0;
  Assign (f, FileName);
  Reset  (f, 1);
  If IOResult<>0 Then BEGIN WriteLn (xf, 'Fehler in Datei '+FileName); Exit; END;

  IsSpace:= GetFileExt(FileName)='SPC';
  If IsSpace Then
  BEGIN ToRead:= b DIV 3; RPos:= b-ToRead-3; END Else
  BEGIN ToRead:= b;       RPos:= 1;          END;

  SeekPos:= 0;
  Ort:= 0;

  While (not Eof(f)) and (Ort=0) Do
  BEGIN
    If SeekPos>0 Then
    BEGIN
      dec  (SeekPos, pred(Length(Suchwort)));
      Seek (f, SeekPos);
    END;

    BlockRead (f, p^[RPos], ToRead, gelesen);

    If IOResult<> 0 Then
    BEGIN
      Close (f);
      InOutRes:= Result;
      WriteLn (xf, 'Fehler in Datei '+FileName);
      Exit;
    END;
    inc (SeekPos, gelesen);

    If gelesen > 0 Then
    BEGIN
      If IsSpace Then UnPackText (p^[RPos], p^, gelesen, gelesen);
      If WinKonvert Then KonvertBuf (p^, gelesen);
      If (HtmlKonvert) and (GetFileExt(FileName)='HTM') Then HTMLKon;
      If SearchMode Then
      Ort:= NotCaseSensPos (SuchWorte, p^, gelesen) Else
      Ort:= CaseSensPos    (SuchWort,  p^, gelesen);
    END;
  END;

  Close (f); InOutRes:= 0;

  GotoXY (15, 5); OutStr (StrVal(Datenmenge shr 10)); OutStr (' kB');

  If Ort<>0 Then
  BEGIN
    inc (ONr); GotoXY (15, 6); OutStr (StrVal(ONr));

    Beispiel:= '';
    c:= #0;
    While (Ort<=Gelesen) and (Length (Beispiel)<79) Do
    BEGIN
      lc:= c;
      c := p^[Ort];
      If (c<=#13) Then c:=' ';
      If (c<>' ') or (lc<>' ') Then Insert (c, Beispiel, 255);
      inc (Ort);
    END;

    If BrowserMode Then
    BEGIN
      WriteQuelle (FileName, Attr);
      Beispiel:= ReplaceAll (Beispiel, '<', '&lt;');
      Beispiel:= ReplaceAll (Beispiel, '>', '&gt;');
    END Else
    WriteLn (xf, FileName, #13#10);

    Write   (xf, Beispiel);
    Write   (xf, Strich);
  END;
END;



PROCEDURE Objekt_listen (Suchpfad: PathStr);
VAR
  de  : Estr;
  s   : Searchrec;
  d   : DateTime;
  atr : PathStr;
BEGIN
  WriteXY (15, 3, SpaceStr (Suchpfad, 80), 7, 0);

  Findfirst (Vollpfad (Suchpfad, '*.*'), Normalfile, s);
  If DOSError>=150 Then ErrorHalt (Copyresultstr (DOSError));
  While (DOSError = 0) and (not Abbruch) Do
  BEGIN
    If (s.name[1]<>'.') and (FileMatch (s.name, SuchMask)) Then
    BEGIN
      WriteXY (15, 5, s.name+'             ', 7, 0);
      If SuchWort='' Then
      BEGIN
        atr:='Attrb: ';
        If (s.attr and directory<>0) Then atr:=atr+'Verzeichnis ' Else atr:=atr+'Datei ';
        If (s.attr and archive  <>0) Then atr:=atr+'/Archiv ';
        If (s.attr and ReadOnly <>0) Then atr:=atr+'/NurLesen ';
        If (s.attr and hidden   <>0) Then atr:=atr+'/Versteckt ';
        If (s.attr and sysfile  <>0) Then atr:=atr+'/Systemdatei';

        UnpackTime (s.time, d);
        If BrowserMode Then WriteQuelle(Vollpfad (suchpfad, s.name), s.attr) Else
        WriteLn (xf, Vollpfad (suchpfad, s.name), #13#10);
        WriteLn (xf, 'Gre: ', StrVal(s.size), ' Byte');
        With d Do
        BEGIN
          WriteLn (xf, 'Datum: ', LZ(day),  '.', LZ(Month),'.',StrVal(Year));
          WriteLn (xf, 'Zeit : ', LZ(hour), ':', LZ(min), ' Uhr');
        END;
        Write (xf, atr);
        Write (xf, Strich);
        inc (ONr); GotoXY (15, 6); OutStr (StrVal(ONr));
      END
      Else
      {--- Textsuche ---}
      If   (s.attr and directory=0)
      and ((SearchExe) or (pos (' '+GetFileExt(s.name)+' ', BinExt)=0)) Then
      BEGIN
        SearchFile (VollPfad (SuchPfad, s.name), s.attr);
        inc (Datenmenge, s.size);
      END;
    END;
    Findnext (s);
    If (keypressed) and (ReadbKey=#27) Then Abbruch:= TRUE;
  END;
END;



PROCEDURE Rekursiv (SuchPfad: PathStr); far;
VAR
  new_dir : PathStr;
  t       : Searchrec;
BEGIN
  Findfirst (Vollpfad (Suchpfad,'*.*'), Normalfile, t);
  While (DOSError = 0) and (not Abbruch) Do
  BEGIN
    If (t.attr and directory <> 0) and (t.name[1]<>'.') Then
    BEGIN
      New_dir:= VollPfad (suchpfad, t.name);
      Objekt_listen (New_dir); 
      Rekursiv (new_dir);
    END;
    Findnext (t);
  END;
END;



PROCEDURE Suche_Objekt;
BEGIN
  Datenmenge:=0; ONr:=0; 
  Objekt_listen (SearchDir);
  If SubDirs Then Rekursiv (SearchDir);
  If SuchWort='' Then
  BEGIN If ONr= 0 Then WriteLn (xf, SuchMask, ' nicht gefunden!'); END Else
  BEGIN If ONr= 0 Then WriteLn (xf, Suchwort, ' nicht gefunden!'); END;
END;



PROCEDURE Viewer;
VAR
  x    : Byte;
  z    : Char;
  r    : Searchrec;
  B    : Word;
  S    : array[1..15000] Of LongInt;
  Ends : Byte;
BEGIN
  Window (1, 2, 80, 25);
  ClrScr;
  If SuchWort<>'' Then BEGIN Window (1, 3, 80, 25); Ends:= 21 END Else Ends:= 22;
  WriteXY (1, 1, ' '+LogFile+FillString (79-Length(LogFile)), 0, 7);
  FindFirst (LogFile, normalfile, r); If r.size<1 Then r.size:=1;
  If (DOSError<>0) or (r.attr and directory<>0) Then
  ErrorHalt ('LOG-Datei nicht gefunden');

  OpenText (LogFile);
  If IOresult<>0 Then
  ErrorHalt ('LOG-Datei kann nicht geffnet werden');

  S[1]:= 0; B:=1;


  REPEAT
    SeekPos(S[B]);
    ClrScr;
    REPEAT   
      ReadChr (z);
      If IOResult <> 0 Then BEGIN CloseText; ErrorHalt ('Lesefehler in LOG-Datei') END;
      If  z=#7 Then OutChar (#32) Else Outchar (z);
    UNTIL (WhereY>=Ends) or (EofText);

    ScanbKeys;
    CASE t2 Of
      Pos1: B:= 1;
      Up, PgUp   : If B>1 Then dec (B);
      Down, PgDn : If not EofText Then
                   BEGIN If B<15000 Then inc (B); S[B]:= TextPos; END;
    END;
  UNTIL t1=#27;

  CloseText;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, SearchDir, 'Verzeichnis oder Laufwerk, das FILEFIND nach Dateien durchsuchen soll:');
  SearchDir:= UpStr (SearchDir);

  a2:
  EditStr (5, SuchMask, 'Name der zu suchenden Datei(en):');
  If t2=Up Then Goto a1;

  a3:
  EditStr (9, SuchWort, 'zu suchender Text (leerlassen, wenn nur nach Dateinamen gesucht werden soll):');
  If t2=Up Then Goto a2;

  a4:
  ParamField (13, SearchMode, 'ignoriert Gro- und Kleinschreibung');
  If t2=Up Then Goto a3;

  a5:
  ParamField (14, Searchexe,  'sucht Text auch in Programmdateien (EXE, COM usw.)');
  If t2=Up Then Goto a4;

  a6:
  ParamField (15, Winkonvert, 'Umlaute in Windows-Dateien richtig erkennen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (16, SubDirs,    'Dateien auch in Unterverzeichnissen suchen');
  If t2=Up Then Goto a6;

  ParamField (17, HTMLKonvert,  'Umlaute in HTML-Dateien richtig erkennen');
  If t2=Up Then Goto a7;

  If (ee=0) and (SearchDir='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;

  If (ee=0) and (SuchMask='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a2 END Else UserAbort;
  END;
END;



PROCEDURE Maske;
BEGIN
  SuchMask:='*.*';
  SearchDir:= FileExpand ('');
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


{--------------------------- HauptProgramm -------------------------------}

BEGIN
  ProgDir:= ParamStr (0); While (ProgDir[pd]<>'\') and (pd>0) Do dec (pd);
  StretchParam (Beispiel);
  SuchWort:='';

  If ParamCount = 0 Then Maske Else
  For i:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (i));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'B' : BEGIN
              HTMLKonvert:= TRUE;
              SearchMode := TRUE;
              SubDirs    := TRUE;
              SearchDir  := copy (Param, 4, 255);
              SuchMask   :='*.HTM';
              BrowserMode:= TRUE;
            END;
      'W' : WinKonvert := TRUE;
      'S' : SubDirs    := TRUE;
      'I' : SearchMode := TRUE;
      'E' : SearchExe  := TRUE;
      'H' : HTMLKonvert:= TRUE;
      'X' : BMode      := TRUE;
    END Else
    If BrowserMode Then SuchWort:= SuchWort+ParamStr (i)+' ' Else
    BEGIN
      If SearchDir = '' Then SearchDir:= Param Else
      If SuchMask  = '' Then SuchMask := Param Else
      SuchWort:= SuchWort+ParamStr (i)+' ';
    END;
  END;

  Suchwort := Trim (Suchwort);

  SearchDir:= FileExpand (SearchDir);
  If DOSError=0 Then PStat:= PathStatus (SearchDir, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then SimpleHalt (PathStatusStr (PStat));

  If BMode Then BrowserMode:= TRUE;

  If not BrowserMode Then
  Strich:=#13#10'-------------------------------------------------------------------------------'#13#10 Else
  BEGIN Strich:='<HR noshade>'; LogFile:= 'FILEFIND.HTM'; END;

  If SuchWort<>'' Then
  BEGIN
    If WinKonvert Then
    BEGIN
      WinKonvert:= FALSE;
      For n:= 1 To Length (SuchWort) Do
      If SuchWort[n]>'z' Then WinKonvert:= TRUE;
    END;

    If SearchMode Then InitNotCaseSensSearch (SuchWort, Suchworte);

    If not SearchExe Then
    SearchExe:= pos (' '+GetFileExt (SuchMask)+' ', BinExt)<>0;
  END;

  Standardkopf (ProgName, '');
  Fusszeile ('Suche Dateien...    (Abbrechen mit Esc)');
  GotoXY (1, 1); OutStr ('Verzeichnis :');
  GotoXY (1, 3); OutStr ('Datei       :');
  GotoXY (1, 5); OutStr ('gelesen     :');
  GotoXY (1, 6); OutStr ('gefunden    :');

  LogFile:= Vollpfad (ProgDir, LogFile);
  Assign   (xf, LogFile);
  SetFAttr (xf, 32);
  Rewrite  (xf);
  If IOResult<>0 Then ErrorHalt ('LogDatei konnte nicht angelegt werden');

  If BrowserMode Then
  WriteLn (xf,'<HTML><HEAD><TITLE>Suchergebnis</TITLE></HEAD><BODY><PRE>');

  b:= Pmax; If b>MaxAvail Then b:=MaxAvail; GetMem (p, b);

  Suche_Objekt;

  FreeMem (p, b);

  If BrowserMode Then WriteLn (xf,'</PRE></BODY></HTML>');
  Close (xf); 

  If not BrowserMode Then
  BEGIN Viewer; ErrorHalt ('Fertig'); END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
