PROGRAM HexType;
{$M 5000, 0, 655350}

USES
  bioscrt, Monitor, hexbin, keyCode, strings, Dos, Masken,
  FileMan, Clipbord;

CONST
  StandardFZ = ' F1Help F2Save F3Cut F4Paste F5Copy F6Clr F7An F8En F9Open F10SaveAs   Ende=Esc ';
  Param           : PathStr = '';
  TextEdit        : Boolean = FALSE;
  IfEdit          : Boolean = FALSE;
  BlockLines      = 2048;             (*nicht ndern !!*)
  BlockSize       = BlockLines * 16;
  AbsLastBlock    = 25;
  FirstLine       : Word = 0;
  LastLine        : Word = 0;
  Line            : Word = 1;
  ActLine         : Word = 1;
  LastBlock       : Word = 1;
  Marker          : Pointer = NIL;
  ActSign         : Word    = 1;
  Ins             : Boolean = TRUE;
  LastUsedBlock   : Word    = 1;
  FSize           : LongInt = 1;
  IncludeError    : Boolean = FALSE;
  SignAn          : LongInt = 0;
  SignEn          : LongInt = 0;

TYPE
  TBlock          = Array[1..Blocksize] Of Char;

VAR
  f               : File;
  Block           : Array[1..AbsLastBlock] Of ^TBlock;
  BlockInfo       : Array[1..AbsLastBlock] Of Word;

  gel, Pro, Code  : Word;
  Para            : String;
  st              : String[3];
  s               : String[2];
  Byt             : Byte;
  NewX            : Byte;
  t               : Char;
  OldAttr         : Word;
  tmp             : Word;
  ClipBuf         : Array[1..20000] Of Char;
  ClipEnd, x      : Word;
  OldEdit         : Boolean;
  Sign            : LongInt;


PROCEDURE Fusszeile (s : String; vc, hc : Byte);
BEGIN
  WriteXY (1, 25, SpaceStr (s, 80), vc, hc);
END;


PROCEDURE Standard;
VAR
  s : String;
  x, c : Byte;
BEGIN
  s:= StandardFZ;
  For x:= 1 To Length (StandardFZ) Do
  BEGIN
    If (s[x]='F') or ((s[x]>='0') and (s[x]<='9')) Then
    c:= Lightcyan Else c:= 7;
    CharXY (x, 25, s[x], c, 1);
  END;
END;


PROCEDURE Hilfe;
CONST
s1=#13#10+
  'BILD '#24#25' / '#24#25'   - Blttern/Scrollen'#13#10+
  'Pos1 / Ende    - Sprung zum Anfang/Ende der Zeile'#13#10+
   #24#25'  '#196#16#32#17#196'      - Cursor bewegen'#13#10+
  'CTRL + Pos1    - Sprung an Dateianfang'#13#10+
  'CTRL + Ende    - Sprung ans Dateiende'#13#10;
s2=
  'Rcktaste/Entf - Zeichen vor/ber Cursor lschen'#13#10+
  'TAB            - wechselt zwischen Text- und Hex-Modus hin und her'#13#10+
  'Einfg          - wechselt zwischen berschreib- und Einfge-Modus hin und her'#13#10#13#10+
  'F2             - Datei speichern';
s3=
  'F3             - verschiebt den markierten Block in die Zwischenablage'#13#10+
  'F4             - fgt die Zwischenablage an der Cursorposition ein'#13#10+
  'F5             - kopiert den markierten Block in die Zwischenablage';
s4=
  'F6             - entfernt eine Block-Markierung'#13#10+
  'F7             - markiert den Beginn eines Blockes'#13#10+
  'F8             - markiert das Ende eines Blockes';
s5=
  'F9             - Datei ffnen'#13#10+
  'F10            - Datei unter anderem Namen speichern'#13#10#13#10+
  'Esc            - Programm beenden';

BEGIN
  TextAttr:= 7; ClrScr;
  OutLnLF (s1);
  OutLnLF (s2);
  OutLnLF (s3);
  OutLnLF (s4);
  OutStr  (s5);
  Fusszeile (' Weiter mit Taste', 15, 1);
  WaitBKey; TextAttr:= 112; ClrScr;
  Standard;
END;



PROCEDURE ErrorMsg (s : String);
VAR
  OldX, OldY : Byte;
BEGIN
  Fusszeile (s, yellow, red);
  OldX:= WhereX; OldY:= WhereY; GotoXY (1, 25);
  t:= UpReadBKey;
  GotoXY (OldX, OldY);
  Standard;
END;



PROCEDURE Ende;
BEGIN
  If Marker <> NIL Then Release (Marker);
  Close (f); If IOResult<>0 Then;
  SetFAttr (f, OldAttr); If IOResult<>0 Then;
  Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
  Halt;
END;



FUNCTION LastLineLen : Word; assembler;
ASM
  mov bx, LastUsedBlock
  dec bx
  add bx, bx
  mov ax, Word Ptr BlockInfo[bx]
  and ax, 0000000000001111b
  jnz @ende
  mov ax, 16
  @ende:
END;



PROCEDURE ReadFile;
BEGIN
  Mark (Marker);
  LastBlock:= 0;
  While (MaxAvail>=BlockSize) and (LastBlock<AbsLastBlock) Do
  BEGIN
    inc (LastBlock);
    New (Block[LastBlock]);
    Fillchar (Block[LastBlock]^, BlockSize, 0);
  END;
  If LastBlock=0 Then
  BEGIN ErrorMsg (' Kein Speicher mehr frei. Weiter mit Taste'); Ende; END;

  Assign (f, Param); FileMode:=0; Reset (f, 1); GetFAttr (f, OldAttr);
  If IOResult<>0 Then
  BEGIN
    LastLine:= 1;
    BlockInfo[1]:= 1;
    Exit;
  END;

  FSize:= FileSize (f); If FSize=0 Then FSize:=1;

  LastUsedBlock:= 0;
  While (not Eof(f)) and (LastUsedBlock<LastBlock) Do
  BEGIN
    inc (LastUsedBlock);
    BlockRead (f, Block[LastUsedBlock]^, BlockSize, gel);
    If IOResult<>0 Then
    BEGIN
      ErrorMsg (' Fehler beim Lesen der Datei. Weiter mit Taste');
      Ende;
    END;
    BlockInfo[LastUsedBlock]:= gel;
    inc (LastLine, gel shr 4);
    If gel and 15 <> 0 Then inc (LastLine);
  END;
  If not Eof (f) Then
  BEGIN ErrorMsg (' Datei zum Laden zu gro. Weiter mit Taste'); Ende; END;
  Close (f); If IOResult<>0 Then;
END;



PROCEDURE WriteFile;
VAR
  ges : Word;
  x   : Word;
LABEL
  NewName;

BEGIN
  If (not IfEdit) and (t1=#27) Then Exit;
  t:= #0;
  If t1=#27 Then
  REPEAT
    ErrorMsg (' nderungen speichern?   <j>a   <n>ein   <z>urck   <a>nderer Dateiname');
    CASE t Of
      'Z'      : BEGIN t1:= #1;  Exit; END;
      #27, 'N' : BEGIN t1:= #27; Exit; END;
    END;
  UNTIL (t=#13) or (t='J') or (t='A');

  If (t2=F10) or (t='A') Then
  BEGIN
    NewName:
    Fusszeile (' Whlen Sie einen neuen Dateinamen aus', 15, 1);
    Param:= DateiManager;
    ClrScr;
    Standard;
    If Param='' Then BEGIN t1:= #1; Exit; END;

    Assign (f, Param); FileMode:= 0; Reset (f, 1); Close (f);
    If IOResult=0 Then
    REPEAT
      ErrorMsg (' Datei existiert bereits. berschreiben?    <j>a   <n>ein');
      If (t=#27) or (t='N') Then BEGIN t1:= #1; Goto NewName; END;
    UNTIL (t=#13) or (t='J');

    WriteXY (2, 1, UpStr (GetFilename (Param)), 15, 1);
  END;

  Assign (f, Param); FileMode:=2; Rewrite (f, 1);
  If IOResult<>0 Then
  BEGIN
    SetFAttr (f, 32);
    Rewrite  (f, 1);
    If IOResult <> 0 Then
    BEGIN
      ErrorMsg (' Datei kann nicht gespeichert werden. Whlen Sie einen anderen Namen.');
      t1:= #1;
      Goto NewName;
    END;
  END;

  For x:= 1 To LastUsedBlock Do
  If BlockInfo[x] > 0 Then 
  BEGIN
    BlockWrite (f, Block[x]^, BlockInfo[x], ges);
    If IOResult<>0 Then
    BEGIN
      ErrorMsg (' Fehler beim Schreiben der Datei. Weiter mit Taste');
      Ende;
    END;
  END;

  IfEdit:= FALSE;
  Close (f); If IOResult<>0 Then;
END;



FUNCTION GetChar (Line, Sign : Word) : Char; assembler;
ASM
  mov ax, Line
  mov dx, ax
  mov cl, 11
  shr dx, cl
  mov bx, dx     (*BlockNum in BX*)
  shl dx, cl
  sub ax, dx
  or  ax, ax     (*Lines in AX*)
  jnz @weiter
    mov ax, BlockLines
    dec bx
  @weiter:
  add bx, bx
  add bx, bx
  les si, DWord Ptr Block[bx]
  dec ax
  mov cl, 4
  shl ax, cl
  add ax, Sign
  dec ax
  add si, ax
  SegES
  lodsb
END;



PROCEDURE PutChar (Line, Sign : Word; Zeichen : Char); assembler;
ASM
  mov ax, Line
  mov dx, ax
  mov cl, 11
  shr dx, cl
  mov bx, dx     (*BlockNum in BX*)
  shl dx, cl
  sub ax, dx
  or  ax, ax     (*Lines in AX*)
  jnz @weiter
    mov ax, BlockLines
    dec bx
  @weiter:
  add bx, bx
  add bx, bx
  les di, DWord Ptr Block[bx]
  dec ax
  mov cl, 4
  shl ax, cl
  add ax, Sign
  dec ax
  add di, ax
  mov al, Zeichen
  stosb
END;



FUNCTION FileEnd (Line, Sign : Word) : Boolean; assembler;
ASM
  xor cx, cx
  mov ax, Line
  cmp ax, LastLine
  jb  @raus
  ja  @true
    call LastLineLen
    cmp  ax, Sign
    jae  @raus
  @true:
    inc  cx
  @raus:
  mov ax, cx
END;



PROCEDURE Seite;
VAR
  kx, ky, kz : Byte;
  x, y       : Word;
  c          : Char;
  LPos       : LongInt;
  IsMarked   : Boolean;
BEGIN
  NumXY (63, 1, 11, LongInt (ActLine-1) shl 4 + ActSign, 15, 1);

  Pro:= LongInt (ActLine)*1600 DIV FSize;
  If Pro>100 Then Pro:=100;
  st:= StrVal (Pro);
  WriteXY (76-Length(st), 1, '  '+st+' %', 15, 1);

  For y:= 1 To 23 Do
  BEGIN
    kx:= 9; ky:= y+1; kz:=64;
    LPos:= LongInt(FirstLine+y-1) shl 4;
    WriteXY (1, ky, copy(LongHex (LPos), 4, 8), 0, cyan);

    For x:= 1 To 16 Do
    BEGIN
      IsMarked:= (SignAn<>0) and (SignEn<>0) and (LPos+x >=SignAn) and (LPos+x <=SignEn);
      If not FileEnd (FirstLine+y, x) Then
      BEGIN
        c:= GetChar (FirstLine+y, x);
        If (x=ActSign) and (y=Line) Then
        BEGIN
          WriteXY (kx, ky, ByteHex (ord (c)), 14, red);
          NumXY (46, 1, 3, ord (c), 15, 1);
          If TextEdit Then GotoXY (kz+1, ky-1) Else GotoXY (kx+NewX, ky-1);
        END Else
        BEGIN
          If IsMarked Then
          WriteXY (kx, ky, ByteHex (ord (c)), 15, 7) Else
          WriteXY (kx, ky, ByteHex (ord (c)), 0, 7);
        END;
      END Else
      BEGIN
        c:= ' ';
        WriteXY (kx, ky, '  ', 0, 7);
      END;
      If x and 3 = 0 Then inc (kx, 5) Else inc (kx, 3);

      inc (kz);
      If (x=ActSign) and (y=Line) Then
      CharXY (kz, ky, c, 14, red) Else
      If IsMarked Then
      CharXY (kz, ky, c, 14, cyan) Else
      CharXY (kz, ky, c, 0, cyan);
    END;
  END;
END;



PROCEDURE IncLine; assembler;
ASM
  mov ax, Actline
  cmp ax, LastLine
  jae @ende
    mov ax, Line
    cmp ax, 23
    jae @weiter
    inc ax
    jmp @fertig
    @weiter:
    inc FirstLine
  @fertig:
  mov Line, ax
  add ax, FirstLine
  mov Actline, ax
  @ende:
END;


PROCEDURE DecLine; assembler;
ASM
  mov bx, FirstLine
  mov ax, Line
  cmp ax, 1
  jbe @weiter
  dec ax
  jmp @fertig
  @weiter:
  or  bx, bx
  jz @fertig
  dec bx
  @fertig:
  mov Line, ax
  add ax, bx
  mov ActLine, ax
  mov FirstLine, bx
END;


PROCEDURE IncCharNum;
BEGIN
  IncludeError:= FALSE;
  If BlockInfo[LastUsedBlock]>=BlockSize Then
  BEGIN
    If LastUsedBlock >= LastBlock Then
    BEGIN
      ErrorMsg (' Kein Speicherplatz mehr zum Einfgen. Weiter mit Taste');
      IncludeError:= TRUE;
      Exit;
    END;
    inc (LastUsedBlock);
    BlockInfo[LastUsedBlock]:= 1;
    inc (LastLine);
  END Else
  BEGIN
    If (BlockInfo[LastUsedBlock]) and 15 = 0 Then inc (LastLine);
    inc (BlockInfo[LastUsedBlock]);
  END;
  inc (FSize);
  IfEdit:= TRUE;
END;



PROCEDURE DecCharNum;
BEGIN
  If BlockInfo[LastUsedBlock]<=1 Then
  BEGIN
    If LastUsedBlock > 1 Then
    BEGIN
      dec (LastUsedBlock);
      BlockInfo[LastUsedBlock]:= BlockSize;
    END;
  END Else dec (BlockInfo[LastUsedBlock]);
  If ((BlockInfo[LastUsedBlock]) and 15 = 0) and (LastLine>1) Then dec (LastLine);
  If FSize > 1 Then dec (FSize);
  IfEdit:= TRUE;
END;



PROCEDURE GoRight;
BEGIN
  If NewX=0 Then NewX:= 1 Else
  BEGIN
    NewX:= 0;
    If ActSign < 16 Then
    BEGIN
      inc (ActSign);
      If FileEnd (ActLine, ActSign) Then IncCharNum;
    END Else
    BEGIN
      If ActLine>= LastLine Then IncCharNum;
      IncLine;
      ActSign:= 1;
    END;
  END;
END;



PROCEDURE GoLeft;
BEGIN
  If NewX=1 Then NewX:= 0 Else
  BEGIN
    NewX:= 1;
    If ActSign > 1 Then dec (ActSign) Else
    If ActLine > 1 Then BEGIN DecLine; ActSign:= 16; END;
  END;
END;



FUNCTION ActBlockNum (Line, Sign : Word) : Word; assembler;
ASM
  mov ax, Line
  mov dx, ax
  mov cl, 11
  shr dx, cl
  mov bx, dx     (*BlockNum in BX*)
  shl dx, cl
  sub ax, dx
  or  ax, ax     (*Lines in AX*)
  jz @weiter
  inc bx
  @weiter:
  mov ax, bx
END;


FUNCTION ActBlockPos (Line, Sign : Word) : Word; assembler;
ASM
  mov ax, Line
  mov dx, ax
  and dx, 1111100000000000b
  sub ax, dx
  or  ax, ax     (*Lines in AX*)
  jnz @weiter
  mov ax, BlockLines
  @weiter:
  dec ax
  mov cl, 4
  shl ax, cl
  add ax, Sign
END;


PROCEDURE DelChar;
VAR
  BNum, BPos  : Word;
BEGIN
  If t1=Back Then
  BEGIN
    If (ActLine=1) and (ActSign=1) Then Exit;
    GoLeft;
  END Else
  If (FileEnd (ActLine, ActSign)) Then Exit;
  NewX:= 0;
  If not FileEnd (ActLine, ActSign+1) Then 
  BEGIN
    BPos:= ActBlockPos (ActLine, ActSign);
    For BNum:= ActBlockNum (ActLine, ActSign) To LastUsedBlock Do
    BEGIN
      Move (Block[BNum]^[BPos+1], Block[BNum]^[BPos], BlockInfo[BNum]-BPos);
      If BNum<LastUsedBlock Then
      Block[BNum]^[BlockSize]:= Block[BNum+1]^[1];
      BPos:= 1;
    END;
  END;
  DecCharNum;
  If (FileEnd (ActLine, ActSign)) Then GoLeft;
END;



PROCEDURE InsChar;
VAR
  BNum, ABlock, BPos  : Word;
BEGIN
  If FileEnd (ActLine, ActSign) Then Exit;
  IncCharNum;
  If IncludeError Then Exit;
  NewX:= 0;
  ABlock:= ActBlockNum (ActLine, ActSign);
  For BNum:= LastUsedBlock DownTo ABlock Do
  BEGIN
    If BNum=ABlock Then BPos:= ActBlockPos (ActLine, ActSign) Else BPos:= 1;
    Move (Block[BNum]^[BPos], Block[BNum]^[BPos+1], BlockInfo[BNum]-BPos);
    If BNum<>ABlock Then Block[BNum]^[1]:= Block[BNum-1]^[BlockSize];
  END;
END;


PROCEDURE CopyIntoClipBoard;
VAR
  xx, yy : Word;
BEGIN
  ClipEnd:= 0;
  yy:= SignAn shr 4 + 1;
  xx:= SignAn and 15;
  For Sign:= SignAn To SignEn Do If ClipEnd<SizeOf (ClipBuf) Then
  BEGIN
    inc (ClipEnd);
    ClipBuf[ClipEnd]:= GetChar (yy, xx);
    If xx<16 Then inc (xx) Else BEGIN inc (yy); xx:= 1; END;
  END;
END;


(* --------------------------- Hauptprogramm ----------------------------- *)
LABEL
  Nochmal;
BEGIN
  StretchParam (Para);
  For x:= 1 To ParamCount Do
  BEGIN
    Para:= UpStr (ParamStr (x));
    If Para[1]='/' Then
    CASE Para[2] Of
      '?' : BEGIN
              DosLnLF (#13#10+
              'HEXE - Hexadezimal-Editor  '+Copyright+#13#10#13#10+
              'HEXE [Dateiname] [/t]'#13#10#13#10+
              '/t   Textmodus');
              Halt;
            END;
      'T' : TextEdit:= TRUE;
    END Else
    If Param='' Then Param:= Para;
  END;
  If Param='' Then Param:= 'NONAME.BIN';

  ClipEnd:=SizeOf (ClipBuf);
  ReadBinClip (ClipBuf, ClipEnd);

Nochmal:
  Window (1, 1, 80, 25); 
  TextAttr:= 31; ClrEOl; WriteXY (39, 1, 'ASCII:             Pos:', 15, 1);
  Standard;
  Window (1, 2, 80, 24); TextAttr:= 112; ClrScr;
  WriteXY (2, 1, UpStr (GetFileName (Param)), 15, 1);

  ReadFile;
  ActSign:= 1; Line:= 1; NewX:= 0; t1:=#0; t2:=#0;

  REPEAT
    If Ins Then
    WriteXY (18, 1, 'Einfgen     ', 7, 1) Else WriteXY (18, 1, 'berschreiben', 7, 1);

    Seite;
    ScanBKeys; If not TextEdit Then t1:= UpChar (t1);

    If t1= #0 Then
    CASE t2 Of
      PgUp      : For Tmp:= 1 To 22 Do DecLine;
      Pos1      : BEGIN ActSign:= 1;  NewX:= 0; END;
      Endx      : BEGIN
                    If ActLine>=LastLine Then
                    ActSign:= LastLineLen Else ActSign:= 16;
                    NewX:= 0;
                  END;
      PgDn      : BEGIN
                    For Tmp:= 1 To 22 Do IncLine;
                    If (ActLine>=LastLine) and (ActSign>LastLineLen) Then
                    ActSign:= LastLineLen;
                    NewX:= 0;
                  END;
      CTRL_PgDn, Ctrl_Ende : BEGIN ActSign:= LastLineLen; While ActLine < LastLine Do IncLine; END;
      CTRL_PgUp, Ctrl_pos1 : BEGIN Line:= 1; FirstLine:= 0; ActLine:= 1; NewX:= 0; ActSign:= 1; END;
      Right     : BEGIN If TextEdit Then NewX:= 2; GoRight; END;
      Left      : BEGIN If TextEdit Then NewX:= 2; GoLeft;  END;
      Up        : DecLine;
      Down      : IncLine;
      F3        : If (SignAn<>0) and (SignEn<>0) Then 
                  BEGIN
                    Fusszeile (' Bitte warten...', 15, 1);
                    OldEdit := TextEdit;
                    TextEdit:= TRUE;
                    t2:= Entf; t1:= #0; 
                    While ActLine > SignAn shr 4 + 1 Do DecLine;
                    While ActLine < SignAn shr 4 + 1 Do IncLine;
                    While ActSign > SignAn and 15    Do GoLeft;
                    While ActSign < SignAn and 15    Do GoRight;
                    CopyIntoClipBoard;
                    For Sign:= SignAn To SignEn Do DelChar;
                    SignEn:= 0; SignAn:= 0;
                    TextEdit:= OldEdit;
                    Standard;
                  END;
      F5        : CopyIntoClipBoard;
      F4        : BEGIN
                    Fusszeile (' Bitte warten...', 15, 1);
                    OldEdit := TextEdit;
                    TextEdit:= TRUE;
                    SignAn:= LongInt (ActLine-1) shl 4 + ActSign;
                    SignEn:= SignAn-1;
                    For x:= 1 To ClipEnd Do
                    BEGIN
                      If Ins Then InsChar Else IncludeError:= FALSE;
                      If not IncludeError Then
                      BEGIN
                        PutChar (ActLine, ActSign, ClipBuf[x]);
                        NewX:= 2; GoRight; inc (SignEn);
                      END;
                    END;
                    TextEdit:= OldEdit;
                    Standard;
                  END;
      F2, F10   : WriteFile;
      F6        : BEGIN SignAn:= 0; SignEn:= 0; END;
      F7        : BEGIN
                    SignAn:= LongInt (ActLine-1) shl 4 + ActSign;
                    If (SignAn>SignEn) and (SignEn<>0) Then BEGIN Sign:= SignAn; SignAn:= SignEn; SignEn:= Sign; END;
                    If (SignEn<>0) and (SignEn-SignAn>=SizeOf (ClipBuf)) Then
                    BEGIN
                      SignEn:= SignAn+SizeOf (ClipBuf)-1;
                      ErrorMsg (' Markierter Block pat nicht ins Clipboard und wird gekrzt'); t1:= #0;
                    END;
                  END;
      F8        : BEGIN
                    SignEn:= LongInt (ActLine-1) shl 4 + ActSign;
                    If SignAn>SignEn Then BEGIN Sign:= SignAn; SignAn:= SignEn; SignEn:= Sign; END;
                    If (SignEn<>0) and (SignEn-SignAn>=SizeOf (ClipBuf)) Then
                    BEGIN
                      SignEn:= SignAn+SizeOf (ClipBuf)-1;
                      ErrorMsg (' Markierter Block pat nicht ins Clipboard und wird gekrzt'); t1:= #0;
                    END;
                  END;
      F9        : BEGIN
                    t1:= #27;
                    WriteFile;
                    Fusszeile (' Whlen Sie die zu ffnende Datei', 15, 1);
                    Param:= DateiManager;
                    ClrScr;
                    If Param<>'' Then
                    BEGIN
                      Release (Marker);
                      Goto Nochmal;
                    END;
                    t1:= #1;
                  END;
      F1        : Hilfe;
      Einfg     : Ins:= not Ins;
      Entf      : DelChar;
    END Else
    If TextEdit Then
    CASE t1 Of
      TAB       : TextEdit:= not TextEdit;
      Back      : DelChar;
      #27       : WriteFile;
      Else        BEGIN
                    If Ins Then InsChar Else IncludeError:= FALSE;
                    If not IncludeError Then
                    BEGIN
                      IfEdit:= TRUE;
                      PutChar (ActLine, ActSign, t1); NewX:= 2; GoRight;
                    END;
                  END;
    END Else
    CASE t1 Of
      TAB       : TextEdit:= not TextEdit;
      Back      : DelChar;
      'A'..'F', '0'..'9' : 
                  BEGIN          
                    IfEdit:= TRUE;
                    s:= ByteHex (ord (GetChar (ActLine, ActSign)));
                    s[NewX+1]:= t1;
                    Val ('$'+s, byt, code);
                    If (ins) and (NewX=0) Then InsChar Else IncludeError:= FALSE;
                    If not IncludeError Then
                    BEGIN
                      PutChar (ActLine, ActSign, chr (Byt));
                      inc (NewX);
                      If NewX= 2 Then GoRight;
                    END;
                  END;
      #27       : WriteFile;
    END;
  UNTIL (t1=#27);

  If ClipEnd<>0 Then WriteBinClip (ClipBuf, ClipEnd);
  Ende;
END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
