PROGRAM IDir;
{$M 60000, 0, 0}

USES
  BiosCrt, Dos, strings, hexbin, Masken, keycode, filecopy, WildCard,
  cdrom, Volume, Disk;

CONST
  StdFName = 'IDIR.BNK';
  TempName = 'IDIR$$$$.TMP';
  ProgName = 'IDIR';
  Attr     :  String[4] = 'ASHR';
  xAttr    :  array[1..4] of Byte = (Archive, SysFile, Hidden, ReadOnly);

VAR
  f        : Text;
  sr       : Searchrec;
  i        : Byte;
  Para     : PathStr;

  LW       : Char;
  FirstSide: Byte;
  FileName : String;
  LastDir  : PathStr;
  Etikett  : PathStr;
  ProgPath : PathStr;
  InBuf,
  OutBuf   : Array[1..20480] Of Byte;
  dt       : DateTime;
  PStat    : Byte;

CONST
  Nochmal  : Boolean = FALSE;
  SaveImage: Boolean = FALSE;
  Page     : Boolean = FALSE;
  NewDrive : Boolean = FALSE;
  NewDir   : Boolean = FALSE;
  DirsOnly : Boolean = FALSE;
  DiskOnly : Boolean = FALSE;
  DelImage : Boolean = FALSE;
  ViewImg  : Boolean = FALSE;
  Einfach  : Boolean = FALSE;
  GetDatas : Boolean = FALSE;
  HiddenY  : Boolean = TRUE;

  SeekFile : PathStr = '';
  t        : Char    = #0;
  x        : Byte    = 0;
  Line     : Byte    = 1;
  Files    : LongInt = 0;


PROCEDURE Tastenfrage;
BEGIN
  REPEAT
    t:= UpReadBKey;
    If t='N' Then t:=#27 Else If t='J' Then t:= #13;
  UNTIL (t=#27) or (t=#13) or (t='A');
END;


PROCEDURE Hilfe;
CONST
s1='DIR-Befehl fr Datentrger-Abbilder'#13#10#13#10+
   'IDIR [Laufwerk | Datei] [/n /t /-h /k= /p /l /b /d /s /e]'#13#10#13#10+
   '/n   fragt, ob ein weiterer Datentrger eingelesen werden soll'#13#10+
   '/t   speichert auch Datei-Datum, Gre und Attribute';
s2='/-h  speichert keine versteckten Dateien und Verzeichnisse'#13#10+
   '/k=  Etikett, das ein einzulesender Datentrger bekommen soll. Etiketten mit'#13#10+
   '     Leerzeichen mssen in Anfhrungszeichen gesetzt werden (/k="Disk 1").';
s3='     Fehlt /k, wird der Datentrgername verwendet.'#13#10+
   '/p   seitenweise Anzeige'#13#10+
   '/l   zeigt alle Datentrger-Etiketten'#13#10+
   '/b   verwendet einfaches Ausgabeformat'#13#10+
   '/d   zeigt nur Verzeichnisse an';
s4='/s   zeigt bei der Suche nach Dateien nur die Datentrger-Etiketten'#13#10+
   '/e   lscht ein Datentrger-Abbild'#13#10;
s5='IDIR A: /k=Disk-1  liest eine Diskette in A: mit dem Namen (=Etikett)'#13#10+
   '                   "Disk-1" und speichert deren Inhalt.'#13#10+
   'IDIR               zeigt eine Eingabemaske'#13#10+
   'IDIR *.TXT         zeigt nur Dateien mit der Endung .TXT';
BEGIN
  Standardkopf ('IDIR', Copyright);
  DosLnLF (s1); DosLnLF (s2); DosLnLF (s3); DosLnLF (s4); DosLnLF (s5);
  BlindStop;
  Halt;
END;


PROCEDURE CloseImageFile;
BEGIN
  If TextRec (f).mode <> fmClosed Then Close (f);
  If IOResult<>0 Then;
END;


FUNCTION GetVolumeName : String;
VAR
  VolName : String;
  sr      : SearchRec;
  p       : Byte;
  MID     : MIDRec;
  ReadBuf : TSector;
  VTOC    : VTOCRec absolute ReadBuf;
LABEL
  Ende;
BEGIN
  VolName:= '?';
  If Drive (LW) and CDDrive<>0 Then
  BEGIN
    ReadVTOC (ord(LW)-65, 0, ReadBuf);
    If IOResult=0 Then VolName:= Trim(VTOC.VolumeName);
  END Else
  BEGIN
    GetMediaID (LW, MID);
    If IOResult=0 Then
    BEGIN
      Move (MID.VolumeLabel, VolName[1], 11);
      VolName[0]:= #11;
      VolName:= Trim (VolName);
    END Else
    BEGIN
      FindFirst (LW+':\*.*', VolumeID, sr);
      While DosError=0 Do
      BEGIN
        If sr.attr and 15 = VolumeID Then { LFN von Win 9x berlesen }
        BEGIN Volname:= sr.name; Goto Ende; END;
        FindNext (sr);
      END;
      Ende:
      p:= pos ('.', VolName);
      If p<>0 Then delete (VolName, p, 1);
    END;
  END;
  GetVolumeName:= VolName;
END;


PROCEDURE ErrorMsg (s : String);
BEGIN
  CloseImageFile;
  SimpleHalt (#13#10+s);
END;


PROCEDURE RewriteImageFile;
BEGIN
  Assign (f, FileName); FileMode:= 2;
  SetTextBuf (f, OutBuf, SizeOf (OutBuf));
  Append (f);
  If IOResult <> 0 Then
  BEGIN
    SetFAttr (f, 32); Append (f);
    If IOResult <> 0 Then
    BEGIN
      Rewrite (f);
      If IOResult <>0 Then
      ErrorMsg ('Abbild-Datei konnte nicht angelegt werden'#13#10+FileName);
    END;
  END;
END;


PROCEDURE ResetImageFile;
BEGIN
  Assign (f, FileName); FileMode:= 0;
  SetTextBuf (f, OutBuf, SizeOf (OutBuf));
  Reset (f); 
  If IOResult <>0 Then
  ErrorMsg ('Abbild-Datei nicht gefunden'#13#10+FileName);
END;


PROCEDURE WriteFileRec (sr : SearchRec);
BEGIN
  If GetDatas Then
  BEGIN
    UnpackTime (sr.time, dt);
    With dt, sr Do
    WriteLn (f, Name+'+'+TausPkt(Size)+'+'+lz(hour)+':'+lz(min)+':'+lz(sec)+'+'+
                +lz(day)+'.'+lz(month)+'.'+StrVal(year)+'+'+chr(sr.attr or 64));
  END Else
  WriteLn (f, sr.name);
  If IOResult<> 0 Then
  ErrorMsg ('Fehler beim Schreiben in Abbilddatei'#13#10+FileName);
END;


PROCEDURE WriteInFile (s : String);
BEGIN
  WriteLn (f, s);
  If IOResult<> 0 Then
  ErrorMsg ('Fehler beim Schreiben in Abbilddatei'#13#10+FileName);
END;


PROCEDURE ListDir (Pfad : PathStr);
VAR
  x1 : Byte;
BEGIN
  FindFirst (Vollpfad (Pfad, '*.*'), Normalfile, sr);
  If DOSError>=150 Then ErrorMsg ('Fehler beim Einlesen der Dateien');
  While DosError = 0 Do
  BEGIN
    If (sr.attr and directory = 0) and ((sr.attr and hidden = 0) or (HiddenY)) Then
    BEGIN
      WriteFileRec (sr);
      If (keyPressed) and (UpReadBKey=#27) Then ErrorMsg ('Abbruch durch Anwender');
    END;
    FindNext (sr);
  END;
END;



PROCEDURE Rek (S : PathStr);
VAR
  tx : Searchrec;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), normalfile, tx);
  While DOSError=0 Do
  BEGIN
    If   (tx.attr and directory<>0) and (tx.name[1]<>'.') 
    and ((tx.attr and hidden = 0) or (HiddenY)) Then
    BEGIN
      WriteInFile ('*'+ Vollpfad (S, tx.name));
      ListDir (Vollpfad (S, tx.name));
      Rek (Vollpfad (S, tx.name));
    END;
    Findnext (tx);
  END;
END;



PROCEDURE ReadLine (VAR s : PathStr);
BEGIN
  ReadLn (f, s);
  If IOResult <> 0 Then
  ErrorMsg ('Fehler beim Lesen der Abbild-Datei'#13#10+FileName);
END;



PROCEDURE OutLine (s : PathStr);
BEGIN
  DosLnLF  (s);
  If (Page) and (not DelImage) and (not SaveImage) Then
  BEGIN
    inc (Line);
    If Line>23 Then
    BEGIN
      Line:= 1;
      DosStr (#13#10'Weiter mit ENTER oder Abbrechen mit Esc');
      Tastenfrage;
      DosLnLF (#13#10);
    END;
  END;
END;



PROCEDURE WriteDriveDatas;
BEGIN
  DosStr ('Datentrger-Etikett: '); OutLine (Etikett);
END;


PROCEDURE WriteDriveNew;
BEGIN
  If NewDrive Then
  BEGIN
    If not DiskOnly Then OutLine ('');
    WriteDriveDatas;
    NewDrive:= FALSE;
  END;
END;


PROCEDURE OutName (Dir, FName : PathStr);
VAR
  TStr : PathStr;
  Att  : Byte;
BEGIN
  WriteDriveNew;
  If DiskOnly Then BEGIN inc (Files); Exit; END;
  If Einfach Then OutLine (Vollpfad (Dir, nthField(FName, '+', 1))) Else
  BEGIN
    If NewDir Then
    BEGIN
      OutLine ('');
      OutLine (Dir);
      NewDir:= FALSE;
    END;
    DosStr  ('   ');
    TStr:= LowStr(nthField(FName, '+', 1));
    If CountFields (FName, '+')>1 Then
    BEGIN
      DosStr (SpaceStr  (TStr, 13));
      DosStr (StretchStr(nthField(FName, '+', 2), 15));
      DosStr (StretchStr(nthField(FName, '+', 4), 16));
      DosStr (StretchStr(nthField(FName, '+', 3), 14));
      TStr:= nthField(FName, '+', 5);
      If Length(TStr)<>0 Then
      BEGIN
        Att:= ord (TStr[1]) and (not 64);
        TStr:= '----';
        For x:= 1 To 4 Do
        If Att and xattr[x]<>0 Then TStr[x]:=Attr[x];
        OutLine (StretchStr(TStr, 11));
      END Else
      OutLine ('');
    END Else
    OutLine (TStr);
  END;
  inc (Files);
END;



PROCEDURE SeekNames;
VAR
  Dir : PathStr;
  Fil : PathStr;
BEGIN

  While (Not Eof(f)) and (t<>#27) Do
  BEGIN
    If (Keypressed) and (UpReadBKey=#27) Then ErrorMsg ('Abbruch durch Anwender');
    ReadLine (Fil);
    If Fil= '.' Then
    BEGIN
      ReadLine (Etikett);
      NewDrive:= TRUE;
    END Else
    If Fil[1] = '*' Then
    BEGIN
      Dir:= Fil; Delete (Dir, 1, 1); NewDir:= TRUE;
      If DirsOnly Then
      BEGIN
        WriteDriveNew;
        OutLine (Dir);
        inc (Files);
      END;
    END Else
    If  (not DirsOnly)
    and (FileMatch (nthField(Fil, '+', 1), SeekFile)) Then OutName (Dir, Fil);
  END;
END;



PROCEDURE DeleteImage (LineNr : LongInt);
VAR
  f1  : Text;
  tmp : PathStr;
  Lin : PathStr;
  idx : LongInt;
  wtr : Boolean;
BEGIN
  wtr:= FALSE;
  idx:= 0;
  tmp:= VollPfad (ProgPath, TempName);
  Rename (f, tmp);
  If IOResult<>0 Then
  BEGIN Assign (f1, tmp); Erase (f1); Rename (f, tmp); END;
  Assign (f1, tmp); FileMode:= 0;
  SetTextBuf (f1, InBuf, SizeOf (InBuf));
  Reset (f1);
  If IOResult <> 0 Then
  ErrorMsg ('Fehler beim Anlegen der Temporrdatei'#13#10+tmp);

  RewriteImageFile;

  While not Eof (f1) Do
  BEGIN
    ReadLn (f1, Lin);
    If IOResult <> 0 Then
    BEGIN
      Close (f1); If IOResult<>0 Then;
      ErrorMsg ('Fehler beim Lesen der Temporrdatei'#13#10+tmp);
    END;
    inc (idx);
    If  (idx > LineNr) and (Lin='.') Then wtr:= TRUE;
    If  (idx < LineNr) or (Wtr) Then WriteInFile (Lin);
  END;
  CloseImageFile;
  Close (f1);
  Erase (f1); If IOResult<>0 Then;
END;



PROCEDURE CheckImageFile;
VAR
  REtikett : PathStr;
  LineNr   : LongInt;
LABEL
  Ende;
BEGIN
  FindFirst (FileName, normalfile, sr); If DOSError<>0 Then Exit;
  LineNr:= 0;
  ResetImageFile;
  While Not Eof (f) Do
  BEGIN
    ReadLine (REtikett);
    inc (LineNr);
    If REtikett = '.' Then
    BEGIN
      ReadLine (REtikett);
      inc (LineNr);
      If REtikett = Etikett Then
      BEGIN
        DosLnLF (#13#10'Datentrger-Abbild mit gleichnamigem Etikett gefunden.'#13#10+
                 'Das gefundene Datentrger-Abbild berschreiben? <j>a  <n>ein  <a>bbrechen');
        Tastenfrage;
        If t=#13 Then
        BEGIN
          CloseImageFile;
          DeleteImage (LineNr-1);
          Exit;
        END Else If t='A' Then Goto Ende;
      END;
    END;
  END;
Ende:
  CloseImageFile;
END;



PROCEDURE EraseImages;
VAR
  LineNr    : LongInt;
  TmpLineNr : LongInt;
  REtikett  : PathStr;
  Found     : Boolean;
LABEL
  Nochmal;
BEGIN
  FindFirst (FileName, normalfile, sr);
  If (DOSError<>0) or (sr.Size=0) Then
  ErrorMsg ('Es existiert noch keine Abbild-Datei');
  Found:= FALSE;
  TmpLineNr:= 0;
Nochmal:
  LineNr:= 0;
  ResetImageFile;

  While Not Eof (f) Do
  BEGIN
    ReadLine (REtikett);
    inc (LineNr);

    If (REtikett = '.') and (LineNr>=TmpLineNr) Then
    BEGIN
      ReadLine (REtikett); 
      inc (LineNr);
      If (Etikett='') or (REtikett=Etikett) or (not DelImage) Then
      BEGIN
        If (not ViewImg) Then OutLine ('');
        If (not ViewImg) or (not Einfach) Then DosStr ('Datentrger-Etikett: ');
        OutLine (REtikett);
        If DelImage Then
        BEGIN
          Found:= TRUE;
          DosLnLF ('Soll dieses Datentrger-Abbild gelscht werden? <j>a  <n>ein  <a>bbrechen');
          Tastenfrage;
          If t=#13 Then
          BEGIN
            CloseImageFile;
            TmpLineNr:= pred(LineNr);
            DeleteImage (TmpLineNr);
            DosLnLF ('Abbild gelscht');
            Goto Nochmal;
          END Else
          BEGIN
            DosLnLF ('Abbild nicht gelscht');
            If t='A' Then
            BEGIN DosLnLF ('Abbruch durch Anwender'); Exit; END;
          END;
        END;
      END;
    END;
  END;
  CloseImageFile;
  If (DelImage) and (not Found) Then
  DosLnLF ('Gesuchtes Abbild nicht gefunden: '+Etikett);
END;


FUNCTION DelQuots (s : String) : String;
BEGIN
  If (pos ('"', s)=1) and (s[Length(s)]='"') Then
  BEGIN delete (s, 1, 1); delete (s, Length(s), 1); END;
  DelQuots:= s;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7;
BEGIN
  Para:= '*.*';
  t2:= #0;

  a1:
  EditStr    (1, Para,    'Name der anzuzeigenden Dateien:');
  If t2=Up Then Goto a1;
  Para:= UpStr (Para);
  If Para = '' Then Para:='*.*';

  a2:
  ParamField (6, Page,    'Anzeige nach jeder Bildschirmseite anhalten');
  If t2=Up Then Goto a1;

  a3:
  ParamField (7, DiskOnly,'nur die Etiketten von Datentrgern mit gefundenen Dateien anzeigen');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, DirsOnly,'nur alle Verzeichnisse anzeigen');
  If t2=Up Then Goto a3;

  a5:
  ParamField (9, ViewImg, 'nur alle Datentrger-Etiketten auflisten');
  If t2=Up Then Goto a4;

  a6:
  ParamField (10, Einfach, 'einfache Bildschirmausgabe');
  If t2=Up Then Goto a5;
END;



PROCEDURE ShowLeseMaske;
LABEL
  a1, a2, a3, a4, a5;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Para, 'einzulesendes Laufwerk:');
  Para:= UpStr (Para);
  a2:
  EditStr (5, Etikett, 'Name, den der Datentrger als Etikett bekommen soll:');
  If t2=Up Then Goto a1;
  a3:
  ParamField (10, Nochmal, 'fragt am Ende, ob ein weiterer Datentrger eingelesen werden soll');
  If t2=Up Then Goto a2;
  a4:
  ParamField (11, GetDatas, 'speichert fr jede Datei auch Datum, Zeit, Gre und Attribute');
  If t2=Up Then Goto a3;
  a5:
  ParamField (12, HiddenY, 'speichert auch versteckte Dateien und Verzeichnisse');
  If t2=Up Then Goto a4;

  If (ee=0) and (Para='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort
  END;
  Etikett:= DelQuots (Etikett);
END;


PROCEDURE ShowDelMaske;
BEGIN
  t2:= #0;
  EditStr (1, Etikett, 'Etikett des Datentrgers, dessen Abbild gelscht werden soll:');
  If ee=1 Then
  BEGIN
    GotoXY (1, 6);
    OutStr ('Wenn Sie kein Etikett angeben, zeigt '+ ProgName +' Ihnen alle gespeicherten'#13#10+
    'Etiketten und fragt bei jedem, ob es gelscht werden soll oder nicht.');
  END;
END;


PROCEDURE Maske;
BEGIN
  Para:= 'A:';
  StandardKopf (ProgName, 'Eingabemaske');
  OutStr ('Welcher Befehl soll ausgefhrt werden?'#13#10#13#10+
     'E    Datentrger einlesen und in der Abbild-Datenbank speichern'#13#10+
     'L    Datentrger-Abbild aus der Abbild-Datenbank lschen'#13#10+
     'A    Dateien/Verzeichnisse anzeigen (DIR-Befehl)'#13#10#13#10+
     'Esc  Abbrechen');
  Fusszeile ('Drcken Sie eine der vorangestellten Tasten');
  REPEAT
    t1:= UpReadBKey;
    If t1=#27 Then UserAbort;
  UNTIL (t1='E') or (t1='L') or (t1='A');
  ClrScr;
  Fusszeile (EingabeHilfe);
  CASE t1 Of
    'E' : BEGIN ee:= 1; ShowLeseMaske; ee:= 0; ShowLeseMaske; END;
    'A' : BEGIN ee:= 1; ShowMaske;     ee:= 0; ShowMaske;     END;
    'L' : BEGIN ee:= 1; ShowDelMaske;  ee:= 0; ShowDelMaske;  DelImage:= TRUE; END;
  END;
  If not DelImage Then BEGIN LW:= Para[1]; SeekFile:= Para; END;
  Window (1, 1, 80, 25); ClrScr;
END;


FUNCTION DiskOkay : Boolean;
VAR
  sr : SearchRec;
BEGIN
  FindFirst (LW+':\*.*', anyfile, sr);
  DiskOkay:= DOSError < 150;
END;


BEGIN
  StretchParam (FileName);
  Etikett:= ''; SeekFile:= '';
  If ParamCount=0 Then Maske Else
  i:= 1;
  While i <= ParamCount Do
  BEGIN
    Para:= UpStr (ParamStr (i));
    If Para[1]='/' Then
    CASE Para[2] Of
      'N' : Nochmal  := TRUE;
      'P' : Page     := TRUE;
      'D' : DirsOnly := TRUE;
      'S' : DiskOnly := TRUE;
      'E' : DelImage := TRUE;
      'L' : ViewImg  := TRUE;
      'B' : Einfach  := TRUE;
      'T' : GetDatas := TRUE;
      'K' : BEGIN
              Etikett:= copy (ParamStr(i), 4, 255);
              If pos ('"', Etikett) = 1 Then
              While (Etikett[Length(Etikett)]<>'"') and (i<ParamCount) Do
              BEGIN
                inc (i);
                Etikett:= Etikett+' '+ParamStr(i);
              END;
              Etikett:= DelQuots (Etikett);
            END;
      '-' : If Para[3]='H' Then HiddenY:= FALSE;
      Else  Hilfe;
    END Else
    BEGIN LW:= Para[1]; SeekFile:= Para; END;
    inc (i);
  END;
  Para:= LW+':';

  TextRec(f).Mode:= fmClosed;
  ProgPath:= ParamStr (0);
  While (Length(ProgPath)>0) and (ProgPath[Length(ProgPath)]<>'\') Do dec (ProgPath[0]);
  FileName:= VollPfad (ProgPath, StdFName);

  SaveImage:= (Length(SeekFile)>=2) and (SeekFile[2]=':');

  If ((DelImage) or (ViewImg)) and (not SaveImage) Then
  BEGIN EraseImages; Halt; END;

  If SaveImage Then
  BEGIN
    PStat:= PathStatus (Para, CheckQuelle);
    If PStat<>0 Then SimpleHalt (PathStatusStr (PStat));
    REPEAT
      If Length (Etikett)=0 Then Etikett:= GetVolumeName;
      DosLnLF (#13#10'Speichere Inhaltsverzeichnis von Datentrger in '+LW+': ...');
      WriteDriveDatas;
      If DiskOkay Then
      BEGIN
        CheckImageFile;
        If t<>'A' Then
        BEGIN
          RewriteImageFile;
          WriteInFile ('.');
          WriteInFile (Etikett);
          WriteInFile ('*'+LW+':\');
          ListDir (LW+':\');
          Rek (LW+':\');
          CloseImageFile;
          DosLnLF ('Datentrger-Abbild erfolgreich gespeichert');
        END Else
        DosLnLF ('Datentrger-Abbild nicht gespeichert');
      END
      Else
      DosLnLF ('Datentrger kann nicht gelesen werden');

      If Nochmal Then
      BEGIN
        DosLnLF (#13#10'Wollen Sie einen weiteren Datentrger speichern?  <j>a  <n>ein');
        Tastenfrage;
        If t=#13 Then
        BEGIN
          StandardKopf (ProgName, 'Eingabemaske');
          Fusszeile (EingabeHilfe);
          ee:= 1; ShowLeseMaske; ee:= 0; ShowLeseMaske;
          LW:= Para[1];
          t:=t1;
          Window (1, 1, 80, 25); ClrScr;
        END;
      END;
    UNTIL (not Nochmal) or (t=#27);
    Halt;
  END;

  ResetImageFile;
  SeekNames;
  If Files = 0 Then ErrorMsg ('Datei nicht gefunden') Else
  BEGIN
    DosStr (#13#10'Dateien gefunden: '); DosNum (Files);
    CloseImageFile;
    SimpleHalt ('');
  END;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
