UNIT cButton;


INTERFACE

USES
  bioscrt, Monitor, Mouse, Time, Keycode;

TYPE
  ButStr = String[80];

VAR
  ee : Byte;


PROCEDURE InsertPos (xx, yy : Byte);
PROCEDURE SetCursor;
PROCEDURE MoveCursor;

PROCEDURE Standard_MT (Modus : Byte);
PROCEDURE Button (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : ButStr; Shadow : Byte);
PROCEDURE Radio  (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : ButStr; VAR Wert : Byte; Vergl : Byte);


CONST
  MaxBut = 255;
  wDays : array[0..6] Of String[10] =
         ('   Sonntag', '    Montag', '  Dienstag', '  Mittwoch',
          'Donnerstag', '   Freitag', '   Samstag');

VAR
  ButCount: Byte;
  LastBut : Byte;
  ActBut  : Byte;
  Buttons : Array[1..MaxBut] Of RECORD x, y, z : Byte; END;
  RepRadio: Boolean;


IMPLEMENTATION
  

PROCEDURE Standard_MT (Modus : Byte);
BEGIN
  kn:= 0; t1:= #0; t2:= #0;
  MouseOn; 
  REPEAT
    Mouseget;
    WriteXY (52, 2, ActDateStr (10), yellow, red);
    WriteXY (40, 2, wDays [DayOfWeek], yellow, red);
    WriteXY (66, 2, ActTimeStr (8)+ ' Uhr', yellow, red);
  UNTIL (kn<>0) or (keypressed);
  MouseOff;
  CASE Modus Of
    1 : If Keypressed Then UpScanKeys Else MouseWait;
    2 : If Keypressed Then ScanKeys   Else MouseWait;
    3 : If keyPressed Then UpScanKeys;
  END;
END;


PROCEDURE InsertPos (xx, yy : Byte);
BEGIN
  If LastBut<MaxBut Then
  BEGIN inc (LastBut); Buttons[LastBut].x:=xx; Buttons[LastBut].y:=yy; END;
END;


PROCEDURE SetCursor;
BEGIN
  Window (1, 1, 80, 25);
  With Buttons[ActBut] Do GotoXY (x, y);
END;


PROCEDURE MoveCursor;
BEGIN
  If t1=TAB Then
  BEGIN
    If ActBut<LastBut Then inc (ActBut) Else ActBut:= 1;
    t1:= #0;
  END Else
  If t2=Shift_TAB Then
  BEGIN
    If ActBut>1 Then dec (ActBut) Else ActBut:= LastBut;
    t2:= #0;
  END;
END;


PROCEDURE Button (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : ButStr; Shadow : Byte);
VAR
  l, y, cv, ch : Byte;
BEGIN 
  l:= Length (st)+a+1;
  If ee=1 Then
  BEGIN
    If Shadow > 1 Then
    BEGIN cv:=yellow+blink; ch:=red; END Else BEGIN cv:=yellow; ch:=blue; END;
    WriteXY (a, b, st, cv, ch);
    CharXY (l-1, b, #220, darkgray, 7);
    For y:= a+1 To l-1 Do CharXY (y, b+1, #223, darkgray, 7);
    y:= Pos (Hotkey, St);
    If y<>0 Then BEGIN WriteXY (a+y-1, b, Hotkey, 15, ch); END;
    InsertPos (a, b);
  END Else
  BEGIN
    inc (ButCount);
    If ((upcase(t1)= Hk1a) and (upcase(t2)=Hk1b))
    or ((kn<>0) and (MouseIn (a, b, l-2, b)))
    or ((t1=#13) and (ButCount=ActBut)) Then
    BEGIN t1 := Hk1a; t2:= Hk1b; END;
  END;
END;


PROCEDURE Radio (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : ButStr; VAR Wert : Byte; Vergl : Byte);
VAR
  l, y : Byte; c : Char;
BEGIN 
  l:= Length (st)+a+4;
  If ee=1 Then
  BEGIN
    WriteXY (a, b, '( )  '+st, 0, 7);
    y:= Pos (Hotkey, St);
    If y<>0 Then BEGIN WriteXY (a+y+4, b, Hotkey, 14, 7); END;
    InsertPos (a+1, b);
  END Else
  BEGIN
    inc (ButCount);
    If ((upcase(t1)= Hk1a) and (upcase(t2)=Hk1b))
    or ((kn<>0) and (MouseIn (a, b, l, b)))
    or ((t1=#13) and (ButCount=ActBut)) Then
    BEGIN Wert:= (Wert and not 12) or Vergl; ActBut:= ButCount; RepRadio:= TRUE; END;
  END;
  If Wert and 12=Vergl Then c:= '+' Else c:= ' ';
  CharXY (a+1, b, c, magenta, 7);
END;

END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
