UNIT dckl_Clp;


INTERFACE
USES
  dckl_var, Dos, Strings, clipbord;

PROCEDURE WriteClipBoard;
PROCEDURE ReadClipBoard;

CONST
  ClipErr : Boolean = FALSE;

IMPLEMENTATION


PROCEDURE WriteClipBoard;
CONST
  ClipSize = SizeOf (Term);
VAR
  Clip     : Array[1..ClipSize] Of Byte absolute ClipBrd;
  x        : Word;
  Empty    : Boolean;
BEGIN
  Empty:= TRUE;
  For x:= 1 To ClipSize Do If Clip[x]<>0 Then Empty:= FALSE;
  If (Empty) or (ClipErr) Then Exit;
  RewriteClip;
  With ClipBrd Do
  BEGIN
    WriteClipLine (Tag+#13#10+Monat+#13#10+Stunde+#13#10+Minute+#13#10+Jahr);
    For x:= 1 To 3 Do WriteClipLine (txt[x]);
  END;
  CloseClip;
END;


PROCEDURE ReadClipBoard;
CONST
  ClipSize = SizeOf (Term);
VAR
  x         : Word;
  tmp, tmp1 : String;
  FNum      : Byte;
  c         : Integer;
  w         : Word;
BEGIN
  ResetClip;
  FNum:= 0;
  With ClipBrd Do
  While (not EofClip) and (FNum<8) Do
  BEGIN
    tmp:= Trim(GetClipLine);
    If (FNum<8) and (tmp<>'') Then
    BEGIN
      inc (FNum);
      If FNum<=5 Then
      BEGIN
        tmp1:= copy (tmp, 1, 2+(ord(FNum=5) shl 1));
        Val (tmp1, w, c);
        If c<>0 Then BEGIN FNum:= 6; ClipErr:= TRUE; END Else  { Zahlenfelder berspringen }
        CASE FNum Of
          1 : Tag   := tmp1; 2 : Monat := tmp1;
          3 : Stunde:= tmp1; 4 : Minute:= tmp1;
          5 : Jahr  := tmp1;
        END;
      END;
      If FNum>=6 Then Txt[FNum-5]:= copy (tmp, 1, 65);
    END;
  END;
  CloseClip;
END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
