UNIT DCKL_FIL;

INTERFACE

USES
  Dckl_var, Strings, Dos, bioscrt, monitor, cbutton, monit, time, mouse;

PROCEDURE OpenDataFile;
PROCEDURE ReadTerm  (VAR vTerm  : Term);
PROCEDURE WriteTerm (VAR vTerm : Term);
PROCEDURE RefreshLastIndex;
PROCEDURE ClearIndex;
PROCEDURE ShowAll;
FUNCTION  NextTerm    : Word;
FUNCTION  PrevTerm    : Word;
FUNCTION  FirstTerm   : Word;
FUNCTION  LastTerm    : Word;
FUNCTION  TermCount   : Word;
FUNCTION  TermPos (Nr : Word) : Word;

PROCEDURE DosErrMsg (Txt : String);
PROCEDURE Fusszeile (Txt : String);
PROCEDURE ErrorMsg  (Txt : String);
PROCEDURE ErrorEnd  (Txt : String);
PROCEDURE Hilfe;


CONST
  StandardMask        = 1;
  ShowMask     : Byte = StandardMask;


IMPLEMENTATION


PROCEDURE OpenDataFile;
VAR
  sr : SearchRec;
BEGIN
  Assign (f, TermDatei); FileMode:= 2;
  FindFirst (TermDatei, anyfile, sr);
  If DOSerror=0 Then
  BEGIN
    If sr.attr and (directory or VolumeID) = 0 Then
    BEGIN
      SetFAttr (f, 32);
      Reset (f); Result:= IOResult;
    END Else Result:= 1;
  END Else
  BEGIN Rewrite (f); Result:= IOResult; END;
  FPos:= 0; IPos:= 0;
END;


PROCEDURE ReadTerm (VAR vTerm : Term);
BEGIN
  Read (f, vTerm);
  Result:= IOResult;
  If Result<>0 Then ErrorEnd ('Fehler beim Lesen aus Termin-Datei');
END;


PROCEDURE WriteTerm (VAR vTerm : Term);
BEGIN
  Write (f, vTerm);
  Result:= IOResult;
  If Result<>0 Then ErrorEnd ('Fehler beim Schreiben in Termin-Datei');
END;


PROCEDURE RefreshLastIndex;
VAR
  Fs : LongInt;
  Old: Word;
BEGIN
  Old:= LastIndex;
  fs:= FileSize(f);
  If fs>MaxTerms Then fs:= MaxTerms; LastIndex:=fs;
  For Old:= Old To LastIndex Do Index[Old]:= ShowMask;
END;


PROCEDURE ClearIndex;
BEGIN
  ShowMask:= StandardMask;
  FillChar (Index, SizeOf(Index), StandardMask); LastIndex:= 0; IPos:= 0;
END;


PROCEDURE ShowAll;
BEGIN
  ShowMask:= StandardMask;
  FillChar (Index, SizeOf(Index), StandardMask); IPos:= 0; RefreshLastIndex;
END;


FUNCTION NextTerm : Word;
VAR
  tmp : Word;
BEGIN
  If LastIndex=0 Then NextTerm:= 0 Else
  BEGIN
    tmp:= IPos;
    If IPos<LastIndex Then
    REPEAT inc (IPos); UNTIL (Index[IPos] and ShowMask=ShowMask) or (IPos>=LastIndex);
    If Index[IPos] and ShowMask<>ShowMask Then IPos:= tmp;
    NextTerm:= pred (IPos);
  END;
END;


FUNCTION PrevTerm : Word;
VAR
  tmp : Word;
BEGIN
  If LastIndex=0 Then PrevTerm:= 0 Else
  BEGIN
    tmp:= IPos;
    If IPos>1 Then
    REPEAT dec (IPos); UNTIL (Index[IPos] and ShowMask=ShowMask) or (IPos<=1);
    If Index[IPos] and ShowMask<>ShowMask Then IPos:= tmp;
    PrevTerm:= pred (IPos);
  END;
END;


FUNCTION FirstTerm : Word;
BEGIN
  IPos:= 0; FirstTerm:= NextTerm;
END;


FUNCTION LastTerm  : Word;
BEGIN
  IPos:= LastIndex+1; LastTerm:= PrevTerm;
END;


FUNCTION TermCount : Word;
VAR
  x, y : Word;
BEGIN
  y:= 0;
  For x:= 1 To LastIndex Do If Index[x] and ShowMask=ShowMask Then inc (y);
  TermCount:= y;
END;


FUNCTION TermPos (Nr : Word) : Word;
VAR
  tmp : Word;
BEGIN
  If LastIndex=0 Then TermPos:= 0 Else
  BEGIN
    tmp:= IPos;
    IPos:=0;
    REPEAT
      inc (IPos);
      If Index[IPos] and ShowMask=ShowMask Then dec (Nr);
    UNTIL (Nr=0) or (IPos>=LastIndex);
    If Nr<>0 Then IPos:= tmp;
    TermPos:= pred (IPos);
  END;
END;



PROCEDURE DosErrMsg (Txt : String);
BEGIN
  DosStr (#13#10);
  DosStr (Txt);
  DosStr (#13#10'Weiter mit beliebiger Taste');
  WaitKey;
END;


PROCEDURE Fusszeile (Txt : String);
BEGIN
  WriteXY (2, 24, SpaceStr (' '+Txt, 78), yellow, black);
END;


PROCEDURE ErrorMsg (Txt : String);
VAR
  pp         : Array[1..4000] Of Byte;
  x1, x2     : Byte;
BEGIN
  GetScreen25 (pp);
  x1:= 38-Length (Txt) shr 1;
  x2:= x1+Length (Txt)+5;
  Rahmen     (x1,    8, x2,   14, 7, 0);
  Rahmen     (x1+1,  9, x2-1, 11, 7, 1);
  Schatten25 (x1,    8, x2,   14);
  WriteXY    (x1+2, 10, ' '+Txt+' ', yellow, red);
  WriteXY    (38,   12, ' Okay ', yellow, blue);
  CharXY     (44,   12, #220, darkgray, 7);
  For x1:= 39 To 44 Do CharXY (x1, 13, #223, darkgray, 7);
  Standard_MT (1); t1:= #0; t2:= #0; kn:= 0;
  SetScreen25 (pp);
END;

PROCEDURE ErrorEnd (Txt : String);
BEGIN
  Close (f); If IOResult<>0 Then;
  ErrorMsg (Txt);
  CursorOn;
  ClearWin (1, 1, 80, 25, 7);
  Halt;
END;


PROCEDURE Hilfe;
BEGIN
  DosStr (HeadLine);
  DosStr (
  'Termin-Kalender mit Alarmfunktion'#13#10#13#10+
  'KALENDER [/s /n /p /t]'#13#10#13#10+
  '/s  sucht beim Start nach aktuellen Terminen und beendet sich sofort, wenn'#13#10+
  '    keine gefunden wurden (empfohlen bei Aufruf in der AUTOEXEC.BAT)'#13#10);
  DosStr (
  '/n  beim Start nicht nach aktuellen Terminen suchen'#13#10+
  '/p  Drucker oder Name der Druckzieldatei, wenn nicht LPT1 (z.B. /p:LPT2)'#13#10+
  '/t  Name der Termin-Datei, wenn nicht KALENDER.TER (z.B. /t:A:\TERMINE.TER)'#13#10);

  Halt;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
