UNIT dckl_kal;

INTERFACE

USES
  bioscrt, dcKl_neu, Dos, cbutton, monitor, monit, dckl_sho,
  keyCode, Strings, time, mouse, dckl_var, dckl_fil, rechnen;


PROCEDURE Kalender_zeigen;


IMPLEMENTATION
CONST
  MaxWT    = 100;

VAR
  Date     : DosDateRec;
  LDay     : Word;
  CDay     : Byte;
  cc       : Word;
  TermMask : Array[1..31] Of RECORD
                               KalTag    : Word;
                               WPtr      : Byte;
                               WeekTerms : Array[1..MaxWT] Of Word;
                               OldMask   : Array[1..MaxWT] Of Byte;
                             END;

PROCEDURE InsertWeekTerm (MaskNum : Byte; TPos : Word);
BEGIN
  With TermMask[MaskNum] Do If WPtr<MaxWT Then
  BEGIN inc (WPtr); WeekTerms[WPtr]:= TPos; END;
END;


PROCEDURE GetMonatsTermine;
VAR
  MonthLen1: MonthArr;
  YearLen  : Array[FirstYear..LastYear] Of LongInt;
  i        : Word;
  l        : LongInt;
  TerDate  : DosDateRec;
  c        : Word;
  wd, y    : Byte;
  dna, dnt : LongInt;
  x, xx    : Byte;

BEGIN
  l:= 0;
  For i:= FirstYear To LastYear Do
  BEGIN YearLen[i]:= l; inc (l, 365+ord(LeapYear(i))); END;
  MonthLen1:= MonthLen;
  If LeapYear (Date.Year) Then MonthLen1[2]:= 29;
  For c:=0 To LastIndex Do Index[c]:= Index[c] and 3;
  Showmask:= 1;
  FPos:= FirstTerm;
  Seek (f, FPos);
  FillChar (TermMask, SizeOf(TermMask), 0); c:= 0;

  While (Not Eof (f)) and (LastIndex<MaxTerms) Do
  BEGIN
    ReadTerm (Termin);
    inc (c);
    With Termin Do
    If Status and 3=sAktiv Then
    BEGIN
      TermToDate (TerDate, Termin);
      With TerDate Do
      CASE Status and 12 Of
        sJahr :  If (year=Date.year) and (month=Date.month) Then
                 BEGIN
                   inc (TermMask[day].KalTag);
                   Index[c]:=Index[c] or (day shl 3);
                 END;
        sMonat : If ((year<Date.year) or ((year=Date.year) and (month<=Date.Month))) Then
                 BEGIN
                   inc (TermMask[day].KalTag);
                   Index[c]:=Index[c] or (day shl 3);
                 END;
        sWoche : If ((year<Date.year) or ((year=Date.year) and (month<=Date.Month))) Then
                 BEGIN
                   wd:=WeekDay (Day, Month, Year);
                   If (year=Date.year) and (month=Date.Month) Then y:= day Else y:= 1;
                   xx:= 0;
                   For x:= y To MonthLen1[Date.Month] Do
                   If  wd=WeekDay (x, Date.Month, Date.Year) Then
                   BEGIN
                     inc (TermMask[x].KalTag);
                     If xx=0 Then Index[c]:=Index[c] or (x shl 3) Else
                     InsertWeekTerm (x, c);
                     xx:= 1;
                   END;
                 END;
        s2Woche: If ((year<Date.year) or ((year=Date.year) and (month<=Date.Month))) Then
                 BEGIN
                   wd := WeekDay (Day, Month, Year);
                   dnt:= DayNum  (Day, Month, Year)+YearLen[Year];
                   If (year=Date.year) and (month=Date.Month) Then y:= day Else y:= 1;
                   If Year<Date.Year Then y:= 1;
                   xx:= 0;
                   For x:= y To MonthLen1[Date.Month] Do
                   If  wd=WeekDay (x, Date.Month, Date.Year) Then
                   BEGIN
                     With Date Do
                     dna:=((DayNum (x, Month, Year)+YearLen[Year])-dnt) DIV 7;
                     If dna and 1 = 0 Then
                     BEGIN
                       inc (TermMask[x].KalTag);
                       If xx=0 Then Index[c]:=Index[c] or (x shl 3) Else
                       InsertWeekTerm (x, c);
                       xx:= 1;
                     END;
                   END;
                 END;
      END;
    END;
  END;
  MonthLen1[2]:= 28;
END;



PROCEDURE Wahltasten;
VAR
  x : Byte;
BEGIN
  If ee=1 Then
  BEGIN
    LastBut:=0; ActBut:= 1;
    InsertPos (18, 6);
    For x:= 9 To 15 Do InsertPos (18, x);
  END Else ButCount:= 8;
  Button(4,  21, #0, Down,   #25 , ' '+#25+' vorwrts ', 1);
  Button(18, 21, #0, Up  ,   #24 , ' '+#24+' rckwrts ', 1);
  Button(33, 21, #0, PgDn,   #25 , ' '+#25+' Jahr vor ', 1);
  Button(47, 21, #0, PgUp,   #24 , ' '+#24+' Jahr zurck ', 1);
  Button(64, 21, #27,  #0,  'Esc', '  Esc Ende   ', 1);
  ee:= 0;
END;



PROCEDURE Tag_ermitteln;
VAR
  x, y, z, v : Byte;
BEGIN
  If kn=0 Then BEGIN CDay:= 0; Exit; END;
  z:=0; y:=0; v:=0;
  REPEAT
    inc (y);
    If v=0 Then BEGIN x:=Date.DayOfWeek; If x=0 Then x:=7; END Else x:= 1;
    REPEAT
      inc (z); 
      If MouseIn (y*6+19, x+8, y*6+20, x+8) Then BEGIN Cday:=z; Exit; END;
      inc (x);
    UNTIL (x=8) or (z=LDay);
    inc (v);
  UNTIL (y=6) or (z=LDay); 
END;



PROCEDURE Monat_abbilden;
CONST
  Tage   : array[1..7 ] Of String[2] = ('Mo','Di','Mi','Do','Fr','Sa','So');
  Monate : array[1..12] Of String[9]=
  ('Januar','Februar','Mrz','April','Mai','Juni','Juli',
   'August','September','Oktober','November','Dezember');

VAR
  v, x, y, z : Byte;
  st         : String;

BEGIN
  With Date Do DayOfWeek:= WeekDay (1, Month, Year);

  GetMonatsTermine;

  With Date Do
  BEGIN
    WriteXY (17, 6, SpaceStr ('  '+Monate[month]+' '+LongStr(Year), 46), yellow, black);
    ClearWin (17, 7, 62, 16, 29); 

    LDay:= MonthLen[Month]; If (Month=2) and (LeapYear(Year)) Then LDay:=29;
    For x:= 1 To 7 Do WriteXY (19, 8+x, Tage[x], LightMagenta, 1);
    z:=0; y:=0; v:=0;

    REPEAT
      inc (y);
      If v=0 Then BEGIN x:=DayOfWeek; If x=0 Then x:=7; END Else x:= 1;
      REPEAT
        inc (z); 
        st:= LongStr (z);
        If TermMask[z].KalTag > 0 Then
        WriteXY (y*6+19+ord(z<10), x+8, st, 0, 7) Else
        WriteXY (y*6+19+ord(z<10), x+8, st,  15, 1);
        inc (x);
      UNTIL (x=8) or (z=LDay);
      inc (v);
    UNTIL (y=6) or (z=LDay); 
  END;
END;



PROCEDURE Kalender_zeigen;
VAR
  pp          : Array[1..4000] Of Byte;
  c           : Word;
  OldShowMask : Byte;
BEGIN
  GetScreen25 (pp);
  OldShowMask:= ShowMask;
  ClearWin (2, 20, 79, 24, 112);
  WriteXY (5, 23, 'Blttern Sie durch den Kalender und klicken Sie mit der Maus auf grau', 0, 7);
  WriteXY (5, 24, 'unterlegte Tage, um die Termine anzuzeigen.', 0, 7);
  Rahmen ( 2, 3, 79, 19, 7, 1);
  Rahmen (15, 5, 64, 17, 7, 0);
  ee:=1; Wahltasten;
  GetDosDate (Date); t1:=#0; t2:=#1;
  ReadNew:= FALSE;
  REPEAT
    If ((t1=#0) and (t2<>#0)) or (ReadNew) Then Monat_abbilden;
    ReadNew:= FALSE;
    CDay:=0;
    SetCursor;
    Standard_MT (3); If kn=1 Then MouseWait;
    MoveCursor;
    Wahltasten;

    With Date Do
    CASE t2 OF
      PgDn : If Year< LastYear Then inc (Year);
      Down : If Year<=LastYear Then
                BEGIN
                  If Month<12 Then inc (month) Else
                  If Year<LastYear Then BEGIN inc (year); Month:= 1; END;
                END;
      PgUp : If Year> FirstYear Then dec (Year);
      Up   : If Year>=FirstYear Then
             BEGIN
               If Month>1 Then dec (Month) Else
               If Year>FirstYear Then BEGIN dec (year); Month:=12; END;
             END;
      Else   Tag_ermitteln;
    END;

    If CDay<>0 Then With TermMask[CDay] Do If KalTag>0 Then
    BEGIN
      ShowMask:=Cday shl 3;
      For cc:= 1 To WPtr Do
      BEGIN
        OldMask[cc]:= Index[WeekTerms[cc]];
        Index[WeekTerms[cc]]:= Index[WeekTerms[cc]] and 3 or ShowMask;
      END;
      For cc:= 0 To LastIndex Do
      If Index[cc] and 248 <> showmask Then Index[cc]:=not Index[cc];
      inc (ShowMask);
      FPos:= FirstTerm;
      If KalTag=1 Then Einzelblattfenster (FPos) Else
      TermListe;
      For cc:= 1 To WPtr Do Index[WeekTerms[cc]]:=OldMask[cc];
      dec (ShowMask);
      For cc:= 0 To LastIndex Do
      If Index[cc] and 1 = 0 Then Index[cc]:=not Index[cc];
      ee:=1; Wahltasten;
    END;
  UNTIL (t1=#27);
  For c:=0 To LastIndex Do Index[c]:= Index[c] and 3;
  ShowMask:= OldShowMask;
  SetScreen25 (pp); t1:= #0; t2:= #0;
END;






END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
