UNIT dcKl_neu;

INTERFACE
USES
  bioscrt, dos, cbutton, monitor, monit, kal_edit, keycode,
  time, Strings, dckl_var, dckl_fil, Rechnen, mouse, dckl_clp;


PROCEDURE WriteStatus (VAR Termin : Term; NewStat      : Byte);
PROCEDURE DateToTerm  (    Date   : DosDateRec; Time   : DosTimeRec; VAR Termin : Term);
PROCEDURE TermToDate  (VAR Date   : DosDateRec; Termin : Term);
PROCEDURE TermToTime  (VAR Time   : DosTimeRec; Termin : Term);
FUNCTION  DayNum      (Tag, Monat, Jahr : Word) : Word;

PROCEDURE Auswahl;               
PROCEDURE Alarmton;
PROCEDURE StandardFusszeile;
PROCEDURE EditWin (VAR Termin : Term; Modus : Byte);
PROCEDURE Neuer_Termin;
PROCEDURE Termin_Editieren (VAR Termin : Term);
PROCEDURE DatumsCheck      (VAR Termin : Term);


IMPLEMENTATION



PROCEDURE WriteStatus (VAR Termin : Term; NewStat : Byte);
BEGIN
  With Termin Do Status:= Status and not 3 or NewStat;
  Seek (f, FPos);
  WriteTerm (Termin); ReadNew:= TRUE;
  If NewStat=sDelete Then NewFile:= TRUE;
END;



PROCEDURE Alarmton;
VAR
  x : Byte;
BEGIN                  
  For x:= 1 To 3 Do
  BEGIN sound (440); xdelay (70); sound (660); xdelay (70); END;
  nosound;
END;


PROCEDURE Auswahl;
BEGIN
  If ee=1 Then BEGIN LastBut:=0; ActBut:= 1; END Else ButCount:= 0;
  If gefunden<>0 Then
  Button (24, 21, 'G', #0, 'G',  '  G   Gefundene Termine ansehen! ', 2) Else
  ClearWin (24, 21, 60, 22, 112);
  Button (24,  7, 'N', #0, 'N',  '  N     Neuen Termin eingeben    ', 0);
  Button (24,  9, 'B', #0, 'B',  '  B     Blttern-Ansicht         ', 0);
  Button (24, 11, 'L', #0, 'L',  '  L     Listen-Ansicht           ', 0);
  Button (24, 13, 'K', #0, 'K',  '  K     Kalender-Ansicht         ', 0);
  Button (24, 15, 'V', #0, 'V',  '  V     Verwaltungsfunktionen    ', 0);
  Button (24, 17, #27, #0, 'Esc','  Esc   Beenden                  ', 0);
  ee:= 0;
END;


PROCEDURE StandardFusszeile;
BEGIN
  Fusszeile (' Drcken Sie eine Taste oder klicken Sie sie mit der Maus an');
END;


PROCEDURE DateToTerm (Date : DosDateRec; Time : DosTimeRec; VAR Termin : Term);
BEGIN
  With Date, Time, Termin Do
  BEGIN
    Jahr  := LongStr (Year);
    Monat := lz (month);
    Tag   := lz (day);
    Stunde:= lz (ho);
    Minute:= lz (mi);
  END;
END;


PROCEDURE TermToTime (VAR Time : DosTimeRec; Termin : Term);
VAR
  c : Integer;
BEGIN
  Result:= 0;
  With Time, Termin Do
  BEGIN
    Val (Stunde, ho,    c); inc (Result, c);
    Val (Minute, mi,    c); inc (Result, c);
  END;
END;


PROCEDURE TermToDate (VAR Date : DosDateRec; Termin : Term);
VAR
  c : Integer;
BEGIN
  Result:= 0;
  With Date, Termin Do
  BEGIN
    Val (Jahr,   Year,  c); inc (Result, c);
    Val (Monat,  Month, c); inc (Result, c);
    Val (Tag,    Day,   c); inc (Result, c);
  END;
END;


PROCEDURE TimeWindow (VAR Year : Word);
BEGIN
  If Year <  80 Then inc (Year, 2000) Else
  If Year <= 99 Then inc (Year, 1900);

 (* hier noch ein verschiebbares Zeitfenster erfinden *)
END;


FUNCTION DayNum (Tag, Monat, Jahr : Word) : Word;
BEGIN
  If LeapYear (Jahr) Then MonthLen[2]:= 29;
  For Monat:= 1 To Monat-1 Do inc (Tag, MonthLen[Monat]);
  MonthLen[2]:= 28;  { mu wieder zurckgesetzt werden ! }
  DayNum:= Tag;
END;


PROCEDURE DatumsCheck (VAR Termin : Term);
VAR
  j1, c : Word;
  Date  : DosDateRec;
  Time  : DosTimeRec;
BEGIN
  TermToDate (Date, Termin);
  TermToTime (Time, Termin);
  If Result<>0 Then Exit;
  With Date, Time Do
  BEGIN
    If Day  >31 Then Day  := 31;
    If Month>12 Then Month:= 12;

    If (Day>30) and ((Month=4) or (Month=6) or (Month=9) or (Month=11)) Then
    Day:=30;

    TimeWindow (Year);

    If Month = 2 Then
    BEGIN
      If LeapYear (Year) Then BEGIN If day>29 Then day:= 29 END Else
      If Day>28 Then day:= 28;
    END;
    If mi>=60 Then mi:=59;
    If ho>=24 Then ho:= 0;
  END;
  DateToTerm (Date, Time, Termin);
END;



PROCEDURE Editoren (VAR Termin : Term; Modus : Byte);
VAR
  x : Byte;
LABEL
  Nochmal;
BEGIN
  If ee=1 Then BEGIN LastBut:=0; ActBut:= 1; GotoXY (16, 10); END Else
  ButCount:= 0;
  With Termin Do
  BEGIN
    EditStr (16, 10, Tag,    2);
    EditStr (19, 10, Monat,  2);
    EditStr (22, 10, Jahr,   4);

    EditStr (16, 12, Stunde, 2);
    EditStr (19, 12, Minute, 2);

    If Modus<>SetSysTime Then
    BEGIN
      For x:= 1 To 3 Do
      EditStr (9, 14+x, Txt[x], 65);
      Nochmal:
      RepRadio:= FALSE;
      Radio (40, 10, 'J', #0, 'J', Periode[sJahr   shr 2], Status, sJahr);
      Radio (40, 11, 'M', #0, 'M', Periode[sMonat  shr 2], Status, sMonat);
      Radio (40, 12, 'Z', #0, 'Z', Periode[s2Woche shr 2], Status, s2Woche);
      Radio (40, 13, 'W', #0, 'W', Periode[sWoche  shr 2], Status, sWoche);
      If (ee=0) and (RepRadio) Then
      BEGIN t1:= #0; t2:= #0; kn:= 0; Goto Nochmal; END;
    END;
  END;
  Button (23, 21-Modus shl 2, #0,  F2, 'F2',  ' F2  Speichern ', 0);
  Button (41, 21-Modus shl 2, #27, #0, 'Esc', ' Esc Abbrechen ', 0);
  ee:= 0;
END;


PROCEDURE EditWin (VAR Termin : Term; Modus : Byte);
VAR
  tmp  : Term;
  pp   : Array[1..4000] Of Byte;
  y    : Byte;
  Date : DosDateRec;
  Time : DosTimeRec;
LABEL
  Nochmal;
BEGIN
  GetScreen25 (pp);
  tmp:= Termin;
Nochmal:
  Rahmen   (2,  3, 79, 23, 7, 1);
  Clearwin (3,  4, 78, 22, 112);
  Rahmen   (5,  6, 76, 19-Modus shl 2, 7, 0);
  Rahmen   (6,  8, 75, 18-Modus shl 2, 7, 1);
  WriteXY  (9, 10, 'Datum    .  .', 0, 7);
  WriteXY  (9, 12, 'Zeit     :', 0, 7);
  If Modus=EditTerm Then
  BEGIN
    WriteXY  (6,   7, SpaceStr ('   Termin eingeben', 70), 14, 0);
    WriteXY  (9,  14, 'Termintext', 0, 7);
  END Else
  WriteXY  (6,  7, SpaceStr ('   Systemzeit eingeben', 70), 14, 0);
  Window (1, 1, 80, 25);
  ee := 1; Editoren (Termin, Modus);
  With Buttons[ActBut] Do GotoXY (x+z-1, y);
  REPEAT
    If ActBut>8-Modus*3 Then SetCursor;
    CASE ActBut Of
      1..5 : Fusszeile ('Zahl eingeben oder heutiges Datum/jetzige Uhrzeit mit Enter besttigen');
      6..8 : Fusszeile ('Geben Sie den Termintext ein');
      9..12: Fusszeile ('Whlen Sie die Wiedervorlage-Periode');
      Else   StandardFusszeile;
    END;
    With Termin Do
    If (Modus = EditTerm) and (ActBut<=4) and ((Length(Jahr)=2) or (Length (Jahr)=4)) Then
    BEGIN
      TermToDate (Date, Termin);
      If Result=0 Then With Date Do
      BEGIN
        TimeWindow (Year);
        WriteXY (64, 7, WDays[WeekDay(Day, Month, Year)]+'  ', 15, 0);
      END;
    END;
    Standard_MT (2);
    MoveCursor;
    Editoren (Termin, Modus);
    CASE t2 Of
      F4 : BEGIN ClipBrd:= Termin; ClipErr:= FALSE; END;
      CF4: BEGIN Termin := ClipBrd; ee := 1; Editoren (Termin, Modus); END;
    END;
  UNTIL (t1=#27) or (t2=F2);
  If t1=#27 Then Termin:= Tmp Else
  BEGIN
    DatumsCheck (Termin);
    If Result<>0 Then
    BEGIN ErrorMsg ('Datums- oder Zeit-Format ungltig'); Goto Nochmal; END;
    ReadNew:= TRUE;
  END;
  SetScreen25 (pp);
END;


PROCEDURE Neuer_Termin;
VAR
  Termin : Term;
  OldPos : Word;
BEGIN
  FillChar (Termin, SizeOf (Termin), 0);
  EditWin (Termin, EditTerm);
  If t1<>#27 Then
  BEGIN
    OldPos:= FilePos (f); Seek (f, FileSize (f));
    WriteTerm (Termin);
    RefreshLastIndex;
    Seek (f, OldPos);
  END;
  t1:= #0; t2:= #0;
END;


PROCEDURE Termin_Editieren (VAR Termin : Term);
BEGIN
  EditWin (Termin, EditTerm);
  If t1<>#27 Then
  BEGIN
    Seek (f, FPos);
    WriteTerm (Termin);
  END;
  t1:= #0; t2:= #0;
END;

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
