UNIT dcKl_sho;


INTERFACE
USES
  bioscrt, cbutton, dcKl_neu, Dos, monitor, monit, keycode,
  strings, Time, dckl_var, dckl_fil, mouse, dckl_clp;


PROCEDURE Einzelblattfenster (TPos : Word);
PROCEDURE TermListe;
PROCEDURE Datei_aktualisieren;



IMPLEMENTATION


PROCEDURE EinzelButtons;
BEGIN
  If ee=1 Then
  BEGIN
    LastBut:=0; ActBut:= 1;
    InsertPos (7,  8);
    InsertPos (7, 10);
    InsertPos (7, 11);
    InsertPos (7, 12);
    InsertPos (7, 14);
  END Else ButCount:= 5;
  Button(5,  21, #0,Down, #25 ,   '  '#25'  Vor    ', 1);
  Button(25, 21, #0, Up , #24 ,   '  '#24' Zurck  ', 1);
  Button(45, 21, 'K', #0, 'K',    ' Korrektur  ', 1);
  Button(65, 21, #27, #0, 'Esc',  '  Esc Ende  ', 1);
  Button(5,  23, 'L', #0, 'L' ,   '  Lschen   ', 1);
  Button(25, 23, 'A', #0, 'A' ,   ' Aktivieren ', 1);
  Button(45, 23, 'S', #0, 'S',    ' Stillegen  ', 1);
  Button(65, 23, #0, Pos1,'Pos1', ' Pos1 ', 1);
  Button(71, 23, #0, Endx,'End'   , #179' End ', 1);
  ee:= 0;
END;



PROCEDURE EinzelWin;
VAR
  x    : Byte;
  Date : DosDateRec;
  s    : String;
BEGIN
  With Termin Do
  BEGIN
    If Status and 12=sJahr Then s:= '  Termin am:  ' Else
    s:= '  '+Periode[(Status and 12) shr 2]+' ab:  ';

    WriteXY ( 6,  8, s, lightgreen, 0);
    WriteXY (6+Length(s),  8, spaceStr (Tag+'.'+Monat+'.'+Jahr, 39-Length(s)), 15, 0);

    WriteXY (45,  8, 'um:  ', lightgreen, 0);
    WriteXY (50,  8, SpaceStr(Stunde+':'+Minute+' Uhr', 14), 15, 0);
    For x:= 1 To 3 Do WriteXY (8, 9+x, SpaceStr (copy (Txt[x], 1, 65), 66), 0, green);
    WriteXY ( 6, 14, SpaceStr ('  Status: '+Stat[Status and 3], 70), CCol[Status and 3], 0);
  END;
  If Termin.Status and 12<>sMonat Then
  BEGIN
    TermToDate (Date, Termin);
    If Result<>0 Then
    WriteXY (64, 8, '        ??  ', 15, 0) Else
    With Date Do
    WriteXY (64, 8, WDays[WeekDay(Day, Month, Year)]+'  ', 15, 0);
  END Else
  WriteXY (64, 8, '            ', 15, 0);
END;


PROCEDURE Einzelblattfenster (TPos : Word);
VAR
  pp : Array[1..4000] Of Byte;
BEGIN
  If (FileSize(f)=0) Then Exit;
  GetScreen25 (pp);
  ClearWin (2, 20, 79, 24, 112); 
  Rahmen (2, 3, 79, 19, 7, 1);
  Rahmen (5, 7, 76, 15, 7, 0);
  Rahmen (6, 9, 75, 13, 7, 1);
  ee:=1; EinzelButtons;
  FPos:= TPos;
  REPEAT
    Seek (f, FPos);
    ReadTerm (Termin);
    EinzelWin;

    SetCursor;
    Standard_MT (1);
    MoveCursor;
    EinzelButtons;

    If t1=#0 Then
    CASE t2 OF
      F4         : BEGIN ClipBrd:= Termin; ClipErr:= FALSE; END;
      Pos1       : FPos:= FirstTerm;
      EndX       : FPos:= LastTerm;
      Down, PgDn : FPos:= NextTerm;
      Up,   PgUp : FPos:= PrevTerm;
    END Else
    CASE t1 OF
      'A' : WriteStatus (Termin, sAktiv);
      'S' : WriteStatus (Termin, sStill);
      'L' : WriteStatus (Termin, sDelete);
      'K' : BEGIN Termin_Editieren (Termin); ee:= 1; EinzelButtons; END;
    END;
  UNTIL t1=#27;
  SetScreen25 (pp); t1:= #0; t2:= #0;
END;

{ ----------------------------- Listenfenster --------------------------- }

PROCEDURE ListButtons;
VAR
  x : byte;
BEGIN
  If ee=1 Then
  BEGIN
    LastBut:=0; ActBut:= 1;
    InsertPos (5, 4);
    For x:= 19 To 21 Do InsertPos (4, x);
  END Else ButCount:= 4;
  Button(4,  23, 'L', #0, 'L',   '  Lschen   ', 1);
  Button(19, 23, 'A', #0, 'A',   ' Aktivieren ', 1);
  Button(34, 23, 'S', #0, 'S',   ' Stillegen  ', 1);
  Button(49, 23, 'K', #0, 'K',   ' Korrektur  ', 1);
  Button(64, 23, #27, #0, 'Esc', '  Esc Ende  ', 1);
  ee:= 0;
END;


PROCEDURE TermListe;
CONST
  ListLen = 13;
VAR
  pp        : Array[1..4000] Of Byte;
  y         : Byte;
  FirstLine : Word;
  OldFLine  : Word;
  FirstPos  : Word;
  Balken    : Word;
  TCount    : Word;
  Terms     : Array[1..Listlen] Of Term;
  OldFPos   : Word;
  PosList   : Array[1..ListLen] Of Word;


PROCEDURE ReadTerms;
VAR
  y : Byte;
  p : Word;
BEGIN
  If FirstLine=OldFLine Then Exit; p:= 65535;
  FPos:= TermPos (FirstLine);
  For y:= 1 To ListLen Do
  BEGIN
    If p<>FPos Then        { Eof ? }
    BEGIN
      Seek (f, FPos);
      ReadTerm (Terms[y]);
      PosList[y]:= FPos;
      p:= FPos;
      FPos:= NextTerm;
    END Else
    FillChar (Terms[y], SizeOf (Term), 0);
  END;
END;


PROCEDURE IncLine (Zahl : Word);
BEGIN
  ActBut:= 1;
  While (Zahl>0) and (FirstLine+Balken<TCount) Do
  BEGIN
    dec (Zahl);
    If Balken<ListLen-1 Then inc (Balken) Else inc (FirstLine);
  END;
END;


PROCEDURE DecLine (Zahl : Word);
BEGIN
  ActBut:= 1;
  While (Zahl>0) and (FirstLine+Balken>1) Do
  BEGIN
    dec (Zahl);
    If Balken>0 Then dec (Balken) Else dec (FirstLine);
  END;
END;


PROCEDURE WriteTer;
VAR
  tmp  : String;
  x    : byte;
  c    : Char;
  Date : DosDateRec;
BEGIN
  With Terms[y] Do
  BEGIN
    tmp:='';
    If y+FirstLine-1<=TCount Then
    BEGIN
      If Status and 12 = sMonat Then tmp:= '   ' Else
      BEGIN
        TermToDate (Date, Terms[y]);
        If Result<>0 Then tmp:= ' ??' Else
        With Date Do
        tmp:= ' '+WeekDays[WeekDay(Day, Month, Year)];
      END;
      If Status and 12 = sJahr Then tmp:= tmp+'   ' Else
      tmp:= tmp+'  '+Periode[(Status and 12) shr 2][1];
      tmp:= copy (tmp+'  '+Tag+'.'+Monat+'.'+Jahr+'   '+Stunde+':'+Minute + '   ' +
            copy (Txt[1], 1, 43), 1, 72);
    END;
    If Status and 3 = sAktiv Then c:= ' ' Else c:= 'x';
    If pred(y)=Balken Then
    BEGIN
      CharXY  (4, y+3, c, Ccol[Status and 3], 0);
      WriteXY (5, y+3, spaceStr (tmp, 72), 15, 0);
      For x:= 1 To 3 Do
      WriteXY (4, ListLen+5+x,  spaceStr (' '+copy (Txt[x],1,65), 74), 0, green);
    END Else
    BEGIN
      CharXY  (4, y+3, c, Ccol[Status and 3]-8, green);
      WriteXY (5, y+3, spaceStr (tmp, 72), 0, green);
    END;
  END;
END;


BEGIN
  If FileSize (f)=0 Then Exit;
  GetScreen25 (pp);
  ClearWin (2, ListLen+10, 79, 24, 112);
  Rahmen (2, ListLen+5, 79, ListLen+9, 7, 1);
  Rahmen (2, 3, 79, ListLen+4, 7, 1);
  TCount:= TermCount;
  CharXY (77, 4,         #24, yellow, 0);
  CharXY (77, 3+ListLen, #25, yellow, 0);
  For y:= 5 To 2+ListLen Do CharXY (77, y, #176, green, 0);
  ee:= 1; ListButtons; ee:= 0;
  FirstLine:= 1; OldFLine:= 65535; Balken:= 0;
  REPEAT
    ReadTerms;
    For y:= 1 To ListLen Do WriteTer;
    OldFLine:= FirstLine;
    Buttons[1].y:=Balken+4;
    SetCursor;
    Standard_MT (3);
    If kn<>0 Then
    BEGIN
      If MouseIn (77, 4, 78, 4) Then t2:= Up Else
      If MouseIn (77, 3+ListLen, 78, 3+ListLen) Then t2:= Down Else
      If MouseIn (4, 4, 76, ListLen+3) Then
      BEGIN
        If ym<Balken+4 Then Balken:= ym-4 Else
        If ym>Balken+4 Then IncLine (ym-(Balken+4));
      END;
      If (t2=Down) or (t2=Up) Then BEGIN If kn=1 Then xDelay (70); END Else
      MouseWait;
    END;
    MoveCursor;
    ListButtons;
    If t1=#0 Then
    CASE t2 Of
      F4   : BEGIN ClipBrd:= Terms[Balken+1]; ClipErr:= FALSE; END;
      Pos1 : DecLine (FirstLine+Balken);
      Endx : IncLine (TCount);
      Down : IncLine (1);
      PgDn : IncLine (ListLen-1);
      Up   : DecLine (1);
      PgUp : DecLine (ListLen-1);
    END Else
    BEGIN
      OldFPos:= FPos;
      FPos := PosList[Balken+1];
      With Termin Do
      CASE t1 OF
        'A' : WriteStatus (Terms[Balken+1], sAktiv);
        'S' : WriteStatus (Terms[Balken+1], sStill);
        'L' : WriteStatus (Terms[Balken+1], sDelete);
        'K' : BEGIN Termin_Editieren (Terms[Balken+1]); ee:= 1; ListButtons; END;
      END;
      FPos:= OldFPos;
    END;
  UNTIL t1=#27;
  SetScreen25 (pp); t1:= #0; t2:= #0;
END;


{---------------------- Gelschte Termine entfernen ----------------------}

PROCEDURE Datei_aktualisieren;
VAR
  BakDatei : PathStr;
  f1       : File Of Term;
BEGIN
  WriteXY (21,21, '  Moment! Termine werden aktualisiert!  ', yellow, red);
  BakDatei:= ChangeFileExt (TermDatei, 'BAK');

  Assign (f1, BakDatei); FileMode:= 0;
  Reset (f1); Close (f1);
  If IOResult=0 Then
  BEGIN
    SetFAttr (f1, 32); Erase (f1);
    If IOResult<>0 Then ErrorEnd ('Lschen von Terminen fehlgeschlagen');
  END;

  Assign (f1, TermDatei);
  Rename (f1, BakDatei);
  If IOResult<>0 Then ErrorEnd ('Lschen von Terminen fehlgeschlagen');

  Assign (f1, BakDatei); FileMode:= 0; SetFAttr (f1, 0); Reset (f1);

  OpenDataFile;
  If Result<>0 Then
  BEGIN
    Rename (f1, TermDatei); If IOResult<>0 Then;
    ErrorEnd ('Lschen von Terminen fehlgeschlagen');
  END;

  Result:= 0;
  While (Not Eof (f1)) and (Result=0) Do
  BEGIN
    Read (f1, Termin);
    If Termin.Status and 3<>2 Then Write (f, Termin);
    Result:= IOResult;
  END;
  If Result<>0 Then
  ErrorMsg ('Lschen von Terminen fehlgeschlagen');
  Close (f1); If IOResult<>0 Then; Close (f); If IOResult<>0 Then;
END;


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
