UNIT dckl_sys;

INTERFACE

USES
  Bioscrt, monitor, monit, dckl_var, cbutton, dckl_neu, dckl_sho,
  dckl_fil, strings, dos, keycode, time;

PROCEDURE Verwaltungsmenue;


IMPLEMENTATION


PROCEDURE VerwaltungsButtons;
BEGIN
  If ee=1 Then BEGIN LastBut:=0; ActBut:= 1; END Else ButCount:= 0;
  Button (24,  7, 'S', #0, 'S',  '  S     Sortiere Termine         ', 0);
  Button (24,  9, 'D', #0, 'D',  '  D     Drucke alle Termine      ', 0);
  Button (24, 11, 'E', #0, 'E',  '  E     Exportieren als Text     ', 0);
  Button (24, 13, 'I', #0, 'I',  '  I     Importiere Text-Datei    ', 0);
  Button (24, 15, 'C', #0, 'C',  '  C     Computer-Uhr stellen     ', 0);
  Button (24, 17, #27, #0, 'Esc','  Esc   Zurck                   ', 0);
  ee:= 0;
END;


PROCEDURE Importiere;
VAR
  f1  : Text;
  x,y : Byte;
  s   : String;
  tc  : Char;
  c   : Integer;
  Num : Word;
  Fs  : Word;
  Err : Word;

LABEL
  Ende, Endx, Wrt;


FUNCTION GetField (MaxLen : Byte) : String;
BEGIN
  x:= pos (tc, s);
  If x=0 Then x:= Length(s)+1;
  GetField:= copy (Trim(copy (s, 1, x-1)), 1, MaxLen);
  delete (s, 1, x);
END;


BEGIN
  Num:= 0; Err:= 0;
  Fusszeile ('Importiere Datensatz: ');
  Assign (f1, ChangeFileExt (Termdatei, 'TXT')); FileMode:= 0;
  Reset (f1);
  If IOResult<>0 Then
  BEGIN ErrorMsg (ChangeFileExt (Termdatei, 'TXT')+' nicht gefunden'); Exit; END;
  fs:= FileSize (f);
  Seek (f, fs);
  While not Eof (f1) Do
  BEGIN
    ReadLn (f1, s);
    If IOResult<>0 then
    BEGIN ErrorMsg ('Fehler beim Lesen aus Quelldatei'); Goto Ende; END;
    s:= Trim (s);
    If s='' Then Goto Endx;
    FillChar (Termin, SizeOf(Termin), #0);
    With Termin Do
    BEGIN
      x:= pos (tab, s);
      If x=0 Then BEGIN tc:=';'; x:= pos (';', s); END Else tc:= Tab;
      If x=0 Then BEGIN inc (Err); Goto Endx; END;
      Tag   := GetField (2); If s='' Then BEGIN inc (Err); Goto Endx; END;
      Monat := GetField (2); If s='' Then BEGIN inc (Err); Goto Endx; END;
      Stunde:= GetField (2); If s='' Then BEGIN inc (Err); Goto Endx; END;
      Minute:= GetField (2); If s='' Then BEGIN inc (Err); Goto Endx; END;
      Jahr  := GetField (4); If s='' Then Goto Wrt;
      For y:= 1 To 3 Do
      BEGIN Txt[y]:= GetField (SizeOf(Txt[1])-1); If s='' Then Goto Wrt; END;
      s:= GetField (1);
      Val (s, y, c);
      If c=0 Then Status:= y;
    END;

    Wrt:
    DatumsCheck (Termin);
    If Result<>0 Then BEGIN inc (Num); Goto Endx; END;

    WriteTerm (Termin);
    inc (Num);
    If Num+Fs>=MaxTerms Then
    BEGIN ErrorMsg ('Es knnen nicht alle Termine importiert werden'); Goto Ende; END;
    NumXY (25, 24, 5, Num, 14, 0);
    Endx:
  END;
Ende:
  If Err<>0 Then
  ErrorMsg ('Einige Datenstze waren fehlerhaft und wurden nicht importiert');
  RefreshLastIndex;
  Close (f1); If IOResult<>0 then;
END;


PROCEDURE Exportiere;
VAR
  f1 : Text;
  x  : Byte;
  Num: Word;
LABEL
  Ende;
BEGIN
  Fusszeile ('Exportiere Datensatz: '); Num:= 0;
  Assign (f1, ChangeFileExt (Termdatei, 'TXT'));
  Rewrite (f1);
  If IOResult<>0 Then
  BEGIN
    SetfAttr (f1, 32); Rewrite (f1);
    If IOResult<>0 Then
    BEGIN ErrorMsg ('Zieldatei konnte nicht angelegt werden'); Exit; END;
  END;
  Seek (f, 0);
  While not Eof (f) Do
  BEGIN
    ReadTerm (Termin);
    With Termin Do
    BEGIN
      Write (f1, Tag, tab, Monat, tab, Stunde, tab, Minute, tab, Jahr);
      For x:= 1 To 3 Do Write (f1, tab, Txt[x]);
      WriteLn (f1, tab, Status);
    END;
    If IOResult<>0 then
    BEGIN ErrorMsg ('Fehler beim Schreiben in Zieldatei');  Goto Ende; END;
    inc (Num);
    NumXY (25, 24, 5, Num, 14, 0);
  END;
Ende:
  Close (f1); If IOResult<>0 then;
END;


PROCEDURE PrintTerms;
VAR
  f1   : Text;
  x    : Byte;
  Num  : Word;
  Line : Word;
LABEL
  Ende;
BEGIN
  Fusszeile ('Drucke Datensatz: '); Num:= 0;
  Assign (f1, Printer);
  Rewrite (f1);
  If IOResult<>0 Then
  BEGIN ErrorMsg ('Drucker konnte nicht angesprochen werden'); Exit; END;

  Seek (f, 0); Line:= 0;
  While not Eof (f) Do
  BEGIN
    ReadTerm (Termin);
    With Termin Do
    BEGIN
      WriteLn (f1, Tag, '.', Monat, '.', Jahr, '    ', Stunde, ':', Minute);
      For x:= 1 To 3 Do If Txt[x]<>'' Then
      BEGIN WriteLn (f1, Txt[x]); inc (Line); END;
      inc (Line, 2);
      If Line>=58 Then
      BEGIN Line:= 0; WriteLn (f1, ''); END Else
      WriteLn (f1, '-----------------------------------------------------------------');
    END;
    If IOResult<>0 then
    BEGIN ErrorMsg ('Fehler beim Drucken');  Goto Ende; END;
    inc (Num);
    NumXY (21, 24, 5, Num, 14, 0);
  END;
Ende:
  If Line<>0 Then WriteLn (f1, ''); If IOResult<>0 Then;
  Close (f1); If IOResult<>0 then;
END;


PROCEDURE Setze_Zeit;
VAR
  Termin : Term;
  Date   : DosDateRec;
  Time   : DosTimeRec;
BEGIN
  FillChar (Termin, SizeOf (Termin), 0);
  EditWin (Termin, SetSysTime);
  If t1<>#27 Then
  BEGIN
    TermToDate (Date, Termin);
    TermToTime (Time, Termin);
    If Result=0 Then
    BEGIN
      SetDosDate (Date);
      SetDosTime (Time);
    END;
  END;
  t1:= #0; t2:= #0;  
END;

VAR
  i, j         : Longint;
  X, Y, RRec   : Term;
  DateX, DateZ : String;
  Overflow     : Boolean;
  SCounter     : Byte;


FUNCTION GetString (FPos : LongInt) : String;
BEGIN
  Seek (f, FPos);
  ReadTerm (RRec);
  With RRec Do GetString:= Jahr+monat+tag+stunde+minute;
END;



PROCEDURE QuickSort (L, R : LongInt);
BEGIN
  If not Overflow Then Overflow:= SPtr < 12000 Else Exit;
  i:= L; j:= R;
  DateX:= GetString ((L+R) shr 1);

  REPEAT
    DateZ:= GetString (i);
    WHILE
      DateZ < DateX Do BEGIN inc (i); DateZ:= GetString (i);
      If SCounter<79 Then inc (SCounter) Else SCounter:= 34;
      WriteXY (Scounter, 24, '', 14, 0);
    END;
    DateZ:= GetString (j);
    WHILE
      DateX < DateZ Do BEGIN dec (j); DateZ:= GetString (j);
      If SCounter<77 Then inc (SCounter) Else SCounter:= 34;
      WriteXY (Scounter, 24, '', 14, 0);
    END;

    If i <= j then
    BEGIN
      Seek (f, i); ReadTerm  (Y);
      Seek (f, j); ReadTerm  (X);
      Seek (f, i); WriteTerm (X);
      Seek (f, j); WriteTerm (Y);
      inc (i); dec (j);
    END;
  UNTIL i > j;
  If L < j Then QuickSort (L, j);
  If i < R Then QuickSort (i, R);
END;



PROCEDURE Sortiere;
BEGIN
  SCounter:= 34;
  WriteXY (2, 24, spacestr ('  Datei wird sortiert...       '#254, 78), 14, 0);
  Seek (f, 0);
  REPEAT
    Overflow:= FALSE;
    If FileSize (f) > 1 Then QuickSort (0, FileSize(f)-1);
  UNTIL not Overflow;
END;



PROCEDURE VerwaltungsMenue;
VAR
  pp : Array[1..4000] Of Byte;
BEGIN
  ee:= 1; Verwaltungsbuttons;
  REPEAT
    SetCursor;
    Standard_MT (1);
    MoveCursor;
    Verwaltungsbuttons;
    GetScreen25 (pp);
    CASE t1 Of
      'C' : BEGIN Setze_Zeit; ee:= 1; Verwaltungsbuttons; END;
      'S' : Sortiere;
      'E' : Exportiere;
      'I' : Importiere;
      'D' : PrintTerms;
    END;
    SetScreen25 (pp);
  UNTIL t1=#27;
  t1:= #0;
END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
