UNIT Dckl_var;

INTERFACE
USES
  BiosCrt, Dos, strings;

TYPE
  MonthArr   = Array[1..12] Of Byte;

CONST
  FirstYear  = 1600;
  LastYear   = 9999;
  Printer    : PathStr = 'LPT1';
  Result     : Word = 0;
  ProgName   = 'KALENDER 3.0';
  MaxTerms   = 50000;
  HeadLine   = #13#10+Progname+'  '+OldCopyright+#13#10;
  TermFile   = 'KALENDER.TER';
  EditTerm   = 0;
  SetSysTime = 1;
  KeyWord    : PathStr = '';

  Stat : array[0..2] of String[30] =
  ('Alarm ist aktiv', 'Alarm ist ausgeschaltet', 'Termin zum Lschen freigegeben');

  CCol : array[0..2] of Byte = (lightgreen, lightblue, lightred);

  MonthLen   : MonthArr = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

  sAktiv     = 0;  { Die Bits 0 und 1 des StatusBytes }
  sStill     = 1;
  sDelete    = 2;
  sFree      = 3;  { Fr sptere Zwecke }

  sJahr      = 0;  { Bits 2 und 3, Jahr=0 wegen Kompatibilitt zum Kal 2.0}
  sMonat     = 4; { Testen mit Status and 12 = sJahr usw. }
  s2Woche    = 8;
  sWoche     = 12;
                   { noch 4 Bits frei }

  Seek_Only  : Boolean = FALSE;
  Seek_Alarm : Boolean = TRUE;
  WeekDays   : array[0..6] Of String[2] = ('So', 'Mo','Di','Mi','Do','Fr','Sa');

  Periode    : Array[0..3] Of String[15] =
 ('Jhrlich', 'Monatlich', 'Zweiwchentlich', 'Wchentlich');

  ReadNew    : Boolean = FALSE;

TYPE
  Term       = RECORD
                 Tag, Monat, Stunde, Minute : String[2];
                 Jahr                       : String[4];
                 Txt                        : Array[1..3] of String[65];
                 Status                     : Byte;
               END;

VAR
  Par        : String;
  gefunden   : Word;
  FPos       : Word;
  Termin     : Term;
  ClipBrd    : Term;
  f          : File Of Term;
  NewFile    : Boolean;
  ComDir     : PathStr;
  Index      : Array[0..MaxTerms] Of Byte;
  LastIndex  : Word;
  IPos       : Word;
  TermDatei  : PathStr;
  UserDatei  : PathStr;

IMPLEMENTATION
BEGIN
  ComDir:=ParamStr(0);
  While (Length(ComDir)>0) and (ComDir[Length(ComDir)]<>'\') do dec (ComDir[0]);
  Termdatei:= Vollpfad (comdir, TermFile);
  FillChar (ClipBrd, SizeOf(ClipBrd), 0);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
