
; besondere Keyb f. Wolf Scheuermann, verwandelt , von NUM-Tasta in .

jmp BEGIN 

DB                      1     ; VersionsNummer des Treibers 
DB                      1     ; Treiber-Nummer zur berprfung d. UnKeyb
DB                      1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB                      09h   ; Nummer eines der umgeleiteten Interrupts 
DB                      0     ; Zahl der erwarteten Start-Parameter
 
Flag                DB  0

Kleinbuchstaben DB  12, "","z",   ",","y",   26 ,"",  "'",""
>                       "(","",   ")","^",   12 ,"",  13, "'" 
>                       27 ,"+",   "+","#",   "V","<",  "5","-"   

Grossbuchstaben DB  21, "","Z",   ",","Y",   26, "",  "'",""
>                       "(","",   ")","",   12 ,"?",  13 ,"`"
>                       27 ,"*",   "+","'",   "V",">",  "5","_" 
>                        3 ,'"',    4 ,"",    7 ,"&",   8 , 47 
>                       11 ,"=",   "3",";",   "4",":",   9 ,"("  
>                       10 ,")"                                     
 
ALTGRZeichen    DB  12, 27 ,"~",   "~","{",   32h,"",  10h,"@"      
>                       79h,"",   7Ah,"",   7Fh,"[",  80h,"]"                
>                       81h,"}",   82h,"\",   "+","|",  18
EuroChar        DB 213  ; gehrt noch in Tabelle ALTGRZeichen !

STRGZeichen     DB   2, 15h, 1Ah, 2Ch, 19h                           

                        ; erstes Byte ist Lngenbyte !
 
NachHinten      DB  "aeiou `" 
Hutdrauf        DB  "aeiou ^"  
NachVorn        DB  "aeiouE ","'"  
MurmelDrauf     DB  "aA "              


Keyboard:                               ; die neue INT-Prozedur
  push dx, ds, bx, ax, cx, es, si, di, cs / pop es
  cld

  mov  ax, 0040h
  mov  ds, ax                   ; Segment der BIOS-Variablen-Tabelle in DS
  mov  dx, [001Ch]              ; Zeiger des Tastaturpuffers laden

  pushf                                     
  DB 9Ah                        ; Call Far Ptr = alte Tastaturroutine
  OBJECT Old09:
    Ofs DW '6.'                 ; hier setzt der Loader die alte Adresse
    Seg DW '24'                 ; der alten Tastatur-Routine ein.
  OBJECT END

  es:
  cmp  Byte Flag, 2             ; Flag wird vom Unloader auf 2 gesetzt, 
  jne  @okay                    ; 2 = Nur alte Routine ausfhren
  jmp  @GanzRaus
  @okay:

  mov  di, [001Ch]              ; Zeiger auf Zeichen in Tastatur-Puffer

  mov  ah, [0096h]              ; MFII-Tastatur-Status-Byte  

  in   al, 60h 

  cmp  al, 86                   ; | gedrckt ??
  jne  @w1
  test ah, 00001000b            ; ALT+GR gedrckt ? 
  jz   @w1                      
  mov  Word [di], '|V'          ; Zeichen | in Tastatur-Puffer schreiben 
  inc  di / inc di              ; neuen Zeiger errechnen
  cmp  di, [0082h] / jb @w0
  mov  di, [0080h]
  @w0:
  mov [001Ch], di               ; Schreibe neuen Zeiger in Tastaturpuffer
  jmp  short @wech              ; und dann raus 
 
  @w1: 
  mov  al, [0017h]              ; Tastatur-Status-Byte 

  test al, 00000011b            ; Shift links oder rechts ?
  jz   @NoShift
  and  byte [0017h], 10111111b  ; Caps-Lock lschen
  @NoShift:

  cmp  dx, di                   ; Vergleiche mit Stand des Zeigers vor dem
  je   @wech                    ; Aufruf der alten Tastaturroutine 
                                ; Wenn keine nderung, dann raus
  cmp  di, [0080h]              ; errechne Position des gerade eingegebenen 
  ja   @Rxx                     ; Zeichens im Tastaturpuffer 
  mov  di, [0082h]
  @Rxx: 
  dec  di / dec di

  mov  bx, [di]                 ; Zeichen aus Tastaturpuffer holen

  cmp  bx, 2C00h
  jne  @S
  mov  Word [di], 1500h
  jmp  short @rausende1
  @S:
  cmp  bx, 1500h
  jne  @T
  mov  Word [di], 2C00h
  @wech:
  jmp  short @rausende1
  @T:
  cmp  bx, 532Eh
  jne  @U
  mov  Word [di], 532Ch
  jmp  short @rausende1
  @U:
  cmp  bx, 5600h
  je   @rausende1               ; Shift+F3 ?

  test ah, 00001000b            ; ALT+GR gedrckt ? 
  jnz  @ALTGR                   
 
  test al, 01000011b            ; Shift oder Caps-Lock (Umschalt fix) ?  
  jnz  @SHIFT                   
 
  test ax, 0000010000000100b    ; STRG gedrckt ? 
  jz   @KLEIN                     

  lea  si, STRGZeichen

jmp short @Suche_Zeichen

;------------------------- Hkchen usw. auswerten -------------------------

@NewChar:
  mov dx, si
  mov cx, 6
      cmp ax, 295Eh/jne @1/ lea si, Hutdrauf               / jmp short @suche
  @1:/cmp ax, 0D60h/jne @2/ lea si, Nachhinten             / jmp short @suche 
  @2:/cmp ax, 29F8h/jne @3/ lea si, Murmeldrauf/ mov cx, 3 / jmp short @suche 
  @3:/cmp ax, 0D27h/jne @4/ lea si, Nachvorn   / inc cx

@suche:                         ; Suche Zeichen in Tabelle  
  es:
  lodsW
  cmp al, bl
  loopne @Suche
  je @5

  mov  [001Ah], dx
@rausende1:
  jmp  short @rausende  
 
@5: 
  mov   bl,  ah                 ; neues Zeichen nach bl
  xor   bh,  bh 
  mov  [di], bx                 ; kompletter Zeichencode in Tastaturpuffer
  jmp  short @rausende  

;---------------------------- Suche Umlaute usw. --------------------------

@KLEIN: / lea si, Kleinbuchstaben / jmp short @Suche_Zeichen        
@SHIFT: / lea si, Grossbuchstaben / jmp short @Suche_Zeichen
@ALTGR: / lea si, ALTGRZeichen   

 
@Suche_Zeichen: 
  mov cl, es:[si] / inc si / xor ch, ch  ; LngenByte laden 
@NochMal:
  es:
  lodsW
  cmp al, bh
loopne @Nochmal

  jne @raus

  mov   bl , ah
  mov  [di], bx                 ; kompletter Zeichencode in Tastaturpuffer

  cmp   bh, 29h / je @Htchen   ; ^ usw.
  cmp   bh, 0Dh / je @Htchen   ; ' usw.
 
@Raus:
  mov   si, di
                                
  cmp   si, [0080h]             ; errechne Position des zuvor eingegebenen 
  ja    @Rx                     ; Zeichens im Tastaturpuffer 
  mov   si, [0082h]
  @Rx: 
  dec   si / dec si
  mov   ax, [si]
  jmp   short @NewChar

@Htchen: 
  mov  ax, [001Ch] / mov [001Ah], ax

@4:
@rausende:
  push cs / pop ds
  cmp  Byte Flag, 1        ; Flag wird vom Unloader auf 1 gesetzt, 
  jne  @GanzRaus           ; wenn KEYB.COM aus dem Speicher entfernt
                           ; werden soll. Sonst Flag = 0
  lds  dx, Old09           ; Alte Adressen laden 
  mov  ax, 2509h           ; SetIntVec 09h
  int  21h                 ; Alte Tastaturroutine wieder einsetzen
 
  push cs / pop es
  mov  ah, 49h             ; Speicher von KEYB.COM wieder freigeben
  int  21h                 ; ES=CS=Segment des freizugebenden Blocks 

@GanzRaus: 
  pop  di, si, es, cx, ax, bx, ds, dx
IRET                                     



;------------------------------- Loader ------------------------------------

BEGIN: 
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &Progname
  #output

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
  
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xe / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xe: / cmp al, 'E' / je  @SetEuro 
                                              lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3509h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  int  09h              ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT

@SetEuro:              ; Euro-Zeichen bestimmen
  mov  si, di
  inc  si
  lodsb / sub al, 48 / xor ah, ah / mov bh, 100 / mul bh / mov cl, al
  lodsb / sub al, 48 / xor ah, ah / mov bh, 10  / mul bh / add cl, al
  lodsb / sub al, 48 /                                     add cl, al
  mov  EuroChar, cl
 
@Laden:
  -EnvironMemFree

  lea  dx, &Load
  #OutPut              ; Gebe Text aus                  
  
  mov  ax, 3509h       ; GetIntVec 09h
  int  21h                                
  mov  Old09.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old09.Seg, es   ; 
  mov  ax, 2509h       ; SetIntVec 09h
  lea  dx, Keyboard    ; = mov dx, Offset Keyboard / DS bereits Segment-Addr.
  int  21h
 
  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
 
.ifopt deu
  &ProgName  DB  'KEYB  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'deutscher Tastatur-Treiber mit Euro-Zeichen-Untersttzung. Das Euro-Zeichen',13,10
  >              'wird mit der Tastenkombination AltGr+E eingegeben.',13,10,13,10
  >              'Laden  : KEYB [/e]',13,10
  >              'Steuern: KEYB [/x|/s|/r]',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren',13,10
  >              '/e  legt fest, welches ASCII-Zeichen als Euro-Symbol ausgegeben werden soll,',13,10
  >              '    z.B. /e238 verwendet das ASCII-Zeichen 238 als Euro. Fehlt /e, verwendet',13,10
  >              '    KEYB das Zeichen 213. Die Zahl mu ggf. mit fhrenden Nullen angegeben',13,10
  >              '    werden, z.B. /e031. Fr Monochrom-Monitore empfiehlt sich /e238.$'

          .endopt

.ifOpt eng
  &Progname  DB  'KEYB  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'German keyboard driver', 13,10,13,10
  >              'Install: KEYB',13,10
  >              'Control: KEYB [/x|/s|/r]',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
