.include output, hexbin, rechnen, mem, strings

jmp @BEGIN

ActMCB     DW  ?

Frei       DB  '  frei', 0
Dos        DB  '  DOS', 0
IoSys      DB  '  IO.SYS', 0
Env        DB  '  Umgebung: ', 0
Data       DB  '  Daten   : ', 0

Temp       DB  13 dup (0)
Param      DB  0
 
UsedLo     DW  0
UsedHi     DW  0
FreeLo     DW  0
FreeHi     DW  0
MaxHi      DW  0  ; Grter freier Block in UMB
MaxLo      DW  0  ;    "      "      "   im konv. RAM
 
Reserviert DW  0

MCBFree    DW  0  ; Zahl der freien MCB
MCBUsed    DW  0  ; Zahl der belegten MCB

FirstUMB   DW  0  ; Gre des ersten UMB -> VideoRAM
UMBFound   DB  0  ; wird 1, wenn ein (der erste) UMB gefunden
SHLFlag    DB  1  ; fr Ausgabe der MCB-Zahl moz "OutLine" auf 0 setzen 

MaxLenSize EQU 12
MaxLenName EQU 20
 
   
OBJECT Arena:
  Signatur DB ?
  Owner    DW ?
  Size     DW ?
  Reserved DB 3 Dup (0)
  Name     DB 8 Dup (0)
  ZeroByte DW 0        ; Stringeende, falls Name 8 Zeichen lang

  PROC Copy:           ; Segment in AX bergeben
    push ax, cx, si, di, ds, es, cs / pop es
    mov  ActMCB, ax
    mov  ds, ax
    xor  si, si
    lea  di, Arena
    mov  cx, 8
    cld
    rep  movsw
    pop  es, ds, di, si, cx, ax
    ret
  ENDP
OBJECT END
 

PROC RepChar: / Char PAR 1 / Count PAR 2
BEGP
  push cx
  mov  cx, Count
  jcxz @raus
  cmp  cx, 80   ; Falls CX < 0
  ja   @raus
  push ax
  mov  al, Char
  @nochmal:
    #DosChar (ax)
  loop @nochmal
  pop  ax
  @raus:
  pop  cx
  ret
ENDP


PROC StrSize: / Size Par 2
  Temp1 LOC 13
BEGP
  push ax, di
  mov  ax, Size
  lea  di, Temp1
  cld
  push di
  stosw
  xor  ax, ax
  stosw
  stosb
  pop  di
  cmp byte SHLFlag, 0  ; fr Ausgabe der MCB-Zahl auf 0 setzen
  je  @weiter
    #LongSHL (di, 4, di)
  @weiter:
  #LongStr (di, di)
  #TausPkt (di, Temp^)
  pop  di, ax
  ret
ENDP


PROC OutSize / Size PAR 2
BEGP
  push ax, cx
  #StrSize (Size)
  #Length  (Temp^)
  mov cx, MaxLenSize
  sub cx, ax
  #RepChar (' ', cx)
  #DosStr  (Temp^)
  pop  cx, ax
  ret
ENDP

 
PROC WriteSegment:
  #Wordhex (ActMCB, Temp^)
  #DosStr  (Temp^)
  #RepChar (' ', 13)
  ret
ENDP


PROC WriteName:
BEGP
  push ax, cx
  #DosStr (si)
  #DosStr (&EnvName^)
  #Length (si)
  mov  bx, ax
  #Length (&EnvName^)
  add  ax, bx
  mov  cx, MaxLenName
  sub  cx, ax
  #RepChar (' ', cx)
  pop  cx, ax
  ret
ENDP

 
PROC IsUMB
  push ax, bx, es
  mov  ax, ActMCB
  mov  es, ax
  mov  bx, es:[3]   ; Gre des Blockes
  add  ax, bx       ; zur Segmentadresse hinzuaddieren 
  cmp  ax, $A000
  jae  @ja
    clc
    jmp  short @raus
  @ja:
  mov  al, UMBFound
  or   al, al
  jnz  @weiter
    inc  al
    mov  UMBFound, al
    inc  bx
    mov  FirstUMB, bx
  @weiter:
  stc
  @raus:
  pop  es, bx, ax
  ret
ENDP
; Ermittelt, ob der Block oberhalb $A000 endet, also ein UMB ist
; Wenn ja, ist das Carry-Flag gesetzt


PROC WhatIam
  push ax, es
  lea  si, Frei        ; SI mit Offset von "frei" vorbelegen

  push cs
  pop  ax
  dec  ax
  cmp  ax, ActMCB
  je   @raus           ; Wenn MEM selbst, wird Block als frei gezeigt
 
  mov  ax, Arena.Owner ; Adresse des PSP des Besitzers 
  or   ax, ax      
  jz   @raus           ; Wenn 0: Der MCB ist ein freier Block
  dec  ax              ; MCB des PSP des Besitzers anpeilen
  cmp  ax, ActMCB      ; Wenn Adresse PSP-1 und MCB gleich sind, dann
  je   @ImAProg        ; kennzeichnet der MCB ein Programm
    inc ax
    mov es, ax         ; PSP des Besitzers
    mov ax, es:[44]    ; Adresse des Environments des Besitzers des PSP
    dec ax             ; PSP des Environments
    cmp ax, ActMCB     ; ist dieser MCB mit dem Environment identisch?
    je  @ImAnEnv       ; wenn ja, ist dieser MCB ein Environment

    lea si, Dos        ; ist es ein DOS-Datenbereich ?
    mov ax, es:[0]
    cmp ax, $20CD      ; Sprungbefehl im PSP-Beginn (int 20h)
    jne @raus
 
    lea si, Data
    jmp short @raus    ; wenn nicht, ist es ein Datenbereich
  @ImAProg:
  lea si, Arena.Name
  jmp short @raus
  @ImAnEnv:
  lea si, Env
  @raus:
  pop es, ax
  ret
ENDP


PROC IncFree
  push ax
  inc word MCBFree
  mov ax, Arena.Size
  #IsUMB
  jnc @KonMem
    cmp ax, MaxHi
    jb  @ng1 / mov MaxHi, ax / @ng1:  ; grten freien UMB ermitteln
    add FreeHi, ax
    jmp short @raus
  @KonMem:
  cmp ax, MaxLo
  jb  @ng2 / mov MaxLo, ax / @ng2:    ; grten freien konv. Block ermitteln
  add FreeLo, ax
  @raus:
  pop ax
  ret
ENDP


PROC IncUsed
  push ax 
  inc word MCBUsed
  mov ax, Arena.Size
  inc ax            ; MCB zu Size addieren, da der MCB selbst Speicher belegt
  #IsUMB
  jnc @KonMem
    add UsedHi, ax
    jmp short @raus
  @KonMem:
  add UsedLo, ax
  @raus:
  pop ax
  ret
ENDP


PROC CopyArenaName / MCBSeg PAR 2 / NameOfs Par 2
BEGP
  push ax, cx, ds, es, si, di
  mov  ds, MCBSeg
  push cs
  pop  es
  mov  di, NameOfs
  mov  cx, 8
  mov  si, cx     ; Weil Offset Arena.Name zufllig auch 8 ist
  rep  movsb
  xor  al, al
  stosb           ; Null-Byte als String-Ende
  pop  di, si, es, ds, cx, ax
  ret
ENDP

 
PROC GetEnvProgname / EnvSeg PAR 2 / EnvStr PAR 2
BEGP
  push ax, cx, di, si, ds, es
  mov  ds, EnvSeg
  xor  si, si
  xor  ax, ax
  @EnvRead:                  ; Lese bis zum Ende des Environments durch
    inc si                   ; Auffinden der Endemarkierung (2 Nullbytes)
    cmp ax, [si]
  jne @EnvRead
  add si, 2
  lodsw                      ; AX, also Word nach Ende des Environments
  cmp ax, 0001h              ; enthlt die Zahl der noch folgenden Werte,
  je  @okay                  ; i.d.R. 0001h
    pop  es
    pop  ds / push ds
    mov  ax, Arena.Owner     ; Hole Namen des Besitzers aus dessen MCB
    dec  ax
    #CopyArenaName (ax, EnvStr)
    jmp short @raus
  @okay:                     ; Danach folgt der vollstndige Pfad des  
  mov di, si                 ; Eigentmers des Umgebungsspeichers
  mov es, EnvSeg
  mov cx, 78
  cld
  xor al, al
  repne scasb
  std
  mov  cx, 20
  dec  di
  mov  al, '\'               ; Stop am letzten BackSlash
  repne scasb
  inc  di / inc di
  mov  si, di
  cld
  pop  es
  mov  di, EnvStr
  mov  cx, 8
  @readname:
    lodsb
    cmp  al, '.'
    je   @ende
    or   al, al
    jz   @ende
    dec  cx
    jcxz @ende
    stosb
  jmp @readname
  @ende:
  xor al, al
  stosb
  @raus:
  pop ds, si, di, cx, ax
  ret
ENDP


PROC IsMyEnv: / MyMCB PAR 2
BEGP
  push ax, bx, es
  mov  ax, MyMCB
  inc  ax              ; Beginn des PSP dieses Programmes
  mov  es, ax
  mov  bx, es:[44]     ; Environment des Besitzers dieses MCB
  dec  bx              ; MCB des Env anpeilen
  mov  es, bx          ; Segment MCB nach ES
  mov  bx, es:[1]      ; Gucken, ob freigegebenes Environment
  or   bx, bx          ; wenn 0, dann ist es ein freier Block
  jz   @no
  cmp  bx, ax          ; Vergleiche PSP im Env-MCB mit eigener PSP-Addresse
  jne  @no             ; Wenn ungleich, gehrt dem Prog das Env nicht mehr
  clc                  ; Carry=0 = dem Prog gehrt das Environment
  jmp short @raus
  @no:
  stc                  ; Carry=1 = das Env gehrt dem Prog nicht
  @raus:
  pop  es, bx, ax
  ret
ENDP

 
PROC CheckName
  push cx, si, ax
  lodsb
  or   al, al
  jz   @error
  cmp  al, 32
  je   @error
  mov  cx, 7
  @next:
    lodsb
    or  al, al
    jz  @okay
    cmp al, 32
    je  @okay
    cmp al, 'A'
    jb  @error
    cmp al, 'Z'
    ja  @error
    @okay:
  loop @next
  jmp  short @raus
  @error:
  pop  ax / push ax
  #IsMyEnv (ax)
  jc   @raus
  inc  ax
  #GetEnvProgName (ax, &EnvOwner^)
  pop  ax
  pop  si
  lea  si, &EnvOwner
  jmp  short @ganzraus
  @raus:
  pop  ax, si
  @ganzraus:
  pop  cx
  ret
ENDP

 
PROC WriteLine:
  push ax
  mov  Byte &EnvName, 0

  mov  ax, ActMCB
  cmp  ax, $9FFF
  jne  @nores
    mov ax, arena.size
    mov Reserviert, ax 
  @nores:

  #WhatIam
  cmp  si, offset Frei
  jne  @belegt
    @frei:
    #IncFree
    jmp short @write
  @belegt:
  #IncUsed

  cmp si, offset Env
  jne @NoEnv
    mov ax, ActMCB
    inc ax
    #GetEnvProgName (ax, &EnvName^)
    jmp short @checkname
  @NoEnv:

  cmp si, offset Data
  jne @checkname
    mov ax, Arena.Owner
    dec ax
    #CopyArenaName (ax, &EnvName^)

  @checkname:
  mov ax, arena.name
  cmp ax, 'SD'        ; System Data ?
  jne @write
    lea si, IOSys
    jmp short @write

  @write:
  cmp byte Param, 'D'
  jne @noout
  #WriteSegment
  #WriteName          ; erwartet Namen des Eigentmers des MCB in SI
  mov ax, Arena.Size
  inc ax
  #OutSize (ax)
  #DosLineFeed
  @noout:
  pop ax
  ret
ENDP

 
PROC OutMem: / Text PAR 2 / Size PAR 2
BEGP
  #DosStr  (Text)
  #OutSize (Size)
  #DosLineFeed
  RET
ENDP


PROC OutLine: / Text PAR 2 / MemFree PAR 2 / MemUsed PAR 2
BEGP
  push ax
  #DosStr  (Text)
  #OutSize (MemFree)
  #OutSize (MemUsed)
  mov ax,   MemFree
  add ax,   MemUsed
  #OutSize (ax)
  #DosLineFeed
  pop ax
  ret
ENDP

;------------------------ Hauptprogramm -----------------------------------
 
@BEGIN:
  cld
  mov  di, 81h                ; Anfang Kommandozeile in ES:SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade Lngen-Byte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @noparam               ; nur Leerzeichen? dann raus
    mov al, es:[di]           ; Zeichen nach '/' laden
    cmp al, '?'
    jne @nohelp
      #DosLn (&Hilfe^)
      jmp @halt
    @nohelp:
    and al, 11011111b         ; UpCase
    cmp al, 'D'
    jne @noparam
    mov Param, al
  @param:
 
  #DosLn   (&Header^)
  #RepChar ('-', 49)
  #DosLineFeed

  @noparam:
  push es
  mov  ah, 52h
  int  21h
  mov  ax, es:[bx-2]    ; Segment des ersten MCB/ArenaRecs in ax
  mov  UsedLo, ax       ; Speicher vor dem ersten MCB ist ja belegt

  push ax
  mov  es, [44]         ; Im PSP an Offset 44dez ein Word nach ES lesen
  mov  ah, 49h          ; Speicher von Umgebung wieder freigeben,
  int  21h              ; da der nicht mehr gebraucht wird
  pop  ax
 
  mov  cx, [44]         ; Segment-Adresse Environment lesen
  dec  cx               ; MCB des Environments anpeilen
  mov  es, cx
  mov  bx, es:[3]       ; Gre Environment lesen, es soll geprft werden, ob
  mov  dx, cs           ; MEM und sein Environment direkt hintereinander liegen
  dec  dx               ; Segment des MCB von MEM
  sub  dx, bx           ; Gre Environment abziehen
  dec  dx               ; Gre MCB des Environments abziehen
  cmp  dx, cx           ; Vergleichen, ob beide identisch sind. Wenn nicht,
  jne  @nooneblock      ; entsteht nach Beenden von MEM kein zus.hngend. Block
    inc  bx             ; sonst + Gre MCB, da dieser ja verschwindet
  @nooneblock:
  mov ActMCB, cx
  #IsUMB
  jnc @LoEnv
    add  FreeHi, bx
    sub  UsedHi, bx
    jmp short @EndEnv
  @LoEnv:
  add  FreeLo, bx
  sub  UsedLo, bx
  mov  Word FirstUMB, 0  ; da diese "vorzeitig" von IsUMB gesetzt werden
  mov  Byte UMBFound, 0
  @EndEnv:
  pop  es

;---------------------- Schleife zum Abklappern aller MCB ---------------

  @nochmal:
    #arena.copy
    mov bl, arena.signatur
    cmp bl, 'M'
    je  @los
    cmp bl, 'Z'
    je  @los
    jmp @ende
    @los:
    #WriteLine
    add ax, arena.size
    inc ax
  jmp @nochmal
  @ende:

; --------------------------- Zusammenfassung ausgeben ---------------------

cmp byte Param, 'D'
jne @out / jmp @halt / @out:
 
#DosLineFeed
#DosStr  ('Hilfe mit /?'^)
 
#RepChar (' ', 18)
#DosLn   (&TabHead^)
#RepChar ('-', 58)
#DosLineFeed

mov ax, FirstUMB   ; "blockiert" i.d.R. den Video-RAM
sub UsedHi, ax

#OutLine ('konventioneller RAM : '^, FreeLo, UsedLo) 
#OutLine ('hoher Speicher..... : '^, FreeHi, UsedHi) 

mov ax, FreeLo 
add ax, FreeHi
mov bx, UsedLo
add bx, UsedHi

#OutLine ('insgesamt.......... : '^, ax, bx) 
 
mov Byte SHLFlag, 0
#OutLine ('Speicherblcke..... : '^, MCBFree, MCBUsed) 
mov Byte SHLFlag, 1
 
#DosLineFeed
  
#OutMem  ('Reserviert......... : '^, Reserviert)
 
#OutMem  ('Grter freier Block: '^, MaxLo)
#OutMem  ('Grter freier UMB  : '^, MaxHi)
#OutMem  ('reserv. Video-RAM.. : '^, FirstUMB)

@Halt: 
.HALT

&Header  DB 13,10, 'Segment            Name                     Gre', 0
&TabHead DB 'Frei      Belegt      Gesamt',0

HelpOffset EQU ($) 

&Hilfe   DB 13,10,
> 'MEM 1.0 fr DOS - Freeware - (c) 2001 A.Olejko / www.dosware.de',13,10,
> 'Anzeige der Belegung des Arbeitsspeichers (alle Angaben in Byte)',13,10,13,10
> 'MEM [/D]',13,10,13,10,
> '/D  zeigt erweiterte Informationen',0

&EnvOwner DB absolute  HelpOffset      ; Benutze Speicher des Hilfetextes
&EnvName  DB absolute (HelpOffset+14)  ; ""



; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
