PROGRAM MenuEdit; { Editor fr Comander-Mens }
USES
  BiosCrt, Strings, DOS, Masken, Filecopy, EdWin, Monitor, Mouse, keycode,
  clipbord;

CONST
  Edit     = 1;
  Neu      = 2;
  Del      = 3;
  Pars     = 'NEL';
  Xchars   = ';[-';
  Progname = 'MENUEDIT';
  TempName = 'MENUE.TMP';
  MenMax   = 16;
  EdMax    = 100;
  LMax     = '100';
  EdLen    : Byte = 0;
  MenCol   : PathStr = '';

TYPE
  MenRec   = RECORD
               Hotkey  : Char;
               Anzeige : String[61];
               Befehl1 : String;
             END;

VAR
  fa, fb   : Text;
  Buf1     : Array[1..10000] Of Char;
  Buf2     : Array[1..10000] Of Char;
  Befehl   : Byte;
  FileName : PathStr;
  MenuName : String;
  LineNum  : Word;
  Lin      : Word;
  Tmp, Tmp1: String;
  Men      : MenRec;
  EdMen    : MenRec;
  TempPath : PathStr;
  ProgPath : PathStr;
  SubMen   : Boolean;
  EdBuf    : Array[1..EdMax] Of ComStr;

CONST
  BufSize = 10000;

VAR
  Buffer    : Array[1..BufSize] Of Char;
  Ed        : Array[1..3] Of EdRec;
  ClipBuffer: Array[1..BufSize] Of Char;
  ClipBoard : ClipRec;


PROCEDURE Hilfe;
BEGIN
  StandardKopf (ProgName, Copyright);
  DosLnLF (
  'Editor fr die Mens des DOS-Comanders'#13#10#13#10+
  'Dieses Programm kann nur aus dem Comander heraus verwendet werden. Geben Sie'#13#10+
  'im Comander die Tastenkombination ALT+F2 ein, um mehr Informationen anzuzeigen');
  BlindStop; Halt;
END;

PROCEDURE CloseAll;
BEGIN
  If TextRec(fa).Mode<>fmClosed Then BEGIN Close (fa); InOutRes:= 0; END;
  If TextRec(fb).Mode<>fmClosed Then BEGIN Close (fb); InOutRes:= 0; END;
END;

PROCEDURE Error;
BEGIN
  CloseAll;
  DosLnLF ('Interner Fehler. Weiter mit Taste.'); WaitBKey; Halt;
END;

PROCEDURE DelError;
BEGIN
  CloseAll;
  RenameFile (TempPath, FileName, TRUE); InOutRes:= 0;
  Error;
END;


PROCEDURE GetParams;
VAR
  c : Integer;
BEGIN
  TextRec (fa).Mode:= fmClosed;
  TextRec (fb).Mode:= fmClosed;
  If ParamCount<>4 Then Hilfe;
  tmp:= UpStr (ParamStr(1));
  Befehl:= pos (tmp[2], Pars); If Befehl= 0 Then Error;
  FileName:= UpStr (ParamStr (2));
  If ObjektExist (FileName)<>Dat Then Error;
  MenuName:= '['+UpStr (ParamStr (3))+']';
  tmp:= UpStr (ParamStr (4));
  Val (tmp, LineNum, c);
  If (c<>0) or (LineNum>MenMax) Then Error;

  ProgPath:= ParamStr (0);
  While (Length (ProgPath)<>0) and (ProgPath[Length(ProgPath)]<>'\') Do
  dec (ProgPath[0]);

  TempPath:= Trim (GetEnv ('TEMP'));
  If  TempPath='' Then TempPath:= Trim (GetEnv ('TMP'));
  If (TempPath='') or (ObjektExist (TempPath)<>Ver) Then TempPath:= ProgPath;
  TempPath:= Vollpfad (TempPath, TempName);
END;


PROCEDURE MakeMenRec (Zeile : String; VAR Men : MenRec);
BEGIN
  With Men Do
  BEGIN
    Zeile:= Trim (Zeile);
    If Zeile='[LINE]' Then
    BEGIN HotKey:= #0; Anzeige:= '[LINE]'; Befehl1:= ''; END Else
    BEGIN
      Hotkey:= upchar (Zeile[1]);
      Delete (Zeile, 1, pos(';', Zeile));
      Anzeige:= Trim (copy (Zeile, 1, pos(';', Zeile)-1));
      Delete (Zeile, 1, pos(';', Zeile));
      Befehl1:= Trim (Zeile);
    END;
  END;
END;


PROCEDURE CheckC (VAR FileName : PathStr);
VAR
  p : Byte;
BEGIN
  If pos ('[', Filename)<>0 Then
  BEGIN
    p:= pos ('[C]', Filename);
    If p=0 Then
    BEGIN
      DosLnLF ('Pfad der Men-Datei konnte nicht ermittelt werden:'#13#10+
                FileName+#13#10#13#10'Weiter mit Taste');
      WaitBKey; Halt;
    END;
    delete (FileName, p, 3);
    insert (ProgPath, FileName, p);
  END;
END;


PROCEDURE ReadLine (VAR InStr : String);
BEGIN
  ReadLn (fa, InStr); If IOResult<>0 Then DelError;
END;


PROCEDURE WriteLine (OutStr : String);
BEGIN
  WriteLn (fb, OutStr); If IOResult<>0 Then DelError;
END;


PROCEDURE CopyLine (VAR tmp : String);
BEGIN
  ReadLine (tmp); WriteLine (tmp);
END;


PROCEDURE Resetfa (Name : PathStr);
BEGIN
  Assign (fa, Name); SetTextBuf (fa, Buf1, SizeOf (Buf1)); FileMode:= 0;
  Reset  (fa);
END;


PROCEDURE Rewritefb (Name : PathStr);
BEGIN
  Assign  (fb, Name); SetTextBuf (fb, Buf2, SizeOf (Buf2)); FileMode:= 2;
  Rewrite (fb);
END;


PROCEDURE RenameAndOpen;
BEGIN
  RenameFile (FileName, TempPath, TRUE);
  If IOResult<>0 Then Error;
  Resetfa   (TempPath); If IOResult<>0 Then DelError;
  Rewritefb (FileName); If IOResult<>0 Then DelError;
END;


PROCEDURE EraseLine;
BEGIN
  RenameAndOpen;
  tmp:='';
  While (not Eof (fa)) and (UpStr(Trim(tmp))<>MenuName) Do CopyLine (tmp);
  If UpStr(Trim(tmp))<>MenuName Then DelError;
  Lin:= 0;
  REPEAT
    ReadLine (tmp);
    tmp1:= UpStr (Trim(tmp));
    If  (tmp1<>'')
    and ((pos (tmp1[1], Xchars) = 0) or (Tmp1='[LINE]')) Then inc (Lin);
    If Lin<>LineNum Then WriteLine (tmp);
  UNTIL (Eof (fa)) or (Lin=LineNum) or (tmp1='[ENDE]');
  If Lin<>LineNum Then DelError;
  If not Eof(fa) Then
  BEGIN
    MakeMenRec (tmp, Men); men.Befehl1:= UpStr (Men.Befehl1);
    SubMen:= pos ('GOTO ', Men.Befehl1) = 1;
    If (pos ('-', Men.Befehl1) = 1) and (not Eof(fa)) Then
    BEGIN
      REPEAT
        ReadLine (tmp); 
        tmp1:= Trim (tmp);
      UNTIL (Eof(fa)) or ((pos ('-', tmp1) <> 1) and (pos (';', tmp1) <> 1));
      If tmp1<>'' Then WriteLine (tmp);
    END;
  END;
  While not Eof (fa) Do CopyLine (tmp);
  CloseAll; { Temp-Datei nicht lschen ! }
END;
    

PROCEDURE DelSubMenu;
LABEL
  Weiter;
VAR
  p           : Byte;
  OldFileName : PathStr;
  OldMenuName : String;
BEGIN
  OldMenuName:= MenuName; OldFileName:= FileName;
  tmp:= Trim (copy (Men.Befehl1, 6, 255));
  p:= pos (' ', tmp);
  If p<>0 Then
  BEGIN
    MenuName:= Trim (copy (tmp, p+1, 255));
    FileName:= copy (tmp, 1, p-1);
    CheckC (FileName);
  END Else MenuName:= tmp;
  If Objektexist (FileName)<>Dat Then Error;

  DosLnLF (
  'Der gelschte Men-Eintrag verwies auf ein Untermen.'#13#10#13#10+
  'Name des Untermens: '+Menuname+#13#10+
  'Enthalten in Datei : '+FileName);
  DosStr (
  #13#10'Wollen Sie dieses Untermen ebenfalls lschen ?  Enter=Ja  Esc=Nein');
  REPEAT
    ScanBKeys; If t1=#27 Then Halt;
  UNTIL t1=#13;

  MenuName:= '['+MenuName+']';
  RenameAndOpen;
  While not Eof (fa) Do
  BEGIN
    ReadLine  (tmp);
    If UpStr(Trim(tmp))=MenuName Then Goto Weiter;
    WriteLine (tmp);
  END;
  Weiter:
  While (not Eof (fa)) and (UpStr(Trim(tmp))<>'[ENDE]') Do ReadLine (tmp);
  While not Eof (fa) Do CopyLine (tmp);
  CloseAll;
  MenuName:= OldMenuName; FileName:= OldFileName;
END;


PROCEDURE InsertLine (Men : MenRec);
VAR
  l, x, p : Byte;
  tMen    : MenRec;
  sTemp   : String;
  fLen    : Byte;
LABEL
  Los;
BEGIN
  RenameAndOpen;
  tmp:='';
  While (not Eof (fa)) and (UpStr(Trim(tmp))<>MenuName) Do CopyLine (tmp);
  If UpStr(Trim(tmp))<>MenuName Then DelError;
  Lin:= 0; If LineNum=0 Then fLen:=30 Else fLen:= 1;
  If LineNum>0 Then
  REPEAT
    CopyLine (tmp);
    Tmp1:= UpStr (Trim(tmp));
    If  (tmp1<>'')
    and ((pos (tmp1[1], Xchars) = 0) or (Tmp1='[LINE]')) Then
    BEGIN
      inc (Lin);
      x:= LastPos (';', tmp1);
      If x > fLen Then fLen:=x;
    END;
  UNTIL (Eof (fa)) or (Lin=LineNum) or (tmp1='[ENDE]');
  If Lin<>LineNum Then DelError;
  If fLen>65 Then fLen:=65;

  MakeMenRec (tmp, tMen);
  If pos ('-', tMen.Befehl1) = 1 Then
  BEGIN
    REPEAT
      ReadLine (tmp); tmp1:= UpStr (Trim (tmp));
      If (tmp1<>'') and (pos ('-', tmp1)<>1) and (pos (';', tmp1)<>1) Then
      BEGIN sTemp:= tmp; Goto Los; END;
      If tmp1<>'' Then WriteLine (tmp);
    UNTIL (Eof (fa)) or (tmp1='[ENDE]');
    DelError;
  END Else sTemp:= '';

  Los:
  If pos ('[', Men.Anzeige)=1 Then  { Farbe oder Line }
  BEGIN WriteLine (Men.Anzeige); SubMen:= FALSE; END Else
  BEGIN
    SubMen:= pos ('GOTO ', UpStr (Men.Befehl1)) = 1;
    tmp:= UpChar (Men.HotKey)+'; '+Men.Anzeige;
    l:= Length (tmp);
    If EdLen>1 Then
    BEGIN
      If Length(Men.Befehl1)+l+fLen>240 Then fLen:= l;
      If fLen<l Then fLen:= l;
      WriteLine (SpaceStr (tmp, fLen-1)+'; -'+EdBuf[1]);
      For x:= 2 To EdLen Do If Trim (EdBuf[x])<>'' Then
      If pos (';', Trim (EdBuf[x]))=0 Then
      WriteLine (FillString (fLen+1)+'-'+EdBuf[x]) Else
      WriteLine (FillString (fLen+1)+EdBuf[x]);
    END Else
    BEGIN
      If Length(Men.Befehl1)+l+fLen>240 Then fLen:= l;
      WriteLine (SpaceStr(tmp, fLen-1)+'; '+Men.Befehl1);
    END;
  END;
  If sTemp<>'' Then WriteLine (sTemp);
  While not Eof (fa) Do CopyLine (tmp);
  CloseAll; { Temp-Datei nicht lschen ! }

  If SubMen Then
  BEGIN
    tmp:= Trim (copy (Men.Befehl1, 6, 255));
    p:= pos (' ', tmp);
    If p<>0 Then
    BEGIN
      MenuName:= Trim (copy (tmp, p+1, 255));
      FileName:= copy (tmp, 1, p-1);
      CheckC (FileName);
    END Else MenuName:= tmp;
    If Objektexist (FileName)<>Dat Then Error;
    MenuName:= '['+UpStr (MenuName)+']';

    Resetfa (FileName);
    While not Eof (fa) Do
    BEGIN
      ReadLn (fa, tmp); If IOResult<>0 Then Error;
      If UpStr (Trim (tmp)) = MenuName Then
      BEGIN Close (fa); InOutRes:= 0; Halt; END;
    END;
    Close (fa); InOutRes:= 0;
    Assign (fb, FileName); SetFAttr (fb, 32); Append (fb);
    If IOResult<>0 Then Error;
    If MenCol<>'' Then MenCol:= '[FARBE '+MenCol+']'#13#10;
    WriteLn (fb, #13#10 + MenuName + #13#10+MenCol+'[ENDE]');
    Close (fb);
    If IOResult<>0 Then Error;
  END;
END;


PROCEDURE ReadOldMen (VAR Men : MenRec);
VAR
  x : Byte;
BEGIN
  Resetfa (FileName);
  tmp:='';
  While (not Eof (fa)) and (UpStr(Trim(tmp))<>MenuName) Do ReadLine (tmp);
  If UpStr (Trim(tmp))<>MenuName Then Error;
  Lin:= 0;
  REPEAT
    ReadLine (tmp);
    tmp1:= UpStr (Trim(tmp));
    If  (tmp1<>'')
    and ((pos (tmp1[1], Xchars) = 0) or (Tmp1='[LINE]')) Then inc (Lin);
  UNTIL (Eof (fa)) or (Lin=LineNum) or (tmp1='[ENDE]');
  If (Eof (fa)) or (Lin<>LineNum) Then Error;

  MakeMenRec (tmp, Men);
  inc (EdLen);
  EdBuf[EdLen]:=Men.Befehl1;
  If (pos ('-', Men.Befehl1) = 1) and (not Eof(fa)) Then
  BEGIN
    EdBuf[EdLen]:=Trim (copy (Men.Befehl1, 2, 255));
    REPEAT
      ReadLine (tmp);
      tmp1:= Trim (tmp);
      If tmp1<>'' Then
      If EdLen<EdMax Then
      BEGIN
        If (pos ('-', tmp1) = 1) or (pos (';', tmp1)=1) Then
        BEGIN
          If pos (';', tmp1)=1 Then tmp:= tmp1 Else
          tmp:= Trim (copy (tmp1, 2, 255));
          inc (EdLen);
          EdBuf[EdLen]:= tmp;
        END;
      END Else
      BEGIN
        DosLnLF (
        'Die Befehlsliste des Meneintrages ist zu lang zum Bearbeiten.'#13#10#13#10+
        'Weiter mit Taste');
        WaitBKey;
        Close (fa); InOutRes:= 0;
        Halt;
      END;
    UNTIL (Eof(fa)) or ((tmp1<>'') and (pos ('-', tmp1) <> 1) and (pos (';', tmp1) <> 1));
  END;
  Close (fa); InOutRes:= 0;
END;



VAR
  BgCol : Byte;
CONST
  Vars  = 'CDQZPEHVXSW'#27; 

PROCEDURE Button (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : String);
VAR
  y : Byte;
BEGIN 
  insert (' ', st, 1);
  If ee=1 Then
  BEGIN
    WriteXY (a, b, st, 7, BgCol);
    y:= Pos (Hotkey, St);
    If y<>0 Then WriteXY (a+y-1, b, Hotkey, lightcyan, BgCol);
  END Else
  BEGIN
    If ((upcase(t1)= Hk1a) and (upcase(t2)=Hk1b))
    or (MouseIn (a, b, Length (st)+a-1, b)) Then
    BEGIN t1 := Hk1a; t2:= Hk1b; END;
  END;
END;


PROCEDURE VarButtons;
BEGIN
  Button (3, 11, 'C', #0, 'C', SpaceStr('[C]  Name des Verzeichnisses, in dem sich der Comander befindet', 74));
  Button (3, 12, 'P', #0, 'P', SpaceStr('[P]  Name des Verzeichnisses im aktiven Fenster des Comanders', 74));
  Button (3, 13, 'Z', #0, 'Z', SpaceStr('[Z]  Name des Verzeichnisses im inaktiven Fenster des Comanders', 74));
  Button (3, 14, 'Q', #0, 'Q', SpaceStr('[Q]  Name der Datei im Lichtbalken des Comanders', 74));
  Button (3, 15, 'X', #0, 'X', SpaceStr('[X]  Prfix des Dateinamens im Lichtbalken des Comanders', 74));
  Button (3, 16, 'S', #0, 'S', SpaceStr('[S]  Suffix des Dateinamens im Lichtbalken des Comanders', 74));
  Button (3, 17, 'E', #0, 'E', SpaceStr('[E]  Aufrufbefehl des im Comander eingestellten Editors', 74));
  Button (3, 18, 'V', #0, 'V', SpaceStr('[V]  Aufrufbefehl des im Comander eingestellten Dateibetrachters', 74));
  Button (3, 19, 'H', #0, 'H', SpaceStr('[H]  Aufruf des Hilfe-Betrachters', 74));
  Button (3, 20, 'W', #0, 'W', SpaceStr('[W]  Windows-Startbefehl', 74));
  Button (3, 21, 'D', #0, 'D', SpaceStr('[D]  Direktstart einer Anwendung erzwingen', 74));
  Button (3, 22, #27, #0, 'Esc', SpaceStr('Esc  Abbruch', 74));
END;


PROCEDURE GetVar;
BEGIN
  MouseWait;
  Window (2, 10, 78, 23); TextAttr:= 112; ClrScr; Window (1, 1, 80, 25);
  ee:= 1; VarButtons; ee:= 0;
  CursorOff; t1:= #0;
  REPEAT
    MouseOn; REPEAT MouseGet; UNTIL (kn<>0) or (KeyPressed); MouseOff;
    If keyPressed Then UpScanBKeys Else MouseWait;
    VarButtons;
  UNTIL pos (t1, Vars)<>0;
  CursorOn;
END;


PROCEDURE Buttons;
BEGIN
  Button ( 1, 25, #0, F2, 'F2', 'F2Speichern');
  Button (13, 25, #0, F3, 'F3', 'F3Cut');
  Button (19, 25, #0, F4, 'F4', 'F4Paste');
  Button (27, 25, #0, F5, 'F5', 'F5Copy');
  Button (34, 25, #0, F6, 'F6', 'F6ClrBlk');
  Button (43, 25, #0, F7, 'F7', 'F7BlockAn');
  Button (53, 25, #0, F8, 'F8', 'F8BlockEn');
  Button (67, 25, #27,#0, 'Esc','EscAbbrechen');
END;


PROCEDURE EditMen (VAR Men : MenRec);
VAR
  s         : String[61];
  h         : String[1];
  gel, x,
  y, i      : Word;
LABEL
  Nochmal;

PROCEDURE Fusszeile (Txt : String);
BEGIN
  WriteXY (1,25, SpaceStr(' '+txt+' Weiter mit Taste', 80), yellow, red);
  MouseOn; REPEAT MouseGet; UNTIL (kn<>0) or (Keypressed); MouseOff;
  If kn<>0 Then MouseWait Else WaitBKey;
END;


PROCEDURE VarBut (ee1 : Byte);
BEGIN
  ee:= ee1;
  If ActEditor=3 Then
  Button  (58, 9, #0, F1, 'F1', 'F1 Variable einfgen') Else
  WriteXY (58, 9, '                     ', 0, BgCol);
  ee:= 0;
END;


BEGIN
  With Men Do
  BEGIN
    If Hotkey=#0 Then h:='' Else h:=Hotkey;
    s  := Anzeige;
    gel:= 0;
    If Befehl1<>'' Then 
    For y:= 1 To EdLen Do If gel+Length(EdBuf[y])+2<BufSize Then
    BEGIN
      For x:= 1 To Length (EdBuf[y]) Do
      BEGIN inc (gel); Buffer[gel]:= EdBuf[y,x]; END;
      inc (gel); Buffer[gel]:= #13; inc (gel); Buffer[gel]:= #10;
    END Else
    BEGIN
      DosLnLF ('Nicht genug Speicher zum Bearbeiten des Meneintrages');
      WaitBKey; Halt;
    END;

    VGAColorOn; MouseInit;
    If ScrMode=MonoMon Then BgCol:= 0 Else
    BEGIN BgCol:= 8; ColCursor (magenta*16); END;
    TextBackGround (BgCol); ClrScr; 
    WriteXY (1, 1, SpaceStr (' MENUEDIT', 79-Length(CopyRight))+CopyRight+' ', 7, blue);

    WriteXY (2, 4, 'Tastenkrzel', 15, BgCol);
    WriteXY (2, 6, 'Meneintrag',  15, BgCol);
    WriteXY (2, 9, 'Befehl(e)',    15, BgCol);

    InitClipBoard (Clipboard, @ClipBuffer, BufSize);
    ClipBoard.ClipEnd:= BufSize;
    ReadBinClip (ClipBuffer, ClipBoard.ClipEnd);

    InitEditor (15,  4, 16,  4, Ed[1], Addr (h[1]), SizeOf (h)-1, Length(h), @ClipBoard);
    InitEditor (15,  6, 79,  6, Ed[2], Addr (s[1]), SizeOf (s)-1, Length(s), @ClipBoard);
    InitEditor ( 2, 10, 79, 23, Ed[3], @Buffer, Bufsize, gel, @ClipBoard);

    Nochmal:
    ee:= 1; Buttons; ee:= 0;
    REPEAT
      VarBut (1);
      EditWin (Ed[Acteditor]);
      If (kn<>0) or ((t2=F1) and (Acteditor=3)) Then
      BEGIN
        For x:= 1 To LastEditor Do CheckMouse (Ed[x]);
        Buttons;
        VarBut (0);
        If (t1<>#0) or (t2<>#0) Then
        BEGIN
          If (Acteditor=3) and (t2=F1) Then
          BEGIN
            GetVar;
            If t1<>#27 Then
            BEGIN
              Sendkey (Ed[3], '[', #0);
              Sendkey (Ed[3], t1,  #0);
              Sendkey (Ed[3], ']', #0);
            END;
            t1:= #0;
          END
          Else Sendkey (Ed[ActEditor], t1, t2);
          MouseWait;
        END;
      END;
    UNTIL (t1=#27) or (t2=F2);
    If t2=F2 Then
    BEGIN
      s[0]:= chr(Ed[2].BufEnd);
      If s[0]>=chr(SizeOf(Anzeige)) Then s[0]:= chr(SizeOf(Anzeige)-1);
      If Length (s)=0 Then
      BEGIN Fusszeile ('Meneintrag fehlt.'); ActEditor:= 2; Goto Nochmal; END;
      If UpStr (Trim(s))<>'[LINE]' Then
      BEGIN
        h[0]:= chr(Ed[1].BufEnd); If h[0]>#1 Then h[0]:= #1;
        If Length (h)=0 Then
        BEGIN Fusszeile ('Tastaturkrzel fehlt.'); ActEditor:= 1; Goto Nochmal; END;
        If (Ed[3].BufEnd=0) or ((Ed[3].BufEnd<=2) and (Buffer[1]=#13)) Then
        BEGIN
          Fusszeile ('Sie mssen wenigstens einen Befehl eingeben.');
          ActEditor:= 3; Goto Nochmal;
        END;
        y:= 1; i:= 0;
        For x:= 1 To Ed[3].BufEnd Do If Buffer[x]<>#13 Then inc (y) Else
        BEGIN
          inc (i);
          If y>=SizeOf (EdBuf[1]) Then
          BEGIN
            Fusszeile ('Ein Befehl ist lnger als erlaubt (max. 127 Zeichen).');
            ActEditor:= 3; Goto Nochmal;
          END Else y:= 0;
        END;
        If i>EdMax Then
        BEGIN
          Fusszeile ('Mehr Befehle als erlaubt (max. '+LMax+' Zeilen).');
          ActEditor:= 3; Goto Nochmal;
        END;
        EdLen:= 0; x:= 0;
        While (EdLen<EdMax) and (x<Ed[3].BufEnd) Do
        BEGIN
          inc (EdLen);
          EdBuf[EdLen]:= '';
          REPEAT
            inc (x);
            If (Buffer[x]<>#13) and (Length (EdBuf[EdLen])<SizeOf (EdBuf[1])-1) Then
            CharAdd (EdBuf[EdLen], Buffer[x]);
          UNTIL (Buffer[x]=#13) or (x>=Ed[3].BufEnd);
          EdBuf[EdLen]:= Trim (EdBuf[EdLen]);
          If EdBuf[EdLen]='' Then dec (EdLen);
          inc (x);
        END;
        Befehl1:= EdBuf[1];
        Hotkey := h[1];
      END Else BEGIN Befehl1:= ''; Hotkey:= #0; END;
      Anzeige:= Trim (s);
      t1:= #13;
    END;

    VGAColorOff;
    TextAttr:= 7; ClrScr;
    If ClipBoard.ClipEnd<>0 Then WriteBinClip (ClipBuffer, ClipBoard.ClipEnd);
  END;
END;


BEGIN
  ClrScr;
  GetParams;
  CASE Befehl Of
    Del  : BEGIN EraseLine; If SubMen Then DelSubMenu; END;
    Edit : BEGIN
             ReadOldMen (EdMen);
             EditMen (EdMen);
             If t1=#13 Then
             BEGIN
               EraseLine;
               If SubMen Then
               CASE pos ('GOTO ', UpStr (Edmen.Befehl1)) Of
                 0 : DelSubMenu;
                 1 : If UpStr (Trim (copy (  Men.Befehl1, 6, 255)))
                     <> UpStr (Trim (copy (EdMen.Befehl1, 6, 255)))
                     Then DelSubMenu;
               END;
               If LineNum>0 Then dec (LineNum);
               InsertLine (EdMen);
             END;
           END;
    Neu  : BEGIN
             Fillchar (EdMen, SizeOf (EdMen), 0);
             EdLen:= 0;
             EditMen (EdMen);
             If t1=#13 Then InsertLine (EdMen);
           END;
  END;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
