PROGRAM Move;
{$M 65000, 1024, 140000}

USES
  DOS, Strings, BiosCrt, masken, keycode, LogFile, filecopy, Disk, WildCard,
  ErrorStr, DblFile;

TYPE
  ErrStr      = String[34];

CONST
  ProgName    = 'MOVE';
  t           : Char    = #0;
  Abfrage     : Boolean = TRUE;
  ImmerFragen : Boolean = FALSE;
  Rekursiv    : Boolean = TRUE;
  Verify      : Boolean = FALSE;
  Dateien     : LongInt = 0;
  SuchPfad    : PathStr = '';
  ZielPfad    : PathStr = '';
  Result      : Word    = 0;

  CreateEmptyFolders : Boolean = FALSE;

VAR
  Objekt, Quelle, Ziel, VZiel,
  ParStr     : String;
  sr         : Searchrec;
  PStat      : Byte;
  DelTarget  : Boolean;
  Files      : DoubleFileRec;

LABEL
  Ende;


PROCEDURE Hilfe;
BEGIN
  Standardkopf (ProgName, Copyright);
  DosLnLF
   ('Verschieben/Umbenennen von Dateien und Verzeichnissen'#13#10#13#10+
    'MOVE [Quelle] [Zielpfad] [/y | /-y /f]'#13#10#13#10+
    '/y   berschreibt im Ziel existierende Dateien ohne Rckfrage');
  DosLnLF
   ('/-y  fragt, ob eine bereits existierende Datei berschrieben werden soll'#13#10+
    '/f   fragt bei jeder Datei, ob sie verschoben werden soll'#13#10+
    '/o   wie /y, Fehler werden aber in der LOG-Datei protokolliert');
  DosLnLF
   ('/v   vergleicht Quell- und Zieldatei bei laufwerksbergreifendem Verschieben');
  Blindstop; Halt (1);
END;


PROCEDURE SimHalt (txt : String);
BEGIN
  DosLnLF ('');
  Simplehaltlog (txt);
END;


PROCEDURE Tastenfrage (s : String);
BEGIN
  DosLnLF (s);
  REPEAT
    t:= UpReadBKey;
    If t=#13 Then t:= 'J';
  UNTIL pos (t, 'JNA'#27)<>0;
  If t=#27 Then Simhalt ('Abbruch durch Anwender');
  DosLnLF ('');
END;


VAR
  ZielExist   : Byte;


PROCEDURE CheckIfZielExist;
VAR
  zsr : SearchRec;
BEGIN
  FindFirst (Ziel, Normalfile, zsr);
  If DOSError<>0 Then ZielExist:= 0 Else
  If zsr.attr and directory<>0 Then ZielExist:= Ver Else ZielExist:= Dat;
END;


PROCEDURE FileMove;
VAR
  CopyParams : Word;

BEGIN
  If Immerfragen Then
  BEGIN
    Tastenfrage ('Datei verschieben?  <j>a  <n>ein  <a>lle  <Esc>Abbruch');
    If t='N' Then Exit;
    If t='A' Then ImmerFragen:= FALSE;
  END;

  If (ZielExist=Dat) and (Abfrage) Then
  BEGIN
    Tastenfrage ('Datei existiert schon. Trotzdem verschieben? <j>a  <n>ein  <a>lle  <Esc>Abbruch');
    If t='N' Then Exit;
    If t='A' Then Abfrage:= FALSE;
  END;

  AssignFiles (Files, Quelle, Ziel);
  If Verify Then SetDFVerifyFlag (Files);

  CopyParams:= 0;
  If DelTarget       Then CopyParams:= CopyParams or EraseTargetFile;
  If ZielExist = Dat Then CopyParams:= CopyParams or DestFileExist Else
                          CopyParams:= CopyParams or DestFileNotExist;
  SetDFParameter (Files,  CopyParams);

  MoveFile (Files);
  Result:= abs(IOResult);
  If Result<>0 Then
  BEGIN
    If Result=1003 Then BEGIN DelTarget:= FALSE; Result:= 0; END Else
            { ^ Quelllaufwerk ist schreibgeschtzt (nur bei laufwerksbergreifendem Verschieben !) }
    Simhalt (ExtIOResultStr (Result));
  END;
  inc (Dateien);
END;


PROCEDURE MoveFolderContent (Suchpfad, VZiel : PathStr);
VAR
  sr          : SearchRec; { mu hier drin bleiben }
  FolderEmpty : Boolean;   { "" }
LABEL
  Ende;
BEGIN
  Findfirst (BuildPath (Suchpfad, '*.*'), Normalfile and not directory, sr);
  If DOSError>=150 Then SimHalt (IOResultStr (DOSError));

  FolderEmpty:= TRUE;
  While DOSError = 0 Do
  BEGIN
    If FileMatch (sr.name, Objekt) Then
    BEGIN
      Quelle:= BuildPath (Suchpfad, sr.name);
      Ziel  := BuildPath (VZiel,    sr.name);

      DosLnLF (Quelle);

      CheckIfZielExist;
      If ZielExist=Ver Then Simhalt (ExtIOResultStr (1001));

      FileMove;
      If t='N' Then FolderEmpty:= FALSE;
      If (KeyPressed) and (UpReadBKey=#27) Then Simhalt ('Abbruch durch Anwender');
    END Else
    FolderEmpty:= FALSE;
    Findnext (sr);
  END;

  If not Rekursiv Then Goto Ende;

  Findfirst (BuildPath (Suchpfad, '*.*'), NormalFile, sr);
  While DOSError = 0 Do
  BEGIN
    If (sr.attr and directory<>0) and (sr.name[1]<>'.') Then
    BEGIN
      Quelle:= BuildPath (Suchpfad, sr.name);
      Ziel  := BuildPath (VZiel,    sr.name);

      CheckIfZielExist;
      If ZielExist<>Dat Then
      BEGIN
        If (CreateEmptyFolders) and (ZielExist=0) Then
        BEGIN
          MkDir (Ziel);
          If InOutRes<>0 Then Simhalt (IOResultStr (IOResult));
        END;

        MoveFolderContent (Quelle, Ziel);

      END Else
      Simhalt (ExtIOResultStr (1002));
    END;

    FindNext (sr);
  END;

Ende:
  If DelTarget and FolderEmpty Then
  BEGIN RmDir (SuchPfad); InOutRes:= 0; END;
END;


PROCEDURE CheckParStr;
BEGIN
  CASE ParStr[2] Of
    '-' : If ParStr[3]='Y' Then AbFrage:= True;
    'Y' : Abfrage := False;                 
  END;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4;

BEGIN
  t2:= #0;
  a1:
  EditStr (1, Suchpfad, 'Verzeichnis oder Dateien, die verschoben werden sollen:');
  SuchPfad:= UpStr (SuchPfad);

  a2:
  EditStr (6, ZielPfad, 'Verzeichnis, in das die Dateien verschoben werden sollen:');
  If t2=Up Then Goto a1;
  ZielPfad:= UpStr (ZielPfad);

  a3:
  ParamField (11, Abfrage,   'fragt, ob eine bereits existierende Datei berschrieben werden soll');
  If t2=Up Then Goto a2;

  a4:
  ParamField (12, Immerfragen, 'fragt bei jeder Datei, ob sie verschoben werden soll');
  If t2=Up Then Goto a3;

  If (ee=0) and (Suchpfad='') Then
  BEGIN
    Tastenabfrage ('Ungltige Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
  If (ee=0) and (Zielpfad='') Then
  BEGIN
    Tastenabfrage ('Ungltige Verzeichnisangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a2 END Else UserAbort;
  END;
END;



PROCEDURE Maske;
BEGIN
  SuchPfad:= FileExpand (''); ZielPfad:= SuchPfad;
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  Window (1, 1, 80, 25);
  ClrScr;
END;



PROCEDURE Parameter;
VAR
  x : Byte;
BEGIN
  StretchParam (ParStr);
  ParStr:= UpStr (GetEnv ('COPYCMD'));
  If ParStr<>'' Then CheckParStr;

  If ParamCount = 0 Then Maske Else
  For x:= 1 To ParamCount Do
  BEGIN
    ParStr:= UpStr (ParamStr (x));
    If ParStr[1]= '/' Then
    BEGIN
      CheckParStr;
      CASE ParStr[2] Of
        '?' : Hilfe;
        'F' : Immerfragen:= TRUE;
        'O' : LogStatus  := 0;
        'V' : Verify     := TRUE;
        'E' : CreateEmptyFolders:= TRUE;
      END;
    END Else
    BEGIN
      If SuchPfad='' Then Suchpfad:= ParStr Else
      If ZielPfad='' Then ZielPfad:= ParStr;
    END;
  END;
  If LogStatus = 0 Then BEGIN Immerfragen:= FALSE; Abfrage:= FALSE; END;

  If (Suchpfad='') or (Zielpfad='') Then SimpleHaltLog ('Pfadangaben unvollstndig');

  If pos ('*', SuchPfad) = 0 Then
  BEGIN      
    If (Length(Suchpfad)<=3) and (Suchpfad[2]=':') Then
    Suchpfad:= BuildPath (SuchPfad, '*.*') Else
    BEGIN
      FindFirst (SuchPfad, normalfile, sr);
      If DOSError>=150 Then SimplehaltLog (IOResultStr (DOSError));
      If (DOSerror=0) and (sr.attr and directory<> 0) Then
      Suchpfad:= BuildPath (SuchPfad, '*.*') Else Rekursiv:= False;
    END;
  END;

  Suchpfad:= FileExpand (SuchPfad);
  If DOSError=0 Then PStat:= PathStatus (Suchpfad, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then SimplehaltLog (PathStatusStr (PStat));
  DelTarget:= Drive (Suchpfad[1]) and CDDrive = 0;

  Zielpfad:= FileExpand (Zielpfad);
  If DOSError=0 Then PStat:= PathStatus (Zielpfad, CheckZiel) Else PStat:= DOSError;
  If PStat<>0 Then SimplehaltLog (PathStatusStr (PStat));

  If Drive (Suchpfad[1]) and SubstDrive <> 0 Then ParStr:= TrueName (Suchpfad) Else ParStr:= '';
  If Drive (Zielpfad[1]) and SubstDrive <> 0 Then Objekt:= TrueName (Zielpfad) Else Objekt:= '';

  If (ParStr<>'') and (Objekt ='') and (ParStr[1]=Zielpfad[1]) Then Suchpfad:= ParStr Else
  If (Objekt<>'') and (ParStr ='') and (Objekt[1]=Suchpfad[1]) Then Zielpfad:= Objekt Else
  If (Objekt<>'') and (ParStr<>'') and (Objekt[1]=ParStr  [1]) Then
  BEGIN Zielpfad:= Objekt; Suchpfad:= ParStr; END;

  Objekt  := GetFileName (SuchPfad);
  SuchPfad:= GetPathName (SuchPfad);

  If SamePath (Suchpfad, Zielpfad, Rekursiv) Then
  SimplehaltLog ('Zyklisches Verschieben nicht mglich');

  DosLnLF ('Verschieben nach: '+ZielPfad);
END;



{----------------------------- HauptProgramm ------------------------------}

BEGIN
  DosLnLF ('');
  Parameter;  

  MoveFolderContent (Suchpfad, Zielpfad);

Ende:
  DosLnLF (''); DosNum (Dateien); DosLnLF (' Dateien verschoben nach '+ZielPfad);
  If not DelTarget Then SimpleHaltLog
  ('Quelldateien wurden nicht gelscht, da das Quelllaufwerk schreibgeschtzt ist.');
  BlindStop;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
