PROGRAM Multivol;
{$M 10000, 0, 0}
USES
  Bioscrt, Dos, Laufbalk, Disk, Strings, Masken, keyCode, rechnen,
  FileCopy, monitor, ErrorStr;

CONST
  Max          = 60000;
  gelesen      : LongInt = 0;
  geschrieben  : LongInt = 0;
  ProgName     = 'MULTIVOL';
  HeadError    = 'Der Dateikopf mit wichtigen Informationen konnte nicht angelegt werden.';
  Quelle       : PathStr = '';
  Ziel         : PathStr = '';


TYPE
  Str20 = String[20];

VAR
  DInfo         : DiskSizeRec;
  sr, tg        : Searchrec;
  FSize         : LongInt;
  x             : Byte;
  Block         : Array[1..Max] Of Byte;
  gel, ges      : Word;
  f1, f2        : File;
  Result        : Word;
  lese          : LongInt;
  InfoRec       : RECORD
                    Header : array[1..2] of Char;
                    UserStr: String[18];
                    Nam    : String[12];
                    siz    : LongInt;
                    tim    : LongInt;
                    att    : Byte;
                    onDisk : LongInt;
                    VolNr  : Word;
                    LastVol: Boolean;
                  END;
CONST
  MinDiskSpace = SizeOf (InfoRec)+1024;


PROCEDURE ClearWin;
BEGIN Window (1, 3, 80, 15); ClrScr; Window (1, 3, 80, 25); END;


PROCEDURE Taste;
BEGIN
  REPEAT
    t1:= UpReadBkey;
    If t1='N' Then t1:= #27 Else If t1='J' Then t1:=#13;
  UNTIL (t1=#13) or (t1=#27);
  ClearWin;
END;



PROCEDURE Fehlertext (s : String);
BEGIN
  Fusszeile ('Treffen Sie eine Auswahl');
  GotoXY (1, 9);
  OutStr (s);
  GotoXY (1, 9);
END;


PROCEDURE Hilfe;
BEGIN
  StandardKopf (ProgName, Copyright);
  DosLnLF (
   'Verteilt eine Datei beim Kopieren auf mehrere Disketten.'#13#10#13#10+
   'MULTIVOL [Quelldatei] [Ziellaufwerk] [Kennwort]'#13#10#13#10+
   '[Quelldatei]'#13#10+
   'Name der Quelldatei. Wildcards (*, ?) sind nicht erlaubt.'#13#10);
  DosLnLF (
   '[Ziellaufwerk]'#13#10+
   'Laufwerksbuchstabe - die Angabe eines Unterverzeichnisses wird ignoriert.'#13#10+
   'Die Diskette mu NICHT leer sein. Fehlt Ziellaufwerk, verwendet MULTIVOL das'#13#10+
   'aktuelle Laufwerk.'#13#10);

  DosLnLF (
   '[Kennwort]'#13#10+
   'max. 18-stelliges Kennwort, mit dem alle Dateiteile gekennzeichnet werden'#13#10+
   'sollen. Fehlt Kennwort, legt MULTIVOL ein Zufallswort fest. Damit ist die'#13#10+
   'zweifelsfreie Zuordnung der einzelnen Dateiteile beim Zusammensetzen');

  DosLnLF ('gewhrleistet.'#13#10#13#10+
   'Um eine zerlegte Datei wieder zusammenzusetzen, verwenden Sie das Programm'#13#10+
   'ADDVOL.EXE.');

  BlindStop; Halt;
END;



PROCEDURE OpenQFile;
BEGIN
  REPEAT
    Filemode:=0;
    Assign (f1, Quelle); FileMode:= 0;
    Reset  (f1, 1);
    If InOutRes<>0 Then
    BEGIN
      TastenAbfrage ('Die Quelldatei konnte nicht geffnet werden. Nochmal versuchen? j/n',
      'J', 'N');
      If t1='N' Then UserAbort;
    END;
  UNTIL IOResult=0;
  FSize:= FileSize(f1);
END;


PROCEDURE OpenZFile;
VAR
  st     : String[4];
  y      : Word;
  Okay   : Boolean;
  sx     : SearchRec;
  Result : Word;

LABEL
  Nochmal;

BEGIN
  inc (InfoRec.VolNr);
  st:= StrVal (InfoRec.VolNr);
  While Length (st) < 4 Do Insert ('0', st, 1);
  st[1]:='.';

  Okay:= FALSE;
  REPEAT
    Nochmal:
    FindFirst (Ziel+st, Normalfile, sr);
    If DOSerror=0 Then
    BEGIN
      If sr.attr and directory <> 0 Then
      BEGIN
        Tastenabfrage
       ('Gleichnamiges Verzeichnis im Ziel. Diskette wechseln und ENTER oder Esc=Abbruch',
        #13, #27);
        If t1=#27 Then UserAbort;
      END Else
      BEGIN
        Fehlertext (
        'Im Ziel existiert bereits eine gleichnamige Datei. Entweder'#13#10+
        '- Diskette wechseln und dann ENTER drcken oder'#13#10+
        '- Datei mit ENTER berschreiben lassen oder'#13#10+
        '- mit ESC abbrechen');
        Taste;
        If t1=#27 Then UserAbort;

        FindFirst (Ziel+st, Normalfile, sx);
        If DOSError<>0 Then Okay:=TRUE Else
        If (sx.attr=sr.attr) and (sx.time=sr.time) and (sx.size=sr.size) Then
        BEGIN
          REPEAT
            EraseFile (Ziel+st); Result:= IOResult;
            If Result<>0 Then
            BEGIN
              Tastenabfrage ('Ziel: '+IOResultStr (Result)+'. Nochmal versuchen? j/n', 'J', 'N');
              If t1='N' Then UserAbort;
            END;
          UNTIL Result=0;
          Okay:= TRUE;
        END Else Goto Nochmal;
      END;
    END Else Okay:= TRUE;
  UNTIL Okay;

  REPEAT
    GetDiskSize (DosDriveNum(Ziel[1]), DInfo);
    If IOResult<>0 Then
    BEGIN
      Tastenabfrage
      ('Datentrger fehlt. Diskette einlegen und ENTER drcken oder mit Esc abbrechen.', #13, #27);
      DInfo.Free:=-1;
    END Else
    If DInfo.Free < MinDiskSpace Then
    BEGIN
      Tastenabfrage
      ('Zu wenig Platz auf Diskette. Wechseln und ENTER drcken oder mit Esc abbrechen.', #13, #27);
      If t1=#27 Then UserAbort;
    END;
  UNTIL DInfo.Free >= MinDiskSpace;

  REPEAT
    Assign  (f2, Ziel+st);
    Rewrite (f2, 1);
    If InOutRes<>0 Then
    BEGIN             
      Tastenabfrage ('Ziel: '+IOResultStr (InOutRes)+'. Nochmal versuchen? j/n', 'J', 'N');
      If t1='N' Then UserAbort;
    END;
  UNTIL IOResult=0;

  With InfoRec, tg Do
  BEGIN
    Header:='AO';
    Nam:=Name; Siz:=Size; Tim:=Time; Att:=Attr;
    onDisk:= 0;
  END;

  BlockWrite (f2, InfoRec, SizeOf (InfoRec), y);
  If (IOResult<>0) or (y<> SizeOf (InfoRec)) Then
  ErrorHalt (HeadError);
  dec (DInfo.Free, SizeOf (InfoRec));
END;



PROCEDURE Kopieren;
BEGIN
  Fusszeile ('Kopiere Datei-Teil...   (Abbruch mit Esc)');
  GotoOldPos;

  REPEAT
    Lese:=DInfo.Free;   { von OpenZFile ermittelt }
    If Lese>Max Then Lese:=Max;

    Blockread  (f1, Block, Lese, gel);
    Result:= IOResult; If Result<>0 Then Exit;

    If gel>0 Then
    BEGIN
      BlockWrite (f2, Block, gel, ges);
      Result:= IOResult; If Result<>0 Then Exit;
      inc (gelesen, gel); inc (Geschrieben, ges);
      inc (InfoRec.onDisk, ges);
      dec (DInfo.Free, ges);
    END Else ges:=0;

    CursorOff;
    Balken (18, gelesen, FSize);
    Balken (15, DInfo.Size-DInfo.Free, DInfo.Size);
    GotoXY (1, 1);
    OutStr ('Dateigre...: '); OutStr (StretchStr(TausPkt(FSize), 14));             OutLnLF (' Byte');
    OutStr ('Kopiert......: '); OutStr (StretchStr(TausPkt(gelesen), 14));           OutLnLF (' Byte');
    OutStr ('Noch offen...: '); OutStr (StretchStr(TausPkt(FSize-geschrieben), 14)); OutLnLF (' Byte'#13#10);
    OutStr ('Disketten-Nr.: '); OutStr (StretchStr(StrVal(InfoRec.VolNr), 14));     OutLnLF ('');
    OutStr ('Speicherplatz: '); OutStr (StretchStr(TausPkt(DInfo.Free), 14));        OutStr  (' Byte');
    ClrEol;
    CursorOn;
    If (keypressed) and (UpReadBKey=#27) Then
    BEGIN XClose(f1); XClose(f2); UserAbort; END;

  UNTIL (gel=0) or (ges<>gel) or (geschrieben=FSize) or (DInfo.Free=0);
END;



PROCEDURE DiskWechseln;
VAR
  ges : Word;
BEGIN
  InfoRec.LastVol:= (geschrieben=FSize);

  If (Result=101) or (Dinfo.Free=0) or (geschrieben=FSize) Then
  BEGIN
    Result:= 0;
    Seek (f2, 0);
    BlockWrite (f2, InfoRec, SizeOf (InfoRec), ges);
    If (IOResult<>0) or (ges<> SizeOf (InfoRec)) Then
    BEGIN XClose (f1); ErrorHalt (HeadError); END;

    Close (f2); Result:= IOResult;

    If geschrieben<>FSize Then
    BEGIN
      Fehlertext (
      'Der Datentrger ist voll. Legen Sie die nchste Diskette ein und'#13#10+
      'drcken Sie ENTER fr Fortfahren oder ESC fr Abbrechen.');
      Taste;
      If t1=#27 Then BEGIN XClose (f1); UserAbort; END;
    END;
  END;
  If Result<>0 Then
  BEGIN XClose(f1); XClose(f2); ErrorHalt ('Fehler: '+IOResultStr (Result)); END;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3;
VAR
  s : PathStr;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Quelle, 'Name der Datei, die auf mehrere Disketten verteilt werden soll:');

  a2:
  EditStr (6, Ziel,   'Laufwerk, zu dem die Datei kopiert werden soll:');
  If t2=Up Then Goto a1;

  a3:
  s:= '';
  If ee=1 Then
  BEGIN
    GotoXY (1, 11);
    OutLnLF (
    'Kennwort, mit dem alle Dateiteile zur eindeutigen Zuordnung markiert werden'#13#10+
    'sollen. Diese Eingabe ist freiwillig. Fehlt das Kennwort, legt MULTIVOL ein'#13#10+
    'Zufallswort fest. Vorsicht: Sie drfen ein Kennwort nicht doppelt vergeben!');
  END;
  EditStr (15, s, 'Ihr Kennwort (bercksichtigt werden die ersten 18 Zeichen):');
  If t2=Up Then Goto a2;
  InfoRec.UserStr:= s;

  If (ee=0) Then
  If (Quelle='') or (Quelle[Length(Quelle)]='\') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname der Quelldatei. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END
  Else
  If Ziel='' Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then
    BEGIN Fusszeile (EingabeHilfe); Goto a2 END Else UserAbort;
  END;
  Quelle:= UpStr(Quelle);
  Ziel  := UpStr(Ziel);
END;



PROCEDURE Parameter;
VAR
  x     : Byte;
  Param : String;
  PStat : Word;
BEGIN
  Fillchar (InfoRec, SizeOf (InfoRec), 0);
  If ParamCount = 0 Then
  BEGIN
    Ziel:= 'A:'; Quelle:= FExpand ('');
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  END Else

  For x:= 1 To ParamCount Do
  BEGIN
    Param:= ParamStr (x);
    If Param[1] = '/' Then
    CASE Param[2] Of
      '?' : Hilfe;
    END Else
    BEGIN
      If Quelle          = '' Then Quelle          :=  UpStr (Param) Else
      If Ziel            = '' Then Ziel            :=  UpStr (Param) Else
      If InfoRec.UserStr = '' Then InfoRec.UserStr :=  Param Else
         InfoRec.UserStr:=         InfoRec.UserStr+' '+Param;
    END;
  END;
  If Length (InfoRec.UserStr) <= 2 Then
  BEGIN
    Randomize;
    For x:= Length (InfoRec.UserStr)+1 To 18 Do
    InfoRec.UserStr[x]:= chr (Random (26)+65);
    InfoRec.UserStr[0]:= #18;
  END;
  
  Standardkopf (ProgName, '');
  Fusszeile ('Kopieren wird vorbereitet... (Abruch mit Esc)');
  GotoOldPos;

  If Ziel='' Then Ziel:= Fexpand (''); Ziel:= Ziel[1]+':\';
  PStat:= PathStatus (Ziel, CheckZiel);
  If PStat<>0 Then ErrorHalt (PathStatusStr (PStat));
  Ziel:= Ziel[1]+':\VOLUME';

  Quelle:= FileExpand (Quelle);
  If DOSError=0 Then PStat:= PathStatus (Quelle, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then ErrorHalt (PathStatusStr (PStat));

  FindFirst (Quelle, Normalfile, tg);
  If DOSError<>0 Then
  BEGIN
    If DOSError>=150 Then ErrorHalt (IOResultStr (DosError)) Else
    ErrorHalt ('Quelldatei nicht gefunden');
  END Else
  If tg.attr and directory <> 0 Then
  ErrorHalt ('Quell-Datei ist ein Verzeichnis und kann nicht kopiert werden.');
END;



BEGIN
  Parameter;
  Unterbalken (18, 'insgesamt kopiert'); GotoXY (1, 1);
  InfoRec.VolNr:=0; 
  OpenQFile;

  REPEAT
    ClearWin;
    Unterbalken  (15, 'auf Diskette belegt'); GotoXY (1, 1);
    OpenZFile;
    Kopieren;
    DiskWechseln;
  UNTIL (FSize = geschrieben);

  XClose (f1);
  Errorhalt ('Datei erfolgreich auf Disketten verteilt.');
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
