UNIT Monitor;

INTERFACE

USES
  crt;


CONST
  MonoMon = 1;
  FarbMon = 2;


VAR
  ScrMode : Byte;
  VideoAddr  : Word;
  VideoMode  : Byte absolute $0040:$0049;


PROCEDURE CursorOn;
PROCEDURE CursorOff;

PROCEDURE ClearWin (a, b, c, d, e    : Byte);
PROCEDURE Rahmen   (a, b, c, d, h, t : Byte);
PROCEDURE Schatten (a, b, c, d       : Byte);

PROCEDURE x50_Zeilen;
PROCEDURE x25_Zeilen;
PROCEDURE GetScreen;
PROCEDURE SetScreen;
PROCEDURE WriteXY (x, y : byte; S  : String; VColor, HColor : Byte);
PROCEDURE ChangeBackColor (x, y, z : byte; HColor : Byte);
PROCEDURE CharXY  (x, y : byte; ch : char;   VColor, HColor : Byte);
PROCEDURE GetSign (x, y: Byte; VAR Zeich: Char; VAR Attri: Byte);
PROCEDURE SetBackColor (x, y, z1, z2 : Byte);


IMPLEMENTATION

VAR
  screen     : Pointer;
  CurA, CurE : Byte;
  ScrArrSize : Word;


PROCEDURE CursorOff; Assembler;
ASM
  mov ah, 1
  mov ch, 40
  mov cl, 40
  int $10
END;


PROCEDURE CursorOn; Assembler;
ASM
  mov ah, 1
  mov ch, CurA
  mov cl, CurE
  int $10
END;


PROCEDURE ClearWin (a, b, c, d, e : Byte);
BEGIN
  TextAttr:=e; Window (a, b, c, d); ClrScr;
END;


PROCEDURE Rahmen (a, b, c, d, h, t : Byte);
VAR
  x, r, s : Byte;

BEGIN
  If ScrMode=FarbMon Then
  BEGIN If t=1 Then BEGIN r:= 8; s:=15; END Else BEGIN r:=15; s:= 8; END; END Else
  BEGIN If h=7 Then BEGIN r:= 0; s:= 0; END Else BEGIN r:= 7; s:= 7; END; END;

  CharXY (a, b, #218, r, h); 
  CharXY (c, b, #191, s, h);
  CharXY (a, d, #192, r, h); 
  CharXY (c, d, #217, s, h);

  For x:= succ(a) To pred(c) Do
  BEGIN CharXY (x, b, #196, r, h); CharXY (x, d, #196, s, h); END;

  For x:= succ(b) To pred(d) Do
  BEGIN CharXY (a, x, #179, r, h); CharXY (c, x, #179, s, h); END;

  inc (a); dec (c); dec (d); inc (b);
  ClearWin (a, b, c, d, h shl 4);
  Window (succ(a), b, pred(c), d);
END; 


PROCEDURE Schatten (a, b, c, d : Byte);
VAR
  x : Byte;
BEGIN
  inc(a); inc(b); inc(c); inc (d);
  For x:= b To d Do SetBackColor (c, x, 8, 0);
  If ScrArrSize=4000 Then
  BEGIN inc (c); For x:= b To d Do SetBackColor (c, x, 8, 0); END;
  For x:= a To c Do SetBackColor (x, d, 8, 0);
END;


PROCEDURE x50_Zeilen;
BEGIN
  Textmode (CO80+Font8x8);
  CursorOff;
  directvideo:= true;
  checksnow  := false;
  ScrArrSize := 8000;
END;


PROCEDURE x25_Zeilen;
BEGIN
  Textmode (CO80);
  directvideo:= true;
  Checksnow  := false;
  ScrArrSize := 4000;
END;


PROCEDURE GetScreen;
BEGIN
  GetMem (Screen, ScrArrSize);
  Move (Mem[VideoAddr:0000], screen^, ScrArrSize);
END;


PROCEDURE SetScreen;
BEGIN
  Move (screen^, Mem[VideoAddr:0000], ScrArrSize);
  Freemem (Screen, ScrArrSize);
END;


PROCEDURE WriteXY (x, y : byte; S : String; VColor, HColor : Byte);
VAR
  a, t, c : Byte;
  b : Word;
BEGIN
  If (x<1) or (y<1) or (y>50) Then Exit;
  a:= Hcolor shl 4 + Vcolor;
  b:= (x shl 1)+(y*160)-162;
  c:= ord(s[0]);
  For t:=1 To c Do
  BEGIN
    Mem[VideoAddr : b]:= Ord (s[t]); inc (b);
    Mem[VideoAddr : b]:= a;          inc (b);
  END;
END;


PROCEDURE ChangeBackColor (x, y, z : byte; HColor : Byte);
VAR
  t : Byte;
  b : Word;
BEGIN
  b:= (x shl 1)+(y*160)-161;
  For t:=1 To z Do
  BEGIN
    Mem[VideoAddr : b]:= (Mem[VideoAddr : b] mod 16) + (HColor shl 4); inc (b, 2);
  END;
END;


PROCEDURE CharXY (x, y : byte; ch : char; VColor, HColor : Byte);
VAR
  a : Byte;
  b : Word;
BEGIN
  If (x<1) or (y<1) or (y>50) Then Exit;
  a:= Hcolor shl 4 + Vcolor;
  b:= (x shl 1)+(y*160)-162;
  Mem[VideoAddr : b]:= Ord (ch); inc (b);
  Mem[VideoAddr : b]:= a;        
END;


PROCEDURE GetSign (x, y: Byte; VAR Zeich: Char; VAR Attri: Byte);
VAR
  b : Word;
BEGIN
  b:= (x shl 1)+(y*160)-162;
  Zeich:= Chr (Mem[VideoAddr : b]); inc (b);
  Attri:=      Mem[VideoAddr : b];
END;


PROCEDURE SetBackColor (x, y, z1, z2 : Byte);
VAR
  b : Word;
BEGIN
  b:= (x shl 1)+(y*160)-161;
  Mem[VideoAddr : b]:=z2 shl 4 + z1;
END;


{---------- Initialisierung (Feststellen der Videoadresse im RAM ----------}


BEGIN
  If videoMode= 7 Then
  BEGIN VideoAddr:=$B000; ScrMode:=MonoMon; curA:=12; CurE:=13; END Else
  BEGIN VideoAddr:=$B800; ScrMode:=FarbMon; curA:=6;  CurE:=7;  END;

  If LastMode= CO80+Font8x8 Then
  ScrArrSize:= 8000 Else ScrArrSize:= 4000;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
