

jmp BEGIN

.include output, param, hexbin

.insert copyrigh


PROC GetPortAddr: / ComP PAR 2
BEGP
  push es, bx
  mov  ax, 0040h
  mov  es, ax
  mov  bx, ComP
  dec  bx
  cmp  bx, 7
  jbe  @weiter
  mov  bx, 7
  @weiter:
  add  bx, bx
  mov  ax, es:[bx]       ; Portadresse holen
  pop  bx, es
  ret
ENDP
; Ausgabe in AX


PROC SetPortAddr: / ComP PAR 2 / PortAddr PAR 2
BEGP
  push es, ax, bx
  mov  ax, 0040h
  mov  es, ax
  mov  bx, ComP
  dec  bx
  cmp  bx, 7
  jbe  @weiter
  mov  bx, 7
  @weiter:
  add  bx, bx
  mov  ax, PortAddr
  mov  es:[bx], ax       ; Portadresse schreiben
  pop  bx, ax, es
  ret
ENDP


PROC DezHex: / InWord PAR 2 / OutStr PAR 2
BEGP
  push ax, si
  mov  ax, InWord
  mov  si, OutStr
  #WordHex (ax, si)
  mov  ax, [si]
  mov [si], ah
  mov  ax, [si+2]
  mov [si+1], ax
  mov  Byte [si+3], 0     ; erstes Zeichen gelscht
  pop  si, ax
  ret
ENDP

Baud DD 115200

PROC GetBaudrate: / Base PAR 2 / BaudRate PAR 2
BEGP
  push ax, bx, dx
  mov  dx, Base
  or   dx, dx
  jz   @BXNull
  add  dx, 3
  in   al, dx
  push ax
  or   ax, 80h
  out  dx, al
  sub  dx, 3
  in   al, dx
  mov  bl, al
  xor  bh, bh
  inc  dx
  in   al, dx
  shl  ax, 8
  add  bx, ax
  add  dx, 2
  pop  ax
  out  dx, al 

  or   bx, bx
  jz   @BXNull
    #LongDiv (Baud^, bx, BaudRate)
    jmp short @raus
  @BXNull:
    push di
    mov  di, Baudrate
    xor  ax, ax
    stosw
    stosw            ; Baudrate = 0
    pop  di
  @raus:
  pop dx, bx, ax
  ret
ENDP


AddrStr DB '3F8',0,'2F8',0,'3E8',0,'2E8',0,'378',0,'278',0,'?  ',0,'?  ',0
Head    DB 'Name     ist    kann   Baudrate', 0 
COM     DB 'COM', 0
LPT     DB 'LPT', 0
Leer    DB '    ', 0
Strich  DB '-------------------------------',0
 

PROC Write_All_PortAddrs:
BEGP
  push ax, bx, cx, si
  #DosLn (Strich^)
  lea  si, AddrStr
  mov  cx, 4
  xor  bx, bx
  @COM:
    inc bx
    #DosStr (COM^) / #DosChar (' ')
    mov ax, bx
    add ax, 48
    #DosChar (ax)
    #DosStr  (Leer^)
    #GetPortAddr (bx)     ; PortAdresse in AX 
    #DezHex  (ax, Head^)
    #DosStr  (Head^)
    #DosStr  (Leer^)
    #DosStr  (si)
    add si,  4
    #DosStr  (Leer^)
    #GetBaudRate (ax, Head^)
    #DosNumLn (Head^)
  loop @COM
  #DosLineFeed

  mov cx, 4
  @LPT:
    inc bx
    #DosStr (LPT^) / #DosChar (' ') 
    mov ax, bx
    add ax, 44
    #DosChar (ax)
    #DosStr  (Leer^)
    #GetPortAddr (bx)     ; PortAdresse in AX 
    #DezHex  (ax, Head^)
    #DosStr  (Head^)
    #DosStr  (Leer^)
    #DosStr  (si)
    add si, 4 
    #DosStr  (Leer^)
    #DosChar ('-')
    #DosLinefeed
  loop @LPT
  pop  si, cx, bx, ax
  ret
ENDP


PROC HexDez: / InHexStr PAR 2
BEGP
  push bx, cx, dx, si
  mov  si, InHexStr
  inc  si
  #Length (si)
  mov  bx, ax
  or   bx, bx
  jz   @error
  dec  ax
  add  si, ax
  std
  xor  dx, dx
  xor  cx, cx
  @loop:
    lodsb
    cmp al, '0' / jb  @error
    cmp al, '9' / jbe @los
    cmp al, 'F' / ja  @error
    cmp al, 'A' / jb  @error
    sub al, 7
    @los:
    sub al, 48
    xor ah, ah
    shl ax, cl
    add dx, ax
    add cx, 4
    dec bx
  jnz @loop

  xchg ax, dx        ; mov ax, dx
  clc
  @ende:
  pop  si, dx, cx, bx
  cld
  ret
  @error:
  stc
  jmp  short @ende
ENDP


ComNum1  DW 0
ComNum2  DW 0
Par1     DW ?        ; Stringoffset !
Par2     DW ?        ;  "  "
ShowPar  DB '/S', 0
Tausch   DB 13,10,'Getauscht',0
 
BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt 
  lea ax, &EndOfProgram
  mov Par1, ax
  add ax, 256
  mov Par2, ax

  #ParamStr (1, Par1) / #UpCaseStr (Par1, Par1)
  #ParamStr (2, Par2) / #UpCaseStr (Par2, Par2) 
 
  #StrPos (LPT^, Par1)
  or  ax, ax              ; String "LPT" gefunden ?
  jnz @found
  #StrPos (COM^, Par1)
  or  ax, ax              ; String "COM" gefunden ?
  jnz @found
  #StrPos (ShowPar^, Par1)
  or  ax, ax              ; String "/S" gefunden ?
  jz  @Hilfe
    #DosLn (Head^);
    jmp @wech
  @Hilfe:
    #DosLn (&Hilfe^)
    jmp @raus
  @Found:

  mov bx, Par1 / mov al, [bx+3] / sub al, 48 / mov ComNum1, al
  #StrPos (LPT^, Par1)
  cmp ax, 1 / jne @notLPT / add Byte ComNum1, 4 / @notLPT:

  #DosLn (Head^);
  #Write_All_PortAddrs
 
  mov bx, Par2
  #Length (bx)
  or  ax, ax
  jnz @ab
  @err:
    #DosStr (&ParFehlt^) 
    jmp @raus
  @ab:

  cmp Byte [bx], '$'
  je  @Zuweisen

    #StrPos (LPT^, Par2)
    or  ax, ax                ; String "LPT" gefunden ?
    jnz @Los
      #StrPos (COM^, Par2)
      or  ax, ax              ; String "COM" gefunden ?
      jz @err
    @Los:

    mov bx, Par2 / mov al, [bx+3] / sub al, 48 / mov ComNum2, al
    #StrPos (LPT^, Par2)
    cmp ax, 1 / jne @notLPTx / add Byte ComNum2, 4 / @notLPTx:

    #GetPortAddr (ComNum1)
    mov bx, ax
    #GetPortAddr (ComNum2)
    #SetPortAddr (ComNum1, ax)
    #SetPortAddr (ComNum2, bx)
    jmp short @Tausch

@Zuweisen:
  #HexDez (Par2)
  jnc @Okay
    #DosStr (&Error^) 
    #DosStr (Par2)
    jmp short @raus
  @Okay:
  #SetPortAddr (ComNum1, ax);
 
@Tausch:
  #DosLn (Tausch^)
@wech:
  #Write_All_PortAddrs
@raus:

.HALT

&Hilfe DB 13,10
> 'PORTSWAP   ', Copyright,13,10
> 'zeigt/ndert die Port-Adressen der seriellen und parallelen Schnittstellen',13,10,13,10
> 'PORTSWAP [Port1] [Port2 | Portadresse]',13,10,13,10
> 'Als [Port1..2] sind COM1 bis COM4 und LPT1 bis LPT4 mglich. Wenn Sie als Port2',13,10
> 'eine Schnittstellenbezeichnung (z.B. COM2) angeben, werden die Portadressen',13,10
> 'der beiden Schnittstellen untereinander ausgetauscht. Ist anstelle von Port2',13,10
> 'eine Adresse angeben, wird diese [Port1] zugewiesen. Diese Adresse mu in',13,10
> 'Hexadezimalschreibweise mit fhrendem $-Zeichen angegeben werden (z.B. $2F8).',13,10,13,10
> 'Beispiele',13,10
> '---------',13,10
> 'PORTSWAP Com1 Com3  -> die Portadressen von COM1 und COM3 werden vertauscht',13,10
> 'PORTSWAP Com4 $2E8  -> Com4 bekommt die Portadresse 2E8 hex zugewiesen',13,10
> 'PORTSWAP /S         -> zeigt die aktuelle Konfiguration, ohne sie zu ndern',13,10,0

&Error    DB 13,10, 'Zugewiesene Portadresse enthlt unerlaubte Zeichen : ',0
&ParFehlt DB 13,10, 'Zweiter Parameter fehlt oder ist ungltig. Infos mit /?', 0
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
