 
jmp BEGIN 

Generation      DB  1      ; GenerationsNummer des Treibers 
DB                  3      ; Treiber-Nummer 
DB                  1,0    ; interne Nummer (vom Programmierer frei whlbar) 
DB                  17h    ; Nummer eines der umgeleiteten Interrupts 
DB                  1      ; Zahl der erwarteten Start-Parameter
Flag            DB  0

.even
BufSize         DW  60000  ; Norm-Gre des Puffers
WritePtr        DW  0      ; Zeiger der Empfangsroutine
ReadPtr         DW  0      ; Zeiger der Druckroutine
CharCounter     DW  0      ; Zahl der noch zu druckenden Zeichen
Counts          DW  16     ; Zahl der pro Timerticks zu druckenden Zeichen
OldCounts       DW  16     ; Speichert Counts zwischen
Printer         DW  0      ; Nummer des Druckers
WaitTimes       DW  256    ; Zahl der Warteschleifen bis TimeOut
Waits           DW  16     ; Zahl der tatschlich gewarteten Schleifen
LockTimer       DB  0      ; Sperrt den Timer-Interrupt
 

PROC IncBX
  inc  bx
  cmp  bx, BufSize
  jbe  @jut
  xor  bx, bx
  @jut:
  RET
ENDP

;------------------------------ Neuer Timer --------------------------------

Timer:
  pushf
  DB 9Ah                      ; Call Far Ptr = alte Timer-Routine
  OBJECT Old1C:
    Ofs DW 'NE'               ; hier setzt der Loader die alte Adresse
    Seg DW 'W!'               ; der alten Timer-Routine ein.
  OBJECT END
  push cx, ds, cs / pop ds

  mov  cx, CharCounter        ; Zahl der noch zu druckenden Zeichen
  jcxz @OldTimer              ; CX=0: kein Zeichen vorhanden
  cmp  byte Flag, 0           ; Nur Drucken, wenn aktiv
  jne  @OldTimer
  cmp  byte LockTimer, 1      ; gesperrt durch int 17h: wenn Puffer-
  je   @OldTimer              ; berlauf droht, wird dort Drucken erzwungen

  push dx, bx, si, di, ax

  mov  dx, Printer
  lea  si, &RingBuffer
  mov  bx, ReadPtr            ; Lesezeiger
  mov  di, Counts             ; Zahl der whrend eines Timer-Ticks
                              ; auszugebenden Zeichen
@PrintChar:
  push cx
  mov  cx, WaitTimes
  @warte:                     ; Wartet auf "Drucker not busy"
    mov  ah, 2
    #OldPrinter
    test ah, 00010000b        ; Online und Papier? = 00010000b
    jz   @wech                ; wenn nicht, raus
    and  ah, 10111000b        ; not Busy, Online, PaperOut
    cmp  ah, 10010000b
    je   @drucken             ; Bit 7 gesetzt, es kann also ohne
  loop @warte                 ; Verzgerung gedruckt werden
  @wech:
  pop  cx
  jmp  short @Schlu          ; TimeOut, also Schlu

@drucken:
  mov  Waits, cx              ; Wie oft mute gewartet werden ?
  pop  cx                     ; durchlaufen werden?
  mov  al, [si+bx]            ; Hole Zeichen aus Ringpuffer  
  xor  ah, ah
  #OldPrinter
  #incBX                      ; Zeiger in BX hochzhlen
  dec  cx
  jcxz @Schlu                ; CX=0: kein Zeichen mehr vorhanden
  dec  di                     ; Schleifenzhler runter
jnz @PrintChar
 
@Schlu: 
  mov ReadPtr,     bx         ; Zeiger aktualisieren
  mov CharCounter, cx

  mov bx, Waits
  cmp bx, WaitTimes
  je  CheckWait
  mov ax, OldCounts
  mov Counts, ax
  @zurck:
 
  pop ax, di, si, bx, dx

@OldTimer:
  pop  ds, cx

IRET

;---------------------- Selbstbeschleuniger --------------------------------

CheckWait:             ; Prft, ob Druck beschleunigt werden kann, wenn
                       ; Printer zu einem Emulator, also eine vorgeladene
  mov ax, 0604h        ; Printer druckt.
  #OldPrinter          ; Prfung
  not ah               ; war ah=FFh?
  jnz @zurck          ; wenn nicht, dann zurck
  or  al, al           ; vorgeladene Printer aktiv, also Flag=0? ?
  jnz @zurck          ; wenn nicht, zurck
  cmp dx, Printer      ; Drucken beide PRINTER zum gleichen Drucker?
  jne @zurck          ; wenn nicht, keine Beschleunigung
  mov Counts, bx       ; in BX ist Waittimes, also 256
jmp short @zurck 

;---------------------------- Alte Druck-Routine ----------------------------
 

OldPrinter:
  pushf                                     
  DB 9Ah                     ; Call Far Ptr = alte Print-Routine 
  OBJECT Old17:
    Ofs DW '6.'             ; hier setzt der Loader die alte Adresse
    Seg DW '24'             ; der alten Print-Routine ein.
  OBJECT END
RET


;--------------------------- Neue INT-17h-Prozedur --------------------------

PROC PRINT:
  cmp  ah, 2
  jbe  @OldFunc
    cmp  ah, 6             ; interne Funktion aufgerufen ?
    jne  @NurWeg
    cmp  al, 8             ; andere Sonder-Funktion
    jae  @NurWeg
      push ds, cs / pop ds
      cmp  al, 3
      ja   @f2                               ; setze Flag
      je   @f1
        mov Flag, al
        jmp short @iret
      @f1:                                   ; Abfrage diverser Daten
      mov  al, Flag                          ; Flag
      mov  cx, CharCounter                   ; Zeichenzahl
      mov  dx, Printer                       ; Aktueller Drucker
      mov  ah, 2 / #OldPrinter / mov bl, ah  ; Drucker-Status in BL
      mov  bh, Generation                    ; DDD-Generation
      push cs    / pop es
      jmp  short @iret
      @f2:                                   ; intern, zur Feststellung, ob
      mov  al, Flag                          ; Printer mehrmals geladen 
      mov  dx, Printer
    @iret:
    mov ah,  $FF                     ; Signal, da PRINTER installiert ist
    pop ds
    @nurweg:
    IRET
  @OldFunc:
  push dx, ds, bx, si, di, ax, cs / pop ds
  mov  bl, Flag
  or   bl, bl
  jz   @OKAY

    ;-------------------------- Unloader ----------------------------
    cmp  bl, 2                 ; Flag wird vom Unloader gesetzt,  
    jne  @UNLOAD               ; 2 = Nur alte Routine ausfhren
      @OldRoutine:
      #OldPrinter
      pop  bx
      push ax                  ; um Status auszugeben
      jmp  @GanzRaus
    @UNLOAD:

    lds  dx, Old17             ; Alte Adressen laden 
    mov  ax, 2517h             ; SetIntVec 17h
    int  21h                   ; Alte Drucker-Routine wieder einsetzen

    cs:
    lds  dx, Old1C             ; Alte Adressen laden  
    mov  ax, 251Ch             ; SetIntVec 1Ch
    int  21h                   ; Alte Timer-Routine wieder einsetzen

    mov  ah, 49h               ; Speicher von PRINT.COM wieder freigeben
    int  21h                   ; ES=CS=Segment des freizugebenden Blocks 
    jmp  @GanzRaus

  ;-------------------------- Schreibe in Puffer ---------------------------

  @OKAY:
  mov bx, CharCounter           ; Zahl der noch zu druckenden Zeichen 
  or  bx, bx
  jz  @ab
    cmp Printer, dx             ; Versuch, whrend des Druckens
    jne @OldRoutine             ; den Drucker zu wechseln
  @ab:

  cmp ah, 1 
  jne @KeinInit                 ; Init des Druckers
    xor bx, bx 
    mov WritePtr, bx 
    mov ReadPtr, bx 
    mov CharCounter, bx
    jmp short @OldRoutine
  @KeinInit:
  mov Printer, dx
  cmp bx, Bufsize               ; cmp CharCounter, Puffergre
  jb  @drucke                   ; noch kein Pufferberlauf
    mov  byte LockTimer, 1      ; Timer sperren, damit der nichts druckt
    or   ah, ah                 ; ah=0=es soll gedruckt werden
    jz @losdruck
      mov  ah, 2
      #Oldprinter
      @PrStatus:
      pop  bx                   ; Dummy
      push ax
      mov  byte LockTimer, 0    ; Timer entsperren
      jmp  short @ganzraus
    @LosDruck:
    lea  si, &RingBuffer
    mov  bx, ReadPtr            ; Lesezeiger
    push ax
    mov  al, [si+bx]            ; Hole Zeichen aus Ringpuffer  
    xor  ah, ah                 ; In DX noch Druckernummer
    #OldPrinter                 ; Zeichen zum Drucker
    test ah, 00101000b          ; Beim Drucken alles Okay ?
    jz   @klappte
      pop bx                    ; Dummy
      jmp short @PrStatus
    @klappte:
    pop  ax
    #incBX
    dec  Word [CharCounter]    
    mov  ReadPtr, bx
    mov  byte LockTimer, 0      ; Timer entsperren, darf wieder drucken
  @drucke:
  or  ah, ah                    ; ah=0=es soll gedruckt werden
  jnz @Status                   ; wenn nicht, nur Status-Flag setzen
    lea si, &RingBuffer
    mov bx, WritePtr
    mov [si+bx], al             ; Zeichen in Ringpuffer schreiben
    inc bx
    cmp bx, BufSize             ; wenn Pufferende erreicht,
    jbe @Jou
    xor bx, bx                  ; dann am Pufferanfang weitermachen
    @Jou:
    mov WritePtr, bx            ; Schreibzeiger speichern
    inc Word [CharCounter]
  @Status:
  pop  ax
  mov  ah, 10010000b            ; alles Okay
  push ax                       ; Status ausgeben

@GanzRaus: 
pop  ax, di, si, bx, ds, dx  
IRET                                     
ENDP
 
&RingBuffer DB 'AO'

ProgSize EQU ($:16+2)           ; Programmgre in Paragraphen
 

;------------------------------- Loader ------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &ProgName
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  jne  @@weiter               ; nur Leerzeichen? dann raus
  jmp  fertig
  @@weiter:
  mov  al, es:[di]            ; Zeichen nach '/' laden
  inc  di
  dec  cx                     ; Zahl der nach '/b' noch folgenden Zeichen
  mov  ah, 6                  ; Interne Funktion aufrufen vorbereitet
  and  al, 11011111b          ; UpCase

         cmp al, 'B' / je  @Laden
         cmp al, 'D' / jne @xx / mov ah, 1  / lea dx, &DelBuf  / jmp short @entladen 
  @xx: / cmp al, 'X' / jne @xs / mov al, 1  / lea dx, &Unload  / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov al, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor al, al / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push ax
  mov  ax, 3517h
  int  21h
  pop  ax
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    mov al, 1                         ; ExitCode = 1 = Error
    jmp short @out
  @ausfhren:

  push ax
  cmp  ah, 1
  jne  @notD
    #CallInt17h
  @notD:
  int  17h
  pop  ax
  cmp  ax, 0601h
  jne  @weg
    mov  ah, 2                        ; Unload anschubsen 
    #CallInt17h
  @weg:
  xor  al, al                         ; ExitCode = 0 = Okay

  @out:
  #OutPut
.HALT

PROC CallInt17h
  push dx
  es:
  mov  dx, Printer
  int  17h                          
  pop  dx
  RET
ENDP
 
@laden:
  mov  ax, es:[di]            ; AL=Puffergre, AH=Counts
  shr  cx, 1                  ; Wieviele Zeichen folgen noch?
  jc   @nur_Gre             ; nur 1, dann nur Puffergre
  jz   Fertig
         
  mov  bl, ah
  cmp  bl, '1'                ; Counts ermitteln  
  jb   @nur_gre
  cmp  bl, '9'
  ja   @nur_gre
  sub  bl, 48
  mov  cl, 4
  shl  bl, cl                 ; mul 16
  xor  bh, bh
  mov  Counts, bx             ; Counts = 16, 32, 48...144
  mov  OldCounts, bx          ; Zwischenspeicher fr Counts

  @nur_gre:
  sub  al, 48                 ; Ziffer eingelesen, nun '1' zu 1 usw.
  or   al, al                 ; al=0 ? Dann Voreinstellung 60000 Byte
  jnz  Jou   
    mov Word BufSize, 500
    jmp short Fertig
  Jou:
  cmp  al, 6                  ; grer 6(0000) Byte ?
  ja   Fertig
  mov  bx, ax
  xor  bh, bh
  mov  ax, 10000
  mul  bx                     ; Parameter mal 10000
  mov  BufSize, ax            ; Puffergre

Fertig:
  -EnvironMemFree

  lea  dx, &Load
  #Output                     ; Gebe Text aus                  
  
  mov  ax, 3517h              ; GetIntVec 17h
  int  21h                                
  mov  Old17.Ofs, bx          ; Schreibe alten Vektor in den Call-Befehl
  mov  Old17.Seg, es       
  mov  ax, 2517h              ; SetIntVec 17h
  lea  dx, Print              ; DS:DX = neue PRINT-Routine
  int  21h

  mov  ax, 351Ch              ; GetIntVec 1Ch
  int  21h                                
  mov  Old1C.Ofs, bx          ; Schreibe alten Vektor in den Call-Befehl
  mov  Old1C.Seg, es     
  mov  ax, 251Ch              ; SetIntVec 1Ch
  lea  dx, Timer              ; DS:DX = neue TIMER-Routine 
  int  21h

  push cs / pop es
  mov  bx, BufSize
  mov  cl, 4
  shr  bx, cl
  add  bx, ProgSize
  mov  ah, 4Ah
  int  21h
  jnc  @exit
    sub bx, ProgSize
    mov cl, 4
    shl bx, cl
    mov BufSize, bx
  @exit:
  
  lea  dx, BEGIN              ; = Zahl der resident zu haltenden 
                              ; Bytes - CS-Register = Segment des PSP
  add  dx, BufSize            ; Addiere gewnschte Puffergre
  int  27h                    ; Programm resident machen

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
.ifopt deu
  &ProgName  DB  'PRINTER  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &DelBuf    DB  'Druckpuffer geleert$'
  &Hilfe     DB  'ermglicht Hintergrund-Druck aus beliebigen Anwendungen (Int 17h)'
  >             13,10,13,10
  >            'Laden  : PRINTER [/bxy]',13,10
  >            'Steuern: PRINTER [/x|/s|/r|/d]',13,10,13,10
  >            '/b  x=Puffergre in 10000 Byte, y=Druckgeschwindigkeit mal 16',13,10
  >            '    z.B. /b54 -> Puffergre 50.000 Byte, 64 Zeichen pro 55 ms',13,10  
  >            '    fehlt /b, nimmt PRINTER den Parameter /b61 an',13,10,13,10
  >            '/x  aus dem Speicher entfernen',13,10
  >            '/s  stillegen',13,10
  >            '/r  reaktivieren',13,10 
  >            '/d  alle Zeichen im Druckpuffer lschen$'
.endopt

.ifopt eng
  &ProgName  DB  'PRINTER  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &DelBuf    DB  'printbuffer empty$'
  &Hilfe     DB  'Enables any applications to print files in background (Int 17h)'
  >             13,10,13,10
  >            'Install: PRINTER [/bxy]',13,10
  >            'Control: PRINTER [/x|/s|/r|/d]',13,10,13,10
  >            '/b  x=buffersize * 10000 Byte, y=printspeed * 16',13,10
  >            '    e.g. /b54 -> buffersize 50.000 Byte, 64 characters per timertick',13,10  
  >            '    if /b is not set, PRINTER use /b61',13,10,13,10
  >            '/x  Remove from memory',13,10
  >            '/s  Deactivate',13,10
  >            '/r  Reactivate',13,10 
  >            '/d  Removes all characters from printbuffer$'
.endopt 



; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
