PROGRAM Recover;
{$M 10000, 0, 0}

USES
  bioscrt, dos, strings, keycode, masken, filecopy, rechnen, logfile;

CONST
  SaveDir                 = 'C:\RECOVER.SAV';
  Found        :  Boolean =  FALSE;
  ProgName                = 'RECOVER';
  SaveVer      :  PathStr = '';
  QName        :  PathStr = '';
  Rekurs                  =  FALSE; { fr sptere Aufrstungen }
  ErrNum       : LongInt  = 0;
  FileNum      : LongInt  = 0;

VAR
  NName        : PathStr;
  Objekt       : PathStr;
  f1, f2       : File;
  Buffer       : Array[1..512] Of Char;
  gel, ges     : Word;
  Sektor       : LongInt;
  FSize, FPos  : LongInt;
  Time         : LongInt;
  sr           : Searchrec;
  IsErr        : Boolean;
  Fields, cf   : Byte;

LABEL
  Ende;


PROCEDURE Hilfe;
BEGIN
  Standardkopf ('RECOVER', Copyright);
  DosLnLF (
  'kopiert beschdigte Dateien ins Sicherungsverzeichnis '+SaveDir+#13#10#13#10+
  'RECOVER [Datei/en] [anderes Sicherungsverzeichnis] [/o]'#13#10);
  DosLnLF (
  '/o  Fehler werden in der LOG-Datei protokolliert'#13#10#13#10+
  'Unlesbare Sektoren werden in der Zieldatei mit dem Zeichen # gefllt.');
  Blindstop;
  Halt;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, QName, 'Datei(en), die gerettet werden soll(en):');

  a2:
  EditStr (6, SaveVer, 'Verzeichnis, in dem die geretteten Dateien gespeichert werden sollen:');
  If t2=Up Then Goto a1;

  If (ee=0) and (QName='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


PROCEDURE Parameter;
VAR
  x     : Byte;
  Param : String;
  PStat : Word;
  tg    : SearchRec;
BEGIN
  StretchParam (Param);
  If ParamCount = 0 Then
  BEGIN
    QName:= FileExpand (''); Savever:= SaveDir;
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  END Else

  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1] = '/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'O' : LogStatus:= 0;
    END Else
    BEGIN
      If QName   = '' Then QName  := Param Else
      If SaveVer = '' Then SaveVer:= Param;
    END;
  END;
  If SaveVer='' Then SaveVer:= SaveDir;
  If QName  ='' Then SimpleHaltLog ('Dateiangabe fehlt');

  If pos ('*', QName) = 0 Then
  BEGIN      
    If (Length(QName)<=3) and (QName[2]=':') Then
    QName:= VollPfad (QName, '*.*') Else
    BEGIN
      FindFirst (QName, normalfile, tg);
      If (DOSerror=0) and (tg.attr and directory<> 0) Then
      QName:= VollPfad (QName, '*.*') (*Else Rekurs:= False*) ;
    END;
  END;

  QName:= FileExpand (QName);
  PStat:= PathStatus (QName, CheckQuelle);
  If PStat<>0 Then SimplehaltLog (PathStatusStr (PStat));

  SaveVer:= FileExpand (SaveVer);
  PStat:= PathStatus (SaveVer, CheckZiel);
  If PStat<>0 Then SimplehaltLog (PathStatusStr (PStat));

  Objekt:= GetFileNames (QName);
  Fields:= CountFields  (Objekt, '+');
  QName := GetPathName  (QName);

  If SamePath (QName, SaveVer, Rekurs) Then
  SimplehaltLog ('Zyklisches Kopieren nicht mglich');

  DosLnLF (#13#10'Kopiere Datei(en) (Abbrechen mit Esc)'#10);
END;


BEGIN
  Parameter;

  For cf:= 1 To Fields Do
  BEGIN
    FindFirst (VollPfad (QName, nthField(Objekt, '+', cf)), Normalfile, sr);
    While (DosError = 0) and (t1<>#27) Do
    BEGIN
      IsErr:= FALSE;
      If sr.attr and directory = 0 Then
      BEGIN
        inc (FileNum);
        If not Found Then
        BEGIN Found:= TRUE; MkDir (SaveVer); If IOResult <> 0 Then; END;
        NName:= VollPfad (GetPathName (QName), sr.name);
        DosLnLF (NName);

        Assign (f1, NName); FileMode:= 0;
        Reset (f1, 1);
        If IOResult <>0 Then
        BEGIN IsErr:= TRUE; DosLnLF ('Quelldatei konnte nicht geffnet werden'); Goto Ende; END;
        FSize:= FileSize (f1);
        FPos := 0;

        Assign (f2, VollPfad (SaveVer, sr.Name)); FileMode:= 2;
        Rewrite (f2, 1);
        If IOResult <> 0 Then
        BEGIN
          SetFAttr (f2, 32); Rewrite (f2, 1);
          If IOResult <>0 Then
          BEGIN
            Close (f1);
            BEGIN IsErr:= TRUE; DosLnLF ('Zieldatei konnte nicht angelegt werden'); Goto Ende; END;
          END;
        END;

        Sektor:= 0;
        While (not Eof (f1)) and (t1<>#27) Do
        BEGIN
          inc (Sektor);
          BlockRead (f1, Buffer, 512, gel);

          If IOResult <> 0 Then
          BEGIN
            IsErr:= TRUE;
            FillChar (Buffer, 512, '#');
            DosStr ('Lesefehler in Sektor '); DosNum (Sektor); DosLnLF ('');
            If FPos+512<=FSize Then
            BEGIN inc (FPos, 512); Seek (f1, FPos); gel:= 512; END Else
            BEGIN Seek (f1, FSize); gel:= Word (FSize-FPos);   END;
          END Else inc (FPos, 512);

          BlockWrite (f2, Buffer, gel, ges);
          If (IOResult<>0) or (gel<>ges) Then
          BEGIN
            IsErr:= TRUE;
            Close (f1);
            Close (f2); If IOResult <> 0 Then;
            DosLnLF ('Fehler beim Schreiben der Zieldatei');
            Goto Ende;
          END;
          If keypressed Then ScanBKeys;
        END;

        GetFTime (f1, Time);
        If IOResult <> 0 Then SetFTime (f2, Time); If IOResult <> 0 Then;
        XClose (f1);
        XClose (f2);
      Ende:
      If IsErr Then Inc (ErrNum);
      END;
      FindNext (sr);
    END;
  END;

  DosLnLF ('');

  If t1=#27    Then SimpleHaltLog ('Abbruch durch Anwender');
  If not Found Then SimpleHaltLog ('Keine Datei gefunden');
  If ErrNum<>0 Then AppendErr (LongStr (ErrNum)+' Dateien konnten nicht fehlerfrei kopiert werden');

  DosLnLF ('Es wurden '+LongStr (FileNum)+' Dateien kopiert, davon '+LongStr (FileNum-ErrNum)+ ' fehlerfrei');
  BlindStop;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
