PROGRAM Refresh;
{$M 10000, 0, 70000}

USES
  bioscrt, dos, monitor, strings, Masken, keycode, Disk_io, LogFile,
  rechnen, disk;

LABEL
  Start;


CONST
  ProgName    = 'REFRESH';
  Nochmal     : Boolean = FALSE;
  NewNumber   : Boolean = FALSE;
  Verify      : Boolean = FALSE;
  UnKnown     : Boolean = FALSE;
  LW          : Char = #0;

TYPE
  TStr  = String[8];

VAR
  InOutBuf    : TIOBuf;
  TrackBuf    : TrackLayOut;
  IORec       : DiskIORec;
  DDPT, OldT  : DiskParamRec;
  BootRec     : Bootsector absolute InOutBuf;

  Writing     : Boolean;
  x           : Word;
  Erledigt    : Byte;
  SysTime     : LongInt absolute $40:$6C;
  StartTime   : LongInt;
  dt          : DateTime;
  l           : LongInt;
  w           : Word;
  DriveType   : Byte;
  Result      : Word;


PROCEDURE Hilfe;
CONST
  tx1=
  'formatiert Disketten ohne Datenverluste (Auffrischungs-Formatierung)'#13#10#13#10+
  'REFRESH [Laufwerks-Buchstabe] [/n /r /o /v /g]'#13#10#13#10+
  '/n  speichert aktuelles Datum in der Datentrgernummer';
  tx2=
  '/r  fragt am Ende, ob eine weitere Diskette formatiert werden soll'#13#10+
  '/o  Durchlauf ohne Benutzerabfrage und Speichern von Fehlern in der LOG-Datei';
  tx3=
  '/v  Verify: nach dem Formatieren wird jede Spur nochmals geprft'#13#10+
  '/g  erzwingt eine vorgegebene Datentrger-Geometrie. /g:9-80-2 bedeutet'#13#10+
  '    z.B., da die Diskette je 9 Sektoren in 80 Spuren auf 2 Seiten hat.';
BEGIN
  Standardkopf (Progname, Copyright);
  DosLnLF (tx1);
  DosLnLF (tx2);
  DosLnLF (tx3);
  BlindStop; Halt;
END;


PROCEDURE ClearWin (a, b, c, d, col : Byte);
BEGIN Window (a, b, c, d); TextAttr:= col; ClrScr; End;


PROCEDURE ResetScreen;
BEGIN
  SetDDPT (OldT);
  VGAColorOff; ClearWin (1, 1, 80, 25, 7);
END;


PROCEDURE ErrorMsg (s : String);
BEGIN
  ResetScreen;
  SimpleHaltLog (s+#13#10+DiskIOErrStr (Result));
END;


PROCEDURE Write_Status (Mode : Byte);
CONST
  col : array [Boolean] of Byte = (yellow, magenta);
BEGIN
  With IORec Do
  BEGIN
    CharXY (13, 14, #4, col [Mode=DiskRead],   7);
    CharXY (13, 15, #4, col [Mode=DiskFormat], 7);
    CharXY (13, 16, #4, col [Mode=DiskWrite],  7);
    CharXY (13, 17, #4, col [Mode=Diskverify], 7);
  END;
END;


PROCEDURE Kopf;
BEGIN
  VGAColorOn;
  CursorOff; ClearWin (1, 1, 80, 25, 240);
  WriteXY (1,  1, SpaceStr (' REFRESH', 80), 14, 2);
  WriteXY (1, 25, SpaceStr (' Esc = Beenden', 80), 14, 2);

  ClearWin(9, 4, 36, 9, 112);
  WriteXY (9, 4, '         Formatiere         ', 10, 8);
  WriteXY (13, 6, 'Spur' , 0, 7);
  WriteXY (13, 8, 'Seite', 0, 7);

  ClearWin(45, 4, 72, 9, 112);
  WriteXY (45, 4, '            Zeit            ', 10, 8);
  WriteXY (49, 6, 'geschtzt', 0, 7);
  WriteXY (49, 8, 'vergangen', 0, 7);

  ClearWin(9,  12, 36, 18, 112);
  WriteXY (9,  12, '           Status           ', 10, 8);
  WriteXY (17, 14, 'Lese'      , 0, 7); 
  WriteXY (17, 15, 'Formatiere', 0, 7);
  WriteXY (17, 16, 'Schreibe'  , 0, 7);
  WriteXY (17, 17, 'Prfe'     , 0, 7);
  Write_Status (0);

  ClearWin(9,  22, 72, 22, yellow*16);
  Writing:=False; 
END;


FUNCTION LTime : LongInt;
BEGIN LTime:= SysTime * 5 DIV 91; END;


FUNCTION Timer (LTime : LongInt) : TStr;
VAR
  ho, mi, se : Word;
BEGIN
  ho:= LTime DIV 3600 DIV 60;
  mi:= LTime DIV 60   MOD 60;
  se:= LTime MOD 3600 MOD 60;
  Timer:= lz(ho)+':'+lz(mi)+':'+lz(se);
END;


PROCEDURE Write_Formatiere;
VAR
  a, b : LongInt;             
BEGIN
  If  LTime >= StartTime Then
  a:= LTime -  StartTime Else
  a:= 86430 -  StartTime + LTime;
  With IORec Do
  BEGIN
    If Spur > 0 Then b:= a * pred (TracksPSide) DIV Spur Else b:=0;
    NumXY (23, 6, 3, Spur,  magenta, 7);
    NumXY (23, 8, 3, Seite, magenta, 7);
  END;
  WriteXY (61, 6, Timer (b), 0, 7);
  WriteXY (61, 8, Timer (a), 0, 7);
END;



PROCEDURE Write_Laufwerk;
BEGIN
  ClearWin(45, 12, 72, 18, 112);
  WriteXY (45, 12, '         Laufwerk           ', 10, 8);
  WriteXY (63, 12, LW+':', lightmagenta, 8);
  With IORec Do
  BEGIN
    WriteXY (49, 14, StretchStr(LongStr (TracksPSide), 2)+'   Spuren'          , 0, 7);
    WriteXY (49, 15, StretchStr(LongStr (SideNum), 2)+    '   Seiten'          , 0, 7);
    WriteXY (49, 16, StretchStr(LongStr (SecPerTrack), 2)+'   Sektoren je Spur', 0, 7);
  END;
END;



PROCEDURE Balken (Wert1, Wert2 : LongInt);
VAR
  x : Byte;
  a : Word;
BEGIN
  If Wert2<1 Then Wert2:=1; a:= (Wert1*63) DIV Wert2; If a<1 Then a:=1;
  If a > 63 Then a:= 63; inc (a, 9);
  For x:= 9 To a Do CharXY (x, 22, #219, magenta, 7);
  a:= (Wert1*100) DIV Wert2; inc (a); If a > 100 Then a:= 100;
  WriteXY (68, 21, StretchStr (LongStr(a), 3)+' %', magenta, 15);
END;



PROCEDURE ShowMaske;
VAR
  lw1 : PathStr;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
BEGIN
  t2:= #0;
  lw1:='A:';

  a1:
  EditStr (1, lw1, 'Laufwerk, das die Diskette enthlt:');
  If lw1 <>'' Then LW:= UpCase (lw1[1]) Else LW:= #0;
 
  a2:
  ParamField (6, Nochmal, 'fragt am Ende, ob eine weitere Diskette kopiert werden soll');
  If t2=Up Then Goto a1;

  a3:
  ParamField (7, NewNumber, 'aktuelles Datum in der Datentrgernummer speichern');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, Verify, 'nach dem Formatieren wird jede Spur nochmals berprft');
  If t2=Up Then Goto a3;

  If (ee=0) and (lw1='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE GetGeometrie (Param : PathStr; VAR IORec : DiskIORec);
VAR
  tmp     : Array[1..3] Of String;
  c, d, e : Integer;
BEGIN
  For c:= 1 To 3 Do tmp[c]:= '';
  c:= 1;
  For d:= 1 To Length (Param) Do
  If (Param[d]='-') and (c<3) Then inc (c) Else tmp[c]:= tmp[c]+Param[d];
 (* If tmp[1]='?' Then BEGIN TestDisk:= TRUE; Exit; END;*)
  With IORec Do
  BEGIN
    Val (tmp[1], SecPerTrack, c);
    Val (tmp[2], TracksPSide, d);
    Val (tmp[3], SideNum,     e);
    If (c+d+e<>0) or (SideNum=0) or (TracksPSide=0)    or (SecPerTrack=0)
                  or (SideNum>2) or (TracksPSide>1024) or (SecPerTrack>64) Then
    SimpleHaltLog ('Angabe der Laufwerksgeometrie hat ungltiges Format');
    SectorNum:= LongInt(Sidenum)*LongInt(TracksPSide)*LongInt (SecPerTrack);
  END;
  Unknown:= TRUE;
END;


PROCEDURE Get_Parameter;
VAR
  Param : String;
  x     : Byte;
BEGIN
  StretchParam (Param);
  If ParamCount = 0 Then Maske Else
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'O' : LogStatus:= 0;
      'R' : Nochmal  := TRUE;
      'N' : NewNumber:= TRUE;
      'V' : Verify   := TRUE;
      'G' : GetGeometrie (copy (Param, 4, 255), IORec);
    END Else If LW=#0 Then LW:= Param[1];
  END;
  If (LW>'B') or (LW<'A') Then SimpleHaltLog ('Es werden nur die Laufwerke A und B untersttzt');
  x:= Drive (LW);
  If x and Phantomdrive<>0 Then SimpleHaltLog ('Phantomlaufwerk wird nicht untersttzt') Else
  If x and Substdrive  <>0 Then SimpleHaltLog ('SUBST-Laufwerk wird nicht untersttzt') Else
  If x and (NetDrive or InterLnkDrive) <> 0 Then SimpleHaltLog ('Netz-Laufwerk wird nicht untersttzt');
END;



PROCEDURE FillBuffer (VAR IORec : DiskIORec); assembler;
ASM
  push ds
  lds  si, IORec
  les  di, dword ptr [si+5]
  mov  ax, 0101h
  mov  cl, [si+11]  { Sektoren pro Spur }
  xor  ch, ch
  shl  cx, 8        { Puffergre in Word }
  rep  StosW
  pop  ds
END;



PROCEDURE Check_Buffer (VAR IORec : DiskIORec); assembler;
ASM
  push ds
  lds  si, IORec
  les  di, dword ptr [si+5]
  mov  cl, [si+11]  { Sektoren pro Spur }
  xor  ch, ch
  shl  cx, 8        { Puffergre in Word }
  mov  al, DDPT.FillerByte
  mov  ah, al
  xor  dx, dx
  pop  ds
  cld
  repe scasW
  je   @ende
  mov  dx, 1
  @ende:
  mov  Writing, dl
END;



BEGIN
  Get_Parameter;
Start:
  Result:= 0;
  Kopf;

  AssignDisk     (IORec, LW, DiskRead, @InOutBuf);
  If not UnKnown Then
  BEGIN
    GetDiskMetrics (IORec); Result:= IOResult;
    If Result<>0 Then ErrorMsg ('Bootsektor nicht lesbar');
  END;

  DriveType:= GetDriveType (IORec); Result:= IOResult;
  If Result<>0 Then
  ErrorMsg ('Fehler bei Laufwerksabfrage');
  If DriveType > Drive1440 Then
  ErrorMsg ('Laufwerkstyp wird nicht untersttzt');

  GetDDPT   (DDPT); OldT:= DDPT;
  If DriveType >= Drive720 Then
  Make3DDPT (DDPT, IORec.SecPerTrack) Else
  Make5DDPT (DDPT, IORec.SecPerTrack);
  SetDDPT   (DDPT);

  InitDrive (IORec); Result:= IOResult;
  If Result<>0 Then ErrorMsg ('Laufwerk nicht bereit');
  With IORec Do SecToRead:= SecPerTrack;

  Write_Laufwerk;
  ClearWin(9,  22, 72, 22, yellow*16);
  StartTime:= LTime;

  With IORec Do
  For Spur:= 0 To pred (TracksPSide) Do
  BEGIN
    For Seite:= 0 To pred (SideNum) Do
    BEGIN
      Write_Formatiere;
      FillBuffer   (IORec);

      Mode:= DiskRead;
      Write_Status (Mode);
      DiskIO (IORec); Result:= IOResult;
      If Result<>0 Then
      ErrorMsg ('Fehler beim Lesen von Spur '+LongStr (Spur)) Else
      If Versuche<>0 Then
      ErrorMsg (
      'Die Diskette neigt zu leichten Fehlern. Kopieren Sie die Diskette daher'#13#10+
      'auf eine neue und formatierte Diskette um und mustern Sie die alte'#13#10+
      'Diskette anschlieend aus.');

      BufAddr:= @TrackBuf;
      Mode:= DiskFormat;
      Write_Status (Mode);
      FillTrackLayOut (IORec);
      DiskIO (IORec); Result:= IOResult;
      If Result<>0 Then ErrorMsg ('Fehler beim Formatieren von Spur '+LongStr (Spur));

      Mode:= DiskWrite;
      BufAddr:= @InOutBuf;
      Check_Buffer (IORec);
      If Writing Then
      BEGIN
        If (NewNumber) and (Spur=0) and (Seite=0) and (not UnKnown) Then
        BEGIN
          With dt Do GetDate (year, Month, day, w);
          With dt Do GetTime (hour, min,   sec, w);
          PackTime (dt, l);
          move (l, BootRec.DiskNummer, 4);
        END;
        Write_Status (Mode);
        DiskIO (IORec); Result:= IOResult;
        If Result<>0 Then ErrorMsg ('Fehler beim Schreiben von Spur '+LongStr (Spur));

        If Verify Then
        BEGIN
          Mode:= DiskVerify;
          Write_Status (Mode);
          DiskIO (IORec); Result:= IOResult;
          If Result<>0 Then ErrorMsg ('Fehler beim Prfen von Spur '+LongStr (Spur));
        END;
      END;

      Balken (Spur, TracksPSide);

      If (keypressed) and (ReadBKey=#27) Then ErrorMsg ('Abbruch durch Anwender');
    END;
  END; 

  SetDDPT (OldT);

  If Nochmal Then
  BEGIN
    ClearWin (1, 1, 80, 25, 7);
    Tastenabfrage ('Wollen Sie eine weitere Diskette berformatieren ? (j/n)', 'J', 'N');
    If t1='J' Then Goto Start;
  END;

  ResetScreen;
  DosLnLF ('Diskette erfolgreich formatiert');
  BlindStop;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
