PROGRAM Replace;
{$M 60000, 1024, 140000}

USES
  BIOSCrt, Strings, DOS, KeyCode, Masken, LogFile, FileCopy, Monitor,
  WildCard, DblFile, ErrorStr;

CONST
  ProgName   = 'REPLACE';
  ask        = 'Beliebige Taste drcken, um Tastaturkommando zu ermglichen';
  t          : Char    = 'A';
  Result     : Word    = 0;
  ZFound     : Boolean = FALSE;
  QFound     : Boolean = FALSE;
  All        : Boolean = TRUE;
  Timing     : Boolean = FALSE;
  SubDirs    : Boolean = FALSE;
  ReadOn     : Boolean = FALSE;
  Hidd       : Boolean = FALSE;
  OnlyNoEx   : Boolean = FALSE;
  Wait       : Boolean = FALSE;
  Simple     : Boolean = FALSE;
  Verify     : Boolean = FALSE;
  ZielPfad   : String  = '';
  QuellPfad  : String  = '';
  Gesamt     : LongInt = 0;
  Kopiert    : LongInt = 0;
  AttrMask   : Byte    = VisibleObjects;

VAR
  Files      : DoubleFileRec;
  FileNames  : String;
  ZielPfad1  : String;
  i          : Byte;
  Param      : String;
  ActFile    : SearchRec;
  cf         : Byte;


PROCEDURE Frage2;
BEGIN
  OutStr ('Replace in den Einzelabfragemodus versetzen (j/n) oder beenden? (Esc)');
  GotoXY (1, WhereY);
  REPEAT
    t:= UpReadBKey;
    If (t='E') or (t=#27) Then UserAbortLog;
  UNTIL (t='J') or (t='N'); If t='N' Then t:= 'A';
  ClrEol;
END;


PROCEDURE Frage;
BEGIN
  Fusszeile ('Auswahl'); GotoOldPos;
  If OnlyNoEx Then OutStr ('Datei hinzufgen?') Else OutStr ('Datei ersetzen?');
  OutStr ('     <J>a  <N>ein  <A>lle  <E>nde');
  GotoXY (4, WhereY);
  REPEAT
    t:= UpReadBKey;
    If (t='E') or (t=#27) Then UserAbortLog;
  UNTIL (t='J') or (t='N') or (t='A');
  GotoXY (20, WhereY); ClrEol;
  Fusszeile (Ask); GotoOldPos;
END;


PROCEDURE Hilfe;
CONST
s1='ersetzt Dateien durch die angegebene(n) Datei(en)'#13#10#13#10+
   'REPLACE  Quelldatei(en)  Zielverzeichnis(se)/laufwerk(e)  [Parameter...]'#13#10#13#10+
   '/p  fragt bei jeder Datei, ob sie ersetzt/hinzugefgt werden soll'#13#10+
   '/u  ersetzt eine Datei nur, wenn sie lter als die Quelldatei ist';
s2='/s  ersetzt Dateien auch in Unterverzeichnissen'#13#10+
   '/r  ersetzt auch schreibgeschtzte Dateien'#13#10+
   '/h  ersetzt auch versteckte Dateien'#13#10+
   '/a  kopiert eine Datei nur, wenn sie noch NICHT im Ziel existiert'#13#10+
   '/w  wartet vor Beginn auf einen Tastendruck';
s3='/o  Fehler werden in der Log-Datei protokolliert'#13#10+
   '/b  Ausgabe im einfachen Format, z.B. fr Umleitung in eine Datei'#13#10+
   '/v  Quell- und Zieldateien werden nach dem Kopieren verglichen'#13#10;
s4='Sie knnen REPLACE whrend des Betriebes (ohne /p) durch Drcken einer Taste in'#13#10+
   'den Abfrage-Modus versetzen. REPLACE kann jederzeit mit Esc abgebrochen werden.'#13#10+
   'Parameter /a setzt die Parameter /s /r /h und /u auer Kraft, /o den Parameter';
s5='/p, und /p den Parameter /b.';

BEGIN
  StandardKopf (ProgName, Copyright); WindMax:= 6200;
  DosLn (s1); DosLn (s2); DosLn (s3); DosLn (s4); DosLn (s5); BlindStop;
  Halt;
END;


PROCEDURE Copy_File (SuchDir, Name : PathStr);
BEGIN
  If not Simple Then
  BEGIN
    If WhereY>1 Then DosLineFeed; DosLn (Suchdir);
    DosStr ('   ' + StretchRight (LowStr (Name), 16));
  END;

  inc (Gesamt);
  ZFound:= TRUE;
  If t<>'A' Then Frage;
  CASE t Of
    'J', 'A' : BEGIN
                 AssignFiles (Files, BuildPath (QuellPfad, Name),
                                     BuildPath (SuchDir,   Name));
                 If Verify Then SetDFVerifyFlag (Files);
                 CopyFile (Files);
                 Result:= abs(IOResult);
                 If Result=0 Then
                 BEGIN
                   inc (Kopiert);
                   If Simple Then
                   DosLn (LowStr(BuildPath(SuchDir, Name))) Else
                   If OnlyNoEx Then
                   DosStr ('Datei hinzugefgt') Else
                   DosStr ('Datei ersetzt');
                 END Else
                 BEGIN
                   If Simple Then
                   BEGIN
                     DosLn  (LowStr(BuildPath(SuchDir, Name)));
                     DosStr ('   ');
                   END;
                   DosStr (ExtIOResultStr (Result));
                   AppendErr (ExtIOResultStr (Result)+#13#10+'Datei: '+BuildPath (SuchDir, Name));
                   If Simple Then DosLineFeed;
                 END;
               END;
    'N'      : If not Simple Then
               If OnlyNoEx Then
               DosStr ('Datei nicht hinzugefgt') Else
               DosStr ('Datei nicht ersetzt');
  END;
  If not Simple Then DosLineFeed;
END;


PROCEDURE CopyIfNotExist (SuchDir : PathStr);
VAR
  sr : SearchRec;
BEGIN
  If Keypressed Then BEGIN WaitBkey; Frage2; END;

  Findfirst (BuildPath (SuchDir, Actfile.name), Normalfile, sr);
  If DOSError>= 150 Then ErrorHaltLog (IOResultStr (DOSError));
  If DosError<> 0   Then Copy_File (SuchDir, ActFile.name);
END;


PROCEDURE ScanFolder (SuchDir : PathStr);
VAR
  tg    : Searchrec;
  Found : Boolean;
BEGIN
  If Keypressed Then BEGIN WaitBkey; Frage2; END;

  Findfirst (BuildPath (SuchDir, '*.*'), AttrMask, tg);
  If DOSError>=150 Then ErrorHaltLog (IOResultStr (DOSError));

  Found:= FALSE;  { Datei wird sonst 2x gefunden, da CopyFile die Zieldatei umbenennt! }
  While DOSError=0 Do
  BEGIN
    If tg.attr and directory = 0 Then
    BEGIN
      If  (not Found)
      and (tg.name = ActFile.name)
      and ((not Timing)  or (ActFile.time > tg.time))
      and ((ReadOn)      or (tg.attr and (Readonly or SysFile) = 0))
      and (not SameFile (BuildPath (SuchDir, tg.name),
                         BuildPath (QuellPfad, ActFile.name),
                         tg, ActFile)) Then
      BEGIN
        Copy_File (SuchDir, tg.name);
        Found:= TRUE;
      END;
    END
    Else
    If (SubDirs) and (tg.name[1]<>'.') Then
    ScanFolder (BuildPath (SuchDir, tg.name));

    Findnext (tg);
  END;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, QuellPfad,  'Name(n) der zu ersetzenden/hinzuzufgenden Datei(en):');
  QuellPfad:= UpStr (QuellPfad);

  a2:
  EditStr (6, ZielPfad,   'Verzeichnis(se), in denen Dateien ersetzt/hinzugefgt werden sollen:');
  If t2=Up Then Goto a1;
  ZielPfad:= UpStr (ZielPfad);

  a3:
  ParamField (12, SubDirs,'Dateien auch in Unterverzeichnissen ersetzen');
  If t2=Up Then Goto a2;

  a4:
  ParamField (13, ReadOn, 'auch schreibgeschtzte Dateien ersetzen');
  If t2=Up Then Goto a3;

  a5:
  ParamField (14, Hidd,   'auch versteckte Dateien ersetzen');
  If t2=Up Then Goto a4;

  a6:
  ParamField (15, All,    'alle Dateien ohne weitere Nachfrage ersetzen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (16, Timing, 'Datei nur ersetzen, wenn sie lter als die Quelldatei ist');
  If t2=Up Then Goto a6;

  a8:
  ParamField (17, Wait,   'vor Beginn auf einen Tastendruck warten');
  If t2=Up Then Goto a7;

  a9:
  ParamField (18, OnlyNoEx,'kopiert eine Datei nur, wenn sie noch NICHT im Ziel existiert');
  If t2=Up Then Goto a8;

  If (ee=0) and (QuellPfad='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Dateiname. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


PROCEDURE Maske;
BEGIN
  QuellPfad:= FexPand (''); ZielPfad:= 'C:\';
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;

{----------------------------- Hauptprogramm --------------------------------}
VAR
  PStat : String;

BEGIN
  StretchParam (Param);
  If ParamCount = 0 Then Maske Else

  For i:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (i));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'P' : All      := FALSE;
      'O' : Logstatus:= 0;
      'U' : Timing   := TRUE;
      'S' : SubDirs  := TRUE;
      'R' : ReadOn   := TRUE;
      'H' : Hidd     := TRUE;
      'A' : OnlyNoEx := TRUE;
      'W' : Wait     := TRUE;
      'B' : Simple   := TRUE;
      'V' : Verify   := TRUE;
    END
    Else
    BEGIN
      If QuellPfad = '' Then QuellPfad:= Param Else
      If ZielPfad  = '' Then ZielPfad := Param;
    END;
  END;

  If LogStatus=0 Then All:= TRUE;
  If not All Then BEGIN t:= 'J'; Simple:= FALSE; END;
  If Hidd Then AttrMask:= AttrMask or hidden;

  If OnlyNoEx Then
  Standardkopf (ProgName, 'Dateien hinzufgen') Else
  Standardkopf (ProgName, 'Dateien ersetzen');

  If Wait Then
  BEGIN
    Tastenabfrage ('Starten mit Enter    Abbrechen mit Esc', #13, #27);
    If t1=#27 Then UserAbort;
  END;

  If OnlyNoEx Then BEGIN Timing:= FALSE; SubDirs:= FALSE; END;

  QuellPfad:= FExpand (QuellPfad);
  PStat:= PathStatusStr (PathStatus(QuellPfad, CheckQuelle));
  If PStat<>'' Then ErrorHaltLog ('Quelldatei: ' + PStat);

  Fusszeile (ask); GotoXY (1, 1);

  FileNames:= GetFileName (QuellPfad);
  QuellPfad:= GetPathName (QuellPfad);
  If QuellPfad = '' Then QuellPfad:= FileExpand ('');

  For cf:= 1 To CountFields (ZielPfad, '+') Do
  BEGIN
    ZielPfad1:= FExpand (nthField (ZielPfad, '+', cf));
    PStat:= PathStatusStr (PathStatus(ZielPfad1, CheckZiel));
    If PStat<>'' Then ErrorHaltLog ('Zielverzeichnis: ' + PStat);

    FindFirst (BuildPath (QuellPfad, '*.*'), VisibleFiles, ActFile);
    If DOSError>=150 Then ErrorHaltLog (IOResultStr (DOSError));
    While DosError=0 Do
    BEGIN
      If FileMatch (ActFile.name, FileNames) Then
      BEGIN
        If ActFile.Size<>0 Then
        BEGIN
          QFound:= TRUE;
          If OnlyNoEx Then
          CopyIfNotExist (ZielPfad1) Else ScanFolder (ZielPfad1);
        END Else
        BEGIN
          DosLineFeed;
          DosLn ('Datei '+ActFile.name+' wegen Gre 0 bergangen');
          AppendErr ('Datei '+ActFile.name+' wegen Gre 0 bergangen');
        END;
      END;
      FindNext (ActFile);
    END;
  END;

  If Not QFound Then ErrorHaltLog ('Quelldatei(en) nicht gefunden') Else
  BEGIN
    If Not ZFound Then If OnlyNoEx Then
    ErrorHalt ('Keine Datei hinzugefgt') Else
    ErrorHalt ('Keine Datei ersetzt');
  END;

  PStat:= StrVal (Kopiert)+' von '+StrVal (Gesamt)+ ' Dateien ';
  If OnlyNoEx Then
  ErrorHalt (PStat+'hinzugefgt') Else ErrorHalt (PStat+'ersetzt');

END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
