UNIT Run_Asm;

INTERFACE
USES
  DOS, run_var, run_stri, run_if, run_tool, crt;


PROCEDURE Assemb;


IMPLEMENTATION

TYPE
  iRegister = RECORD
                CASE Integer of
                0: (iAX,iBX,iCX,iDX,iBP,iSI,iDI,iDS,iES,Flags: Word);
                1: (iAL,iAH,iBL,iBH,iCL,iCH,iDL,iDH: Byte);
              END;

CONST
  Max     = 255;
  Nr      : Byte = 0;
  RepNum  : Word = 1;
  IfRep   : Byte = 0;
  RepArt  : Byte = 0;
  fC = 0; fP = 2; fA = 4; fZ = 6; fS = 7; fT = 8; fi = 9; fD = 10; fO = 11;

VAR
  Regs       : iRegister;
  iRegs      : Registers absolute Regs;
  RegStack   : Array[1..Max] Of Word;
  w1, w2, w3 : Word;
  xw         : Word;


PROCEDURE GetArgs (Num : Byte);
BEGIN
  GetArguments (GetProcName(Line));
  If ArgNum <> Num Then ErrorMsg (Line, ParamNumError);
END;



PROCEDURE MakeInt;
BEGIN
  Intr (Byte (xxVal (GetProcName(Line))), iRegs);
END;



FUNCTION Flag (BitNr : Byte) : Boolean;
BEGIN
  Flag:= (Regs.Flags and (1 shl BitNr)) <> 0;
END;



PROCEDURE SetFlag (BitNr : Byte);
BEGIN
  Regs.Flags:= Regs.flags or (1 shl BitNr);
END;



PROCEDURE DelFlag (BitNr : Byte);
BEGIN
  Regs.Flags:= Regs.flags and not (1 shl BitNr);
END;



PROCEDURE InRegs (Reg : String; w : Word);
BEGIN
  If(Reg[1]='@') and (Reg[2]>='A') and (Reg[2]<='Z') Then vLongArr[Reg[2]]:= w Else
  BEGIN
    xw:= ord(Reg[1]) + ord (reg[2]) * 256;
    CASE xw Of
      19521 : Regs.ial:= Byte (w) ;
      19522 : Regs.ibl:= Byte (w) ;
      19523 : Regs.icl:= Byte (w) ;
      19524 : Regs.idl:= Byte (w) ;
      18497 : Regs.iah:= Byte (w) ;
      18498 : Regs.ibh:= Byte (w) ;
      18499 : Regs.ich:= Byte (w) ;
      18500 : Regs.idh:= Byte (w) ;
      22593 : Regs.iax:= w        ;
      22594 : Regs.ibx:= w        ;
      22595 : Regs.icx:= w        ;
      22596 : Regs.idx:= w        ;
      20546 : Regs.ibp:= w        ;
      18771 : Regs.isi:= w        ;
      18756 : Regs.idi:= w        ;
      21316 : Regs.ids:= w        ;
      21317 : Regs.ies:= w        ;
      Else    ErrorMsg (Line, 'fehlerhafte Registerangabe');
    END;
    If w = 0 Then setFlag (fZ);
  END;
END;


FUNCTION OutRegs (Reg : String) : Word;
BEGIN
  If Reg[1]='''' Then OutRegs:= Byte (Reg[2]) Else
  BEGIN
    xw:= ord(Reg[1]) + ord (reg[2]) * 256;
    CASE xw Of
      19521 : OutRegs:= Regs.ial;
      19522 : OutRegs:= Regs.ibl;
      19523 : OutRegs:= Regs.icl;
      19524 : OutRegs:= Regs.idl;
      18497 : OutRegs:= Regs.iah;
      18498 : OutRegs:= Regs.ibh;
      18499 : OutRegs:= Regs.ich;
      18500 : OutRegs:= Regs.idh;
      22593 : OutRegs:= Regs.iax;
      22594 : OutRegs:= Regs.ibx;
      22595 : OutRegs:= Regs.icx;
      22596 : OutRegs:= Regs.idx;
      20546 : OutRegs:= Regs.ibp;
      18771 : OutRegs:= Regs.isi;
      18756 : OutRegs:= Regs.idi;
      21316 : OutRegs:= Regs.ids;
      21317 : OutRegs:= Regs.ies;
      Else    OutRegs:= Word (GetFuncLong(Reg));
    END;
  END;
END;



PROCEDURE AsmMov;
BEGIN
  GetArgs (2);
  InRegs (StrArr[1], OutRegs (StrArr[2]));
END;



PROCEDURE xchg;
VAR
  tmp : Word;
BEGIN
  GetArgs (2);
  tmp:= OutRegs (StrArr[1]);
  InRegs (StrArr[1], OutRegs (StrArr[2]));
  InRegs (StrArr[2], tmp);
END;



PROCEDURE IncReg;
BEGIN
  GetArgs (1);
  w1:= OutRegs (StrArr[1]);
  ASM inc w1; pushf; pop Regs.flags; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE DecReg;
BEGIN
  GetArgs (1);
  w1:= OutRegs (StrArr[1]);
  ASM dec w1; pushf; pop Regs.flags; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE xor_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; xor ax, w2; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE or_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; or ax, w2; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE and_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; and ax, w2; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE not_ ;
BEGIN
  GetArgs (1);
  w1:= OutRegs (StrArr[1]);
  ASM not w1; pushf; pop Regs.flags; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE add_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; add ax, w2; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE sub_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; sub ax, w2; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE mul_;
BEGIN
  GetArgs (1);
  w2:= OutRegs (StrArr[1]);
  ASM
    mov ax, Regs.iax; mov bx, w2; mul bx;
    pushf; pop Regs.flags;
    mov Regs.iax, ax; mov Regs.idx, dx
  END;
END;



PROCEDURE div_;
BEGIN
  GetArgs (1);
  w1:= OutRegs (StrArr [1]);
  If w1 = 0 Then ErrorMsg (Line, DivisionByZero);
  ASM
    mov ax, Regs.iax; mov dx, Regs.idx; mov bx, w1; div bx;
    pushf; pop Regs.flags;
    mov Regs.iax, ax; mov Regs.idx, dx
  END;
END;



PROCEDURE shl_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; mov cx, w2; shl ax, cl; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;



PROCEDURE shr_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; mov cx, w2; shr ax, cl; pushf; pop Regs.flags; mov w1, ax; END;
  InRegs (StrArr[1], w1);
END;


PROCEDURE rolror (Modus : Byte);
VAR
  w    : Word;
  b, c : Byte;
BEGIN
  GetArgs (2);
  c:= Byte (OutRegs (StrArr[2]));
  If (StrArr[1, 2]='H') or (StrArr[1, 2]='L') Then
  BEGIN
    b:= Byte (OutRegs (StrArr[1]));
    ASM
      mov al, b
      mov cl, c
      mov bl, Modus
      cmp bl, 0
      je @weiter
      rol al, cl
      jmp @ende
      @weiter:
      ror al, cl
      @ende:
      pushf
      pop Regs.flags
      mov b, al
    END;
    Inregs (StrArr[1], b);
  END Else
  BEGIN
    w:= OutRegs (StrArr[1]);
    ASM
      mov ax, w
      mov cl, c
      mov bl, Modus
      cmp bl, 0
      je @weiter
      rol ax, cl
      jmp @ende
      @weiter:
      ror ax, cl
      @ende:
      pushf
      pop Regs.flags
      mov w, ax
    END;
    Inregs (StrArr[1], w);
  END;
END;



PROCEDURE Push;
BEGIN
  If Nr<Max Then inc (Nr) Else ErrorMsg (Line, 'interner Speicherberlauf durch zuviele PUSH-Befehle');
  GetArgs (1);
  RegStack[Nr]:= OutRegs (StrArr[1]);
END;



PROCEDURE Pop;
BEGIN
  GetArgs (1);
  InRegs (StrArr[1], RegStack[Nr]);
  If Nr>0 Then dec (Nr) Else ErrorMsg (Line, 'interner Speicherunterlauf durch zuviele POP-Befehle');
END;


PROCEDURE Pushf;
BEGIN
  If Nr<Max Then inc (Nr) Else ErrorMsg (Line, 'interner Speicherberlauf durch zuviele PUSH-Befehle');
  RegStack[Nr]:= Regs.Flags;
END;



PROCEDURE Popf;
BEGIN
  Regs.Flags:= RegStack[Nr];
  If Nr>0 Then dec (Nr) Else ErrorMsg (Line, 'interner Speicherunterlauf durch zuviele POP-Befehle');
END;



PROCEDURE in_;
BEGIN
  GetArgs (2);
  w2:= OutRegs(StrArr[2]);
  If StrArr[1]= 'AL' Then
  ASM mov dx, w2; in al, dx; pushf; pop Regs.flags; mov Regs.ial, al; END Else
  If StrArr[1]= 'AX' Then
  ASM mov dx, w2; in ax, dx; pushf; pop Regs.flags; mov Regs.iax, ax; END Else
  ErrorMsg (Line, 'IN bentigt das AL- oder AX-Register');
END;



PROCEDURE out_;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  If StrArr[2]= 'AL' Then
  ASM mov dx, w1; mov al, Regs.ial; out dx, al; pushf; pop Regs.flags; END Else
  If StrArr[2]= 'AX' Then
  ASM mov dx, w1; mov ax, Regs.iax; out dx, ax; pushf; pop Regs.flags; END Else
  ErrorMsg (Line, 'OUT bentigt das AL- oder AX-Register');
END;



PROCEDURE Test;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; mov bx, w2; test ax, bx; pushf; pop Regs.flags; END;
END;



PROCEDURE Les;
BEGIN
  GetArgs (2);
  Regs.ies:= SegOfs (StrArr[2], Segment);
  InRegs (StrArr[1], VarOfs);
END;



PROCEDURE Lds;
BEGIN
  GetArgs (2);
  Regs.ids:= SegOfs (StrArr[2], Segment);
  InRegs (StrArr[1], VarOfs);
END;



PROCEDURE RegCX; Assembler;
ASM
  cmp IfRep, 0
  je @ende
    mov Regs.icx, cx
    mov IfRep, 0
  @ende:
  mov RepNum, 1
END;



PROCEDURE xlat; assembler;
ASM
  mov al, Regs.ial
(* mov es, Regs.ies*)
  mov bx, Regs.ibx
  xlat
  mov Regs.ial, al
END;



PROCEDURE LodsB; assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov bx, ds
  mov si, Regs.isi
  mov ds, Regs.ids
  rep lodsb
  mov ds, bx
  mov Regs.ids, bx
  mov Regs.isi, si
  mov Regs.ial, al
  call RegCX
END;


PROCEDURE LodsW; assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov bx, ds
  mov si, Regs.isi
  mov ds, Regs.ids
  rep lodsW
  mov ds, bx
  mov Regs.ids, bx
  mov Regs.isi, si
  mov Regs.iax, ax
  call RegCX
END;



PROCEDURE StosB; assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov di, Regs.idi
  mov es, Regs.ies
  mov al, Regs.ial
  rep Stosb
  mov Regs.ies, es
  mov Regs.idi, di
  call regCX
END;



PROCEDURE StosW; assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov di, Regs.idi
  mov es, Regs.ies
  mov ax, Regs.iax
  rep StosW
  mov Regs.ies, es
  mov Regs.idi, di
  call regCX
END;


PROCEDURE Movs (Modus : Byte); assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov dl, Modus
  mov es, Regs.ies
  mov di, Regs.idi
  mov si, Regs.isi
  mov bx, ds
  mov ds, Regs.ids

  cmp dl, 0
  je @weiter
  rep movsW;
  jmp @raus
  @weiter:
  rep movsB
  @raus:

  mov ds, bx
  mov Regs.ies,  es
  mov Regs.idi,  di
  mov Regs.ids,  bx
  mov Regs.isi,  si
  call RegCX
END;


PROCEDURE Scas (Modus : Byte); assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum
  mov ax, Regs.iax
  mov es, Regs.ies
  mov di, Regs.idi
  
  cmp RepArt, 2
  je @xRepe
  cmp Modus, 0; je @weiter1; repne ScasW; jmp @ende
  @weiter1:
  repne Scasb;
  jmp @ende

  @xRepe:
  cmp Modus, 0; je @weiter2; repe ScasW; jmp @ende
  @weiter2:
  repe Scasb;

  @ende:
  pushf
  pop Regs.flags
  mov Regs.ies, es
  mov Regs.idi, di
  call RegCX
END;



PROCEDURE Cmps (Modus : Byte); assembler;
ASM
  push Regs.flags
  popf
  mov cx, RepNum;
  mov dl, RepArt
  mov dh, Modus
  mov es, Regs.ies
  mov di, Regs.idi
  mov si, Regs.isi
  mov bx, ds
  mov ds, Regs.ids

  cmp dl, 2
  je @xRepe

  cmp dh, 0; je @weiter1; repne cmpsW; jmp @ende
  @weiter1:
  repne cmpsb; jmp @ende

  @xRepe:
  cmp dh, 0; je @weiter2; repe cmpsW; jmp @ende;
  @weiter2:
  repe cmpsb;
  @ende:

  pushf
  pop Regs.flags
  mov ds, bx
  mov Regs.ids, bx
  mov Regs.isi, si
  mov Regs.ies, es
  mov Regs.idi, di
  call RegCX
END;


PROCEDURE cli_; assembler; ASM cli; pushf; pop Regs.flags; END;
PROCEDURE clc_; assembler; ASM clc; pushf; pop Regs.flags; END;
PROCEDURE cld_; assembler; ASM cld; pushf; pop Regs.flags; END;
PROCEDURE cmc_; assembler; ASM cmc; pushf; pop Regs.flags; END;
PROCEDURE sti_; assembler; ASM sti; pushf; pop Regs.flags; END;
PROCEDURE stc_; assembler; ASM stc; pushf; pop Regs.flags; END;
PROCEDURE std_; assembler; ASM std; pushf; pop Regs.flags; END;


PROCEDURE Loop (Modus : Byte);
VAR
  ProcName : String;
BEGIN
  If Modus=0 Then
  BEGIN dec (Regs.icx); If Regs.icx=0 Then BEGIN LastLoop:=0; Exit; END; END;

  If i<>LastLoop Then
  BEGIN
    LastLoop:= i;
    ProcName:= GetProcname (TLine[i]^)+':';
    While (i>1)         and (ProcName <> TLine[i]^) and (TLine[i]^<>'ASM') Do dec (i);
    While (i < LineNum) and (ProcName <> TLine[i]^) and (TLine[i]^<>'END') Do inc (i);
    If (i>=LineNum) or (TLine[i]^='END') Then ErrorMsg (ProcName, 'Sprungmarke nicht gefunden');
    LastLabel:= i;
  END Else i:= LastLabel;
END;


PROCEDURE Rep (Modus : Byte);
BEGIN
  IfRep:= 1;
  RepArt:= Modus;
  RepNum:= Regs.icx;
  Line:= GetProcname (Line);
END;



PROCEDURE Cmp;
BEGIN
  GetArgs (2);
  w1:= OutRegs (StrArr[1]);
  w2:= OutRegs (StrArr[2]);
  ASM mov ax, w1; cmp ax, w2; pushf; pop Regs.flags; END;
END;



PROCEDURE Jmp;
BEGIN
  CASE pos (' ', Line) Of
  3:
  If xPos ('JZ'  )=0 Then BEGIN If     Flag (fZ) Then loop (1); END Else
  If xPos ('JE'  )=0 Then BEGIN If     Flag (fZ) Then loop (1); END Else
  If xPos ('JA'  )=0 Then BEGIN If(not Flag (fC)) and (not Flag(fZ)) Then loop (1); END Else
  If xPos ('JB'  )=0 Then BEGIN If     Flag (fC) Then loop (1); END Else
  If xPos ('JG'  )=0 Then BEGIN If not Flag (fZ) Then loop (1); END Else
  If xPos ('JL'  )=0 Then BEGIN If Flag (fS) <>Flag (fO) Then loop (1); END Else
  If xPos ('JC'  )=0 Then BEGIN If     Flag (fC) Then loop (1); END Else
  If xPos ('JO'  )=0 Then BEGIN If     Flag (fO) Then loop (1); END Else
  If xPos ('JP'  )=0 Then BEGIN If     Flag (fP) Then loop (1); END Else
  ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
  4:
  If xPos ('JMP' )=0 Then BEGIN                       loop (1); END Else
  If xPos ('JNZ' )=0 Then BEGIN If not Flag (fZ) Then loop (1); END Else
  If xPos ('JNE' )=0 Then BEGIN If not Flag (fZ) Then loop (1); END Else
  If xPos ('JAE' )=0 Then BEGIN If not Flag (fC) Then loop (1); END Else
  If xPos ('JNB' )=0 Then BEGIN If not Flag (fC) Then loop (1); END Else
  If xPos ('JBE' )=0 Then BEGIN If (Flag(fC)) or (Flag(fZ)) Then loop (1); END Else
  If xPos ('JNA' )=0 Then BEGIN If (Flag(fC)) or (Flag(fZ)) Then loop (1); END Else
  If xPos ('JGE' )=0 Then BEGIN If Flag (fS) = Flag (fO) Then loop (1); END Else
  If xPos ('JNL' )=0 Then BEGIN If Flag (fS) = Flag (fO) Then loop (1); END Else
  If xPos ('JNC' )=0 Then BEGIN If not Flag (fC) Then loop (1); END Else
  If xPos ('JNP' )=0 Then BEGIN If not Flag (fP) Then loop (1); END Else
  If xPos ('JPO' )=0 Then BEGIN If not Flag (fP) Then loop (1); END Else
  If xPos ('JNO' )=0 Then BEGIN If not Flag (fO) Then loop (1); END Else
  If xPos ('JNS' )=0 Then BEGIN If not Flag (fS) Then loop (1); END Else
  If xPos ('JPE' )=0 Then BEGIN If     Flag (fP) Then loop (1); END Else
  ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
  5:
  If xPos ('JCXZ')=0 Then BEGIN If Regs.icx= 0   Then loop (1); END Else
  If xPos ('JNBE')=0 Then BEGIN If(not Flag (fC)) and (not Flag(fZ)) Then loop (1); END Else
  If xPos ('JNAE')=0 Then BEGIN If     Flag (fC) Then loop (1); END Else
  If xPos ('JNLE')=0 Then BEGIN If not Flag (fZ) Then loop (1); END Else
  If xPos ('JNGE')=0 Then BEGIN If Flag (fS) <>Flag (fO) Then loop (1); END Else
  ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
  Else
  ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
  END;
END;



PROCEDURE Assemb;
LABEL
  Nochmal;

BEGIN
  IfRep := 0;
  RepNum:= 1;

  Nochmal:
  If Line[Length(Line)] = ':' Then     Else
  If Line[1]            = 'J' Then jmp Else
  BEGIN
    Sign:= pos (' ', Line); If Sign=0 Then Sign:= Length (Line)+1;
    CASE Sign of
      6 :
      If xpos ('LODSB') = 0 Then lodsB     Else
      If xpos ('LODSW') = 0 Then lodsW     Else
      If xpos ('STOSB') = 0 Then stosB     Else
      If xpos ('STOSW') = 0 Then stosW     Else
      If xpos ('MOVSB') = 0 Then movs (0)  Else
      If xpos ('MOVSW') = 0 Then movs (1)  Else
      If xpos ('CMPSB') = 0 Then cmps (0)  Else
      If xpos ('CMPSW') = 0 Then cmps (1)  Else
      If xpos ('PUSHF') = 0 Then pushf     Else
      If xpos ('SCASB') = 0 Then Scas (0)  Else
      If xpos ('SCASW') = 0 Then Scas (1)  Else
      If xpos ('REPNE') = 0 Then BEGIN rep (1); Goto Nochmal; END Else
      ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
      5 :
      If xpos ('LOOP') = 0 Then BEGIN Loop (0); Exit; END Else
      If xpos ('XLAT') = 0 Then xlat      Else
      If xpos ('XCHG') = 0 Then xchg      Else
      If xpos ('POPF') = 0 Then popf      Else
      If xpos ('PUSH') = 0 Then push      Else
      If xpos ('SAHF') = 0 Then move (regs.iah, regs.flags, 1) Else
      If xpos ('LAHF') = 0 Then regs.iah:= lo (regs.flags) Else
      If xpos ('TEST') = 0 Then test      Else
      If xpos ('REPE') = 0 Then BEGIN rep (2); Goto Nochmal; END Else
      ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
      4 :
      If xpos ('MOV') = 0 Then AsmMov    Else
      If xpos ('INC') = 0 Then IncReg    Else
      If xpos ('DEC') = 0 Then DecReg    Else
      If xpos ('OUT') = 0 Then out_      Else
      If xpos ('INT') = 0 Then MakeInt   Else
      If xpos ('CMP') = 0 Then cmp       Else
      If xpos ('XOR') = 0 Then xor_      Else
      If xpos ('AND') = 0 Then and_      Else
      If xpos ('NOT') = 0 Then not_      Else
      If xpos ('ADD') = 0 Then add_      Else
      If xpos ('SUB') = 0 Then sub_      Else
      If xpos ('MUL') = 0 Then mul_      Else
      If xpos ('DIV') = 0 Then div_      Else
      If xpos ('SHL') = 0 Then shl_      Else
      If xpos ('SHR') = 0 Then shr_      Else
      If xpos ('ROL') = 0 Then rolror(1) Else
      If xpos ('ROR') = 0 Then rolror(0) Else
      If xpos ('POP') = 0 Then pop       Else
      If xpos ('LES') = 0 Then les       Else
      If xpos ('LEA') = 0 Then lds       Else
      If xpos ('LDS') = 0 Then lds       Else
      If xpos ('CLI') = 0 Then cli_      Else
      If xpos ('CLC') = 0 Then clc_      Else
      If xpos ('CLD') = 0 Then cld_      Else
      If xpos ('CMC') = 0 Then cmc_      Else
      If xpos ('STI') = 0 Then sti_      Else
      If xpos ('STC') = 0 Then stc_      Else
      If xpos ('STD') = 0 Then std_      Else
      If xpos ('REP') = 0 Then BEGIN rep (0); Goto Nochmal; END Else
      If xPos ('END') = 0 Then ASMon:= FALSE  Else
      ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
      3:
      If xpos ('IN')  = 0 Then in_       Else
      If xpos ('OR')  = 0 Then or_       Else
      ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
      Else
      ErrorMsg (Line, 'nicht untersttzter Assemblerbefehl');
    END;
  END;
END;


BEGIN
  Fillchar (regs, SizeOf (Regs), 0);
  ASM
    mov Regs.ies, es
    mov Regs.ids, ds
    cld
    pushf
    pop regs.flags
  END;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
