UNIT Run_Dat;


INTERFACE
USES
  DOS, Run_var, Run_if, Run_Stri, Run_tool, Strings;


PROCEDURE FileOp;
PROCEDURE DirOp;


IMPLEMENTATION
VAR
  LF : Boolean;


PROCEDURE MakeChangeRemDir (Modus : Byte);
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>1 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  CASE Modus Of
    1 : MkDir (StrArr[1]);
    2 : ChDir (StrArr[1]);
    3 : RmDir (StrArr[1]);
  END;
  Error:= IOResult;
END;



PROCEDURE GetDr;
VAR
  b : Byte;
  c : Char;
BEGIN
  GetArguments (GetKlammerString(Line));
  If  ArgNum<>2 Then ErrorMsg (Line, ParamNumError);
  If  StrArr[2, 1] <>'!' Then ErrorMsg (Line, 'verwenden Sie eine Variable mit !');
  c:= StrArr[2, 2];
  If (c> 'Z') or (c<'A')  Then ErrorMsg (Line, 'Fehler in Variablenname');
  If (StrArr[1, 1]='''') or (StrArr[1, 1]='#') or (StrArr[1, 1]='%')
  or (StrArr[1, 1]='!') Then b:= ord (upcase (GetFuncChar(StrArr[1])))-64 Else
  b:= Byte (GetFuncLong (StrArr[1]));
  If (b<0) or (b>26) Then ErrorMsg (Line, 'fehlerhafte Laufwerksangabe');
  GetDir (b, vStrgArr[c]);
  Error:= IOResult;
END;



PROCEDURE DirOp;
BEGIN
  If xpos ('GETDIR') = 0 Then GetDr Else
  If xpos ('MKDIR' ) = 0 Then MakeChangeRemDir (1) Else
  If xpos ('CHDIR' ) = 0 Then MakeChangeRemDir (2) Else
  If xpos ('RMDIR' ) = 0 Then MakeChangeRemDir (3) Else
  ErrorMsg (Line, 'unbekannter Befehl'); 
END;



PROCEDURE GetFileAttr_Time (Modus : Byte);
VAR
  f : File;
  w : Word;
  c : Char;
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>2 Then ErrorMsg (Line, ParamNumError);
  c:= StrArr[2, 2];
  If StrArr [2, 1] <> '@' Then ErrorMsg (Line, 'verwenden Sie eine Variable mit @');
  If (c> 'Z') or (c<'A')  Then ErrorMsg (Line, 'Fehler in Variablenname');
  CheckVariab;
  Assign (f, StrArr[1]);
  CASE Modus Of
    1 : BEGIN GetFAttr (f, w); Error:= DosError; vLongArr[c]:= w; END;
    2 : BEGIN Filemode:=0; Reset (f, 1); GetFTime (f, vLongArr[c]);  Close (f); Error:= IOresult; END;
    3 : BEGIN Filemode:=0; Reset (f, 1); vLongArr[c]:= FileSize (f); Close (f); Error:= IOresult; END;
  END;
END;



PROCEDURE SetFileAttr_Time (Modus : Byte);
VAR
  f : File;
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>2 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  Assign (f, StrArr[1]);
  CASE Modus Of
    1 : BEGIN SetFAttr (f, Byte (xxVal(StrArr[2]))); Error:= DosError; END;
    2 : BEGIN Filemode:=2; Reset (f, 1); SetFTime (f, xxVal(StrArr[2])); Close (f); Error:= IOresult; END;
  END;
END;




PROCEDURE EraseFile;
VAR
  f : File;
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>1 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  Assign (f, StrArr[1]);
  Erase (f);
  Error:= IOResult;
END;



PROCEDURE RenameFile;
VAR
  f : File;
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>2 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  Assign (f, StrArr[1]);
  Rename (f, StrArr[2]);
  Error:= IOResult;
END;



PROCEDURE CopyFile;
VAR
  f1, f2   : File;
  Buf      : Array[1..51200] Of Byte;
  gel, ges : Word;
  i        : LongInt;
BEGIN
  GetArguments (GetKlammerString(Line));
  If ArgNum<>2 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  Assign (f1, StrArr[1]);
  Assign (f2, StrArr[2]);
  FileMode:=0;
  Reset (f1, 1); SetFAttr (f2, 32); Rewrite (f2, 1);
  Error:= IOResult; If Error<>0 Then Exit;
  While (Not EOF (f1)) and (Error=0) Do
  BEGIN
    BlockRead  (f1, Buf, SizeOf(Buf), gel);
    BlockWrite (f2, Buf, gel, ges);
    Error:= IOResult;
    If gel<>ges Then Error:= 255;
  END;
  If Error <> 0 Then BEGIN Close (f1); Exit; END;
  GetFTime (f1, i); SetFTime (f2, i);
  Close (f1); Close (f2);
  Error:= IOResult; If Error<>0 Then Exit;
  GetFAttr (f1, gel); SetFAttr (f2, gel);
  DError:= DosError;
END;



PROCEDURE OpenFile;
BEGIN
  Closex;
  StrCopy (UpStr (GetFuncString(GetKlammerString(Line))), FNames[FNr]);
  Assign (fx[FNr], FNames[FNr]);
  CASE FNr Of
    1 : BEGIN FileMode:= 0; Reset (fx[1], 1); END;
    2 : BEGIN
          FileMode:= 2;
          If FNames[1] <> FNames[2] Then
          Rewrite (fx[2], 1) Else Reset (fx[2], 1);
        END;
  END;
  Error:= IOResult;
  If Error=0 Then Open[FNr]:= TRUE;
END;



PROCEDURE ReadWriteFile;
VAR
  s : String;
  c : Char;
  p : Byte;
BEGIN
  If Error<>0 Then Exit;
  StrCopy (GetKlammerString(Line), s);
  c:= s[2];
  If (c<'A') or (c>'Z') Then ErrorMsg (Line, 'Fehler in Variablenname');
  CASE FNr Of
    1 : BEGIN
          CASE s[1] Of
            '%' : BlockRead (fx[1], Block, SizeOf(Block), gelesen);
            '#' : BlockRead (fx[1], vCharArr[c], 1, gelesen);
            '@' : BlockRead (fx[1], vLongArr[c], 1, gelesen);
            '!' : BEGIN
                    BlockRead (fx[1], vStrgArr[c, 1], 254, gelesen);
                    vStrgArr[c, 0]:= chr (lo (gelesen));
                    If gelesen > 0 Then
                    BEGIN
                      p:= pos (#13#10, vStrgArr[c]);
                      If p<>0 Then
                      BEGIN
                        vStrgArr[c, 0]:= chr (p-1);
                        Seek(fx[1], FilePos(fx[1])-gelesen+p+1);
                        If IOResult<>0 Then;
                      END;
                    END;
                  END;
            Else  ErrorMsg (Line, 'ungltige Variable');
          END;
        END;
    2 : BEGIN
          CASE s[1] Of
            '%' : BEGIN
                    If gelesen>30000 Then ErrorMsg (Line, 'Variable @FRead darf nicht grer als 30000 sein');
                    BlockWrite (fx[2], Block, gelesen, geschrieben);
                  END;
            '#' : BlockWrite (fx[2], vCharArr[c], 1, geschrieben);
            '@' : BlockWrite (fx[2], vLongArr[c], 1, geschrieben);
            '!' : BEGIN
                    If (LF) and (pos (#13#10, vStrgArr[c])=0) Then
                    StrAdd (vStrgArr[c], #13#10);
                    BlockWrite (fx[2], vStrgArr[c, 1], Length(vStrgArr[c]), geschrieben);
                  END;
            Else  ErrorMsg (Line, 'ungltige Variable');
          END;
        END;
  END;
  Error:= IOResult;
END;



PROCEDURE SeekFile;
BEGIN
  If Error <>0 Then Exit;
  GetArguments (GetKlammerString(Line));
  CheckVariab;
  Seek (fx[FNr], xxVal (StrArr[1]));
  Error:= IOResult;
END;



PROCEDURE FileOp;
VAR
  Tmp : String;
BEGIN
  If pos ('(', Line)<>0 Then
  StrCopy (copy (Line, 1, pos ('(', Line)), tmp) Else StrCopy (Line, tmp);
  If pos ('OUT',   tmp) <> 0 Then FNr:= 1 Else
  If pos ('IN',    tmp) <> 0 Then FNr:= 2 Else
  BEGIN
    If pos ('RENAME',      tmp) = 1 Then RenameFile Else
    If pos ('ERASE',       tmp) = 1 Then EraseFile Else
    If pos ('COPYFILE',    tmp) = 1 Then CopyFile Else
    If pos ('SETFILEATTR', tmp) = 1 Then SetFileAttr_Time (1) Else
    If pos ('SETFILETIME', tmp) = 1 Then SetFileAttr_Time (2) Else
    If pos ('GETFILEATTR', tmp) = 1 Then GetFileAttr_Time (1) Else
    If pos ('GETFILETIME', tmp) = 1 Then GetFileAttr_Time (2) Else
    If pos ('GETFILESIZE', tmp) = 1 Then GetFileAttr_Time (3) Else
    ErrorMsg (Line, 'unbekannter Befehl');
    Exit;
  END;
  If pos ('OPEN',  tmp) = 1 Then OpenFile Else
  If pos ('CLOSE', tmp) = 1 Then Closex Else
  If pos ('READ',  tmp) = 1 Then ReadWriteFile Else
  If pos ('PUTSTR',tmp) = 1 Then BEGIN lf:= FALSE; ReadWriteFile END Else
  If pos ('PUT',   tmp) = 1 Then BEGIN lf:= TRUE;  ReadWriteFile END Else
  If pos ('SEEK',  tmp) = 1 Then SeekFile Else
  ErrorMsg (Line, 'unbekannter Befehl');
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
