UNIT RUN_File;

INTERFACE

USES Run_Var, Run_Stri, Run_Tool, Strings, dos;

PROCEDURE Read_Run_File (FileName : String);
PROCEDURE Read_All_Files;
PROCEDURE GetRAM;
PROCEDURE CheckSchachteln;


IMPLEMENTATION



PROCEDURE GetRAM;
BEGIN
  If not RAMFree Then Exit;
  MaxLines:= 0;
  RAMfree:= FALSE;
  While (MaxAvail > MaxLen+2) and (MaxLines < MaxLi) do
  BEGIN
    inc (MaxLines);
    GetMem (TLine[MaxLines], MaxLen+2);
  END;
END;


FUNCTION KommentOnPos : Byte;
VAR
  InKlam : Boolean;
  x      : Byte;
BEGIN
  InKlam:= FALSE;
  For x:= 1 To Length (Line) Do
  BEGIN
    If Line[x]='''' Then InKlam:= not InKlam Else
    If not InKlam Then
    BEGIN
      If (Line[x]= '{')
      or ((Line[x]='(') and (x<Length(Line)) and (Line[x+1]='*'))
      Then BEGIN KommentOnPos:= x; Exit; END;
    END;
  END;
  KommentOnPos:= 0;
END;


FUNCTION KommentOffPos : Byte;
VAR
  InKlam : Boolean;
  x      : Byte;
BEGIN
  InKlam:= FALSE;
  For x:= 1 To Length (Line) Do
  BEGIN
    If Line[x]='''' Then InKlam:= not InKlam Else
    If not InKlam Then
    BEGIN
      If (Line[x]= '}')
      or ((Line[x]=')') and (x>1) and (Line[x-1]='*'))
      Then BEGIN KommentOffPos:= x; Exit; END;
    END;
  END;
  KommentOffPos:= 0;
END;


PROCEDURE Read_Run_File (FileName : String);
VAR
  temp      : String;
  ltemp     : String;
  IsKomment : Boolean;
  p1, p2    : Byte;
LABEL
  Weiter;
BEGIN
  Assign (f, FileName);
  FileMode:= 0;
  Reset (f); Result:= IOResult;
  If Result<>0 Then ErrorMsg (FileName, 'Datei nicht gefunden');
  Result:=0; 
  IsKomment:= FALSE;
  LTemp:= '';

  While (not EOF (f)) and (LineNum < MaxLines) and (Result=0) Do 
  BEGIN
    If Length(LTemp)=0 Then
    BEGIN
      ReadLn (f, Line); Result:= IOResult;
      StrCopy (UpCaseString (Line), Line);
    END Else
    BEGIN
      StrCopy (LTemp, Line);
      LTemp[0]:= #0;
    END;

    p1:= KommentOnPos;
    p2:= KommentOffPos;
    If (p1 <> 0) and (p2 <> 0) Then delete (Line, p1, p2-p1+1) Else
    If (p1 <> 0) and (not IsKomment) Then
    BEGIN
      IsKomment:= TRUE;
      delete (Line, p1, 255);
    END Else
    If (p2 <> 0) and (IsKomment) Then
    BEGIN
      IsKomment:= FALSE;
      delete (Line, 1, p2);
    END Else
    If IsKomment Then Line:= '';

    StrCopy (Trim (Line), Line);

    p1:= pos ('BEGIN', Line);
    If (p1<>0) and (Line<>'BEGIN') and (Line<>'BEGIN-MAIN') Then
    BEGIN
      If p1>1 Then
      BEGIN
        lTemp:= Trim(copy (Line, p1, 255));
        Line := Trim(copy (Line, 1,  p1-1));
      END Else
      If p1=1 Then
      BEGIN
        lTemp:= Trim(copy (Line, 6, 255));
        Line := Trim(copy (Line, 1,  5));
      END;
      Goto Weiter;
    END;

    p1:= pos ('REPEAT', Line);
    If (p1<>0) and (Length (Line)>6) Then
    BEGIN
      If p1>1 Then
      BEGIN
        lTemp:= Trim(copy (Line, p1, 255));
        Line := Trim(copy (Line, 1,  p1-1));
      END Else
      If p1=1 Then
      BEGIN
        lTemp:= Trim(copy (Line, 7, 255));
        Line := Trim(copy (Line, 1,  6));
      END;
      Goto Weiter;
    END;

    p1:= pos ('ENDIF', Line);
    If (p1>1) and (Line<>'ENDIF') Then
    BEGIN
      lTemp:= Trim(copy (Line, p1, 255));
      Line := Trim(copy (Line, 1,  p1-1));
      Goto Weiter;
    END;

    p1:= pos ('ENDW', Line);
    If (p1>1) and (Line<>'ENDIF') Then
    BEGIN
      lTemp:= Trim(copy (Line, p1, 255));
      Line := Trim(copy (Line, 1,  p1-1));
      Goto Weiter;
    END;

    p1:= pos ('ENDFOR', Line);
    If (p1>1) and (Line<>'ENDFOR') Then
    BEGIN
      lTemp:= Trim(copy (Line, p1, 255));
      Line := Trim(copy (Line, 1,  p1-1));
      Goto Weiter;
    END;

    Weiter:

    If (Length(Line)<>0) and (Line[Length(Line)]<>';') Then CharAdd (Line,';');

    If (Line<>'') Then
    BEGIN
      While (pos (';', Line) <> 0) and (LineNum < MaxLines) Do
      BEGIN
        StrCopy (Trim (copy (Line, 1, pos (';', Line)-1)), temp);
        If Length (temp) > MaxLen-8 Then
        ErrorMsg (temp, #13#10'Ein Befehl darf max. '+xxStr(MaxLen-8)+' Zeichen lang sein.') Else
        If Length (temp)<>0 Then
        BEGIN
          inc (LineNum);
          StrCopy (temp, TLine[LineNum]^);
        END;
        Delete (Line, 1, pos (';', Line));
      END;
    END;
  END;

  If not EOF (f) Then ErrorMsg ('', 'Das Programm hat zuviele Zeilen.');
  Close (f); If IOResult<>0 Then;
  If Result<>0 Then ErrorMsg (FileName, 'Lesefehler in Datei.');
END;



PROCEDURE Read_All_Files;
VAR
  sr : SearchRec;
  sk : String;
BEGIN
  LineNum:= 0;
  Read_Run_File (FileName);
  GetUnitNames;
  If ArgNum>0 Then
  BEGIN
    For x:= 1 To ArgNum Do
    BEGIN
      FindFirst (StrArr[x], anyFile, sr);
      If DOSError <> 0 Then
      BEGIN
        StrCopy (FSearch (StrArr[x], GetEnv ('PATH')), sk);
        If (sk='') and (pos ('\', FileName) <> 0) Then
        BEGIN
          sk:= FileName;
          While (Length (sk)>0) and (sk[Length(sk)]<>'\') do dec (sk[0]);
          StrAdd (sk, StrArr[x]);
        END;
        StrCopy (sk, StrArr[x]);
      END;
    END;
    LineNum:= 0;
    For x:= 1 To ArgNum Do Read_Run_File (StrArr[x]);
    Read_Run_File (FileName);
  END;
  i:= 1;
  While (i < LineNum) and (TLine[i]^<>'BEGIN-MAIN') do inc (i);
END;




PROCEDURE CheckBeginEnd (Beginn, Ende : String; Modus : Byte);
CONST
  MaxSchachtel = 1025;

VAR
  x      : Word;
  Count  : Byte;
  wi     : array[0..MaxSchachtel] Of Word;

BEGIN
  Count:= 1;
  For x:= 1 To LineNum-1 Do
  BEGIN
    If (TLine[x]^[1] = BEGINN[1]) 
    and (Pos (BEGINN, TLine[x]^)=1) and ((Modus=1) or (TLine[x+1]^='BEGIN')) Then
    BEGIN
      If Count>=MaxSchachtel Then
      ErrorMsg (TLine[x]^, 'zuviele verschachtelte '+BEGINN+'-'+ENDE+'-Anweisungen');
      wi[Count]:= x;
      inc (Count);
    END Else
    If (TLine[x]^[1] = ENDE[1]) and (Pos (ENDE, TLine[x]^)=1) Then
    BEGIN
      dec (Count);
      If Count < 1 Then ErrorMsg (TLine[x]^, ENDE+' fehlt');
      CharAdd (TLine[x]^, '-');
      StrAdd  (TLine[x]^, xxStr(wi[Count]));
      CharAdd (TLine[x]^, '^');
      insert ('-'+ xxStr(x)+ '^', TLine[wi[Count]]^, Length (BEGINN)+1);
    END;
  END;
  If Count <> 1 Then ErrorMsg (TLine[x]^, ENDE+' fehlt');
END;



PROCEDURE CheckSchachteln;
BEGIN
  CheckBeginEnd    ('WHILE', 'ENDW',   0);
  CheckBeginEnd    ('IF',    'ENDIF',  0);
  CheckBeginEnd    ('FOR',   'ENDFOR', 0);
  CheckBeginEnd    ('REPEAT','UNTIL',  1);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
