UNIT Run_hex;

INTERFACE

USES
  Strings;


FUNCTION  ByteBits (Wert : Byte)    : String;
FUNCTION  WordBits (Wert : Word)    : String;
FUNCTION  LongBits (Wert : LongInt) : String;

FUNCTION  Bytehex  (Wert : Byte)    : String;
FUNCTION  Wordhex  (Wert : Word)    : String;
FUNCTION  LongHex  (Wert : LongInt) : String;



IMPLEMENTATION



FUNCTION Bit (Wert : LongInt; BitNr : Byte) : Byte;
VAR
  wa : array[1..2] of Word absolute Wert;
BEGIN
  dec (BitNr);
  If BitNr<=15 Then
  Bit:= ord (wa[1] and (1 shl  BitNr) <> 0) Else
  Bit:= ord (wa[2] and (1 shl (BitNr-16)) <> 0)
END;




FUNCTION ByteBits (Wert : Byte) : String;
VAR
  x : Byte;
  s : String;
BEGIN
  s:='';
  For x:= 1 To 8 Do CharAdd (s, char (Bit (Wert, x)+48));
  ByteBits:= s;
END;



FUNCTION WordBits (Wert : Word) : String;
VAR
  x : Byte;
  s : String;
BEGIN
  s:='';
  For x:= 1 To 16 Do CharAdd (s, char (Bit (Wert, x)+48));
  WordBits:= s;
END;



FUNCTION LongBits (Wert : LongInt) : String;
VAR
  x : Byte;
  s : String;
BEGIN
  s:='';
  For x:= 1 To 32 Do CharAdd (s, char (Bit (Wert, x)+48));
  LongBits:= s;
END;




FUNCTION Bytehex (Wert : Byte) : String;
VAR
  h, l : Byte;
BEGIN
  h:= Wert div 16; l:= Wert Mod 16;
  Bytehex:= chr (h+48+7*ord(h>9)) + chr (l+48+7*ord(l>9));
END;



FUNCTION Wordhex (Wert : Word) : String;
BEGIN
  WordHex:= ByteHex (hi(Wert)) + ByteHex (lo(Wert));
END;



FUNCTION LongHex (Wert : LongInt) : String;
VAR
  a : array[1..2] of Word absolute Wert;
BEGIN
  LongHex:= WordHex (a[2]) + WordHex (a[1]);
END;





END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
