UNIT Run_If;

INTERFACE
USES
  run_var, mouse, crt, Run_tool,
  keycode, dos, run_moni, run_hex, Strings;


PROCEDURE GetArguments (ein : String);
FUNCTION  GetEckKlammerWord (ein : String) : Word;
FUNCTION  GetFuncLong (Func : String) : LongInt;
FUNCTION  GetFuncChar (Func : String) : Char;
FUNCTION  GetFuncString (Func : String) : String;
FUNCTION  GetCharLine (ein : String) : String;
PROCEDURE CheckVariab;
FUNCTION  xSizeOf (ein : String) : LongInt;
FUNCTION  SegOfs (Ein : String; Modus : Byte) : Word;

PROCEDURE Cut_If;
PROCEDURE Cut_While;
PROCEDURE Cut_Until;
PROCEDURE Cut_For;


IMPLEMENTATION


FUNCTION xFSearch (Func : String) : String;
VAR
  ar   : SArr;
  oArg : Byte;
BEGIN
  ar:= StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString (Func));
  If Argnum<>2 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  xFSearch:= FSearch (StrArr[1], StrArr[2]);
  StrArr:= ar;
  ArgNum:= oArg;
END;



FUNCTION DskSize (Func : String; Mode : Byte) : LongInt;
VAR
  s : String;
  b : Byte;
BEGIN
  StrCopy (GetKlammerString (Func), s);
  If s[1]='''' Then s[2]:= UpCase (s[2]);
  If (s[1]='#') or (s[1]='''') Then b:= ord (GetFuncChar(s))-64 Else
  b:= Byte (GetFuncLong (s));
  If (b<0) or (b>26) Then ErrorMsg (Line, 'fehlerhafte Laufwerksangabe');
  CASE Mode Of
    1 : DskSize:= DiskSize (b);
    2 : DskSize:= DiskFree (b);
  END;
END;



FUNCTION GetByte (Func : String) : LongInt;
VAR
  tmp : String;
BEGIN
  Strcopy (GetKlammerString (Func), tmp);
  Case Tmp[1] Of
    '%' : If pos ('%BLOCK', tmp)=1 Then
          GetByte:= LongInt (GetFuncChar (tmp)) Else
          GetByte:= LongInt (GetFuncLong (tmp));
    '@' : GetByte:= LongInt (GetFuncLong (tmp));
    '#' : GetByte:= LongInt (GetFuncChar (tmp));
    '!' : GetByte:= LongInt (GetFuncChar (tmp));
    '''': GetByte:= LongInt (tmp[2]);
    Else  GetByte:= LongInt (GetFuncLong (tmp));
  END;
END;



FUNCTION HiLo (Func : String; Modus : Byte) : Word;
VAR
  tmp : Word;
BEGIN
  tmp:= Word (GetFuncLong (GetKlammerString (Func)));
  CASE Modus Of
    1 : Hilo:= Lo (tmp);
    2 : Hilo:= Hi (tmp);
    3 : Hilo:= Hi (tmp) * 256 + Lo (tmp);
    4 : Hilo:= Swap (Tmp);
  END;
END;



PROCEDURE GetArguments (ein : String);
VAR
  ar      : Array[0..NumArrMax] of Byte;
  Klammer : Integer;
  x       : Byte;
  Komma   : Boolean;

BEGIN
  Klammer:= 0; ArgNum:= 0; ar[0]:= 0; Komma:= False;

  For x:= 1 To Length (ein) Do
  BEGIN
    If ein[x]='('  Then inc (Klammer) Else If ein[x]=')' Then dec (Klammer);
    If ein[x]='''' Then Komma:= not Komma;
    If (Klammer=0) and (Not Komma) and ((ein[x]=',') or (ein[x]='+')) Then
    BEGIN
      inc (ArgNum);
      If ArgNum >= NumArrMax-1 Then
      ErrorMsg (Line, 'es knnen nicht mehr als '+xxStr(NumArrMax-1)+' Argumente verarbeitet werden');
      ar[ArgNum]:=x;
    END;
  END;

  If Klammer<>0 Then ErrorMsg (Line, 'Klammer fehlt oder ist berzhlig');
  If Komma      Then ErrorMsg (Line, 'Hochkomma fehlt oder ist berzhlig');
  inc (ArgNum); ar[ArgNum]:= Length(ein)+1;

  For x:= 1 To ArgNum Do
  StrCopy (Trim (copy (ein, ar[x-1]+1, ar[x]-ar[x-1]-1)), StrArr[x]);
END;
{Verteilt die Teilargumente eines eingeklammerten Strings in ein Array}



FUNCTION GetPos (Func : String) : Byte;
VAR
  ar   : SArr;
  oArg : Byte;
BEGIN
  ar  := StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString (Func));
  If Argnum<>2 Then ErrorMsg (Line, ParamNumError);
  CheckVariab;
  GetPos:= pos (StrArr[1], StrArr[2]);
  StrArr:= ar;
  ArgNum:= oArg;
END;



FUNCTION GetScrColCha (Func : String; Modus : Byte) : Byte;
VAR
  ar   : SArr;
  c    : Char;
  co   : Byte;
  oArg : Byte;
BEGIN
  ar  := StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString (Func));
  If Argnum<>2 Then ErrorMsg (Line, ParamNumError);
  GetSign1 (GetFuncLong (StrArr[1]), GetFuncLong (StrArr[2]), c, co);
  CASE Modus Of
    1 : GetScrColCha := co;
    2 : GetScrColCha := Byte (c);
  END;
  StrArr:= ar;
  ArgNum:= oArg;
END;



FUNCTION xSizeOf (ein : String) : LongInt;
BEGIN
  StrCopy (GetKlammerString (ein), ein);
  CASE ein[1] Of
    '@' : If pos ('[', ein) = 0 Then xSizeOf:= 4 Else xSizeOf:= 1;
    '#' : xSizeOf:= 1;
    '!' : If pos ('[', ein) = 0 Then xSizeOf:= SizeOf (String) Else xSizeOf:= 1;
    '%' : If pos ('%BLOCK', ein) = 1 Then
          BEGIN
            If pos ('[', ein) = 0 Then xSizeOf:= SizeOf (Block) Else xSizeOf:= 1;
          END Else
          If pos ('%DATETIME', ein) = 1 Then
          BEGIN
            If pos ('.', ein) = 0 Then xSizeOf:= SizeOf(DatTim) Else xSizeOf:= 2;
          END Else
          If pos ('%SEARCHREC', ein) = 1 Then
          BEGIN
            If pos ('.', ein) = 0 Then xSizeOf:= SizeOf(SRec) Else
            ErrorMsg (Line, 'Kann nur Gesamtgre von %SearchRec ermitteln');
          END;
     '''':xSizeOf:= Length (ein)-1;
     Else ErrorMsg (Line, '@SizeOf kann nur gltige Variablen auswerten');
  END;
END;



FUNCTION CopyStr (Func : String) : String;
VAR
  ar   : SArr;
  oArg : Byte;
BEGIN
  ar  := StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString(Func));
  If ArgNum<>3 Then ErrorMsg (Line, ParamNumError);
  CopyStr:= copy (GetFuncString(StrArr[1]), Byte (GetFuncLong(StrArr[2])), Byte (GetFuncLong (StrArr[3])));
  StrArr:= ar;
  ArgNum:= oArg;
END;


FUNCTION ConcatStr (Func : String) : String;
VAR
  ar   : SArr;
  oArg : Byte;
  tmp  : String;
  x    : Byte;
BEGIN
  tmp := '';
  ar  := StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString(Func));
  CheckVariab;
  For x:= 1 To ArgNum Do StrAdd (tmp, StrArr[x]);
  StrArr:= ar;
  ArgNum:= oArg;
  ConcatStr:= tmp;
END;



FUNCTION Rechne (Func : String; Modus : Byte) : LongInt;
VAR
  ar      : SArr;
  oArg, x : Byte;
  tmp     : LongInt;
BEGIN
  ar  := StrArr;
  oArg:= ArgNum;
  GetArguments (GetKlammerString(Func));
  If ArgNum < 1 Then ErrorMsg (Line, ParamNumError);
  tmp:= GetFuncLong (StrArr[1]);
  For x:= 2 To ArgNum Do
  BEGIN
    If ((Modus=7) or (Modus=8)) and (GetFuncLong (StrArr[x]) = 0) Then
    ErrorMsg (Line, DivisionByZero);
    CASE Modus Of
      1 : inc  (tmp,    GetFuncLong (StrArr[x]));
      2 : dec  (tmp,    GetFuncLong (StrArr[x]));
      3 : tmp:= tmp  or GetFuncLong (StrArr[x]);
      4 : tmp:= tmp xor GetFuncLong (StrArr[x]);
      5 : tmp:= tmp and GetFuncLong (StrArr[x]);
      6 : tmp:= tmp *   GetFuncLong (StrArr[x]);
      7 : tmp:= tmp div GetFuncLong (StrArr[x]);
      8 : tmp:= tmp mod GetFuncLong (StrArr[x]);
      9 : tmp:= tmp shl GetFuncLong (StrArr[x]);
     10 : tmp:= tmp shr GetFuncLong (StrArr[x]);
    END;
  END;
  StrArr:= ar;
  ArgNum:= oArg;
  Rechne:= Tmp;
END;



FUNCTION sswap (Func : String) : String;
VAR
  tmp : String;
BEGIN
  tmp:= '';
  Strcopy (GetFuncString(GetKlammerString(Func)), Func);
  For x:= Length (Func) DownTo 1 Do CharAdd (tmp, Func[x]);
  sswap:= tmp;
END;

{---------------------------------------------------------------------------}


FUNCTION GetEckKlammerWord (ein : String) : Word;
VAR
  a, b : Byte;
BEGIN
  a:= pos ('[', ein)+1;
  b:= LastPos (']', ein);
  If (a=1) or (b=0) Then GetEckKlammerWord:= 0 Else
  GetEckKlammerWord:= Word (GetFuncLong (Trim (copy (ein, a, b-a))));
END;



FUNCTION GetCharLine (ein : String) : String;
VAR
  tmp  : String;
  st   : String[3];
  x, y : Byte;
BEGIN
  tmp:=''; x:= 1;
  While x <= Length (ein) Do
  BEGIN
    inc (x); y:= 1;
    st[0]:= #0;
    While (x <= Length(ein)) and (ein[x] <> '#') and (y <= 3) Do
    BEGIN CharAdd (st, ein[x]); inc (x); inc (y); END;
    CharAdd (Tmp, Char (Byte (xxVal (st))));
  END;
  GetCharLine:= tmp;
END;



FUNCTION SegOfs (Ein : String; Modus : Byte) : Word;
TYPE
  a1 = array[0..3] Of Byte;
VAR
  a : ^a1;
  t : Word;
BEGIN
  If  ein[1]= '(' Then StrCopy (GetKlammerString (ein), ein);
  If (ein[2]<'A') or (ein[2]>'Z') Then ErrorMsg (TLine[i]^, 'Fehler in Variablenname');
  t:= GetEckKlammerWord (ein);
  CASE ein[1] Of
    '@' : BEGIN
            If t>3 Then ErrorMsg (Line, 'Der Index darf nicht grer als 3 sein');
            a:= addr (vLongArr[ein[2]]);
            VarOfs:= Ofs (a^[t]);
            VarSeg:= Seg (a^[t]);
          END;
    '!' : BEGIN
            If t>SizeOf(String)-1 Then ErrorMsg (Line, 'Der Index darf nicht grer als '+xxStr(SizeOf(String)-1)+' sein');
            VarOfs:= Ofs (vStrgArr[ein[2]][t]);
            VarSeg:= Seg (vStrgArr[ein[2]][t]);
          END;
    '%' : If pos ('%BLOCK', ein) = 1 Then
          BEGIN
            If t>SizeOf(Block)-1 Then ErrorMsg (Line, 'Der Index darf nicht grer als '+xxStr(SizeOf(Block)-1)+' sein');
            VarOfs:= Ofs (Block[t]);
            VarSeg:= Seg (Block[t]);
          END Else
          If (pos ('%DATETIME', ein)=1) and (pos ('.', ein)=0) Then
          BEGIN
            VarOfs:= Ofs (DatTim);
            VarSeg:= Seg (DatTim);
          END Else
          If (pos ('%SEARCHREC', ein)=1) and (pos ('.', ein)=0) Then
          BEGIN
            VarOfs:= Ofs (SRec);
            VarSeg:= Seg (SRec);
          END Else
          ErrorMsg (Line, 'Diese Adresse kann nicht ermittelt werden');
    '#' : BEGIN
            VarOfs:= Ofs (vCharArr[ein[2]]);
            VarSeg:= Seg (vCharArr[ein[2]]);
          END;
    Else  ErrorMsg (Line, 'Diese Adresse kann nicht ermittelt werden');
  END;
  CASE Modus Of
    Offset  : SegOfs := VarOfs;
    Segment : SegOfs := VarSeg;
  END;
END;



FUNCTION xMem (ein : String) : LongInt;
VAR
  a, b   : Byte;
  tmp    : String;
  w1, w2 : Word;
BEGIN
  a:= pos     ('[', ein);
  b:= Lastpos (']', ein);
  StrCopy (Trim (copy (ein, a+1, b-a-1)), tmp);
  a:= pos (':', tmp);
  If a= 0 Then ErrorMsg (Line, 'Adress-Element oder Doppelpunkt fehlt');
  w1:= word (GetFuncLong (Trim (copy (tmp, 1, a-1))));
  w2:= word (GetFuncLong (Trim (copy (tmp, a+1, Length(tmp)))));
  If pos ('%MEML', ein)=1 Then xMem:= MemL [w1 : w2] Else
  If pos ('%MEMW', ein)=1 Then xMem:= MemW [w1 : w2] Else
  If pos ('%MEM' , ein)=1 Then xMem:= Mem  [w1 : w2];
END;



FUNCTION xPort (ein : String) : Word;
VAR
  w  : Word;
BEGIN
  w:= GetEckKlammerWord (ein);
  If pos ('%PORTW', ein)=1 Then xPort:= PortW [w] Else
  If pos ('%PORT' , ein)=1 Then xPort:= Port  [w];
END;



FUNCTION GetFuncLong (Func : String) : LongInt;
VAR
  w : Word;
  l : LongInt;
  a : Array[0..3] Of Byte absolute l;
BEGIN
  If (Func [1] = '@') and (Func[2]>='A') and (Func[2]<='Z') Then
  BEGIN
    If Length (Func) = 2 Then GetFuncLong:= vLongArr[Func[2]] Else
    If  ( pos ('[', Func) > 0)
    and ((pos ('(', Func) > pos ('[', Func)) or (pos ('(', Func)=0)) Then
    BEGIN
      w:= GetEckKlammerWord (Func);
      If w > 3 Then ErrorMsg (Line, 'Der Index mu zwischen 0 und 3 liegen');
      l:= vLongArr[Func[2]];
      GetFuncLong:= a[w];
    END Else
    If Func = '@WHEREX'     Then GetFuncLong:= WhereX       Else
    If Func = '@WHEREY'     Then GetFuncLong:= WhereY       Else
    If Func = '@MOUSEY'     Then GetFuncLong:= ym           Else
    If Func = '@MOUSEX'     Then GetFuncLong:= xm           Else
    If Func = '@MOUSEBUT'   Then GetFuncLong:= Mousekn      Else
    If Func = '@PARAMCOUNT' Then GetFuncLong:= ParamCount-1 Else
    If Func = '@ENVCOUNT'   Then GetFuncLong:= EnvCount     Else
    If Func = '@KEYPRESSED' Then GetFuncLong:= ord (Keypressed) Else
    If Func = '@VIDEOMODE'  Then GetFuncLong:= VideoMode Else
    If Func = '@VIDEOSEG'   Then GetFuncLong:= VideoAddr Else
    If Func = '@ERROR'      Then GetFuncLong:= Error Else
    If Func = '@EOFIN'      Then BEGIN If Open[2] Then GetFuncLong:= ord (EOf (fx[2])) END  Else
    If Func = '@EOFOUT'     Then BEGIN If Open[1] Then GetFuncLong:= ord (EOf (fx[1])) END  Else
    If Func = '@FPOSIN'     Then BEGIN If Open[2] Then GetFuncLong:= FilePos  (fx[2])  END  Else
    If Func = '@FPOSOUT'    Then BEGIN If Open[1] Then GetFuncLong:= FilePos  (fx[1])  END  Else
    If Func = '@FSIZEIN'    Then BEGIN If Open[2] Then GetFuncLong:= FileSize (fx[2])  END  Else
    If Func = '@FSIZEOUT'   Then BEGIN If Open[1] Then GetFuncLong:= FileSize (fx[1])  END  Else
    If Func = '@FREAD'      Then GetFuncLong:= gelesen Else
    If Func = '@FWRITE'     Then GetFuncLong:= geschrieben Else
    If Func = '@RESULT'     Then GetFuncLong:= LongRes Else
    If Func = '@READONLY'   Then GetFuncLong:= $01 Else
    If Func = '@HIDDEN'     Then GetFuncLong:= $02 Else
    If Func = '@SYSFILE'    Then GetFuncLong:= $04 Else
    If Func = '@VOLUMEID'   Then GetFuncLong:= $08 Else
    If Func = '@DIRECTORY'  Then GetFuncLong:= $10 Else
    If Func = '@ARCHIVE'    Then GetFuncLong:= $20 Else
    If Func = '@ANYFILE'    Then GetFuncLong:= $3F Else
    If Func = '@TEXTATTR'   Then GetFuncLong:= TextAttr Else
    If pos ('@SEG',      Func) = 1  Then GetFuncLong:= SegOfs  (Func, 1) Else
    If pos ('@OFS',      Func) = 1  Then GetFuncLong:= SegOfs  (Func, 2) Else
    If pos ('@ORD',      Func) = 1  Then GetFuncLong:= GetByte (Func) Else
    If pos ('@ADD',      Func) = 1  Then GetFuncLong:= Rechne  (Func, 1) Else
    If pos ('@SUB' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 2) Else
    If pos ('@OR',       Func) = 1  Then GetFuncLong:= Rechne  (Func, 3) Else
    If pos ('@XOR' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 4) Else
    If pos ('@AND' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 5) Else
    If pos ('@MUL',      Func) = 1  Then GetFuncLong:= Rechne  (Func, 6) Else
    If pos ('@DIV' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 7) Else
    If pos ('@MOD' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 8) Else
    If pos ('@SHL' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func, 9) Else
    If pos ('@SHR' ,     Func) = 1  Then GetFuncLong:= Rechne  (Func,10) Else
    If pos ('@SUCC',     Func) = 1  Then GetFuncLong:= succ (GetByte (Func)) Else
    If pos ('@PRED' ,    Func) = 1  Then GetFuncLong:= pred (GetByte (Func)) Else
    If pos ('@SIZEOF',   Func) = 1  Then GetFuncLong:= xSizeOf (Func) Else
    If pos ('@BYTE',     Func) = 1  Then GetFuncLong:= GetByte (Func) Else
    If pos ('@LENGTH',   Func) = 1  Then GetFuncLong:= Length (GetFuncString (GetKlammerString (Func))) Else
    If pos ('@POS',      Func) = 1  Then GetFuncLong:= GetPos  (Func) Else
    If pos ('@GETATTR',  Func) = 1  Then GetFuncLong:= GetScrColCha(Func, 1) Else
    If pos ('@LO',       Func) = 1  Then GetFuncLong:= HiLo (Func, 1)  Else
    If pos ('@HI',       Func) = 1  Then GetFuncLong:= HiLo (Func, 2)  Else
    If pos ('@WORD',     Func) = 1  Then GetFuncLong:= HiLo (Func, 3)  Else
    If pos ('@SWAP',     Func) = 1  Then GetFuncLong:= HiLo (Func, 4)  Else
    If pos ('@ABS',      Func) = 1  Then GetFuncLong:= Abs (GetFuncLong(GetKlammerString(Func))) Else
    If pos ('@NEG',      Func) = 1  Then GetFuncLong:= Integer (GetFuncLong (GetKlammerString (Func))) Else
    If pos ('@NOT',      Func) = 1  Then GetFuncLong:= not (GetFuncLong (GetKlammerString (Func))) Else
    If pos ('@VAL',      Func) = 1  Then GetFuncLong:= xxVal (GetFuncString(GetKlammerString (Func))) Else
    If pos ('@DISKSIZE', Func) = 1  Then GetFuncLong:= DskSize (Func, 1) Else
    If pos ('@DISKFREE', Func) = 1  Then GetFuncLong:= DskSize (Func, 2) Else
    If pos ('@RANDOM',   Func) = 1  Then GetFuncLong:= Random (GetFuncLong(GetKlammerString (Func)))+1 Else
    If pos ('@DOSVERSION',Func)= 1  Then GetFuncLong:= DosVersion Else
    If pos ('@DOSERROR', Func) = 1  Then GetFuncLong:= DError Else
    If pos ('@ODD',      Func) = 1  Then GetFuncLong:= Ord (odd(GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('@CSEG',     Func) = 1  Then GetFuncLong:= CSeg Else
    If pos ('@SSEG',     Func) = 1  Then GetFuncLong:= SSeg Else
    If pos ('@DSEG',     Func) = 1  Then GetFuncLong:= DSeg Else
    If pos ('@SPTR',     Func) = 1  Then GetFuncLong:= SPtr Else
    If pos ('@PREFIXSEG',Func) = 1  Then GetFuncLong:= PrefixSeg Else
    If pos ('@WINDMIN',  Func) = 1  Then GetFuncLong:= WindMin Else
    If pos ('@WINDMAX',  Func) = 1  Then GetFuncLong:= WindMax Else
    If pos ('@DIRECTVIDEO', Func) = 1  Then GetFuncLong:= ord (DirectVideo) Else
    If pos ('@CHECKSNOW',   Func) = 1  Then GetFuncLong:= ord (CheckSnow) Else
    If pos ('@LASTMODE',    Func) = 1  Then GetFuncLong:= LastMode Else
    If pos ('@TRUE',      Func) = 1  Then GetFuncLong:= ord (TRUE) Else
    If pos ('@FALSE',     Func) = 1  Then GetFuncLong:= ord (FALSE) Else
    If pos ('@PROCNUM',   Func) = 1  Then GetFuncLong:= Procnum;
  END Else
  If pos ('%MEM',      Func) = 1  Then GetFuncLong:= xMem    (Func)    Else
  If pos ('%PORT',     Func) = 1  Then GetFuncLong:= xPort   (Func)    Else
  If pos ('%DATETIME', Func) = 1  Then
  BEGIN
    If pos ('.YEAR',      Func)<> 0 Then GetFuncLong:= DatTim.Year      Else
    If pos ('.MONTH',     Func)<> 0 Then GetFuncLong:= DatTim.Month     Else
    If pos ('.DAYOFWEEK', Func)<> 0 Then GetFuncLong:= DatTim.dayOfWeek Else
    If pos ('.DAY',       Func)<> 0 Then GetFuncLong:= DatTim.day       Else
    If pos ('.HOUR',      Func)<> 0 Then GetFuncLong:= DatTim.hour      Else
    If pos ('.MIN',       Func)<> 0 Then GetFuncLong:= DatTim.min       Else
    If pos ('.HUNSEC',    Func)<> 0 Then GetFuncLong:= DatTim.hunsec    Else
    If pos ('.SEC',       Func)<> 0 Then GetFuncLong:= DatTim.sec       Else
    ErrorMsg (Line, 'ungltiges Datums- oder Zeitfeld');
  END Else
  If Pos ('%SEARCHREC',  Func) = 1 Then
  BEGIN
    If Pos ('.ATTR',  Func) <> 0 Then GetFuncLong:= SRec.Attr Else
    If Pos ('.TIME',  Func) <> 0 Then GetFuncLong:= SRec.Time Else
    If Pos ('.SIZE',  Func) <> 0 Then GetFuncLong:= SRec.Size Else
    ErrorMsg (Line, 'Feld existiert nicht in %SEARCHREC');
  END Else
  If Func [1] = '!'  Then
  BEGIN StrCopy (GetFuncString (Func), Func); GetFuncLong:= Byte (Func [1]); END Else
  BEGIN GetFuncLong:= xxVal (Func); END;
END;



FUNCTION GetFuncChar (Func : String) : Char;
VAR
  w : Word;
BEGIN
  If Func[1]='#' Then
  BEGIN
    If (Length(Func)=2) and (Func[2]>='A') and (Func[2]<='Z') Then
    GetFuncChar:= vCharArr[Func[2]] Else
    If Func = '#KEY'     Then GetFuncChar:= t1    Else
    If Func = '#KEY2'    Then GetFuncChar:= t2    Else
    If Func = '#READKEY' Then GetFuncChar:= Readkey Else
    If pos ('#CHAR',    Func) = 1 Then GetFuncChar:= char (Byte (GetFuncLong (GetKlammerString (Func)))) Else
    If pos ('#UPCASE',  Func) = 1 Then GetFuncChar:= upCase (GetFuncChar (GetKlammerString (Func))) Else
    If pos ('#GETCHAR', Func) = 1 Then GetFuncChar:= char (GetScrColCha (Func, 2)) Else
    If pos ('#SUCC',    Func) = 1 Then GetFuncChar:= char (succ (GetByte (Func))) Else
    If pos ('#PRED' ,   Func) = 1 Then GetFuncChar:= char (pred (GetByte (Func))) Else
    If Func = '#F10'    Then GetFuncChar:= F10   Else
    If Func = '#ENTER'  Then GetFuncChar:= #13   Else
    If Func = '#ESC'    Then GetFuncChar:= #27   Else
    If Func = '#BACK'   Then GetFuncChar:= Back  Else
    If Func = '#TAB'    Then GetFuncChar:= Tab   Else
    If Func = '#UP'     Then GetFuncChar:= Up    Else
    If Func = '#DOWN'   Then GetFuncChar:= Down  Else
    If Func = '#PGUP'   Then GetFuncChar:= PgUp  Else
    If Func = '#PGDN'   Then GetFuncChar:= PgDn  Else
    If Func = '#LEFT'   Then GetFuncChar:= Left  Else
    If Func = '#RIGHT'  Then GetFuncChar:= Right Else
    If Func = '#ENTF'   Then GetFuncChar:= Entf  Else
    If Func = '#EINFG'  Then GetFuncChar:= Einfg Else
    If Func = '#POS1'   Then GetFuncChar:= Pos1  Else
    If Func = '#ENDX'   Then GetFuncChar:= Endx  Else
    If Func = '#SPACE'  Then GetFuncChar:= #32   Else
    If Func = '#RESULT' Then GetFuncChar:= CharRes  Else
    If (Func[2]='F') and (Func[3]>='1') and (Func[3]<='9') Then
    GetFuncChar:= chr (ord (Func[3])+10) Else
    GetFuncChar:= chr (xxVal (copy (Func, 2, 3)));
  END Else
  If Func [1] = '''' Then GetFuncChar:= Func[2] Else
  If Func [1] = '!'  Then
  BEGIN StrCopy (GetFuncString (Func), Func); GetFuncChar:= Func [1]; END Else
  If pos ('%BLOCK', Func) = 1 Then
  BEGIN
    w:= GetEckKlammerWord (Func);
    If w>30000 Then ErrorMsg (Line, 'Der Blockindex mu eine Zahl zwischen 0 und 30000 sein');
    GetFuncChar:= Block[w];
  END
  Else GetFuncChar:= Func[1];
END;



FUNCTION GetFuncString (Func : String) : String;
VAR
  w : Word;
BEGIN
  If (Func[1] = '!') and (Func[2]>='A') and (Func[2]<='Z') Then
  BEGIN
    If Length(Func)=2 Then GetFuncString:= vStrgArr[Func[2]] Else
    If  ( pos ('[', Func) > 0)
    and ((pos ('(', Func) > pos ('[', Func)) or (pos ('(', Func)=0)) Then
    BEGIN
      w:= GetEckKlammerWord (Func);
      If w > Length (vStrgArr[Func[2]]) Then ErrorMsg (Line, 'aktuelle Stringlnge kleiner als Index');
      GetFuncString:= vStrgArr[Func[2], byte(w)];
    END Else
    If pos ('!COPY'  ,    Func)=1 Then GetFuncString:= CopyStr (Func)  Else
    If pos ('!CONCAT',    Func)=1 Then GetFuncString:= ConcatStr (Func)  Else
    If pos ('!UPSTRING',  Func)=1 Then GetFuncString:= UpStr (GetFuncString (GetKlammerString (Func))) Else
    If pos ('!DOWNSTRING',Func)=1 Then GetFuncString:= LowStr  (GetFuncString (GetKlammerString (Func))) Else
    If pos ('!GETENV'  ,  Func)=1 Then GetFuncString:= Getenv (GetFuncString (GetKlammerString (Func))) Else
    If pos ('!ENVSTR'  ,  Func)=1 Then GetFuncString:= EnvStr (Byte (GetFuncLong (GetKlammerString (Func)))) Else
    If pos ('!PARAMSTR',  Func)=1 Then GetFuncString:= ParamStr(succ(Byte(GetFuncLong(GetKlammerString(Func)))))Else
    If pos ('!FEXPAND',   Func)=1 Then GetFuncString:= FExpand (GetFuncString(GetklammerString(Func))) Else
    If pos ('!FSEARCH',   Func)=1 Then GetFuncString:= xFsearch (Func) Else
    If pos ('!RUNPATH',   Func)=1 Then GetFuncString:= ParamStr(0) Else
    If pos ('!BHEX',      Func)=1 Then GetFuncString:= ByteHex (byte(GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!WHEX',      Func)=1 Then GetFuncString:= WordHex (Word(GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!LHEX',      Func)=1 Then GetFuncString:= LongHex (    (GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!BBIT',      Func)=1 Then GetFuncString:= ByteBits(byte(GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!WBIT',      Func)=1 Then GetFuncString:= WordBits(Word(GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!LBIT',      Func)=1 Then GetFuncString:= LongBits(    (GetFuncLong(GetKlammerString(Func)))) Else
    If pos ('!RESULT',    Func)=1 Then GetFuncString:= StringRes Else
    If pos ('!STR',       Func)=1 Then GetFuncString:= xxStr (GetFuncLong(GetKlammerString(Func))) Else
    If pos ('!SWAP',      Func)=1 Then GetFuncString:= sswap (Func);
  END Else
  If Func[1]= '''' Then GetFuncString:= DelHochkomma (Func) Else
  If Func[1]= '#'  Then GetFuncString:= GetCharLine (Func) Else
  If Func   = '%SEARCHREC.NAME' Then GetFuncString:= SRec.Name Else
  GetFuncString:= Func;
END;



PROCEDURE CheckVariab;
VAR
  x   : Byte;
  tmp : String;
BEGIN
  For x:= 1 To ArgNum Do
  If Length (StrArr[x])<>0 Then
  Case StrArr[x, 1] Of
    '$'  : StrCopy (xxStr(xxVal(StrArr[x])), StrArr[x]);
    '!'  : StrCopy (GetFuncString (StrArr[x]), StrArr[x]);
    '''' : StrCopy (GetFuncString (StrArr[x]), StrArr[x]);
    '#'  : If (LastPos ('#', StrArr [x])=1) or (pos ('(', StrArr [x])<>0) Then
           StrArr[x]:= GetFuncChar (StrArr[x]) Else
           StrCopy (GetCharLine (StrArr[x]), StrArr[x]);
    '@'  : StrCopy (xxStr (GetFuncLong (StrArr[x])), StrArr[x]);
    '%'  : If pos ('%BLOCK',    StrArr[x])=1 Then StrArr[x]:= GetFuncChar (StrArr[x]) Else
           If pos ('%MEM',      StrArr[x])=1 Then StrCopy (xxStr (GetFuncLong (StrArr[x])), StrArr[x]) Else
           If pos ('%PORT',     StrArr[x])=1 Then StrCopy (xxStr (GetFuncLong (StrArr[x])), StrArr[x]) Else
           If pos ('%DATETIME', StrArr[x])=1 Then StrCopy (xxStr (GetFuncLong (StrArr[x])), StrArr[x]) Else
           If pos ('%SEARCHREC',StrArr[x])=1 Then
           BEGIN
             If pos ('.NAME', StrArr[x])<>0 Then StrCopy (SRec.name, StrArr[x]) Else
             If pos ('.ATTR', StrArr[x])<>0 Then StrCopy (xxStr (SRec.attr), StrArr[x]) Else
             If pos ('.SIZE', StrArr[x])<>0 Then StrCopy (xxStr (SRec.size), StrArr[x]) Else
             If pos ('.TIME', StrArr[x])<>0 Then StrCopy (xxStr (SRec.Time), StrArr[x]) Else
             ErrorMsg (Line, 'Feld existiert nicht in %SEARCHREC');
           END;
  END;
END;



FUNCTION GetBool (tmp : String) : Boolean; forward;


FUNCTION Bool (ein : String) : Boolean;
CONST
  max = 6;
  a : Array [1..Max] of String[2]= ('>=','<=', '<>', '>', '<', '=');

VAR
  p      : Byte;
  l      : Byte;
  s1, s2 : String;
  l1, l2 : LongInt;
  c1, c2 : Char;
  Bol    : Boolean;
  b1     : Boolean;

BEGIN
  If pos ('(', ein)=1 Then BEGIN Bool:= GetBool (ein); Exit; END;

  If pos ('NOT', ein)=1 Then
  BEGIN Strcopy (GetProcName (ein), ein); b1:= FALSE; END Else b1:= TRUE;

  p:= 0; x:= 0;
  While (p=0) and (x<Max) do BEGIN inc (x); p:= Pos (a[x], ein); END;

  If p = 0 Then Bol:= GetFuncLong (ein) = 1 Else
  BEGIN
    If x<=3 Then l:=2 Else l:= 1;

    StrCopy (Trim (copy (ein, 1, p-1)), s1);
    StrCopy (Trim (copy (ein, p+l, Length (ein))), s2);

    If  (((s1[1]='!') and (pos ('[', s1)=0)) or ((s1[1]='''') and (s2[1]<>'#'))
    or ((s1[1]='#') and ((Lastpos('#', s1)>1) or (Length (s1)=2))))
    and (((s2[1]='!') and (pos ('[', s2)=0)) or ((s2[1]='''') and (s1[1]<>'#'))
    or ((s2[1]='#') and ((Lastpos('#', s2)>1) or (Length (s2)=2)))) Then
    BEGIN
      StrCopy (GetFuncString (s1), s1);
      StrCopy (GetFuncString (s2), s2);
      CASE x Of
        1 : Bol:= s1>=s2; 2 : Bol:= s1<=s2; 3 : Bol:= s1<>s2;
        4 : Bol:= s1> s2; 5 : Bol:= s1< s2; 6 : Bol:= s1= s2;
      END;
    END Else
    If  (((s1[1]='!') and (pos ('[', s1)<>0))
    or  (pos ('%BLOCK', s1)=1) or (s1[1]='#') or ((s1[1]='''') and (Length(s1)=3)))
    and (((s2[1]='!') and (pos ('[', s2)<>0))
    or  (pos ('%BLOCK', s2)=1) or (s2[1]='#') or ((s2[1]='''') and (Length(s2)=3)))
    Then
    BEGIN
      c1:= GetFuncChar (s1);
      c2:= GetFuncChar (s2);
      CASE x Of
        1 : Bol:= c1>=c2; 2 : Bol:= c1<=c2; 3 : Bol:= c1<>c2;
        4 : Bol:= c1> c2; 5 : Bol:= c1< c2; 6 : Bol:= c1= c2;
      END;
    END Else
    If  ((s1[1]='@') or (s1[1]='$') or (pos ('%DATETIME', s1)=1) or ((s1[1]>='0') and (s1[1]<='9')))
    and ((s2[1]='@') or (s2[1]='$') or (pos ('%DATETIME', s1)=1) or ((s2[1]>='0') and (s2[1]<='9'))) Then
    BEGIN
      l1:= GetFuncLong (s1);
      l2:= GetFuncLong (s2);
      CASE x Of
        1 : Bol:= l1>=l2; 2 : Bol:= l1<=l2; 3 : Bol:= l1<>l2;
        4 : Bol:= l1> l2; 5 : Bol:= l1< l2; 6 : Bol:= l1= l2;
      END;
    END Else
    ErrorMsg (ein, 'Auswertung nicht durchfhrbar');
  END;
  Bool:= Bol = b1;
END;



FUNCTION GetVergleich (ein : String; VAR Len : Byte) : String;
VAR
  y, z   : Byte;
BEGIN
  z:= 1;
  While ein[z]<>'(' Do inc (z);
  StrCopy (Trim (copy (ein, z, Length(ein))), ein);
  y:= 0; Len:= 0;
  REPEAT
    inc (Len);
    If ein[Len]='(' Then inc (y) Else If ein[Len]=')' Then dec (y);
  UNTIL (y=0) or (Len>=Length(ein));
  If y<>0 Then ErrorMsg (Line, 'fehlende oder berzhlige Klammer');
  Getvergleich:= copy (ein, 1, Len);
  inc (Len, pred(z));
END;



FUNCTION GetBool (tmp : String) : Boolean;
CONST
  MaxBools = 20;
VAR
  xtmp   : String;
  p      : Byte;
  x, y   : Byte;
  b      : array[1..MaxBools] Of Boolean;
  a      : Array[1..MaxBools] Of Byte;
  Len    : Byte;
  IfBool : Boolean;

BEGIN
  x:= 0;

  While (pos ('(', tmp)<>0) and (pos (')', tmp)<>0) and (x<MaxBools) Do
  BEGIN
    StrCopy (GetKlammerString(GetVergleich(tmp, Len)), xtmp);
    inc (x);
    b[x]:= Bool (xtmp);
    delete (tmp, 1, Len);
    Strcopy (Trim (tmp), tmp);
    If pos ('OR' , tmp)=1 Then a[x]:= 1 Else
    If pos ('AND', tmp)=1 Then a[x]:= 2 Else a[x]:=0;
  END;

  If (x=0) or ((x<=MaxBools) and (a[x]<>0)) Then
  ErrorMsg (Line, 'zuviele oder fehlende Vergleiche oder Klammern');

  IfBool:= b[1];
  For y:= 2 To x Do
  BEGIN
    If a[y-1]=1 Then IfBool:= IfBool or  b[y] Else
    If a[y-1]=2 Then IfBool:= IfBool and b[y];
  END;
  GetBool:= IfBool;
END;



PROCEDURE Cut_If;
VAR
  p, e : Byte;
  tmp  : String;
BEGIN
  e:= pos (' ELSE', Line); p:= pos (' THEN', Line);

  If p=0 Then ErrorMsg (Line, 'THEN oder Leerzeichen vor THEN fehlt');
  Strcopy (Trim (copy (Line, 1, p-1)), tmp);
  delete (tmp, 1, pos ('^', tmp));
  inc (p, 5);

  IfIs:= GetBool (tmp);

  If IfIs Then
  BEGIN
    If p < Length (Line) Then
    BEGIN
      If e=0 Then
      StrCopy (Trim(Copy(Line, p, Length(Line))), Line) Else
      StrCopy (Trim(Copy(Line, p, e-p)), Line);
    END Else
    BEGIN
      inc (i);
      StrCopy (TLine[i]^, Line);
    END;
  END Else
 {If Not IfIs Then}
  BEGIN
    If p >= Length (Line) Then i:= GetJumpLine Else
    If e<>0 Then BEGIN delete (Line, 1, e+5); Ifis:= True; END;
  END;
END;



PROCEDURE Cut_While;
VAR
  p, a, b : Byte;

BEGIN
  p:= pos (' DO', Line);
  If p=0 Then ErrorMsg (Line, 'DO oder Leerzeichen vor DO fehlt'); 
  a:= pos     ('(', Line);
  b:= lastpos (')', Line);
  inc (p, 3);        

  WhileIs:= GetBool (copy (Line, a, b-a+1));

  If WhileIs Then
  BEGIN
    If p < Length (Line) Then
    BEGIN StrCopy (Trim(Copy (Line, p, Length(Line))), Line); dec (i); END Else
    BEGIN
      inc (i);
      StrCopy (TLine[i]^, Line);
    END;
  END Else
 {If Not WhileIs Then}
  BEGIN
    If p >= Length (Line) Then i:= GetJumpLine;
    StrCopy (TLine[i]^, Line);
  END;
END;



PROCEDURE Cut_Until;
BEGIN
  RepeatIs:= GetBool (copy (Line, pos ('(', Line), Length(Line)));
  If not RepeatIs Then i:= GetJumpLine;
END;



PROCEDURE Cut_For;
VAR
  p, g, r, s, t, d : Byte;
  tmp              : String;
  x                : ^LongInt;
  y                : LongInt;
  k, l, hp         : Byte;
  p1               : Byte;

BEGIN
  p1:= pos (' DO', Line); 
  If  p1=0 Then ErrorMsg (Line, 'DO oder Leerzeichen vor DO fehlt');
  p:= pos (' DO', copy (Line, p1+1, Length(Line)));
  If p=0 Then p:= p1 Else p:= p+p1;

  hp:= pos ('^', Line); If hp=0 Then hp:= 3;
  StrCopy (Trim (copy (Line, hp+1, p-hp)), tmp);
  inc (p, 3);

  g:= pos (':=',      tmp); If g=0 Then ErrorMsg (tmp, ':= fehlt');
  d:= pos (' DOWNTO', tmp);
  t:= pos (' TO',     tmp);
  If (t=0) and (d=0) Then ErrorMsg (Line, 'TO, DOWNTO oder Leerzeichen vor diesen Worten fehlt');

  If t=0 Then BEGIN k:= d; l:= 7; END Else BEGIN k:= t; l:= 3; END;

  x:= Ptr (SegOfs (Trim (copy (tmp, 1, g-1)), Segment), VarOfs);
  y:= GetFuncLong (Trim (copy (tmp, k+l, Length (Tmp))));

  If ForInit=0 Then
  BEGIN
    x^:= GetFuncLong (Trim (copy (tmp, g+2, k-(g+2))));
    ForInit:= 1;
    If t<>0 Then dec (x^) Else inc (x^);
  END;

  If t<>0 Then
  BEGIN ForIs:=  x^ < y; If ForIs Then inc (x^); END Else
  BEGIN ForIs:=  x^ > y; If ForIs Then dec (x^); END;

  If ForIs Then
  BEGIN
    If p < Length (Line) Then
    BEGIN StrCopy (Trim(Copy (Line, p, Length(Line))), Line); dec (i); END Else
    BEGIN
      inc (i);
      StrCopy (TLine[i]^, Line);
    END;
  END Else
 {If Not ForIs Then}
  BEGIN
    If p >= Length (Line) Then i:= GetJumpLine;
    StrCopy (TLine[i]^, Line);
    ForInit:= 0;
  END;
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
