UNIT Run_Moni;

INTERFACE

USES
  crt;


CONST
  MonoMon = 1;
  FarbMon = 2;


VAR
  ScrMode    : Byte;
  VideoAddr  : Word;
  VideoMode  : Byte absolute $0040:$0049;



PROCEDURE VGAColorOn; 
PROCEDURE VGAColorOff;
PROCEDURE CursorOn;
PROCEDURE CursorOff;

PROCEDURE Rahmen   (a, b, c, d, h, t : Byte);
PROCEDURE Schatten (a, b, c, d       : Byte);
PROCEDURE GleitRahmen_einfach (xAnfang, yAnfang, xEnde, yEnde : Byte);
PROCEDURE GleitRahmen_doppelt (xAnfang, yAnfang, xEnde, yEnde : Byte);

PROCEDURE WriteXY (x, y : byte; S  : String; VColor, HColor : Byte);
PROCEDURE ChangeBackColor (x, y, z : byte; HColor : Byte);
PROCEDURE CharXY (x, y : Byte; c : char; VColor, HColor : Byte); 
PROCEDURE GetSign1 (x, y: Byte; VAR Zeich: Char; VAR Attri: Byte);
PROCEDURE SetBackColor (x, y, z1, z2 : Byte);


IMPLEMENTATION


VAR
  CurA, CurE    : Byte;



PROCEDURE VGAColorOn; assembler;
ASM;
  mov ah, $10
  mov al, $03
  mov bl, $00
  int $10
END;



PROCEDURE VGAColorOff; assembler;
ASM;
  mov ah, $10
  mov al, $03
  mov bl, $01
  int $10
END;



PROCEDURE CursorOff; Assembler;
ASM
  mov ah, 1
  mov ch, 40
  mov cl, 40
  int $10
END;



PROCEDURE CursorOn; Assembler;
ASM
  mov ah, 1
  mov ch, CurA
  mov cl, CurE
  int $10
END;



PROCEDURE ClearWin (a, b, c, d, e : Byte);
BEGIN
  TextAttr:=e; Window (a, b, c, d); ClrScr;
END;



PROCEDURE Rahmen (a, b, c, d, h, t : Byte);
VAR
  x, r, s : Byte;

BEGIN
  If ScrMode=FarbMon Then
  BEGIN If t=1 Then BEGIN r:= 8; s:=15; END Else BEGIN r:=15; s:= 8; END; END Else
  BEGIN If h=7 Then BEGIN r:= 0; s:= 0; END Else BEGIN r:= 7; s:= 7; END; END;

  CharXY (a, b, #218, r, h); 
  CharXY (c, b, #191, s, h);
  CharXY (a, d, #192, r, h); 
  CharXY (c, d, #217, s, h);

  For x:= succ(a) To pred(c) Do
  BEGIN CharXY (x, b, #196, r, h); CharXY (x, d, #196, s, h); END;

  For x:= succ(b) To pred(d) Do
  BEGIN CharXY (a, x, #179, r, h); CharXY (c, x, #179, s, h); END;

  inc (a); dec (c); dec (d); inc (b);
  ClearWin (a, b, c, d, h shl 4);
  Window (succ(a), b, pred(c), d);
END; 



PROCEDURE GleitRahmen_einfach (xAnfang, yAnfang, xEnde, yEnde : Byte);
VAR
  x, y : Byte;
BEGIN
  GotoXY  (xAnfang,     yAnfang );     Write (#218);
	For x := xAnfang+1 To xEnde-1 Do     Write (#196);
											                 Write (#191);
	GotoXY  (xAnfang,     yEnde   );     Write (#192);
	For x := xAnfang+1 To xEnde-1 Do     Write (#196);
																       Write (#217);
	For y := yAnfang+1 To yEnde-1 Do
	Begin
  	GotoXY  (xAnfang,     y     );     Write (#179);
  	GotoXY  (xEnde  ,     y     );     Write (#179);
  End;
END; 


PROCEDURE GleitRahmen_doppelt (xAnfang, yAnfang, xEnde, yEnde : Byte);
VAR
  x, y : Byte;

BEGIN
	GotoXY  (xAnfang,     yAnfang );     Write (#201);
	For x := xAnfang+1 To xEnde-1 Do     Write (#205);
											                 Write (#187);
	GotoXY  (xAnfang,     yEnde   );     Write (#200);
	For x := xAnfang+1 To xEnde-1 Do     Write (#205);
																       Write (#188);
	For y := yAnfang+1 To yEnde-1 Do
	Begin
		GotoXY  (xAnfang,     y       );     Write (#186);
		GotoXY  (xEnde  ,     y       );     Write (#186);
  End;
END;



PROCEDURE Schatten (a, b, c, d : Byte);
VAR
  x : Byte;
BEGIN
  inc(a); inc(b); inc(c); inc (d);
  For x:= b To d Do
  BEGIN SetBackColor (c, x, 8, 0); SetBackColor (c+1, x, 8, 0); END;
  For x:= a+1 To c Do SetBackColor (x, d, 8, 0);
END;



PROCEDURE WriteXY (x, y : Byte; S : String; VColor, HColor : Byte); assembler;
ASM
  mov dl, x;  mov bh, y;
  cmp dl, 1;  jb @raus;
  cmp bh, 1;  jb @raus;
  cmp bh, 50; ja @raus;
  mov ax, VideoAddr; mov es, ax;                {Segment Bildspeicher in es}
  push ds; cld; lds si, s;
  lodsb; xor ah, ah; mov cx, ax; jcxz @Ende;    {Stringlnge in cx}
  xor dh, dh; shl dl, 1;   mov al, 160; mul bh;
  add ax, dx; sub ax, 162; mov di, ax;          {Offset Bildspeicher in di}
  mov al, HColor;
  {$IFOPT G+}
    shl al, 4;
  {$ELSE}
    shl al, 1; shl al, 1; shl al, 1; shl al, 1
  {$ENDIF}
  add al, VColor;    {Farbe in al}
  @beginn:
     movsb;
     stosb;
  loop @beginn;
  @ende: pop ds;
  @raus:
END;



PROCEDURE ChangeBackColor (x, y, z, HColor : Byte); assembler;
ASM
  mov dl, x;  mov bh, y; 
  cmp dl, 1;  jb @raus;
  cmp bh, 1;  jb @raus;
  cmp bh, 50; ja @raus;
  mov cl, z;  xor ch, ch;
  mov ax, VideoAddr; mov es, ax;                {Segment Bildspeicher in es}
  xor dh, dh; shl dl, 1;   mov al, 160; mul bh;
  add ax, dx; sub ax, 161; mov di, ax;          {Offset  Bildspeicher in di}
  mov bh, 16; mov bl, HColor;
  {$IFOPT G+}
    shl bl, 4;        {neue Farbe in bl}
  {$ELSE}
    shl bl, 1; shl bl, 1; shl bl, 1; shl bl, 1
  {$ENDIF}
  @beginn:
     mov al, es:[di];
     xor ah, ah; div bh; add ah, bl;
     mov es:[di], ah;
     add di, 2;
  loop @beginn
  @raus:
END;




PROCEDURE CharXY (x, y : Byte; c : char; VColor, HColor : Byte); assembler;
ASM
  mov dl, x;  mov bh, y;
  cmp dl, 1;  jb @raus;
  cmp bh, 1;  jb @raus;
  cmp bh, 50; ja @raus;
  mov ax, VideoAddr; mov es, ax;                 {Segment Bildspeicher in es}
  xor dh, dh;  shl dl, 1;   mov al, 160; mul bh;
  add ax, dx;  sub ax, 162; mov di, ax;          {Offset  Bildspeicher in di}
  mov al, c;                                     {Zeichen in al}
  mov ah, HColor;
  {$IFOPT G+}
    shl ah, 4
  {$ELSE}
    shl ah, 1; shl ah, 1; shl ah, 1; shl ah, 1
  {$ENDIF}
  add ah, VColor;     {Farbe in ah}
  stosw;
  @raus:
END;



PROCEDURE GetSign1 (x, y: Byte; VAR Zeich: Char; VAR Attri: Byte);
VAR
  b : Word;
BEGIN
  b:= (x shl 1)+(y*160)-162;
  Zeich:= Chr (Mem[VideoAddr : b]); inc (b);
  Attri:=      Mem[VideoAddr : b];
END;



PROCEDURE SetBackColor (x, y, z1, z2 : Byte); assembler;
ASM
  mov dl, x;  mov bh, y;
  cmp dl, 1;  jb @raus;
  cmp bh, 1;  jb @raus;
  cmp bh, 50; ja @raus;
  mov ax, VideoAddr; mov es, ax;                {Segment Bildspeicher in es}
  xor dh, dh; shl dl, 1;   mov al, 160; mul bh;
  add ax, dx; sub ax, 161; mov di, ax;          {Offset  Bildspeicher in di}
  mov al, z2;
  {$IFOPT G+}
    shl al, 4
  {$ELSE}
    shl al, 1; shl al, 1; shl al, 1; shl al, 1;
  {$ENDIF}
  add al, z1;          {Farbe in al}
  stosb;
  @raus:
END;




{---------- Initialisierung (Feststellen der Videoadresse im RAM ----------}


BEGIN
  If videoMode= 7 Then
  BEGIN VideoAddr:=$B000; ScrMode:=MonoMon; curA:=12; CurE:=13; END Else
  BEGIN VideoAddr:=$B800; ScrMode:=FarbMon; curA:=6;  CurE:=7;  END;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
