UNIT Run_Str;


INTERFACE
USES
  DOS;



PROCEDURE StrCopy  (Quelle   : String; VAR Ziel);
PROCEDURE StrCat   (VAR Ziel; Q1, Q2   : String);
PROCEDURE StrAdd   (VAR Q1;    Q2       : String);
PROCEDURE CharAdd  (VAR Q1;    Zeichen  : Char  );
PROCEDURE ZeroStr  (Quelle  : String; VAR Ziel : String);
FUNCTION  PasStr   (Quelle  : String)          : String;


IMPLEMENTATION



PROCEDURE StrCopy (Quelle : String; VAR Ziel); assembler;
ASM
  mov bx, ds           {DS-Register in BX zwischenspeichern. Wichtig!}
  les di, Ziel         {Startadresse von Ziel in ES:DI laden}
  lds si, Quelle       {Startadresse von Quelle in DS:SI laden}
  cld                  {Adressen sollen hochgezhlt werden}
  lodsW                {Lade die ersten zwei Zeichen}
  stosW                {schreibe diese}

  mov cx, ax           {bernehme Lngenbyte aus AL-Register}
  xor ch, ch           
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep movsW            {kopiere sooft, bis CX = Null}

  mov ds, bx           {Restauriere DS-Register. Wichtig!}
END;
{schnellerer Ersatz fr Str1:= Str2 --> StrCopy (Str2, Str1)}



PROCEDURE StrCat (VAR Ziel; Q1, Q2 : String); assembler;
ASM
  mov bx, ds           {DS-Register in BX zwischenspeichern. Wichtig!}
  les di, Ziel         {Startadresse von Ziel in ES:DI laden}
  lds si, Q1           {Startadresse von Quelle1 in DS:SI laden}
  cld                  {Adressen sollen hochgezhlt werden}
  lodsW                {Lade die ersten zwei Zeichen}
  stosW                {schreibe diese}

  xor ah, ah
  mov cx, ax           {}
  mov dx, ax           {Stringlnge in dx zwischenspeichern}
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep movsW            {kopiere sooft, bis CX = Null}

  les di, Ziel         {Startadresse von Ziel in ES:DI laden}
  lds si, Q2           {Startadresse von Quelle2 in DS:SI laden}
  lodsb                {Lade Lngenbyte}
  mov cl, al
  add al, dl
  stosb                {schreibe Summe beider Lngenbytes}
  add di, dx           {Schreibzeiger wieder an letzte Position setzen}

  movsb                {Einzelbyte kopieren}
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep movsW            {kopiere sooft, bis CX = Null}

  mov ds, bx           {Restauriere DS-Register. Wichtig!}
END;
{schnellerer Ersatz fr Str1:= Str2+Str3 --> StrCat (Str1, Str2, Str3)}



PROCEDURE StrAdd (VAR Q1; Q2 : String); assembler;
ASM
  mov bx, ds           {DS-Register in BX zwischenspeichern. Wichtig!}
  les di, Q1           {Startadresse von Ziel in ES:DI laden}
  lds si, Q2           {Startadresse von Quelle1 in DS:SI laden}
  cld                  {Adressen sollen hochgezhlt werden}

  xor dx, dx
  mov dl, es:[di]
  lodsB
  mov cl, al
  add al, dl
  stosB
  add di, dx

  movsb                {Einzelbyte kopieren}
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep movsW            {kopiere sooft, bis CX = Null}

  mov ds, bx           {Restauriere DS-Register. Wichtig!}
END;
{Mehrfach schnellerer Ersatz fr Str1:= Str1+Str2 --> StrAdd (Str1, Str2)}




PROCEDURE CharAdd (VAR Q1; Zeichen : Char); assembler;
ASM
  cld
  xor ax, ax
  les di, Q1           {Startadresse von Ziel in ES:DI laden}
  mov al, es:[di]
  inc al
  stosB
  dec ax
  add di, ax
  mov al, Zeichen
  Stosb
END;
{Mehrfach schnellerer Ersatz fr Str1:= Str1+Char --> CharAdd (Str1, Char)}




PROCEDURE ZeroStr (Quelle : String; VAR Ziel : String); assembler;
ASM
  mov bx, ds; lds si, Quelle; les di, Ziel; cld;
  lodsb; xor ah, ah; mov dx, ax;
  mov cx, ax; jcxz @ende;
  shr cx, 1
  rep movsW
  test dx, 1
  je @ende
  movsB
  @ende:
  xor al, al
  stosb
  mov ds, bx
END;
{Verwandelt einen Pascal-String in einen null-terminierten String}




FUNCTION PasStr (Quelle : String) : String; assembler;
ASM
  cld
  les di, Quelle
  xor al, al
  mov dx, 255
  mov cx, dx
  repne scasb
  sub dx, cx
  dec dx

  mov bx, ds
  lds si, Quelle
  les di, @Result
  mov cx, dx
  mov ax, dx
  stosb
  rep MovsB

  mov ds, bx
END;
{Verwandelt einen null-terminierten String in einen Pascal-String}



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
