UNIT Run_Tool;

INTERFACE
USES
  run_Var, crt, Run_moni, Run_str, mouse;

PROCEDURE w1 (s : String);
PROCEDURE w0 (s : String);
FUNCTION  UpCaseString (ein : String) : String;
FUNCTION  DownCaseStr (s : String) : String;
FUNCTION  GetProcName (ein : String) : String;
FUNCTION  GetJumpLine : Word;
FUNCTION  GetFuncName (ein : String) : String;
FUNCTION  xPos (Strg : String) : Word;
PROCEDURE Init;
PROCEDURE FreeRAM;
PROCEDURE Closex;
PROCEDURE ErrorMsg (Line, Msg : String);
FUNCTION  xVAL (s : String) : LongInt;
FUNCTION  xStr (s : LongInt) : String;
FUNCTION  BackPos (Zeichen : Char; Quelle : String) : Byte; 
FUNCTION  DelSpace (ein : String) : String;
FUNCTION  DelHochKomma (ein : String) : String;
FUNCTION  GetKlammer (ein : String) : String;
FUNCTION  GetKlammerString (ein : String) : String;
PROCEDURE Hilfe;


IMPLEMENTATION

PROCEDURE w1 (s : String); BEGIN WriteLn (s); END;
PROCEDURE w0 (s : String); BEGIN Write   (s); END;



FUNCTION GetProcName (ein : String) : String;
VAR
  p : Byte;
BEGIN
  p:= pos (#32, ein);
  If p<>0 Then
  GetProcName:= delspace (copy (ein, p, MaxLen)) Else GetProcName:='';
END;



FUNCTION GetJumpLine : Word;
VAR
  p : Byte;
BEGIN
  p:= pos ('-', Line)+1;
  GetJumpLine:= xVal (copy (Line, p, pos ('^', Line)-p));
END;



FUNCTION GetFuncName (ein : String) : String;
VAR
  a, b : Byte;
BEGIN
  a:= pos ('&', ein);
  inc (a);
  b:= a;
  While (b<Length(ein)) and (ein[b]>',') and (ein[b]<>']') Do inc (b);
  dec (b, a);
  GetFuncName:= copy (ein, a, b);
END;




FUNCTION xPos (Strg : String) : Word; assembler;
ASM
  lea di, Line
  mov ax, ds
  mov es, ax
  mov dl, es:[di]
  inc di
  mov bx, ds
  lds si, Strg
  cld
  lodsb

  mov cx, 1
  cmp dl, al
  jb @ende

  mov cl, al
  jcxz @ende
  inc cl
  repe cmpsb

  @ende:
  mov ds, bx;
  mov ax, cx
END;



FUNCTION UpCaseString (ein : String) : String; assembler;
ASM
  mov dx, ds; cld; lds si, ein; les di, @Result
  lodsb; stosb; xor ah, ah ; mov cx, ax; jcxz @3
  xor bh, bh
 @1:
  lodsb
  cmp al, 39
  jne @weiter
    or bh, bh
    jz @drehe
    xor bh, bh
    jmp @weiter;
    @drehe:
    mov bh, 1
  @weiter:
  cmp bh, 1
  je @2;
  cmp al, 'a'; jb  @2
  cmp al, 'z'; ja  @a
  sub al,  32; stosb; loop @1; jmp @3
 @a: cmp al, ''; jne @b; mov al, ''; jmp @2
 @b: cmp al, ''; jne @c; mov al, ''; jmp @2
 @c: cmp al, ''; jne @2; mov al, ''; 
 @2:
  stosb
  loop @1
 @3:
  mov ds, dx;
END; {Verwandelt alle Zeichen eines Strings in Grobuchstaben}



FUNCTION DownCaseStr (s : String) : String; assembler;
ASM
  mov dx, ds; cld; lds si, s;  les di, @Result
  lodsb; stosb; xor ah, ah; mov cx, ax; jcxz @3
 @1:
  lodsb
  cmp al, 'A'; jb  @2
  cmp al, 'Z'; ja  @a
  add al,  32; stosb; loop @1; jmp @3
 @a: cmp al, ''; jne @b; mov al, ''; jmp @2
 @b: cmp al, ''; jne @c; mov al, ''; jmp @2
 @c: cmp al, ''; jne @2; mov al, ''; 
 @2:
  stosb
  loop @1
 @3:
  mov ds, dx
END;  {Verwandelt alle Zeichen eines Strings in Kleinbuchstaben}



PROCEDURE Init;
BEGIN Window (1, 1, 80, 25); TextAttr:= 7; ClrScr; CursorOn; END;



PROCEDURE FreeRAM;
BEGIN
  If RAMFree Then Exit;
  While MaxLines > 0 Do
  BEGIN FreeMem (TLine[MaxLines], MaxLen+2); dec (MaxLines); END;
  RAMFree:= TRUE;
END;


PROCEDURE Closex;
BEGIN
  If Open[FNr] Then Close (fx[FNr]); If IOResult<>0 Then;
  Open[FNr]:= FALSE;
  FNames[FNr]:= '';
END;



PROCEDURE ErrorMsg (Line, Msg : String);
BEGIN
  MouseOff;
  FNr:= 1; Closex; FNr:= 2; Closex; 
  FreeRAM;
  ChDir (ActDir); If IOResult<>0 Then;
  Init;
  W1 (Line); W0 ('- '); w0(Msg); W1 ('. Weiter mit TASTE');
  ASM mov ah, 0; int $16; END;
  Halt;
END;



FUNCTION xVAL (s : String) : LongInt;
VAR
  tmp  : LongInt;
  code : Integer;
BEGIN
  Val (s, tmp, code);
  If Code <> 0 Then ErrorMsg (Line, 'Fehler in Ziffernfolge') Else
  xVal:= tmp;
END;



FUNCTION xStr (s : LongInt) : String;
VAR
  tmp : String;
BEGIN
  Str (s, tmp); xStr:= tmp;
END;



FUNCTION Delspace (ein : String) : String; assembler;
ASM
  mov bx, ds; cld; les di, @Result;
  lds si, ein;
  lodsb; xor ah, ah; xor dl, dl; mov cx, ax; jcxz @1
  lds si, ein; std; add si, cx;
  @a: lodsb; cmp al, 32; jne @b; loop @a; jmp @1;
  @b: lds si, ein; cld; mov dl, cl; inc cx; inc si;
  @c: lodsb; cmp al, 32; jne @d; dec dl;  loop @c; jmp @1;
  @d: sub si, 2; inc cx; rep movsb;
@1:
  les di, @Result; mov al, dl; stosb;
  mov ds, bx;
END;



FUNCTION DelHochKomma (ein : String) : String;
VAR
  b : Byte absolute ein;
BEGIN
  If  ein[b]= ''''  Then dec (b);
  If  ein[1]= ''''  Then delete (ein, 1, 1);
  DelHochkomma:= Ein;
END;



FUNCTION BackPos (Zeichen : Char; Quelle : String) : Byte; assembler;
ASM
  les di, Quelle
  xor cx, cx
  mov cl, es:[di]
  add di, cx
  inc cx
  std
  mov al, Zeichen
  repne scasB
  mov ax, cx
END;
{Wie POS, es wird jedoch das letzte Vorkommen von Zeichen angezeigt}




FUNCTION GetKlammerString (ein : String) : String;
VAR
  p : Byte;
BEGIN
  p:= pos ('(', Ein) + 1;
  GetKlammerString:= delspace (copy (Ein, p, backpos (')', Ein)-p));
END;



FUNCTION GetKlammer (ein : String) : String;
VAR
  p : Byte;
BEGIN
  p:= pos ('(', Ein) + 1;
  GetKlammer:= delspace (copy (Ein, p, pos (')', Ein)-p));
END;



PROCEDURE Hilfe;
CONST
t1=#13#10+
   'RUN   Copyright (C) 1996 Andr Olejko'#13#10#10+
   'PASCAL-ASSEMBLER-Interpreter fr ausfhrbare RUN-Dateien'#13#10#10+
   'RUN [Dateiname] [Parameter 1..10] [/debug, /cut oder /list]'#10;
t2='Dateiname : Pfad oder Name der auszufhrenden Datei (Endung .RUN)'#13#10#10+
   'Parameter : Kommandozeilen-Parameter fr die RUN-Datei'#13#10#10+
   '/debug    : schrittweise Ausfhrung der RUN-Datei. Die gerade abgearbeitete';
t3='            Befehlszeile wird am unteren Bildschirmrand angezeigt.'#13#10#10+
   '/cut      : Programm kann jederzeit mit einem Tastendruck beendet werden.'#13#10+
   '            Anwenden bei Gefahr von Endlos-Schleifen.'#13#10;
t4='/list     : zeigt den geladenen Quellcode in der von RUN umgearbeiteten'#13#10+
   '            Form. Hilfsmittel bei der Suche nach unerklrlichen Fehlern.'#13#10#10+
   'Wenn Sie keinen Dateinamen angeben, zeigt RUN eine Eingabezeile.';
t5='Ausfhrliche Hilfe finden Sie in den Dateien RUNxxxx.HLP'#10;
BEGIN
  ClrScr;
  w1 (t1);
  w1 (t2);
  w1 (t3);
  w1 (t4); 
  w1 (t5);
  Halt;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
