PROGRAM ScanDrv;
{$M 65000, 0, 650000}

USES
  Monitor, monit, DOS, bioscrt, scan_txt, Strings, mouse, scan_but,
  scan_var, sperre, time, rechnen, scan_uni, Disk, LogFile;



PROCEDURE DrawKasten (Ch : Char; vcol, hcol : Byte);
BEGIN
  With Act Do
  If Kast<LastKast Then
  BEGIN
    If X<54 Then inc (X) Else BEGIN X:= 4; inc (Y); END;
    inc (Kast);
    CharXY (X, Y, ch, vcol, hcol);
  END;
END;



PROCEDURE Balken (Modus : Byte);
VAR
  m : Word;
BEGIN
  If gelesen >= KSize Then
  BEGIN
    m:=0;
    WHILE m*KSize <= Gelesen Do
    BEGIN 
      inc (m);
      If (Modus=Fehlerhaft) and (m>1) Then Modus:= OverJump;
      CASE Modus Of
        Vollbelegt : DrawKasten (#8,  yellow,     red);
        Teilbelegt : DrawKasten (#8,  lightgreen, red);
        Fehlerhaft : DrawKasten ('F', lightred,   0);
        OverJump   : DrawKasten (#26, lightblue,  0);
        Nichtger   : DrawKasten ('-', lightcyan,  0);
        Gerettet   : DrawKasten ('X', lightcyan,  0);
      END;
    END;
    dec (gelesen, (m*KSize));
  END;
END;



PROCEDURE Read_a_File (Quelle : PathStr; FSize : LongInt);
CONST
  MaxVersuche= 5;
VAR
  Q          : File;
  Error, i   : Word;
  Reading,
  XRead,
  LastSec    : LongInt;
  Bindex     : Word;
  Versuche   : Word;
  Err        : Word;
  FileCluster: LongInt;

BEGIN
  Old:= Act; Dateiretten:= FALSE;

  inc (Dateien); WriteXY (67, 7, LongStr (Dateien), 15, 7);
  If FSize=0 Then Exit;

  Fusszeile (22, Quelle, 14, 1);

  Error:=0; Reading:=0;

  If Clustersize=0 Then ClusterSize:=1;
  FileCluster:= FSize DIV ClusterSize + ord (FSize MOD ClusterSize<>0);

  Assign (Q, Quelle); FileMode:= 0;
  Versuche:= 0;
  REPEAT
    Reset (Q, 1); Error:= IOresult;
    inc (Versuche);
  UNTIL (Error=0) or (Error=5) or (Versuche>=MaxVersuche);

  If Error<>0 Then
  BEGIN
    If Error=5 Then
    BEGIN
      Err:= GetExtendedError;
      If (Err=$20) or (Err=$21) Then
      BEGIN
        ErrorText (Quelle, FSize, 1000, 3);
        Checkbericht (3);
        Error:= 0;
      END;
    END;
    If Error<>0 Then
    BEGIN
      ErrorText (Quelle, FSize, Error, 1);
      Checkbericht (1);
      inc (Defekte_Dateien);
      WriteXY (67, 8, LongStr (Defekte_Dateien), 15, 7);
    END;
    inc (gelesen, (ClusterSize*FileCluster));
    inc (ReadingSectors, (FileCluster*SecProCl));
    WriteXY (67, 6, LongStr (ReadingSectors), 15, 7);
    If Error<>0 Then Balken (Fehlerhaft) Else Balken (OverJump);
    Exit;
  END;
  
  LastSec:= ReadingSectors;
  XRead  := (FileCluster*ClusterSize)-FSize;

  While not Eof (Q) Do
  BEGIN
    BlockRead (Q, Buf^, BufSize, i); Error:=IOresult;

    inc (Gelesen, i);
    inc (Reading, i);

    If Error<>0 Then
    BEGIN
      If Error=5 Then Err:= GetExtendedError Else Err:= 0;
      If (Err=$20) or (Err=$21) Then
      BEGIN
        ErrorText (Quelle, FSize, 1000, 3);
        Checkbericht (3);
        Error:= 0;
      END;
      If Error<>0 Then
      BEGIN
        Close (Q);
        inc (Defekte_Dateien);
        WriteXY (67, 8, LongStr (Defekte_Dateien), 15, 7);
        ErrorText (Quelle, FSize, Error, 2);
      END;
      inc (Gelesen, ((FSize-Reading)+XRead));
      ReadingSectors:= LastSec + (FileCluster*SecProCl);
      WriteXY (67, 6, LongStr (ReadingSectors), 15, 7);
      If Error<>0 Then
      BEGIN Balken (Fehlerhaft); Dateiretten:= TRUE; Exit; END Else
      Balken (OverJump);
    END;

    inc (ReadingSectors, BufSize DIV SektorSize);
    WriteXY (67, 6, LongStr (ReadingSectors), 15, 7);

    BIndex:=0;
    While BIndex< BufSize Do
    BEGIN
      If (BIndex+SektorSize=BufSize) and (i<BufSize) Then 
      Balken (Teilbelegt) Else Balken (Vollbelegt);
      inc (BIndex, SektorSize);
    END;
    If keypressed Then
    BEGIN
      ScanKeys;
      If t1=#27 Then BEGIN ExCode:=1; Close (Q); Exit; END Else t1:= #0;
    END;
  END;

  Close (Q);
  inc (gelesen, XRead);
  If XRead<>0 Then Balken (TeilBelegt) Else Balken (Vollbelegt);
  ReadingSectors:= LastSec + (FileCluster*SecProCl);
END;


PROCEDURE Repair_File (Name : PathStr; FSize : LongInt);
VAR
  Q, Q1           : File;
  s               : Char;
  gel, ges        : Word;
  ToRead          : Word;
  Versuche        : Byte;
  FPos            : LongInt;
  Result          : Word;
  ZielPfad        : PathStr;
  sOld            : PosRec;
  Filled          : Boolean;
  Lese            : Word;

CONST
  MaxVersuche     = 10;
LABEL
  Ende, Endx, Stop, Fill;

BEGIN
  inc (RepDateien);
  Repair_Laufwerk;
  If ExCode<>0 Then Goto Endx;

  sOld:= Act; Act:= Old; GoodBytes:= 0;
  ToRead:= SektorSize; If ToRead>BufSize Then ToRead:= BufSize;

  Repair_Anzeige;
  If t1='N' Then Goto Ende Else
  If t1=#27 Then BEGIN ExCode:= 1; Goto Ende; END;

  Repair_DeskTop;
  WriteXY (67, 8, LongStr(RepDateien), 15, 7);

  Assign (Q, Name); FileMode:= 0;
  Reset (Q, 1);
  If IOResult<>0 Then
  BEGIN
    ErrMsg (' Quelldatei konnte nicht geffnet werden. Weiter mit Taste');
    Goto Stop;
  END;

  ZielPfad:= Name;
  If pos ('\', ZielPfad)<>0 Then delete (ZielPfad, 1, pos ('\', ZielPfad));
  ZielPfad:=  VollPfad (Pfad, ZielPfad);

  Assign (Q1, ZielPfad);
  ReWrite (Q1, 1);
  If IOResult<>0 Then
  BEGIN
    MakeTree (GetPathName (ZielPfad));
    If DOSError=0 Then BEGIN ReWrite (Q1, 1); DOSError:= IOResult; END;
    If DOSError<>0 Then
    BEGIN
      Close (Q);
      ErrMsg (' Zieldatei konnte nicht angelegt werden. Weiter mit Taste');
      Goto Stop;
    END;
  END;

  FPos:=0; gelesen:= 0;

  Fusszeile (24, 'Versuche Rettung der Datei. (berspringen: beliebige Taste)', white, brown);

  While not Eof (Q) Do
  BEGIN
    Seek (Q, FPos);
    Versuche:= 0;
    Lese:= ToRead; If Lese>FSize-FPos Then Lese:= FSize-FPos; 
    REPEAT
      If keypressed Then
      BEGIN
        WaitKey;
        ZW_Fragefenster;
        CASE t1 Of
          'S' : Goto Fill;
          'D', #27 : BEGIN
                       While Act.Kast<sOld.Kast
                       Do DrawKasten ('-', lightcyan, 0);
                       If t1=#27 Then ExCode:= 1;
                       Goto Stop;
                     END;
        END;
      END;
      inc (Versuche);
      BlockRead (Q, Buf^, Lese, gel);
      Result:= IOResult;
    UNTIL (Result=0) or (Versuche>=MaxVersuche);

    If Result <> 0 Then
    BEGIN
      Fill:
      Fillchar (Buf^, Lese, '#');
      Filled:= TRUE;
      gel:= Lese;
    END Else Filled:= FALSE;

    inc (gelesen, gel);

    BlockWrite (Q1, Buf^, gel, ges);

    If IOResult<>0 Then
    BEGIN
      ErrMsg ('Fehler beim Schreiben in Zieldatei. Weiter mit Taste');
      Goto Stop;
    END Else
    BEGIN
      If Filled Then
      BEGIN If gelesen>=KSize Then Balken (Nichtger); END Else
      BEGIN
        inc (GoodBytes, gel);
        WriteXY (67, 6, LongStr (GoodBytes), 15, 7);
        If gelesen>=KSize Then Balken (gerettet);
      END;
    END;

    inc (FPos, Lese);
    WriteXY (67, 7, LongStr(FPos), 15, 7);
  END;
  While Act.Kast<sOld.Kast
  Do DrawKasten ('X', lightcyan, 0);

Stop:
  Close (Q); Close (Q1);

Ende:
  Act:= sOld;
  Rechtes_Fenster;
  WriteXY (67, 8, LongStr (Defekte_Dateien), 15, 7);

Endx:
  If GoodBytes=FSize Then
  BEGIN inc (Ganzgerettet); Checkbericht (4); END Else
  If GoodBytes<>0 Then
  BEGIN inc (Teilgerettet); Checkbericht (2); END Else
  CheckBericht (5);
END;


PROCEDURE ObjektProzedur (Objekt, Suchpfad: PathStr);
VAR
  sr : Searchrec;
BEGIN
  Findfirst (Vollpfad (Suchpfad, Objekt), anyfile, sr);
  While (DOSError = 0) and (ExCode=0) Do
  BEGIN
    If sr.Attr and VolumeID=0 Then
    BEGIN
      If sr.attr and directory = 0 Then
      BEGIN
        Read_a_File (Vollpfad (Suchpfad, sr.name), sr.Size);
        If Dateiretten Then
        Repair_File (Vollpfad (Suchpfad, sr.name), sr.Size);
      END Else
      If sr.name[1]<>'.' Then
      BEGIN
        inc (Verzeichnisse);
        inc (Gelesen, ClusterSize);
        inc (ReadingSectors, SecProCl);
        WriteXY (67, 6, LongStr (ReadingSectors), 15, 7);
        Balken (Teilbelegt);
      END;
    END;
    If ExCode<>0 Then Exit;
    Findnext (sr);
  END;
END;



PROCEDURE Rekursiv (Objekt, SuchPfad: PathStr);
VAR
  new_dir : PathStr;
  t       : Searchrec;
BEGIN
  If ExCode<>0 Then Exit;
  Findfirst (Vollpfad(Suchpfad,'*.*'), anyfile, t);
  While (DOSError = 0) Do
  BEGIN
    If (t.attr and directory <> 0) and (t.name[1]<>'.') Then
    BEGIN
      New_dir:= VollPfad (Suchpfad, t.name);
      ObjektProzedur (Objekt, New_dir);     
      Rekursiv (Objekt, new_dir);
    END;
    Findnext (t);
  END;
END;


PROCEDURE ReadFiles (Objekt, LW : PathStr);
BEGIN
  BufSize:= 63488;
  While (BufSize > MaxAvail) and (BufSize>SektorSize) Do dec (BufSize, SektorSize);
  If BufSize>MaxAvail Then BEGIN ExCode:=2; Exit; END;
  GetMem         (Buf, BufSize);
  Objektprozedur (Objekt, LW);
  Rekursiv       (Objekt, LW);
  FreeMem        (Buf, BufSize);
END;


{------------------------- Hauptprozedur -----------------------------}

PROCEDURE ScanDrive;
VAR
  tt  : Char;
  sr  : searchrec;
  hx  : Byte;
  Par : String;
  tmp : String;
  x, c: Byte;
LABEL
  Ende, Next;

BEGIN     
  StretchParam (Par);
  ZielLW:=#0; DurchLauf:= 0; LWNum:= 0; BilanzCode:= 0;

  For hx:= 1 To ParamCount Do
  BEGIN
    Par:= UpStr (ParamStr (hx));
    If Par[1]='/' Then
    CASE Par[2] Of
      'O' : BEGIN Wait:= FALSE; LogStatus:= 0; Bericht:= FALSE; END; {=/NOSUMMARY von ScanDisk}
      'W' : Wait:= FALSE;
      '?' : Hilfe;
    END Else
    If LWNum=0 Then
    BEGIN
      c:= CountFields (Par, '+');
      x:= 0;
      While (x<c) and (LWNum<LWMax) Do
      BEGIN
        inc (x);
        Tmp:=nthField(Par, '+', x);
        If (Tmp[1]>='A') and (Tmp[1]<='Z') Then
        BEGIN inc (LWNum); LWList[LWNum]:=Tmp[1]; END;
      END;
    END Else
    If (ZielLW=#0) and (Par[1]>='A') and (Par[1]<='Z') and (LWExist[ord(Par[1])-64]<>NoDrive) Then
    ZielLW :=Par[1];
  END;

  CursorOff;
  MouseInit; If ScrMode = FarbMon Then CyanCursor; MouseMoveXY (10,10);

  Alle_Rahmen;
  Rechtes_Fenster;

  Assign (LD, LogF); Rewrite (LD);
  If IOResult<>0 Then
  BEGIN
    SetFAttr (LD, 32); Rewrite (LD); 
    If IOResult<>0 Then BEGIN Fehlermeldung; Goto Ende; END;
  END;

  REPEAT
    t1:= #0; t2:= #0;
    Defekte_Dateien:= 0; QuellLW:= #0;
    Rechtes_Fenster;
    Kastenfeld;

    inc (DurchLauf);
    If Durchlauf<=LWNum Then QuellLW:=LwList[Durchlauf] Else
    BEGIN
      LaufWerksWahl (QuellLW, 'Welches Laufwerk soll berprft werden ?');
      If t1=#27 Then
      BEGIN WriteLn (LD, 'Prfung vom Benutzer abgebrochen'); Goto Ende; END;
    END;

    DeskTop;

    Gelesen:=0; ExCode:=0; Act.X:=3; Act.Y:=4; Act.Kast:=0; ReadingSectors:=0;
    Dateien:=0; Verzeichnisse:=0; GanzGerettet:= 0; Teilgerettet:= 0;
    RepDateien:= 0;

    LogDateiKopf;

    FileMode:=0;
    If Zustand=0 Then
    BEGIN
      ReadFiles ('*.*', QuellLW+':\');
      LogDateiBericht;
    END;

    If Defekte_Dateien<>0 Then
    BEGIN
      If Ganzgerettet<>Defekte_Dateien Then BilanzCode:= 255 Else
      If (Ganzgerettet=Defekte_Dateien) and (BilanzCode=0) Then
      Bilanzcode:= 254;
    END;
  UNTIL (DurchLauf>=LWNum) or (t1=#27);

Ende:
  Close (LD); If IOResult<>0 Then;
  If Bericht Then MiniViewer;
  ClearWin (1,1,80,25, 7); CursorOn;

  If ExCode=3 Then ExCode:= 2 Else
  If ExCode=1 Then ExCode:= 3 Else
                   ExCode:= BilanzCode;
  If ExCode<>0 Then AppendErr ('Scandrive hat Probleme gefunden und in der Datei SCANDRV.LOG protokolliert');
  Halt (ExCode);
END;


{------------------------  HauptProgramm ---------------------------------}

BEGIN
  ScanDrive;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
