UNIT scan_txt;

INTERFACE
USES
  DOS, Bioscrt, Monitor, strings, monit, Mouse, Scan_But,
  scan_var, time, keycode, scan_uni, rechnen, disk, cdrom, clipbord;


PROCEDURE ZW_Fragefenster;
PROCEDURE LaufWerksWahl (VAR LChar : Char; Txt : String);
PROCEDURE Platte;
PROCEDURE Desktop;
PROCEDURE Checkbericht (Mode : Byte);
PROCEDURE ErrorText (Quelle: PathStr; FSize: LongInt; Error, Fehler : Word);
PROCEDURE FehlerMeldung;
PROCEDURE LogDateikopf;
PROCEDURE LogDateibericht;
PROCEDURE Repair_Laufwerk;
PROCEDURE Repair_Anzeige;
PROCEDURE MiniViewer;


IMPLEMENTATION



PROCEDURE LW_Buttons;
VAR
  w, z : Byte;
  c    : Char;
BEGIN
  z:=12; w:=1;
  For c:= 'A' To 'Z' Do
  BEGIN
    If c='N' Then BEGIN z:=15; w:=1; END;
    If LWExist[ord(c)-64]<>NoDrive Then
    Button (10+w*4, z, c, #0, c, c+' ', 4, 7);
    inc (w);
  END;
  Button (50, 8, #27, #0, 'Esc', ' Esc  Abbruch ', 9, 15);
END;


PROCEDURE Laufwerkswahl (VAR LChar : Char; Txt : String);
BEGIN
  GetScreen25 (pp);
  Rahmen  (12, 7, 67, 19, 7, 0); Schatten25 (12, 7, 67, 19);
  Rahmen  (14, 8, 45, 10, 7, 1);
  WriteXY (15, 9, '     Gefundene Laufwerke      ', 10, 0);

  Fusszeile (22, Txt, yellow, brown);
  Fusszeile (24, 'Laufwerk auswhlen oder mit Esc abbrechen.', lightcyan, blue);

  ee:=1; LW_Buttons; ee:=0;
  REPEAT
    t1:= #0; t2:= #0; kn:= 0;
    MouseOn;
    REPEAT MouseGet; UNTIL (kn<>0) or (keypressed);
    MouseOff;
    If Keypressed Then UpScanKeys;
    LW_Buttons;
  UNTIL (t1=#27) or ((t1>='A') and (t1<='Z')) and (LWExist[ord(t1)-64]<>NoDrive);
  If t1<>#27 Then LChar:= t1;
  If LWExist[ord(t1)-64]=PhantomDrive Then
  BEGIN SetLogicalDriveMap (ord(t1)-64); GetLWList (LWExist); END;
  SetScreen25 (pp);
END;



PROCEDURE ZW_Buttons;
BEGIN
  Button (14, 12, 'D', #0, 'D',   '     nchste Datei       ', 4, 15);
  Button (14, 15, 'S', #0, 'S',   '     nchster Sektor     ', 4, 15);
  Button (51, 12, #27, #0, 'Esc', ' Esc Beenden ',             4, 15);
END;


PROCEDURE ZW_Fragefenster;
BEGIN
  GetScreen25 (pp);
  Rahmen (12, 7, 67, 19, 7, 0); Schatten25 (12, 7, 67, 19);
  Rahmen (14, 8, 65, 10, 7, 1);
  WriteXY (15, 9, '        Wo soll ScanDrive weitermachen ?          ', 10, 0);
  ee:=1; ZW_Buttons; ee:=0;
  REPEAT
    MouseOn;
    REPEAT MouseGet; UNTIL (kn<>0) or (keypressed);
    MouseOff;
    If Keypressed Then UpScanKeys;
    ZW_Buttons;
  UNTIL (t1='S') or (t1='D') or (t1=#27);
  SetScreen25 (pp);
END;


PROCEDURE Platte;
BEGIN
  ASM
    mov dl, QuellLW
    sub dl, 64
    mov ah, $36
    int $21
    mov SecProCl, ax
    mov Word Ptr FreeClusters, bx
    mov Word Ptr FreeClusters[2], 0
    mov Sektorsize, cx
    mov Word Ptr AllClusters, dx
    mov Word Ptr AllClusters[2], 0
  END;
  If SecProCl<>$FFFF Then
  BEGIN
    HSecPC     := SecProCl; {Weil Multiplikation von Word und LongInt falsch}
    ClusterSize:= SecProCl*SektorSize;
    BelegteCl  := AllClusters-FreeClusters;
    BelegteSec := BelegteCl*HSecPC;
    Zustand    := 0;
  END Else Zustand:=1;
END;


PROCEDURE Desktop;
VAR
  Buf     : TSector;
  VTOC    : VTOCRec absolute Buf;
  a, c, d : LongInt;
  z       : Word;
  x, y    : Byte;
  sr      : SearchRec;

BEGIN
  WriteXY   (76,  2, QuellLW+':', lightcyan, red);
  Fusszeile (22, 'Laufwerk wird aktiviert', yellow, cyan);
  Fusszeile (24, 'Abbruch mit Escape', white, brown);

  If IsCDROM (ord (QuellLW)-65) Then
  BEGIN
    FindFirst (QuellLW+':\*.*', anyfile, sr); { Dummmy-Befehl, drinlassen }
    ReadVTOC (ord (QuellLW)-65, 0, Buf);
    If IOresult<>0 Then BEGIN Zustand:= 1; Exit; END;
    ClustNum    := VTOC.iSize;
    SecProCl    := 1;
    SektorSize  := 2048;
    ClusterSize := 2048;
    AllClusters := ClustNum;
    BelegteCl   := ClustNum;
    HSecPC      := SecProCl; {Weil Multiplikation von Word und LongInt falsch} 
    BelegteSec  := BelegteCl*HSecPC;
    FreeClusters:= 0;
    Zustand     := 0;
  END Else
  Platte;

  a:= Allclusters; d:= BelegteCl;

  If a=0 Then a:=1;
  LastKast:= (d * 867) DIV a;
  c:=  (d * ClusterSize);
  z:=0;
  For y:= 4 To 20 Do For x:= 4 To 54 Do
  BEGIN inc (z); If z<=LastKast Then CharXY (x, y, #8, 3, 5); END;
  If LastKast=0 Then LastKast:=1;
  KSize:= c DIV LastKast; {Nach KSize gelesenen Bytes ein Kstchen malen}
END;


PROCEDURE Checkbericht (Mode : Byte);
BEGIN
  Write (LD, 'Datenrettung: ');
  CASE Mode Of
    1 : WriteLn (LD, 'Rettungsversuch mit Scandrive nicht mglich');
    2 : WriteLn (LD, Goodbytes, ' Bytes gerettet');
    3 : WriteLn (LD, 'nicht erforderlich');
    4 : WriteLn (LD, 'Datei komplett gerettet');
    5 : WriteLn (LD, 'keine Daten gerettet');
  END;
END;


PROCEDURE ErrorText (Quelle: PathStr; FSize: LongInt; Error, Fehler : Word);
VAR
  Fehlertext : String[38];
BEGIN
  CASE Error Of
    2   : Fehlertext:='Datei nicht gefunden';
    3   : Fehlertext:='Verzeichnispfad nicht gefunden';
    5   : Fehlertext:='Dateizugriff verweigert';
    6   : Fehlertext:='Dateihandler zerstrt';
    150 : Fehlertext:='Laufwerk ist schreibgeschtzt';
    152 : Fehlertext:='Laufwerk nicht betriebsbereit';
    154 : Fehlertext:='Prfsummenfehler beim Lesen der Datei';
    155 : Fehlertext:='Parameterblock der Diskette defekt';
    156 : Fehlertext:='Positionsfehler des Lesekopfes';
    157 : Fehlertext:='Unbekanntes Datentrgerformat';
    158 : Fehlertext:='Laufwerks-Sektor nicht gefunden';
    161 : Fehlertext:='Zugriffsfehler auf Peripheriegert';
    162 : Fehlertext:='Unbekannter Hardwarefehler';
    1000: Fehlertext:='Datei wird z.Z. von einem anderen Programm benutzt';
    Else  Fehlertext:='Undefinierter Fehler Nr.: '+LongStr (Error);
  END;
  WriteLn (LD, #13#10'DATEI.......: ', Quelle);
  WriteLn (LD, 'Gre.......: ', FSize);
  If Fehler<>0 Then Write (LD, 'Fehler......: ');
  CASE Fehler Of
    1: WriteLn (LD, 'Datei lie sich nicht ffnen');
    2: WriteLn (LD, 'Datei enthlt zerstrte Daten');
    3: WriteLn (LD, 'keiner, die Datei wurde ledigich bersprungen'); 
  END;
  WriteLn (LD, 'Diagnose....: ', Fehlertext);
END;


PROCEDURE FehlerMeldung;
BEGIN
  Piep;
  Fusszeile (22, 'ACHTUNG! Protokolldatei konnten nicht angelegt werden!', yellow, red);
  Fusszeile (24, '(New-DOS-Laufwerk schreibgeschtzt?) Weiter mit Taste oder Mausklick.', yellow, blue);
  Klick_Enter;
END;


PROCEDURE LogDateikopf;
BEGIN
  WriteLn (LD, '');
  If Zustand=1 Then
  BEGIN
    WriteLn (LD, 'Datentrger nicht verfgbar oder unbekanntes Format - '+QuellLW+':');
  END Else
  BEGIN
    WriteLn (LD, 'geprftes Laufwerk.....: ', QuellLW, ':');
    WriteLn (LD, 'Kapazitt in KiloByte..: ', (ClusterSize*Allclusters) shr 10);
    WriteLn (LD, 'Sektorgre in Byte....: ', SektorSize);
    WriteLn (LD, 'Sektoren je Cluster....: ', SecProCl);
    WriteLn (LD, 'Clustergre in Byte...: ', ClusterSize);
    WriteLn (LD, 'Gesamtzahl der Cluster.: ', Allclusters);
    WriteLn (LD, 'belegte Cluster........: ', BelegteCl);
    WriteLn (LD, 'freie Cluster..........: ', FreeClusters);
    WriteLn (LD, 'belegte Sektoren.......: ', BelegteSec);
  END;
END;


PROCEDURE LogDateibericht;
BEGIN
  If ExCode=2 Then
  WriteLn (LD, #13#10'SCANDRIVE bentigt mehr freien RAM') Else
  BEGIN
    WriteLn (LD, #13#10'gefundene Verzeichnisse: ', Verzeichnisse);
    WriteLn (LD, 'geprfte Dateien.......: ', Dateien);
    WriteLn (LD, 'davon fehlerhaft.......: ', Defekte_Dateien);
    If Defekte_Dateien<>0 Then
    BEGIN
    WriteLn (LD, 'davon ganz gerettet....: ', Ganzgerettet);
    WriteLn (LD, 'davon teilgerettet.....: ', Teilgerettet, #13#10);
    END Else WriteLn (LD, '');
    CASE ExCode Of
      1 :  WriteLn (LD, 'Prfung vom Benutzer abgebrochen.');
      3 :  WriteLn (LD, 'Rettungsverzeichnis SCANDRV.XXX lie sich nicht anlegen.');
      Else If Defekte_Dateien=0 Then
           WriteLn (LD, 'Alle Dateien sind in Ordnung.') Else
           WriteLn (LD, 'Keine weiteren Fehler gefunden.');
    END;
  END;
END;



PROCEDURE Repair_Laufwerk;
VAR
  sr      : Searchrec;
  OldPath : PathStr;

LABEL
  Nochmal;

BEGIN
  If ZielExist Then Exit;
  Nochmal:

  If ZielLW=#0 Then 
  BEGIN
    Laufwerkswahl (ZielLW, 'Auf welches Laufwerk sollen die defekten Dateien umkopiert werden?');
    If ZielLW=#27 Then BEGIN ExCode:= 1; Exit; END;
  END;

  GetDir (0, OldPath);
  ChDir  (ZielLW+':\');
  If IOResult<> 0 Then
  BEGIN
    ErrMsg ('Ziellaufwerk nicht bereit! Weiter mit Taste oder Mausklick.');
    ZielLW:=#0; Goto Nochmal;
  END Else
  BEGIN ChDir (OldPath); If IOResult<>0 Then; END;

  Pfad:= ZielLW+':\SCANDRV.XXX';
  FindFirst (Pfad, anyfile, sr);

  If DOSerror=0 Then
  If (sr.attr and directory<>0) Then
  BEGIN ZielExist:= TRUE; Exit; END Else
  BEGIN
    ErrMsg ('Zielverzeichnis SCANDRV.XXX kann nicht angelegt werden! Weiter: Taste/Klick');
    ExCode:= 3; Exit;
  END Else
  BEGIN
    MkDir (Pfad);
    If IOResult<>0 Then
    BEGIN
      ErrMsg ('Zieldatentrger nicht bereit! Weiter mit Taste oder Mausklick.');
      Goto Nochmal;
    END;
    ZielExist:= TRUE;
  END;
END;



PROCEDURE Repair_Anzeige;
BEGIN
  If not Wait Then BEGIN t1:= 'J'; Exit; END;
  Fusszeile (24, 'Datei wieder herstellen?    ja    nein     Esc Abbruch', yellow, brown);
  CharXY    (31, 24, 'j',   lightcyan, brown);
  CharXY    (37, 24, 'n',   lightcyan, brown);
  WriteXY   (46, 24, 'Esc', lightcyan, brown);
  REPEAT
    kn:=0; t1:=#0; t2:= #0;
    MouseOn;
    REPEAT MouseGet; UNTIL ((kn<>0) and (ym=24)) or (keypressed);
    MouseOff;
    If keypressed Then UpScankeys Else
    BEGIN
      If MouseIn (29, 24, 35, 24) Then t1:= 'J' Else
      If MouseIn (36, 24, 43, 24) Then t1:= 'N' Else
      If MouseIn (44, 24, 61, 24) Then t1:= #27;
      MouseWait;
    END;
  UNTIL (t1='J') or (t1='N') or (t1=#27);
END;


PROCEDURE MiniViewer;
CONST
  Max       = 10000;
  StrLen    = 74;

TYPE
  Line = String[StrLen];

VAR
  Temp      : String;
  Marker    : Pointer;
  f         : Text;
  Block     : Array [1..Max] Of ^Line;
  LastLine  : Word;
  FirstLine : Word;
  x         : Word;

LABEL
  Ende;

PROCEDURE ViewText;
VAR
  yy, y : Word;
BEGIN
  yy:= 4;
  For y:= FirstLine To FirstLine+16 Do
  BEGIN
    If y<=LastLine Then
    WriteXY (5, yy, SpaceStr (Block[y]^, 74), 15, 1) Else
    WriteXY (5, yy, SpaceStr (' '      , 74), 15, 1);
    inc (yy);
  END;
END;


PROCEDURE DecLine (Zahl : Word);
BEGIN
  While (Zahl>0) and (FirstLine > 1) Do
  BEGIN dec (Zahl); dec (FirstLine); END;
END;

PROCEDURE IncLine (Zahl : Word);
BEGIN
  While (Zahl>0) and (FirstLine < LastLine) Do
  BEGIN dec (Zahl); inc (FirstLine); END;
END;

BEGIN
  t1:=#0; t2:= #0;
  Mark (Marker);
  If (Defekte_Dateien<>0) Then GetScreen25 (pp);
  Rahmen (2, 3, 79, 21, 7, 1);

  Fusszeile (22, 'ScanDrive: Prfbericht von Laufwerk '+QuellLW+':',lightcyan, blue);
  Fusszeile (24, 'Vorblttern : '+#25+'            Zurckblttern : '+#24+'                Beenden : Esc', yellow, brown);
  ClearWin (3, 4, 78, 20, 31); Window (4, 5, 78, 20); kn:=0; LastLine:=0;

  FileMode:=0; Assign (f, LogF); Reset (f);
  If IOResult<>0 Then
  BEGIN
    WriteStr (#13#10'LOG-Datei nicht gefunden!'#13#10);
    WriteStr ('Weiter mit ENTER oder Mausklick'#13#10);
    Klick_Enter; Goto Ende;
  END;

  LastLine:= 0;
  While (not Eof (f)) and (LastLine<Max) and (IOResult=0) and (MaxAvail>SizeOf (Line)) Do
  BEGIN
    ReadLn (f, Temp);
    inc (LastLine);
    GetMem (Block[LastLine], SizeOf(Line));
    Block[LastLine]^:= copy (Temp, 1, StrLen);
  END;
  Close (f); If IOResult<>0 Then; FileMode:=2;

  FirstLine:= 1; CursorOn; GotoXY (1, 1);

  REPEAT
    ViewText;
    MouseOn;
    REPEAT MouseGet; UNTIL ((kn<>0) and (ym=24)) or (Keypressed);
    MouseOff;
    If Keypressed Then ScanKeys Else
    BEGIN
      CASE xm Of 1..28 : t2:= Down; 29..60 : t2:=Up; 61..80 : t1:=#27; END;
      If kn=1 Then xDelay (70);
    END;
    CASE t2 Of
      F4   : BEGIN
               RewriteClip;
               For x:=1 To LastLine Do WriteClipLine (Block[x]^);
               CloseClip;
             END;
      Down : IncLine (1);
      Up   : DecLine (1);
      PgDn : IncLine (13);
      PgUp : DecLine (13);
      Pos1 : FirstLine:= 1;
      Endx : IncLine (LastLine);
    END;
  UNTIL (t1=#27);

Ende:
  CursorOff;
  t1:= #0; t2:= #0;
  MouseWait;
  MouseMoveXY (5, 10);
  If (Defekte_Dateien<>0) Then SetScreen25 (pp);
  Release (Marker);
END; 


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
