PROGRAM Scanfix;
{$M, 10000, 0, 0}

USES
  bioscrt, Laufbalk, masken, dos, strings, keycode, bootsec, cdrom, disk,
  monitor, logFile, time;

CONST
  ProgName = 'SCANFIX';
  BSize    = 512*64;
  ENTER    = 'Weiter mit ENTER';
  Nochmal  : Boolean = FALSE;
  SFormat  : Boolean = FALSE;
  SelfTest : Boolean = FALSE;
  Quicktest: Boolean = FALSE;
  Abbruch  : Boolean = FALSE;
  SecError : Byte    = 0;
  LWNum    : Byte    = 0;
  MaxLW              = 30;

TYPE
  TStr  = String[9];
  xTRec = RECORD ho, mi, se, hu : Word END;

  bloc  = array[1..BSize] of char;


VAR
  LWList           : Array[1..MaxLW] Of Char;
  Sektoren_gelesen : LongInt;
  SectorNum        : LongInt;
  Fehler           : LongInt;
  LeseSektoren     : Byte;
  IsCD             : Boolean;

  StartTime : LongInt;
  Param     : PathStr;
  LW        : Char;
  x         : Byte;
  Buf       : bloc;
  CDBuf     : TSector absolute Buf;
  VTOC      : VTOCRec absolute Buf;
  MaxSec    : Byte;
  MaxSides  : Word;
  Zylinder  : Word;
  FirstSide : Byte;
  Durchgang : Byte;

  BootRec             : BootSector absolute Buf;
  StrPar              : String;
  Spur, Seite, Sektor : Byte;
  xSpur, xSektor      : Word;

  STestLastSec : Byte;
  STestLastCyl : Word;
  STestLastSid : Byte;
  STestSecSize : Word;

  ReadTrys     : LongInt;
  Versuche     : Byte;


PROCEDURE EndePrc;
BEGIN
  If (KeyPressed) and (ReadBKey=#27) Then
  ErrorHaltLog ('Abbruch durch Anwender bei Laufwerk '+LW+':');
END;


PROCEDURE ErrorMg (s : String);
BEGIN
  ErrorMsg (s+' - '+LW+': ');
  Abbruch:= TRUE;
END;


PROCEDURE Hilfe;
BEGIN
  Standardkopf (ProgName, CopyRight);
  DosStr (
  'berprft die Oberflche eines Datentrgers auf physikalische Fehler'#13#10#13#10+
  'SCANFIX [Laufwerke (A..Z)] [/r /s /q /t /o]'#13#10#13#10+
  '/r   fragt am Ende, ob weitere Datentrger geprft werden sollen'#13#10);
  DosStr (
  '/s   scannt Disketten mit Sonderformat (Sektoren einzeln lesen)'#13#10+
  '/q   Schnellprfung (testet nur Spurzugriff)'#13#10+
  '/t   scannt unbekannte Datentrger'#13#10);
  DosStr (
  '/o   Fehler werden in der LOG-Datei gespeichert, es erfolgt keine Benutzer-'#13#10+
  '     Abfrage (empfohlen fr Batch-Betrieb)'#13#10);

  BlindStop; Halt;
END;



PROCEDURE ReadSektor (LW:Char; VAR buff; Spur:Word; Seite,Sektor,SecToRead:Byte); Assembler;
ASM
  mov Byte Ptr Versuche, 0
  @neuerversuch:
  mov ah, 2           {Befehl 2: Sektor(en) lesen}
  mov al, SecToRead   {Lese Sektor-Anzahl}

  mov dl, LW          {Laufwerk: A=0, B=1 usw, C=$80, D=$81 (Bit 7 gesetzt)}
  and dl, 00011111b   {'a' und 'A' und #1 = 1 usw.}
  dec dl              {A=0 usw}
  cmp dl, 1           
  jbe @a              {<=B: ?}
  add dl, 126
  @a:

  mov bx, Spur
  mov cl, 6
  shl bh, cl
  mov ch, bl          {Spur   0 -  x, bei C Zylindernummer}
  mov cl, Sektor      {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  add cl, bh

  mov dh, Seite       {Seite  0/1, bei C Kopfnummer 0..x}
  les bx, Buff        {Pufferaddresse}
  int 13h
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah
END;


FUNCTION DisSize : Word; assembler;
ASM
  mov ah, 36h
  mov dl, LW
  and dl, 00011111b   {'a' und 'a' = 1 usw.}
  int 21h
END;


PROCEDURE Read_BootRecord;
BEGIN
  If (not SelfTest) Then
  If DisSize = 65535 Then BEGIN ErrorMg ('Laufwerk nicht bereit'); Exit; END;
  ReadSektor (LW, Buf, 0, FirstSide, 1, 1);

  If BootRec.BytesProSec <> 512 Then BEGIN ErrorMg ('Laufwerk nicht prfbar'); Exit; END;

  With BootRec Do
  BEGIN
    If GesamtSec1=0 Then
    BEGIN
      Zylinder  := GesamtSec2 DIV SecProSpur DIV DiskSeiten + 1;
      SectorNum := GesamtSec2 + VerstecktSec;
    END Else
    BEGIN
      Zylinder  := (GesamtSec1+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
      SectorNum := (GesamtSec1+VerstecktSec);
    END;
    MaxSec    := SecProSpur;
    MaxSides  := DiskSeiten-1;
  END;
END;



PROCEDURE Write_Anzeige;
BEGIN
  Standardkopf (Progname, 'Datentrger in Laufwerk '+LW+':');
  Fusszeile ('Datentrger wird gescannt                                        Abbruch mit Esc');
  GotoOldPos;
  With BootRec Do
  BEGIN
    OutStr ('Spur / Zylinder :'); GotoXY (40, 1);
    OutStr ('von : '); OutNum (Zylinder); 
    OutStr (#13#10'Sektor absolut  :'); GotoXY (40, 2);
    OutStr ('von : '); OutNum (SectorNum);
    OutStr (#13#10#10'Zeit insgesamt  :'#13#10'Zeit vergangen  :'#13#10#10'Fehler          :');
  END;
END;



FUNCTION TimeStr (VAR TimeRec : xTRec) : TStr; assembler;
ASM
  push ds                                        {Datensegment sichern}
  cld
  les di, @Result
  mov al, 8
  stosB                                          {Lngenbyte schreiben}
  lds si, TimeRec
  mov cx, 3                                      {Schleifenzhler}
  mov bh, 10
  @nochmal:
    lodsW
    xor ah, ah
    div bh
    add ax, 12336                                {Bytes in Zeichen umwandeln}
    stosW
    mov al, ':'
    stosB 
  loop @nochmal
  pop ds                                         {Datensegment zurck}
END; 



FUNCTION Timer (LTime : LongInt) : TStr;
VAR
  TimeRec : xTRec;
BEGIN
  With TimeRec Do
  BEGIN
    ho:= LTime DIV 216000;
    mi:= LTime DIV 60 MOD 60;
    se:= LTime MOD 60;
  END;
  Timer:= TimeStr (TimeRec);
END;



PROCEDURE Write_LeseZeiger;
VAR
  a, b : LongInt;             
  (* 1572840 *)
BEGIN
  If  Seconds >= StartTime Then
  a:= Seconds -  StartTime Else
  a:= 86430   -  StartTime + Seconds;

  If not IsCD Then 
  BEGIN If xSpur > 0 Then b:= a * Zylinder DIV xSpur; END Else
  If Sektoren_Gelesen>0 Then b:= a * SectorNum DIV Sektoren_gelesen;

  GotoXY (19, 1); OutNum (xSpur);
  GotoXY (19, 2); OutNum (Sektoren_gelesen);
  GotoXY (19, 4); OutStr (Timer(b));
  GotoXY (19, 5); OutStr (Timer(a));
  GotoXY (19, 7); OutNum (Fehler);

  If SecError <> 0 Then
  BEGIN 
    CASE SecError Of
      $02 : OutStr ('  Adressmarkierung nicht gefunden');
      $04 : OutStr ('  Sektor nicht gefunden');
      $10 : OutStr ('  Prfsummenfehler');
      $20 : OutStr ('  Controller-Fehler');
    END;
    ClrEol;
  END;
END;



PROCEDURE LeseSpur (LW:Char; Spur:Word; Seite, LastSector, SecToRead : Byte);
VAR
  Sektor : Byte;
BEGIN
  Sektor := 1;
  REPEAT
    ReadSektor (LW, Buf, Spur, Seite, Sektor, SecToRead);
    If Versuche<>0 Then inc (ReadTrys);
    If SecError<>0 Then inc (Fehler);
    inc (Sektor, SecToRead);
    EndePrc;
  UNTIL (Sektor>=LastSector) or ((SelfTest) and (SecError<>0));
  STestLastSec:= Sektor - 2;
END;



PROCEDURE TestDiskette;
BEGIN
  Standardkopf (ProgName, 'Datentrgeranalyse');
  Fusszeile ('Bitte warten. Mechanische Datentrger-Analyse...                 Abbruch mit Esc');
  GotoOldPos;
  STestLastSid:= 0;
  STestLastCyl:= 0;
  ReadSektor (LW, Buf, 0, 0, 1, 1);
  LeseSpur (LW, 0, 0, 64, 1);
  OutStr ('Sektoren: '); OutNum (STestLastSec);

  SecError:=0; OutStr (#13#10'Zylinder: ');
  REPEAT
    ReadSektor (LW, Buf, STestLastCyl, 0, STestLastSec, 1);
    GotoXY (11, 2); OutNum (STestLastCyl);
    inc (STestLastCyl);
    EndePrc;
  UNTIL SecError<>0;

  dec (STestLastCyl);
  If LW>='C' Then dec (STestLastCyl);
  GotoXY (11, 2); OutNum (STestLastCyl); ClrEol;

  SecError:=0; OutStr (#13#10'Seiten  : ');
  REPEAT
    ReadSektor (LW, Buf, STestLastCyl, STestLastSid, STestLastSec, 1);
    GotoXY (11, 3); OutNum (STestLastSid);
    inc (STestLastSid);
    EndePrc;
  UNTIL SecError<>0;

  If LW>='C' Then dec (STestLastSid, 2);
  GotoXY (11, 3); OutNum (STestLastSid+1); ClrEol;

  If Logstatus=2 Then
  Tastenabfrage ('Soll SCANFIX die ermittelten Werte zu Prfung verwenden? (j/n)', 'J', 'N');
  If t1='N' Then UserAbort;

  MaxSec  :=STestLastSec;
  Zylinder:=STestLastCyl;
  MaxSides:=STestLastSid;

  SectorNum:= LongInt(MaxSec) * LongInt(Zylinder) * LongInt(MaxSides+1);
END;



PROCEDURE Program_Init;
BEGIN
  Abbruch:= FALSE; ReadTrys:= 0; LW := LWList[Durchgang];

  FirstSide:= ord (LW>'B');
  t1:=#0;
  IsCD:= Drive (LW) and CDDrive<>0;
  If IsCD Then
  BEGIN
    QuickTest:= FALSE;
    ReadVTOC (ord(LW)-65, 0, CDBuf);
    If IOResult<> 0 Then BEGIN ErrorMg ('CD-Laufwerk nicht bereit'); Exit; END;
    SectorNum:= VTOC.iSize;
    Zylinder:= 0;
  END Else
  BEGIN
    If SelfTest Then TestDiskette Else
    BEGIN Read_Bootrecord; If Abbruch Then Exit; END;
    If SFormat  Then LeseSektoren:= 1 Else LeseSektoren:= MaxSec;
  END;

  CursorOff;
  Write_Anzeige;

  Unterbalken (18, 'Geprft');

  StartTime:= Seconds;
  Sektoren_gelesen:=0;
  Fehler:=0;
  If QuickTest Then BEGIN MaxSec:= 1; LeseSektoren:= 1; END;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Param, 'Buchstaben der zu prfenden Laufwerke (z.B. ac oder A: C:):');

  a2:
  ParamField (6, Nochmal,  'fragt am Ende, ob weitere Datentrger geprft werden sollen');
  If t2=Up Then Goto a1;

  a3:
  ParamField (7, SFormat,  'Diskette hat Sonderformat (z.B. 2.88 MB)');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, Selftest, 'Format des zu prfenden Datentrgers ist unbekannt (z.B. Mac-Diskette)');
  If t2=Up Then Goto a3;

  ParamField (9, Quicktest,'Schnellprfung (testet nur Spurzugriff)');
  If t2=Up Then Goto a4;
END;


PROCEDURE CheckString (Ein : PathStr; VAR Arr); Assembler;
ASM
  push ds
  cld
  lds si, Ein
  les di, Arr
  xor bx, bx
  xor cx, cx
  lodsb
  mov cl, al
  jcxz @ende
  @start:
  lodsb
  cmp al, 'A'; jb @weiter
  cmp al, 'Z'; ja @weiter
  inc bx
  cmp bl, 29 ; ja @ende
  stosb
  @weiter:
  loop @start
  @ende:
  pop ds
  mov LWNum, bl
END;


PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  Param:= 'C:';
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  CheckString (UpStr(Param), LWList);
END;

{---------------------------- HauptProgramm -----------------------------}

BEGIN                                              
  ClrScr;

  If ParamCount=0 Then Maske Else
  BEGIN
    Stretchparam (StrPar);
    For Durchgang:= 1 To ParamCount Do
    BEGIN
      Param:= UpStr (ParamStr (Durchgang));
      If Param[1]='/' Then 
      CASE Param[2] Of
        '?' : Hilfe;
        'R' : Nochmal  := TRUE;
        'S' : SFormat  := TRUE;
        'T' : SelfTest := TRUE; 
        'Q' : QuickTest:= TRUE;
        'O' : LogStatus:= 0;
      END Else
      If LWNum<MaxLW Then
      BEGIN inc (LWNum); LWList[LWNum]:= Param[1]; END;
    END;
  END;
  If LWNum = 0 Then SimpleHaltLog ('Laufwerksangabe fehlt');
  Standardkopf (Progname, '');

  REPEAT
    For Durchgang:= 1 To LWNum Do
    If Drive (LWList[Durchgang]) and (Diskdrive or Harddisk or cdDrive) <> 0 Then
    BEGIN
      Program_Init; xSpur:=0;
      If not Abbruch Then
      BEGIN
        If IsCD Then
        REPEAT
          EndePrc;
          ReadSector (ord(LW)-65, Sektoren_gelesen, 16, Buf);
          SecError:= IOResult;
          If SecError<>0 Then inc (Fehler);
          inc (Sektoren_gelesen, 16);
          If Sektoren_gelesen>SectorNum Then Sektoren_gelesen:= SectorNum;
          Write_LeseZeiger; Balken (18, Sektoren_gelesen, SectorNum);
        UNTIL Sektoren_gelesen>=SectorNum Else
        REPEAT
          Seite:= 0;
          REPEAT
            LeseSpur (LW, xSpur, Seite, MaxSec, LeseSektoren);
            inc (Seite);
            inc (Sektoren_gelesen, MaxSec);
          UNTIL Seite > MaxSides;
          inc (xSpur);
          Write_LeseZeiger; Balken (18, xSpur, Zylinder);
        UNTIL xSpur >= Zylinder;
      END;
      If (Fehler<>0) and (not Abbruch) Then
      ErrorMsgLog ('Datentrger '+LW+': ist fehlerhaft') Else
      If ReadTrys<>0 Then
      ErrorMsgLog ('Datentrger '+LW+': war lesbar, neigt aber zu leichten Fehlern');
    END Else

    BEGIN
      LW:= LWList[Durchgang];
      If Drive (LW) and Phantomdrive<>0 Then
      ErrorMsgLog ('Laufwerk '+LW+': ist ein Phantomlaufwerk und kann nicht geprft werden') Else
      If Drive (LW) and (NetDrive or InterLnkDrive)<>0 Then
      ErrorMsgLog ('Laufwerk '+LW+': ist ein Netz- oder InterLnk-Laufwerk und kann nicht geprft werden') Else
      If Drive (LW) and SubstDrive<>0 Then
      ErrorMsgLog ('Laufwerk '+LW+': ist ein SUBST-Laufwerk und kann nicht geprft werden');
    END;

    If Nochmal Then
    BEGIN
      Tastenabfrage ('Weiteren Datentrger prfen? (j/n)', 'J', 'N');
      If t1 = 'N' Then t1:=#27;
    END;
  UNTIL (t1=#27) or (Nochmal=FALSE);

  ErrorHalt ('Fertig');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
