PROGRAM SetDate;
{$M 5000, 0, 0}

USES
  Dos;

TYPE
  DateRec = RECORD Year, Month, Day, DoW : Word; END;

VAR
  Date  : DateRec;
  Datum : String;
  p     : Byte;
  c     : Integer;

CONST
  WeekDay : Array[0..6] Of String[2] = ('So','Mo','Di','Mi','Do','Fr','Sa');

LABEL
  Error, NewRead;


FUNCTION Num2Str (Num : Word) : String;
VAR
  tmp : String;
BEGIN
  Str (Num, tmp);
  Num2Str:= tmp;
END;


FUNCTION lz (Num : Word) : String;
BEGIN
  If Num<10 Then lz:= '0'+Num2Str (Num) Else lz:= Num2Str (Num);
END;



BEGIN
  With Date Do
  BEGIN
    If ParamCount=0 Then
    BEGIN
      GetDate (year, month, day, DoW);
      Write   ('Gegenwrtiges Datum: ', WeekDay[DoW], ', ');
      WriteLn (lz(day), '.', lz(month), '.', Num2Str(Year));
    NewRead:
      Write   ('Neues Datum (TT.MM.JJ): ');
      ReadLn  (Datum);
    END
    Else Datum:= ParamStr (1);

    If Datum='/?' Then
    BEGIN
      WriteLn (#13#10+
      'SETDATE  (c) Copyright 1998-2000 A.Olejko - FREEWARE'+#13#10#13#10+
      'Alternativer DATE-Befehl, lt 2-stellige Jahresangaben auch fr die'#13#10+
      'Jahre 2000-2079 zu. Jahres-Angaben zwischen 00 und 79 werden als 2000');
      WriteLn
     ('bis 2079 interpretiert, zwischen 80 und 99 als 1980 bis 1999.'#13#10#13#10+
      'DATE [TT.MM.JJ oder TT.MM.JJJJ]'#13#10#13#10+
      'DATE ohne Datumsangabe zeigt eine Abfrage.');
      ASM xor ax, ax; int 16h END;
      Halt;
    END;

    If Datum='' Then Halt;

    p:= pos ('.', Datum);
    If p=0 Then Goto Error;
    Val (copy (Datum, 1, p-1), Day, c);
    If c<>0 Then Goto Error;
    delete (Datum, 1, p);

    p:= pos ('.', Datum);
    If p=0 Then Goto Error;
    Val (copy (Datum, 1, p-1), Month, c);
    If c<>0 Then Goto Error;
    delete (Datum, 1, p);

    Val (Datum, Year, c);
    If c<>0 Then Goto Error;

    If Year< 80 Then inc (Year, 2000) Else
    If Year<100 Then inc (Year, 1900);

    ASM                  (* SetDate (...) *)
      mov ah, 2Bh
      mov cx, Date.Year
      mov dh, byte ptr Date.Month
      mov dl, byte ptr Date.day
      int 21h
      cmp al, $FF
      je  Error
    END;

    Halt;
  END;
  Error:
  WriteLn (#13#10'Unzulssige Datumsangabe');
  Goto NewRead;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
