UNIT Control;

INTERFACE

USES
  masken, Dos, bioscrt, set_var, set_tool, cmd_var {wegen RC}, strings,
  Set_Edit;


PROCEDURE SControl (Pfad : PathStr; Par : Char);


IMPLEMENTATION



PROCEDURE SControl (Pfad : PathStr; Par : Char);
VAR
  f           : File Of RCI;
  t           : Char;
  PF          : Byte;
  Edit, Upld  : PathStr;
  IniPath     : PathStr;

CONST
  Error    ='Datei DC.INI konnte nicht geschrieben werden';
  EdFound  : Boolean = FALSE;
  UpFound  : Boolean = FALSE;
  arjFound : Boolean = FALSE;
  LhaFound : Boolean = FALSE;
  LrcFound : Boolean = FALSE;
  zipFound : Boolean = FALSE;
  unzFound : Boolean = FALSE;
  zxeFound : Boolean = FALSE;


FUNCTION AllFound : Boolean;
BEGIN
  AllFound:= (EdFound)  and (UpFound)  and (arjFound) and (LhaFound) and
             (LrcFound) and (zipFound) and (unzFound) and (zxeFound);
END;


PROCEDURE PackerFound;
BEGIN
  arjFound := TRUE;
  LhaFound := TRUE;
  LrcFound := TRUE;
  zipFound := TRUE;
  unzFound := TRUE;
  zxeFound := TRUE;
END;


PROCEDURE Schluss;
BEGIN
  Kopf;
  W (g1); Fusszeile (ENTER);
  WaitBKey;
END;



PROCEDURE EditorWahl;
BEGIN
  Edit:= VollPfad (Pfad, StdEditor);
  Kopf;
  Fusszeile (Eingabe); GotoXY (1, 1);
  w (h1); WriteStr (h2); EditStr (1, 10, Edit); If t1=#27 Then HaltProc (1);
  If pos ('\', Edit) <> 0 Then EdFound:= TRUE;
  Edit:= UpStr (Edit);
  RC.Editor:= Edit;
END;



PROCEDURE UploadWahl;
BEGIN
  Upld:= StdUpLoad;
  Kopf;
  Fusszeile (Eingabe); GotoXY (1, 1);
  W (u1); W (u2); EditStr (1, 10, Upld); If t1=#27 Then HaltProc (1);
  If pos ('\', Upld)<>0 Then UpFound:= TRUE;
  Upld:= UpStr (Upld);
  RC.Upload:= Upld;
END;



PROCEDURE Objekt_listen (Suchpfad: PathStr);
CONST
  p = 'Packer: ';
  u = 'Upload: ';
  e = 'Editor: ';

VAR
  s  : Searchrec;


PROCEDURE WFound (ss : String);
BEGIN W (ss + vollpfad (SuchPfad, s.name)); END;


BEGIN
  Findfirst (Vollpfad (Suchpfad, '*.*'), anyfile, s);
  With s Do
  While (DOSError = 0) and (t<>#27) Do
  BEGIN
    If keypressed Then t:=ReadbKey;

    If (not EdFound) and (name=Edit) Then
    BEGIN
      RC.Editor:= VollPfad (SuchPfad, name);
      WFound (e);
      EdFound:= TRUE;
    END;                              

    If (not UpFound) and (name=Upld) Then
    BEGIN
      RC.Upload:= VollPfad (SuchPfad, name);
      WFound (u);
      UpFound:= TRUE;
    END;

    If (PF=1) and (pos ('.EXE', Name) <>0) Then
    BEGIN
      If (not zipfound) and (name='PKZIP.EXE')   Then
      BEGIN RC.pkzip:=  VollPfad (SuchPfad, name); WFound(p); zipfound:= TRUE; END Else
      If (not unzfound) and (name='PKUNZIP.EXE') Then
      BEGIN RC.pkunzip:=VollPfad (SuchPfad, name); WFound(p); unzfound:= TRUE; END Else
      If (not zxefound) and (name='ZIP2EXE.EXE') Then
      BEGIN RC.zip2exe:=VollPfad (SuchPfad, name); WFound(p); zxefound:= TRUE; END Else
      If (not lhafound) and (name='LHA.EXE')     Then
      BEGIN RC.lha:=    VollPfad (SuchPfad, name); WFound(p); lhafound:= TRUE; END Else
      If (not lrcfound) and (name='LHARC.EXE')   Then
      BEGIN RC.lharc:=  VollPfad (SuchPfad, name); WFound(p); lrcfound:= TRUE; END Else
      If (not arjfound) and (name='ARJ.EXE')     Then
      BEGIN RC.arj:=    VollPfad (SuchPfad, name); WFound(p); arjfound:= TRUE; END;
    END;
    Findnext (s);
  END;
END;



PROCEDURE Rekursiv (SuchPfad : String);
VAR
  sr       : Searchrec;
  new_dir  : PathStr;
BEGIN
  If (t=#27) or (AllFound) Then Exit;
  Findfirst (Vollpfad(Suchpfad,'*.*'), anyfile, sr);
  While DOSError = 0 Do
  BEGIN
    If (sr.attr and directory <> 0) and (sr.name[1]<>'.') Then
    BEGIN
      New_dir:= VollPfad (suchpfad, sr.name);
      Objekt_listen (New_dir);
      Rekursiv (new_dir);
    END;
    Findnext (sr);
  END;
END;



PROCEDURE Suche_Objekt;
VAR
  Suchpfad : PathStr;
BEGIN
  Kopf;
  Fusszeile ('Abbrechen mit Esc');  GotoXY (1, 1);
  w (o1);
  Suchpfad := Pfad[1]+':\';
  Objekt_listen (Suchpfad);
  Rekursiv (Suchpfad);
  Fusszeile (Enter); WaitBKey;
END;


PROCEDURE Ini_lesen;
VAR
  sr : Searchrec;
BEGIN
  FindFirst (IniPath, anyfile, sr);
  If (DOSerror<>0) or (sr.Size<>SizeOf(RC)) Then Exit;
  Assign (f, IniPath); FileMode:=0;
  Reset (f);
  If IOResult=0 Then BEGIN Read (f, RC); Close (f); END;
  If IOResult=0 Then FileMode:=2;
END;


PROCEDURE Ini_schreiben;
BEGIN
  Assign (f, IniPath); SetFAttr (f, 32);
  Rewrite (f); Write (f, RC); Close (f); 
  If IOResult<>0 Then
  BEGIN W (Error); Fusszeile (Enter); WaitBKey; END;
END;


{------------------------- Hauptprozedur ----------------------------------}

BEGIN
  If (Par<>'E') and (Par<> 'P') and (Par<>'U') and (Par<>'A') Then Exit;

  IniPath:= VollPfad (Pfad, 'DC.INI'); 

  t:= Par; PF:= 0;

  Ini_Lesen;

  CASE t Of
    'E' : BEGIN EditorWahl; UpFound:= TRUE; PackerFound;    END;
    'P' : BEGIN PF:= 1;     UpFound:= TRUE; EdFound:= TRUE; END;
    'U' : BEGIN Uploadwahl; EdFound:= TRUE; PackerFound;    END;
    'A' : BEGIN EditorWahl; Uploadwahl; PF:=1;              END;
  END;

  If not AllFound Then Suche_Objekt;

  Ini_Schreiben;

  If Par = 'A' Then Schluss;
  
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
