UNIT Install;


INTERFACE

USES
  masken, DOS, biosCrt, set_var, set_tool, strings, set_edit,
  filecopy, set_menu;


PROCEDURE Ziel_Verzeichnis_Wahl;
PROCEDURE Xcopy (QuellPfad, ZielPfad : PathStr);
PROCEDURE ComanderStartdatei_erzeugen;
PROCEDURE ChangeConfigAndAutoexec;



IMPLEMENTATION



PROCEDURE Ziel_Verzeichnis_Wahl;
VAR
  df : LongInt;
BEGIN
  OldNewDosPath:= DelLastSlash (GetPathName(FSearch ('DCLOAD.EXE', GetEnv ('PATH'))));
  OldNewDosPath:= UpStr (OldNewDosPath);

  If OldNewDosPath<>'' Then
  BEGIN
    If ObjektExist (OldNewDosPath+'.OLD')=0 Then
    BEGIN
      Rename_Menu (OldNewDosPath);
      RenameFile (OldNewDosPath, OldNewDosPath+'.OLD', FALSE);
      If IOResult<>0 Then Rename_Error;
    END;
  END;

  ZielDir:= StdZielDir;
  REPEAT
    Kopf;
    Fusszeile (Eingabe); GotoXY (1, 1);
    w ('Geben Sie das Verzeichnis an, in dem '+ProgName+' installiert werden'#13#10+
       'soll oder besttigen Sie das angezeigte Verzeichnis mit ENTER.');
    EditStr (1, 4, ZielDir); If t1=#27 Then HaltProc (1);
    ZielDir:= Trim (UpStr (ZielDir));
    If Length (ZielDir) = 0 Then HaltProc (2);
    If ObjektExist (ZielDir) = Ver Then
    BEGIN
      If ZielDir<>ProgDir Then
      BEGIN
        Fusszeile ('Drcken Sie J fr Installieren oder N fr Neueingabe');
        GotoXY (1, 6);
        w ('Verzeichnis existiert bereits. Trotzdem installieren? (j/n)');
        GetKey ('JN');
      END Else t1:= 'J';
    END;
  UNTIL (ObjektExist (ZielDir)<>Ver) or (t1 = 'J');
  df:= DiskFree (ord (ZielDir[1])-64);
  If df = -1 Then FehlerEnde ('Ziellaufwerk nicht bereit');
  If df < 4000000 Then FehlerEnde ('Zu wenig Speicherplatz auf Ziellaufwerk');
END;


PROCEDURE Xcopy;
VAR
  ActDir : PathStr;
BEGIN
  If ProgDir<>ZielDir Then
  BEGIN
    If ObjektExist (Vollpfad (ProgDir, CopyProg)) <> Dat Then
    Fehlerende ('Das Kopierprogramm '+CopyProg+' wurde nicht gefunden.');
    SwapVectors;
    Exec (VollPfad (ProgDir, CopyProg), ProgDir+' '+ZielDir+' /e/v/r/h');
    SwapVectors;
    If (DosExitCode<>0) or (DOSError<>0) Then
    BEGIN
      Kopf;
      Fehlerende ('Beim Kopieren ist ein Fehler aufgetreten.');
    END;
  END;

  If ObjektExist (Vollpfad (ZielDir, PackArchiv)) = Dat Then
  BEGIN
    GetDir (0, ActDir);
    ChDir (ZielDir);
    SwapVectors;
    Exec (PackArchiv, '');
    SwapVectors;
    If (DOSError<>0) Then
    BEGIN
      Kopf;
      Fehlerende ('Beim Entpacken ist ein Fehler aufgetreten.');
    END;
    EraseFile (PackArchiv);
    ChDir (ActDir);
  END;
END;


PROCEDURE ComanderStartdatei_erzeugen;
VAR
  f : Text;
BEGIN
  Assign   (f, VollPfad (ZielDir, Start_bat));
  Rewrite  (f);
  If IOResult<>0 Then BEGIN SetFAttr (f, 32); Rewrite (f); END;

  WriteLn  (f, '@ECHO OFF');
  WriteLn  (f,  Vollpfad (ZielDir, Loader));
  WriteLn  (f, 'EXIT');
  Close    (f);

  If IOResult<>0 Then FehlerEnde (
  'Die Start-Datei fr den Datei- und Programm-Manager konnte nicht'#13#10+
  'erzeugt werden.');
END;


PROCEDURE KonfigError;
BEGIN
  FehlerEnde ('Anpassung der DOS-Konfigurationsdateien ist fehlgeschlagen');
END;

VAR
  KalFound : Boolean;
  AlFound  : Boolean;
  DCFound  : Boolean;

  EuroInst : Boolean;
  Y2KInst  : Boolean;
  ClipInst : Boolean;
  ASCIIInst: Boolean;
  ANSIInst : Boolean;
  PrintInst: Boolean;


PROCEDURE Abfragen;
BEGIN
  EuroInst:= Install_Abfrage (
  'Wollen Sie die Untersttzung des Euro-Whrungssymboles auf Ihrem'#13#10+
  'Computer installieren? (j/n)',
  'Ermglicht die Eingabe des Euro-Zeichens auf der Tastatur mit der'#13#10+
  'Tastenkombination ALTGR+E und die Darstellung des Eurosymboles auf'#13#10+
  'dem Monitor und dem Drucker.');

  Y2KInst:= Install_Abfrage (
  'Wollen Sie die Jahr-2094-Tools auf Ihrem Computer installieren? (j/n)',
  '- Zweistellige Jahresangaben ab dem Jahr 2000 werden von DOS korrekt'#13#10+
  '  verarbeitet'#13#10+
  '- Der Jahr-2094-Fehler wird automatisch korrigiert');

  ClipInst:= Install_Abfrage (
  'Wollen Sie die anwendungsbergreifende Zwischenablage (Clipboard)'#13#10+
  'auf Ihrem Computer installieren? (j/n)',
  'ber die Zwischenablage knnen Sie hnlich wie unter Windows Daten'#13#10+
  'zwischen verschiedenen Anwendungen austauschen.');

  AsciiInst:= Install_Abfrage (
  'Wollen Sie die speicherresidente ASCII-Tabelle auf Ihrem Computer'#13#10+
  'installieren? (j/n)',
  'Blendet beim Drcken beider SHIFT-Tasten eine Tabelle mit allen ASCII-'#13#10+
  'Zeichen in eine DOS-Anwendung ein, aus der Sie Zeichen direkt in die'#13#10+
  'Anwendung einfgen knnen.');

  If AnsiSysInstalled Then
  ANSIInst:= Install_Abfrage (
  'Wollen Sie den neuen ANSI-Treiber auf Ihrem Computer'#13#10+
  'installieren? (j/n)',
  'Der ANSI-Treiber ermglicht im DOS-Textmodus die Ausgabe von Farben'#13#10+
  'u.. Der neue '+PName+'-ANSI-Treiber untersttzt jedoch keine'#13#10+
  'Tastaturmakros, verbraucht aber weniger Speicher als das Original.')
  Else AnsiInst:= FALSE;

  PrintInst:= Install_Abfrage (
  'Wollen Sie die Hintergrunddruck-Funktion auf Ihrem Computer'#13#10+
  'installieren? (j/n)',
  'Ermglicht das Drucken im Hintergrund aus beliebigen DOS-Anwendungen.'#13#10+
  'Sie sollten diese Funktion nur installieren, wenn Sie noch ber'#13#10+
  'gengend freien DOS-Speicher verfgen');
END;



VAR
  f1, f2      : Text;
  KonfigBlock : Boolean;


FUNCTION FoundInFile (FileName : PathStr; Line : String) : Boolean;
VAR
  Found: Boolean;
  lh   : String;
BEGIN
  Found:= FALSE;
  Assign (f1, FileName); FileMode:= 0; Reset (f1);
  While (not Found) and (not Eof (f1)) and (IOResult=0) Do
  BEGIN
    ReadLn (f1, lh);
    If pos (Line, UpStr (Trim (lh)))<>0 Then Found:= TRUE;
  END;
  Close (f1); InOutRes:= 0;
  FoundInFile:= Found;
END;


FUNCTION FoundInKonfigblock (Line : String) : Boolean;
VAR
  Found   : Boolean;
  lh      : String;
  InBlock : Boolean;
BEGIN
  Found:= FALSE; InBlock:= FALSE;
  Assign (f1, 'C:\AUTOEXEC.BAT'); FileMode:= 0; Reset (f1);
  While (not Found) and (not Eof (f1)) and (IOResult=0) Do
  BEGIN
    ReadLn (f1, lh);
    lh:= UpStr (Trim (lh));
    If (pos ('NEW-DOS+KONFIGURATIONSBLOCK', lh)<>0) Then InBlock:= TRUE Else
    If (pos ('NEW-DOS-KONFIGURATIONSBLOCK', lh)<>0) Then InBlock:= FALSE;
    If (InBlock) and (pos (Line, lh)<>0) Then Found:= TRUE;
  END;
  Close (f1); InOutRes:= 0;
  FoundInKonfigBlock:= Found;
END;


PROCEDURE CloseAll;
BEGIN
  Close (f1); InOutRes:= 0; Close (f2); InOutRes:= 0;
END;


PROCEDURE RestoreOldKonfig;
BEGIN
  CloseAll;
  RenameFile ('C:\AUTOEXEC.OLD', 'C:\AUTOEXEC.BAT', TRUE);
  RenameFile ('C:\CONFIG.OLD',   'C:\CONFIG.SYS',   TRUE);
  EraseFile  (Vollpfad (TempPath, TempFile)); InOutRes:= 0;
  KonfigError;
END;


FUNCTION IsRem (ein : String) : Boolean;
BEGIN
  ein:= UpStr (Trim (ein));
  IsRem:=    (pos ('REM ', ein) = 1)
          or (pos (';',    ein) = 1)
          or (pos (':',    ein) = 1);
END;


PROCEDURE Rename_and_Open (Name : PathStr);
BEGIN
  RenameFile (Name, Vollpfad (TempPath, TempFile), TRUE);
  If IOResult<>0 Then KonfigError; 
  Assign (f1, Vollpfad (TempPath, TempFile)); FileMode:= 0; Reset (f1);
  Assign (f2, Name); SetFAttr (f2, 32); Rewrite (f2);
  If IOResult<>0 Then RestoreOldKonfig;
END;


PROCEDURE DeInstallOldNewDos;
VAR
  s, s1, tmp  : String;
  p           : Byte;


PROCEDURE WriteKonfigBlock;
BEGIN
  s:= #0;
  If KonfigBlock Then Exit;
  KonfigBlock:= TRUE;
  WriteLn (f2, 'REM NEW-DOS+Konfigurationsblock (diesen Eintrag nicht verndern)');
  WriteLn (f2, 'REM NEW-DOS-Konfigurationsblock (diesen Eintrag nicht verndern)');
END;


BEGIN
  KalFound:= FALSE; AlFound:= FALSE; DCFound:= FALSE;
  Rename_and_Open ('C:\AUTOEXEC.BAT');
  While not Eof (f1) Do
  BEGIN
    ReadLn (f1, s);
    tmp:= UpStr (Trim(s));

    If (OldNewDosPath<>'') and (not IsREM (tmp)) Then
    BEGIN
      If  (pos ('PATH', tmp)=1)
      or ((pos ('SET',  tmp)=1) and (pos ('PATH', tmp)<>0)) Then
      BEGIN
        If pos (OldNewDosPath, tmp)<>0 Then
        BEGIN
          p:= pos (OldNewDosPath, UpStr (s));
          delete (s, p, Length (OldNewDosPath));
          While (Length (s)>0) and (s[p]=' ') Do   delete (s, p, 1);
          If    (Length (s)>0) and (s[p]=';') Then delete (s, p, 1);
        END;
      END Else

      If (tmp='DC') or (tmp='DC.BAT')
      or (tmp=Vollpfad (OldnewdosPath, 'DC'))
      or (tmp=Vollpfad (OldnewdosPath, 'DC.BAT')) Then
      BEGIN
        WriteKonfigBlock;
        DCFound:= TRUE;
      END Else

      If pos ('KALENDER', tmp) <> 0 Then
      BEGIN
        WriteKonfigBlock;
        KalFound:= TRUE;
      END Else

      If pos ('ALARM', tmp) <> 0 Then
      BEGIN
        WriteKonfigBlock;
        AlFound:= TRUE;
      END;
    END Else
    If (GetFileName (tmp)='WIN')
    or (GetFileName (tmp)='WIN.COM')
    or (GetFileName (tmp)='NC')
    or (GetFileName (tmp)='NC.EXE') Then
    BEGIN
      s1:= s;
      WriteKonfigBlock;
      s:= s1;
    END;

    tmp:= UpStr (Trim(s));
    While pos (' ', tmp)<>0 Do delete (tmp, pos (' ',tmp), 1);
    If (tmp<>'SETPATH=%PATH%') and (s<>#0) Then
    WriteLn (f2, s);

    If IOResult<>0 Then RestoreOldKonfig;
  END;
  WriteKonfigBlock;
  CloseAll;
END;


PROCEDURE DeleteEntry (FileName : PathStr; Entry : String; Del : Boolean);
VAR
  s : String;
BEGIN
  Rename_and_Open (FileName);
  While not Eof (f1) Do
  BEGIN
    ReadLn (f1, s);
    If  (not IsREM (s))
    and (pos (Entry, UpStr (s))<>0) Then
    BEGIN
      If Del=FALSE Then insert ('REM ', s, 1) Else
      If Eof (f1) Then s:='' Else ReadLn (f1, s);
    END;   
    WriteLn (f2, s);
    If IOResult<>0 Then RestoreOldKonfig;
  END;
  CloseAll;
END;


PROCEDURE InsertEntry (Entry : String; LineNum : Byte);
VAR
  s, tmp  : String;
  InBlock : Boolean;
  Found   : Boolean;
BEGIN
  Rename_and_Open ('C:\AUTOEXEC.BAT');
  InBlock:= FALSE; Found:= FALSE;
  While not Eof (f1) Do
  BEGIN
    ReadLn (f1, s);
    tmp:= UpStr (Trim (s));
    If (pos ('NEW-DOS+KONFIGURATIONSBLOCK', tmp)<>0) Then
    BEGIN
      If LineNum=1 Then
      BEGIN WriteLn (f2, s); s:= Entry; END Else
      InBlock:= TRUE;
    END Else
    If (pos ('NEW-DOS-KONFIGURATIONSBLOCK', tmp)<>0)
    or (tmp='DC') or (tmp='DC.BAT')
    or (pos ('KALENDER', tmp) = 1)
    or (pos ('ALARM', tmp) = 1)
    Then
    BEGIN If (not Found) and (InBlock) Then WriteLn (f2, Entry); InBlock:= FALSE; END Else
    If  (InBlock) and (not Found)
    and ((tmp=Entry)
    or  ((pos (' ', Entry)<>0) and (pos (copy (Entry, pos (' ', Entry)+1, 255), tmp)<>0))) Then
    BEGIN
      Found:= TRUE;
      s:= Entry;
    END;
    WriteLn (f2, s);
    If IOResult<>0 Then RestoreOldKonfig;
  END;
  CloseAll;
END;


FUNCTION UMBExist : Byte;
VAR
  tmp  : String;
BEGIN
  UMBExist:= 0;
  Assign (f1, 'C:\CONFIG.SYS'); FileMode:= 0; Reset (f1);
  While (not Eof (f1)) and (IOResult=0) Do
  BEGIN
    ReadLn (f1, tmp);
    tmp:= UpStr (Trim (tmp));
    If not IsREM (tmp) Then
    BEGIN
      If (pos ('HIDOS=ON', tmp)<>0) and (pos ('ON',  tmp)<>0) Then UMBExist:= 2 Else  { DR-DOS }
      If (pos ('DOS=',     tmp)<>0) and (pos ('UMB', tmp)<>0) Then UMBExist:= 1;
    END;
  END;
  Close (f1); InOutRes:= 0;
END;


PROCEDURE ChangeConfigAndAutoexec;
VAR
  Buffer : Array[1..10000] Of Byte;
  lh     : String;
  cdFound: Byte;

PROCEDURE CopyOldFile (Name : PathStr);
BEGIN
  CopyFile (Vollpfad (OldNewDosPath+'.OLD', Name),
            Vollpfad (ZielDir, Name), Buffer, SizeOf (Buffer));
END;

BEGIN
  CopyFile ('C:\AUTOEXEC.BAT', 'C:\AUTOEXEC.OLD', Buffer, SizeOf (Buffer));
  If CopyResult<>0 Then KonfigError;
  CopyFile ('C:\CONFIG.SYS',   'C:\CONFIG.OLD',   Buffer, SizeOf (Buffer));
  If CopyResult<>0 Then KonfigError;

  If TempPath='' Then TempPath:= VollPfad (ZielDir, TmpName);
  If ObjektExist (TempPath)<>Ver Then
  BEGIN
    MkDir (TempPath);
    If IOResult<>0 Then TempPath:= 'C:\';
  END;

  KonfigBlock:= FoundInFile ('C:\AUTOEXEC.BAT', 'NEW-DOS-KONFIGURATIONSBLOCK');
  DeInstallOldNewDos;

  If FoundInKonfigBlock ('SET PATH=') Then
  DeleteEntry ('C:\AUTOEXEC.BAT', 'SET PATH=', True);

  InsertEntry ('SET PATH='+ZielDir+';%PATH%', 1);
  If Vollpfad (ZielDir, TmpName) = TempPath Then
  InsertEntry ('SET TEMP='+TempPath, 0);

  CASE UMBExist Of
    1 :  lh:= 'LH ';
    2 :  lh:= 'HILOAD ';
    Else lh:= '';
  END;

  Abfragen;

  If EuroInst Then
  BEGIN
    DeleteEntry ('C:\AUTOEXEC.BAT', 'KEYB', False);
    DeleteEntry ('C:\CONFIG.SYS',   'KEYB', False);
    InsertEntry (lh+'KEYB', 0);
    InsertEntry (lh+'EURO', 0);
  END;

  If Y2KInst Then
  BEGIN
    DeleteEntry ('C:\AUTOEXEC.BAT', 'YEAR2000', true);
    InsertEntry ('YEAR2094', 0);
    SwapVectors;
    Exec (Vollpfad (ZielDir, 'YEAR2094.COM'), '/i');
    SwapVectors;
    InsertEntry (lh+'DATE2000', 0);
  END;

  If ClipInst  Then InsertEntry (lh+'CLIP', 0);
  If ASCIIInst Then InsertEntry (lh+'ASCII', 0);
  If ANSIInst  Then InsertEntry (lh+'ANSI', 0);
  If PrintInst Then InsertEntry (lh+'PRINTER', 0);
  If DCFound   Then InsertEntry ('DC', 0);
  If KalFound  Then InsertEntry ('KALENDER /S', 0);

  If AlFound  Then
  BEGIN
    CopyOldFile ('ALARM.EXE');
    If CopyResult=0 Then
    CopyOldFile ('ALARM.DOC');
    If CopyResult=0 Then InsertEntry ('ALARM.EXE /S', 0);
  END;


  If OldNewDosPath<>'' Then
  BEGIN
    CopyOldFile ('KALENDER.TER');
    CopyOldFile ('DC.INI');
    CopyOldFile ('AUTOSTAR.INI');
    CopyOldFile ('ED.INI');
    CopyOldFile ('USERPACK.INI');
    CopyOldFile ('STAPEL.LOG');
    CopyOldFile ('DC.MNU');
  END;

  If  (ObjektExist (Vollpfad (ZielDir, 'DC.MNU')) = Dat)
  and (not FoundInFile (Vollpfad (ZielDir, 'DC.MNU'), '[CHDIR]')) Then
  BEGIN
    RenameFile (Vollpfad (ZielDir, 'DC.MNU'),  Vollpfad (ZielDir, 'DC.MN_'), True);
    Assign (f1, Vollpfad (ZielDir, 'DC.MN_')); FileMode:= 0; Reset (f1);
    Assign (f2, Vollpfad (ZielDir, 'DC.MNU')); Rewrite (f2);
    cdFound:= 0;
    While (IOResult=0) and (not Eof (f1)) Do
    BEGIN
      ReadLn (f1, lh);
      WriteLn (f2, lh);
      If (cdFound=0) and (UpStr (Trim (lh)) = '[ENDE]') Then
      BEGIN
        inc (cdFound);
        WriteLn (f2, #13#10'[CHDIR]'#13#10'[ENDE]'#13#10);
      END;
    END;
    Close (f1); Close (f2); Erase (f1);
  END;

  AutoExec_fertig;
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
