UNIT set_Tool;


INTERFACE

USES
  Dos, bioscrt, monitor, set_var, masken, filecopy, strings;

FUNCTION  AnsiSysInstalled : Boolean;
FUNCTION  PrintInstalled   : Boolean;

PROCEDURE ClearWin  (a, b, c, d, e : Byte);
PROCEDURE Kopf;
PROCEDURE Clear;
PROCEDURE w         (s     : String);
PROCEDURE Fusszeile (s     : PathStr);
PROCEDURE Linie     (y     : Byte);
PROCEDURE GetKey    (InStr : String);
PROCEDURE HaltProc  (Modus : Byte);
FUNCTION  HeadLine         : String;

CONST
  NAttr= 31;
  UAttr= 30;
  BAttr= 20;

CONST
  AutoChange : Boolean = FALSE;

IMPLEMENTATION


FUNCTION AnsiSysInstalled : Boolean; assembler;
ASM
  mov ax, 1A00h
  int 2Fh
  and al, 1
END;


FUNCTION PrintInstalled : Boolean; assembler;
ASM
  mov ax, 0100h
  int 2Fh
  cmp al, 1
  jne @ende
  dec al
  @ende:
  and al, 1
END;
{al = 0   : Print.com nicht installiert, aber installierbar}
{al = 1   : Print.com nicht installiert, aber auch NICHT installierbar}
{al = $FF : Print.com resident installiert}



FUNCTION HeadLine : String;
VAR
  tmp : String;
BEGIN
  tmp:= 'SETUP    Einrichtungsprogramm fr '+ProgName;
  While Length (tmp)<71 Do insert (' ', tmp, 6);
  HeadLine:= tmp;
END;


PROCEDURE w (s: String); BEGIN WriteStr (s+#13#10); END;


PROCEDURE ClearWin (a, b, c, d, e : Byte);
BEGIN
  TextAttr:=e; Window (a, b, c, d); ClrScr;
END;


PROCEDURE Linie (y : Byte);
VAR
  x : Byte;
BEGIN
  GotoXY (1, y); For x:= 1 To 71 Do WriteChar (#196);
END;


PROCEDURE Fusszeile (s : PathStr);
BEGIN
  GotoXY (1, 20);
  WriteStr (s); ClrEol;
END;


PROCEDURE Kopf;
BEGIN
  ClearWin (1, 1, 80, 25, NAttr); 
  Window (6, 2, 80, 25); W (HeadLine); Linie (2);
  Window (6, 5, 78, 25);
END;


PROCEDURE Clear;
BEGIN
  ClearWin (6, 5, 78, 25, NAttr);
END;


PROCEDURE GetKey (InStr : String);
BEGIN
  REPEAT UpScanBKeys UNTIL pos (t1, InStr)<>0;
END;



PROCEDURE HaltProc (Modus : Byte);
BEGIN
  ClearWin (1, 1, 80, 25, 7);
  CASE Modus Of
    0 : w ('Ende der Installation');
    1 : w ('Abbruch durch Benutzer');
    2 : w ('Abbruch durch Bedienfehler');
    3 : w ('Abbruch durch Programm- oder Ausfhrungsfehler');
  END;
  If Modus>=2 Then
  BEGIN w (Enter); WaitBKey; END;
  EraseFile (VollPfad (TempPath, TempFile));
  Halt;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
