
jmp BEGIN 

DB                  1   ; VersionsNummer des Treibers 
DB                  7   ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0 ; interne Nummer (vom Programmierer frei whlbar) 
DB                  21h ; Nummer eines der umgeleiteten Interrupts 
DB                  1   ; Zahl der erwarteten Start-Parameter
 
Flag            DB  0
DosVer          DW  0
OemNr           DB  0

;----------------------- Unterfunktionen ---------------------------------
 


GetVersion:
  cs:
  cmp  Byte Flag, 2
  je   @Old
  cs:
  cmp  Byte Flag, 1       ; Flag wird vom Unloader auf 1 gesetzt, 
  je   @Unload

  cmp  ah, 30h            ; Versionsabfrage ?
  jne  @Old

  cs:
  mov  ax, DosVer
  cs:
  mov  bh, OemNr
  retf 2

@Old:
  DB 0EAh                 ; JMP Far Ptr = alte Int-21h-Routine
  OBJECT Old21:
    Ofs DW '6.'           ; hier setzt der Loader die alte Adresse
    Seg DW '24'           ; der alten Int-21h-Routine ein.
  OBJECT END
@Unload:
  push ax, di
  cli
  cld
  xor  ax, ax
  mov  es, ax
  mov  di, 21h
  shl  di, 1
  shl  di, 1 
  cs:
  mov  ax, Old21.Ofs
  stosw
  cs:
  mov  ax, Old21.Seg
  stosw
  sti
  pop  di, ax

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von SETVER.COM wieder freigeben
  jmp  short @Old

; ------------------------------ Loader --------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &ProgName
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @xh                    ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  inc  di
  dec  cx                     ; Zahl der nach '/b' noch folgenden Zeichen
  and  al, 11011111b          ; UpCase
 
         cmp al, 'V' / je @Laden
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3521h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  mov  ah, 30h / int  21h              ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT


PROC Val:
  sub  al, 48 / sub ah, 48
  mov  bl, ah
  xor  ah, ah
  mov  bh, 10
  mul  bh
  add  al, bl
  RET
ENDP


@Laden:
  cmp  cx, 4
  jb   @xh
 
  mov  ax, es:[di]
  cmp  al, ' ' / je @xh / cmp  ah, ' ' / je @xh 
  #val
  mov  dl, al
  mov  ax, es:[di+2]
  cmp  al, ' ' / je @xh / cmp  ah, ' ' / je @xh 
  #val
  mov  dh, al
  mov  Dosver, dx

  mov  ah, 30h          ; OEM-Nr holen
  int  21h
  mov  OemNr, bh

  -EnvironMemFree

  lea  dx, &Load
  #OutPut              ; Gebe Text aus                  

  mov  ax, 3521h       ; GetIntVec 21h
  int  21h                                
  mov  Old21.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old21.Seg, es 

  mov  ax, 2521h       ; SetIntVec 21h
  lea  dx, GetVersion  ; = mov dx, Offset GetVersion, DS bereits Segment-Addr.
  int  21h
 
  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen


PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
 
.ifopt deu
  &ProgName  DB  'SETVER  ', Copyright,'$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'tuscht Anwendungen gegenber die angegebene DOS-Versionsnummer vor'
  >               13,10,13,10
  >              'Laden  : SETVER [/v?]',13,10
  >              'Steuern: SETVER [/x|/s|/r]',13,10,13,10
  >              '/v  gewnschte DOS-Version, z.B. /v0622 fr DOS 6.22',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren$' 
.endopt 

.ifopt eng
  &ProgName  DB  'SETVER  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Simulates the assigned DOS version number for applications'
  >               13,10,13,10
  >              'Install: SETVER [/v?]',13,10
  >              'Control: SETVER [/x|/s|/r]',13,10,13,10
  >              '/v  Desired DOS version, e.g. /v0622 for DOS 6.22',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt  
            


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
