PROGRAM Space;
{$M 20000, 0, 0}

USES
  BiosCrt, Dos, masken, keycode, spc, strings, logfile, filecopy, WildCard;

CONST
  Max      = 20000;
  ProgName = 'SPACE';
  ErrCode  : Byte   = 0;
  Files    : Byte   = 0;
  Quelle   : String = '';
  Zielpfad : PathStr= '';

VAR
  x            : Byte;
  ck           : Word;
  f1, f2       : File;
  d1           : array[1..Max    ] Of Byte;
  d2           : array[1..Max * 2] Of Byte;
  gel, ges, y  : Word;
  p3           : PathStr;
  c            : Char;
  sr           : Searchrec;
  p            : PathStr;
  d, dd        : DirStr;
  n            : NameStr;
  e            : ExtStr;
  unp, gep     : LongInt;
  Pfad, Objekt : PathStr;
  Param        : String;
  PStat        : Byte;

LABEL
  Weiter, Error;


PROCEDURE Hilfetext;
BEGIN
  Standardkopf (ProgName, Copyright);
  DosLnLF
    ('Programm zum Packen und Entpacken von Textdateien.'#13#10#13#10+
     'SPACE [Quelldatei/en] [ZielPfad] [/e /p /o]'#13#10#13#10+
     '/e  oder kein Parameter: SPC-Datei entpacken'#13#10+
     '/p  Datei packen');
  DosLnLF
    ('/o  Fehler werden in der LOG-Datei protokolliert'#13#10#13#10+
     'Fehlt [Zielpfad], werden die Zieldateien im gleichen Verzeichnis wie die'#13#10+
     'Quelldateien abgelegt.');
  Blindstop; Halt;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4;
CONST
  packen    : Boolean = TRUE;
  entpacken : Boolean = FALSE;

BEGIN
  t2:= #0;
  a1:
  EditStr (1, Quelle, 'Datei(en), die ge- oder entpackt werden soll(en):');
  Quelle:= UpStr (Quelle);

  a2:
  EditStr (6, Zielpfad, 'Zielverzeichnis (leer = gleiches Verzeichnis wie Quelldateien):');
  If t2=Up Then Goto a1;

  a3:
  ParamField (10, packen, 'Dateien packen');
  entpacken:= not packen;
  If t2=Up Then Goto a2;

  a4:
  ParamField (11, entpacken, 'Dateien entpacken');
  Packen:= not entpacken;
  If t2=Up Then Goto a3;

  If (ee=0) and (Quelle='') Then
  BEGIN
    Tastenabfrage ('Ungltige Dateiangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;

  If ee=0 Then
  BEGIN If packen Then c:= 'P'; If entpacken Then c:= 'E'; END;
END;



PROCEDURE Maske;
BEGIN
  Quelle:= '*.TXT';
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;



PROCEDURE ErrorEnd (ErrCode1 : Byte);
BEGIN
  If FileRec(f1).mode<>fmClosed Then XClose (f1);
  If FileRec(f2).mode<>fmClosed Then XClose (f2);
  ErrCode:= ErrCode1;
  SimpleHaltLog (#13#10'Ausfhrungsfehler');
END;



BEGIN
  FileMode:=0;
  StretchParam (Param);

  If ParamCount=0 Then Maske Else
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfetext;
      'P' : c:= 'P';
      'E' : c:= 'E';
      'O' : LogStatus:= 0;
    END Else
    BEGIN
      If Quelle  ='' Then Quelle  := Param Else
      If ZielPfad='' Then ZielPfad:= Param;
    END;
  END;

  Quelle:= FileExpand (Quelle);
  If DOSError=0 Then PStat:= PathStatus (Quelle, CheckQuelle) Else
                     PStat:= DOSError;
  If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));

  Objekt:= GetFileNames (Quelle);
  Pfad  := GetPathName  (Quelle);

  If ZielPfad='' Then ZielPfad:= Pfad Else ZielPfad:= FileExpand (ZielPfad);
  If DOSError=0 Then PStat:= PathStatus (ZielPfad, CheckZiel) Else PStat:= DOSError;
  If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));

  StandardKopf (ProgName, '');

  FindFirst (VollPfad (Pfad, '*.*'), NormalFile, sr);
  If DOSError>=150 Then SimpleHaltLog (CopyResultStr (DosError));

  While DOSError=0 Do
  BEGIN
    Files:= 1;
    If (sr.attr and directory<>0) or (not FileMatch (sr.name, Objekt)) Then Goto Weiter;
    Quelle:= VollPfad (Pfad, sr.name);
    FSplit (Quelle, dd, n, e);
    If ZielPfad<>'' Then dd:= ZielPfad;

    If c='E' Then
    BEGIN
      If e<>'.SPC' Then Goto Weiter;
      p3:= Vollpfad (dd, n+'.TXT');
    END Else p3:= Vollpfad (dd, n+'.SPC');

    Assign (f1, Quelle); Reset (f1, 1); If IOResult<>0 Then ErrorEnd (2);
    Assign (f2, p3); SetFAttr (f2, 32);
    Rewrite (f2, 1); If IOResult<>0 Then ErrorEnd (3);

    unp:=0; gep:=0;

    While not Eof (f1) Do
    BEGIN
      BlockRead (f1, d1, Max, gel);
      If IOResult<>0 Then ErrorEnd (4);
      If c = 'E' Then
      BEGIN
        ck:= gel;
        While (ck>0) and (d1[ck]=31) Do dec (ck);
        If (ck<>gel) and (odd (ck)) and (not Eof (f1)) Then
        BEGIN
          UnPackText (d1, d2, pred (gel), y);
          Seek (f1, pred (FilePos(f1)));
        END Else UnPackText (d1, d2, gel, y);
      END
      Else
      BEGIN
        If (d1[gel]= 13) and (not Eof (f1)) Then
        BEGIN
          PackText (d1, d2, pred (gel), y);
          Seek (f1, pred (FilePos(f1)));
        END Else PackText (d1, d2, gel, y);
      END;
      BlockWrite (f2, d2, y, ges);
      If IOResult<>0 Then ErrorEnd (5);
      inc (unp, gel); inc (gep, ges);
    END;

    Close(f1); Close(f2); If IOResult<>0 Then ErrorEnd (6);
    inc (unp); If unp<1 Then unp:=1;
    DosNum (gep*100 DIV unp); DosStr (' %  '); DosLnLF (Quelle);

    Weiter:
    FindNext (sr);
  END;

  If Files=0 Then ErrorEnd (1);
  Blindstop; Halt (0);
END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
