PROGRAM Text2Exe;
{SView.exe mu mit copy /b text2exe.exe+sview.exe t.exe an text2exe.exe
 angehngt werden. Anschlieend umbenennen von t.exe in text2exe.exe} 

USES
  BiosCrt, strings, Masken, spc, konvert, keycode;


CONST
  ProgName = 'TEXT2EXE';
  ProgSize = 8656;
  WinKon   : Boolean = FALSE;
  Quelle   : String  = '';

VAR
  f1, f2   : File;
  gel, ges : Word;
  Buf      : Array[1..60000] Of Char;
  Ziel     : String;
  Packe    : Boolean;


PROCEDURE Hilfe;
BEGIN
  Standardkopf (ProgName, CopyRight);
  DosLnLF (
 'verwandelt Textdateien in sich selbst anzeigende EXE-Dateien'#13#10#13#10+
 'TEXT2EXE [Dateiname] [/i]'#13#10#13#10+
 '/i  Windows-Zeichensatz in DOS-Zeichensatz konvertieren');
  BlindStop; Halt;
END;


PROCEDURE ErrorMsg (s : String);
BEGIN
  DosLnLF ('');
  DosLnLF (s);
  BlindStop;
  Halt;
END;


PROCEDURE AddFiles;
BEGIN
  FileMode:= 2;
  Assign (f2, Ziel);
  Reset (f2, 1); Close (f2);
  If IOResult = 0 Then ErrorMsg ('Ziel-Datei existiert bereits');

  ReWrite (f2, 1);

  FileMode:= 0;
  Assign (f1, ParamStr (0));
  Reset (f1, 1);
  Seek (f1, ProgSize);
  BlockRead  (f1, Buf, SizeOf (Buf), gel);
  BlockWrite (f2, Buf, gel, ges);
  Close (f1);

  Assign (f1, Quelle);
  Reset (f1, 1);
  BlockRead  (f1, Buf, SizeOf (Buf), gel);
  If WinKon Then
  For ges:= 1 To gel Do Buf[ges]:= WinToDos (Buf[ges]);
  If Packe  Then PackText (Buf, Buf, gel, gel);
  BlockWrite (f2, Buf, gel, ges);
  Close (f1);
  Close (f2);

  If IOResult <> 0 Then ErrorMsg ('Fehler beim Anlegen der Zieldatei');
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Quelle, 'Datei, die in eine EXE-Datei verwandelt werden soll:');

  a2:
  ParamField (6, WinKon, 'Windows-Zeichensatz in DOS-Zeichensatz konvertieren');
  If t2=Up Then Goto a1;

  If (ee=0) and (Quelle='') Then
  BEGIN
    Tastenabfrage ('Ungltige Dateiangabe. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


BEGIN
  Stretchparam (Ziel);
  If ParamCount = 0 Then
  BEGIN
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
    ClrScr;
  END Else

  For gel:= 1 To ParamCount Do
  BEGIN
    Ziel:= UpStr (ParamStr (gel));
    If Ziel[1] = '/' Then
    CASE Ziel[2] Of
      '?' : Hilfe;
      'I' : WinKon:= TRUE;
    END Else
    If Quelle = '' Then Quelle:= Ziel;
  END;
  If Quelle='' Then ErrorMsg ('Dateiname fehlt');

  Packe:= pos ('.SPC', Quelle) = 0;

  Ziel:= ChangeFileExt (Quelle, 'EXE');
  AddFiles;
  ErrorMsg (Quelle+' zu '+Ziel+' konvertiert');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
