PROGRAM Touch;
{$M 60000, 0, 0}

USES
  DOS, BiosCrt, Strings, masken, LogFile, filecopy, Disk, Time, WildCard;


VAR
  Objekt, ParStr : PathStr;

  px      : Byte;
  tg      : Searchrec;
  Q       : File;
  Dummy   : Word;
  NDates,
  ODates  : DateTime;
  PStat   : Byte;
  DateStr : String;
  TimeStr : String;

CONST
  SuchPfad  : String   = '';
  Result    : Word     = 0;
  Rekurs    : Boolean  = False;
  LosTaste  : Boolean  = False;
  Files     : LongInt  = 0;
  OTime     : LongInt  = 0;
  NTime     : LongInt  = 0;
  TimeSet   : Boolean  = False;
  DateSet   : Boolean  = False;
  Found     : Boolean  = False;
  LowCase   : Boolean  = False;
  Attrs     : Byte     = 255 and not (Hidden or Sysfile or ReadOnly);


PROCEDURE Tastenfrage;
BEGIN
  REPEAT
    UpScanBKeys;
  UNTIL (t1='J') or (t1='N') or (t1= 'A') or (t1=#13) or (t1=#27);
END;



PROCEDURE ExProc;
BEGIN
  If (t1=#27) or (Result<>0) Then
  BEGIN
    DosLnLF ('');
    If t1=#27 Then
    BEGIN ErrCode:= 253; SimpleHaltLog ('Abbruch durch Anwender'); END Else
    BEGIN ErrCode:= 255; SimpleHaltLog (CopyResultStr (Result));   END;
    DosLnLF ('');
  END;
END;



PROCEDURE Hilfetext;
CONST
s1='ndert Datum und/oder Uhrzeit von Dateien'#13#10#10+
   'TOUCH [Verzeichnis/Dateiname/n] [Parameter 1..x]'#13#10#10+
   '/t:hh:mm:ss  setzt die angebene Zeit. Wenn Sie nur /t eingeben, wird die';
s2='             aktuelle Uhrzeit verwendet.'#13#10#13#10+
   '/d:tt.mm.jj  setzt das angebene Datum. Wenn Sie nur /d eingeben, wird das'#13#10+
   '             aktuelle Datum verwendet.'#13#10#13#10+
   '/y           verndert auch Systemdateien (VORSICHT !!!)';
s3='/r           verndert auch schreibgeschtzte Dateien'#13#10+
   '/p           fragt bei jeder Datei nach, ob die nderung erfolgen soll'#13#10+
   '/s           verndert auch Dateien in Unterverzeichnissen'#13#10+
   '/h           verndert auch versteckte Dateien';
s4='/l           Anzeige erfolgt in Kleinschreibung (nur mit /p)'#13#10+
   '/o           Fehler werden in der LOG-Datei protokolliert'#13#10#13#10+
   'Wenn Sie /t oder /d weglassen, bleibt der betreffende Wert unverndert.';

BEGIN
  Standardkopf ('TOUCH', Copyright);
  DosLnLF(s1); DosLnLF(s2); DosLnLF(s3); DosLnLF(s4);
  BlindStop;
  Halt (255);
END;



PROCEDURE Zeiten_setzen (Quelle : PathStr);
VAR
  Attr : Word;
LABEL
  Ende;
BEGIN
  Found:= TRUE;

  If Lostaste Then
  BEGIN
    DosLnLF ('');
    If LowCase Then DosLnLF (LowStr(Quelle)) Else DosLnLF (Quelle);
    DosStr  ('   Zeit oder Datum ndern?   <j>a   <n>ein   <a>lle   <Esc>Abbruch');
    GotoXY  (3, WhereY);
    Tastenfrage;
    DosLnLF ('');
    ExProc;
    If t1='N' Then Exit Else
    If t1='A' Then LosTaste:= FALSE;
  END;

  Assign (Q, Quelle);

  If (not TimeSet) or (not DateSet) Then
  BEGIN
    Reset    (Q);        
    GetFTime (Q, OTime); Result:= DOSError; If Result<>0 Then Goto Ende;
    Close    (Q);        Result:= IOResult; If Result<>0 Then Goto Ende;
    UnPackTime (OTime, ODates);

    If not DateSet Then
    BEGIN
      NDates.year  := ODates.year;
      NDates.day   := ODates.day;
      NDates.month := ODates.month;
    END;

    If not TimeSet Then
    BEGIN
      NDates.hour  := ODates.hour;
      NDates.min   := ODates.min;
      NDates.sec   := ODates.sec;
    END;

    PackTime (NDates, NTime);
  END;

  inc (Files);

  Reset  (Q);
  SetFTime (Q, NTime); Result:= DOSError; If Result<>0 Then Goto Ende;
  Close (Q);           Result:= IOResult;

Ende:
  If Result<>0 Then BEGIN DosStr (Quelle); ExProc; END;
END;


PROCEDURE Rekursiv (SuchPfad: PathStr);
VAR
  tg : Searchrec;
BEGIN
  Findfirst (Vollpfad (Suchpfad, '*.*'), Normalfile, tg);
  If DOSError>=150 Then BEGIN Result:= DosError; ExProc; END;

  While DOSError = 0 Do
  BEGIN
    If tg.attr and directory <> 0 Then
    BEGIN
      If (tg.Name[1]<>'.') and (Rekurs) Then
      Rekursiv (Vollpfad (suchpfad, tg.name));
    END
    Else
    If  (tg.attr and Attrs = tg.attr)
    and (FileMatch (tg.name, Objekt)) Then
    Zeiten_Setzen (Vollpfad (suchpfad, tg.name));

    Findnext (tg);
    If keypressed Then BEGIN UpScanBKeys; ExProc; END;
  END;

END;


PROCEDURE Parameter;
VAR
  x  : Byte;
  ps : String;

BEGIN
  DateStr:= ActDateStr (10);
  TimeStr:= ActTimeStr (8);

  StretchParam (ps);
  If ParamCount = 0 Then Hilfetext;
  SuchPfad:='';

  For x:= 1 To ParamCount Do
  BEGIN
    ParStr:= ParamStr (x);
    If ParStr[1] = '/' Then
    CASE upcase(ParStr[2]) Of
      'S' : Rekurs    := TRUE;
      'P' : Lostaste  := TRUE;
      'D' : BEGIN
              DateSet:=True;
              If Length (ParStr)<>2 Then
              DateStr:= copy (ReplaceAll(ParStr, '-', '.'), 4, 255);
            END;
      'T' : BEGIN
              TimeSet:=True;
              If Length (ParStr)<>2 Then
              TimeStr:= copy (ParStr, 4, 255);
            END;
      'Y' : Attrs:= Attrs or SysFile;
      'H' : Attrs:= Attrs or Hidden;
      'R' : Attrs:= Attrs or ReadOnly;
      'L' : LowCase:= TRUE;
      'O' : LogStatus := 0;
      '?' : Hilfetext;
    END Else If SuchPfad='' Then SuchPfad:= ParStr;
  END;
  If Logstatus=0 Then Lostaste:= FALSE;
  If SuchPfad='' Then Suchpfad:= '*';

  If (TimeSet=FALSE) and (Dateset=FALSE) Then
  BEGIN ErrCode:= 255; SimpleHaltLog ('Parameter fehlt') END;

  DateStr:= DateStr+';'+TimeStr;
  NTime:= ParseDate (DateStr);
  If NTime = -1 Then
  BEGIN ErrCode:= 252; SimpleHaltLog ('Fehlerhaftes Datum'); END;
  If NTime = -2 Then
  BEGIN ErrCode:= 251; SimpleHaltLog ('Fehlerhafte Uhrzeit'); END;
  UnPackTime (NTime, NDates);

  If not IsWildCard (SuchPfad) Then
  BEGIN      
    If (Length(Suchpfad)<=3) and (Suchpfad[2]=':') Then
    Suchpfad:= VollPfad (SuchPfad, '*.*') Else
    BEGIN
      FindFirst (SuchPfad, normalfile, tg);
      If DOSError>=150 Then BEGIN Result:= DosError; ExProc; END;
      If (DOSerror=0) Then
      If (tg.attr and directory<>0) Then Suchpfad:=VollPfad (SuchPfad, '*.*') Else
      Rekurs:= False;
    END;
  END;

  Suchpfad:= FileExpand (SuchPfad);
  If DOSError=0 Then PStat:= PathStatus (Suchpfad, CheckQuelle) Else PStat:= DOSError;
  If Drive (SuchPfad[1]) and CDDrive<>0 Then Pstat:= CDFound;
  If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));

  Objekt  := GetFileNames (SuchPfad);
  SuchPfad:= dellastslash (GetPathName (SuchPfad));
END;


{----------------------------- HauptProgramm ------------------------------}

BEGIN
  Parameter;
  FileMode:= 0;

  Rekursiv (Suchpfad);

  If Lostaste Then DosLnLF ('');
  If not Found Then
  BEGIN ErrCode:= 254; SimpleHaltLog ('Keine Dateien gefunden'); END Else
  BEGIN DosNum (Files); DosLnLF (' Dateien verarbeitet'); END;

  BlindStop;
  Halt (0);
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
